/*---------------------------------------------------------------------------*
  Project:  
  File:     mic_Lib.cpp
  
 *---------------------------------------------------------------------------*/

#include <stdio.h>

#if 0
#include <nn/demo.h>
#endif

#include <nn/os.h>
#include <nw/ut.h>
#include "mic_Lib.h"

using namespace uji;
using namespace uji::sys;
using namespace nn::math;

namespace uji {
namespace eva {

char MicLib::m_MicBuffer[MIC_BUFFER_SIZE] NN_ATTRIBUTE_ALIGN(nn::mic::BUFFER_ALIGNMENT_ADDRESS);
MicLib* MicLib::m_pInstance = 0;

/************************************************************************

MicLib

************************************************************************/
/************************************************************************
}CNJn
************************************************************************/
void MicLib::Initialize(void)
{
    nn::Result result;
    
    // mic ̏
    if( m_IsInitializedMic==false )
    {
        result = nn::mic::Initialize();
        NN_UTIL_PANIC_IF_FAILED(result);

        m_IsInitializedMic=true;
        NN_LOG("@ initializing process of mic is completed.\n");
        
        result = nn::mic::SetBuffer(&m_MicBuffer, MIC_BUFFER_SIZE);
        NN_UTIL_PANIC_IF_FAILED(result);
        
        m_IsSettingBuffer=true;
        NN_LOG("@ Setting buffer process is completed.\n");
        
        // TvOobt@TCY擾
        size_t size;
        result = nn::mic::GetSamplingBufferSize(&size);
        NN_UTIL_PANIC_IF_FAILED(result);
        m_SamplingLength = size / sizeof(s16);
        NN_LOG("size = %d\n", size);
        NN_LOG("m_SamplingLength = %d\n", m_SamplingLength);
        
        // MICAv̐ݒ
        result = nn::mic::GetAmpGain(&m_Gain);
        NN_UTIL_PANIC_IF_FAILED(result);
        result = nn::mic::SetAmpGain(m_Gain);
        NN_UTIL_PANIC_IF_FAILED(result);
    }
}

/************************************************************************
}CNI
************************************************************************/
void MicLib::Finalize(void)
{
    nn::Result result;
    
    if( m_IsSampling==true )
    {
        result = nn::mic::StopSampling();
        NN_UTIL_PANIC_IF_FAILED(result);
        
        m_IsSampling=false;
        NN_LOG("@ Stop Sampling.\n");
    }

    if( m_IsInitializedMic==true )
    {
        result = nn::mic::ResetBuffer();
        NN_UTIL_PANIC_IF_FAILED(result);
        
        m_IsSettingBuffer=false;
        NN_LOG("@ Reset buffer process is completed.\n");
    
        // MICAvɖ߂
        result = nn::mic::SetAmpGain(m_Gain);
        NN_UTIL_PANIC_IF_FAILED(result);
        
        result = nn::mic::Finalize();
        NN_UTIL_PANIC_IF_FAILED(result);
        
        m_IsInitializedMic=false;
        NN_LOG("@ Finalizing process of mic is completed.\n");
    }
}

/************************************************************************
}CNdI
************************************************************************/
bool MicLib::TurnOnMic()
{
    if( m_EnabledMic==false )
    {
        // MIC̓dON
        nn::Result result = nn::mic::SetAmp(true);
        NN_UTIL_PANIC_IF_FAILED(result);
        
        m_EnabledMic=true;
    }
    return true;
}

/************************************************************************
}CNdIt
************************************************************************/
bool MicLib::TurnOffMic()
{
    if( m_EnabledMic==true )
    {
        // MIC̓dON
        nn::Result result = nn::mic::SetAmp(false);
        NN_UTIL_PANIC_IF_FAILED(result);
        
        m_EnabledMic=false;
    }
    return true;
}

/************************************************************************
TvO^Cvƃ[gvZbg
************************************************************************/
void MicLib::PresetSamplingType(SamplingType type)
{
    m_SamplingType = type;
}
void MicLib::PresetSamplingRate(SamplingRate rate)
{
    m_SamplingRate = rate;
}

/************************************************************************
TvOJn
************************************************************************/
void MicLib::StartSampling(void)
{
    nn::Result result = 
    nn::mic::StartSampling(static_cast<nn::mic::SamplingType>(m_SamplingType),
                           static_cast<nn::mic::SamplingRate>(m_SamplingRate),
                           m_SamplingOffset, 
                           m_SamplingLength * sizeof(s16), 
                           m_Loop);
    NN_UTIL_PANIC_IF_FAILED(result);
}

/************************************************************************
TvOI
************************************************************************/
void MicLib::StopSampling(void)
{
    nn::Result result = nn::mic::StopSampling();
    NN_UTIL_PANIC_IF_FAILED(result);
}

/************************************************************************
}CNTvO
************************************************************************/
void MicLib::GetMicData(s32* pDest, size_t size)
{
    uptr src;
    nn::Result result = nn::mic::GetLastSamplingAddress(&src);
    NN_UTIL_PANIC_IF_FAILED(result);

    s16 *data = reinterpret_cast<s16*>(m_MicBuffer);
    u32 offs = src - reinterpret_cast<uptr>(m_MicBuffer);
    s32 sum = 0;

    m_MaxIndex = 0;
    m_MinIndex = 0;
    
    for (int i = 0; i < size; i++)
    {
        switch( m_SamplingType )
        {
            case MIC_SAMPLING_TYPE_8BIT:
                *(pDest + i) = static_cast<u8>(data[(offs - i) % m_SamplingLength]);
                break;
            case MIC_SAMPLING_TYPE_SIGNED_8BIT:
                *(pDest + i) = static_cast<s8>(data[(offs - i) % m_SamplingLength]);
                break;
            
            case MIC_SAMPLING_TYPE_16BIT:
                *(pDest + i) = static_cast<u16>(data[(offs - i) % m_SamplingLength]);
                break;
            case MIC_SAMPLING_TYPE_SIGNED_16BIT:
                *(pDest + i) = static_cast<s16>(data[(offs - i) % m_SamplingLength]);
                break;
        }
        
        //őŏ̃CfbNX
        if(*(pDest + m_MaxIndex) < *(pDest + i))    m_MaxIndex=i;
        if(*(pDest + i) < *(pDest + m_MinIndex))    m_MinIndex=i;
        
        //a
        sum += *(pDest + i);
    }
    m_Amplitude  = *(pDest + m_MaxIndex) - *(pDest + m_MinIndex);
    m_SumMicData = sum;
    m_AveMicData = sum / size;
}

/************************************************************************
TvOӂ̎gpobt@TCYĐݒ/ gpĂȂ
************************************************************************/
void MicLib::SetSamplingLength(int length)
{
    m_SamplingLength = static_cast<size_t>(length);
}

void MicLib::ResetSamplingLength(void)
{
    size_t size;
    nn::Result result;
    
    result = nn::mic::GetSamplingBufferSize(&size);
    NN_UTIL_PANIC_IF_FAILED(result);
    m_SamplingLength = size / sizeof(s16);
}

/************************************************************************
}CNTvOOt`n
************************************************************************/
void MicLib::SetSamplingGraphScreen(void)
{
    SetSamplingGraphScreen(0.f);
}
void MicLib::SetSamplingGraphScreen(f32 delta)
{
    GraphicsDrawing* gfx = GraphicsDrawing::GetInstance();
    
    // TvOOt̕`ݒ
    const f32 w = gfx->DISPLAY1_WIDTH;
    const f32 h = gfx->DISPLAY1_HEIGHT;
    
    //Ot`̃TCYؑ֗pϐ
    if(0.f <= m_Delta+delta &&  m_Delta+delta <= 80.f)
    {
        m_Delta+=delta;
    }
    const nn::math::VEC2 CHANGE_SIZE_VALUE = nn::math::VEC2(m_Delta, m_Delta);
    
    //tTCYɑ΂ďk\܂
    m_ScreenPos = nn::math::VEC2( 0.f, 0.f ) + CHANGE_SIZE_VALUE;
    m_ScreenSize= nn::math::VEC2(   w,   h ) - CHANGE_SIZE_VALUE*2.f;
}
void MicLib::SetSamplingGraphLine(const nw::ut::Color8 color, const f32 width)
{
    //OtFA
    m_GraphColor = color;
    m_GraphLineWidth = width;
}
void MicLib::GetSamplingGraph(const s32* pDest)
{
    GraphicsDrawing* gfx = GraphicsDrawing::GetInstance();
    gfx->BeginDrawingShape();

    //-------------------------------------------------------------------------------------
    // Ot`iXN[j
    //-------------------------------------------------------------------------------------
    gfx->SetColor(nw::ut::Color8::GRAY,     //E
                  nw::ut::Color8::GRAY,     //
                  nw::ut::Color8::BLACK,    //
                  nw::ut::Color8::BLACK );  //E
    gfx->SetLineWidth(1.f);
    gfx->FillRectangle(m_ScreenPos, m_ScreenSize);
    
    // `̖ڐ
    gfx->SetColor(nw::ut::Color8::WHITE);
    const int PARTITION_NUM = 4;
    for(int i=1; i<PARTITION_NUM; i++)
    {
        nn::math::VEC2 lineStartCoordinate;
        nn::math::VEC2 lineEndCoordinate;
        
        lineStartCoordinate.x = static_cast<f32>(m_ScreenPos.x);
        lineEndCoordinate.x   = static_cast<f32>(m_ScreenPos.x + m_ScreenSize.x);
        lineStartCoordinate.y = static_cast<f32>(m_ScreenPos.y + m_ScreenSize.y * i/PARTITION_NUM);
        lineEndCoordinate.y   = lineStartCoordinate.y;
        
        gfx->DrawLine(lineStartCoordinate, lineEndCoordinate);
    }
    
    // `̈͂ݐ
    gfx->SetColor(nw::ut::Color8::BLACK);
    gfx->DrawWidth1Rectangle(m_ScreenPos, m_ScreenSize);
    
    //-------------------------------------------------------------------------------------
    //Ot
    //-------------------------------------------------------------------------------------
    gfx->SetColor(m_GraphColor);
    gfx->SetLineWidth(m_GraphLineWidth);
    
    f32 slide = 0.f;    //XCh
    f32 scope = 0.f;    //͈
    switch( m_SamplingType )
    {
        case MIC_SAMPLING_TYPE_8BIT:            slide = 128.f;      scope = 1.f/256.f;      break;
        case MIC_SAMPLING_TYPE_SIGNED_8BIT:     slide = 0.f;        scope = 1.f/256.f;      break;
        case MIC_SAMPLING_TYPE_16BIT:           slide = 32768.f;    scope = 1.f/65536.f;    break;
        case MIC_SAMPLING_TYPE_SIGNED_16BIT:    slide = 0.f;        scope = 1.f/65536.f;    break;
    }
    
    f32 scale = m_ScreenSize.y * scope; //Pڐ
    f32 graphCenterY = m_ScreenSize.y/2.f + m_ScreenPos.y;
    
    for (int i=1; i<m_ScreenSize.x-1; i++)
    {
        nn::math::VEC2 lineStartCoordinate;
        nn::math::VEC2 lineEndCoordinate;
        
        lineStartCoordinate.x = static_cast<f32>(i   + m_ScreenPos.x);
        lineEndCoordinate.x   = static_cast<f32>(i+1 + m_ScreenPos.x);
        lineStartCoordinate.y = static_cast<f32>((pDest[i]  -slide) * scale + graphCenterY);
        lineEndCoordinate.y   = static_cast<f32>((pDest[i+1]-slide) * scale + graphCenterY);
        
        DrawLine_Y_Reverse(lineStartCoordinate, lineEndCoordinate);
    }
}


/************************************************************************
p[^EBhE\ύXp֐
************************************************************************/
int MicLib::ChangeCursor(int i, int paraNum, bool increase)
{
    ( increase ) ? ((i<paraNum-1) ? ++i : i=0) : ((0<i) ? --i : i=paraNum-1);
    return i;
}
void MicLib::ChangeType(bool increase)
{
    int foo = static_cast<int>(m_SamplingType);
    
    ( increase ) ? (( foo<MIC_SAMPLING_TYPE_SUPREMUM-1 ) ? ++foo : 0) 
                 : (( 0<foo )                            ? --foo : 0);
    
    m_SamplingType = static_cast<SamplingType>(foo);
    
    GetSamplingType();
}
void MicLib::ChangeRate(bool increase)
{
    int foo = static_cast<int>(m_SamplingRate);
    
    ( increase ) ? (( foo<MIC_SAMPLING_RATE_SUPREMUM-1 ) ? ++foo : 0) 
                 : (( 0<foo )                            ? --foo : 0);
    
    m_SamplingRate = static_cast<SamplingRate>(foo);
    
    nn::mic::AdjustSampling(static_cast<nn::mic::SamplingRate>(m_SamplingRate));
    
    GetSamplingRate();
}
void MicLib::ChangeGain(bool increase)
{
    ChangeGain(increase, 1);
}
void MicLib::ChangeGain(bool increase, u8 accel)
{
    ( increase ) ? (( m_Gain<=MIC_GAIN_MAX-accel ) ? m_Gain+=accel : m_Gain=MIC_GAIN_MAX)
                 : (( MIC_GAIN_MIN+accel<=m_Gain ) ? m_Gain-=accel : m_Gain=MIC_GAIN_MIN);
    // MICAv̐ݒ
    nn::Result result = nn::mic::SetAmpGain(m_Gain);
    NN_UTIL_PANIC_IF_FAILED(result);
}
void MicLib::SwitchLoop(void)
{
    if( IsSamplingLoop() )
    {
        m_Loop=false;
    }
    else
    {
        m_Loop=true;
    }
}
void MicLib::SwitchSampling(void)
{
    ( IsSampling() ) ? StopSampling() : StartSampling();
}
void MicLib::SwitchAmp(void)
{
    if( GetAmp() )
    {
        nn::Result result = nn::mic::SetAmp(false);
        NN_UTIL_PANIC_IF_FAILED(result);
    }
    else
    {
        nn::Result result = nn::mic::SetAmp(true);
        NN_UTIL_PANIC_IF_FAILED(result);
    }
}
int MicLib::ChangeSound(bool increase)
{
    int foo = static_cast<int>(m_SndFile);
    
    ( increase ) ? (( foo<SOUND_FILE_NAME_SUPREMUM-1 ) ? ++foo : 0) 
                 : (( -1<foo )                         ? --foo : 0);
    
    m_SndFile = static_cast<SoundFileName>(foo);
    
    GetSoundFileName();
    
    return foo;
}

/************************************************************************
o[ϐԂ
************************************************************************/
nn::math::VEC2 MicLib::GetScreenSize(void)
{
    return m_ScreenSize;
}
char* MicLib::GetSamplingType()
{
    switch(m_SamplingType)
    {
    case MIC_SAMPLING_TYPE_8BIT :           sprintf(m_TypeName, "8bit  ( 0/ 255)      ");   break;
    case MIC_SAMPLING_TYPE_16BIT:           sprintf(m_TypeName, "16bit ( 0/ 65535)    ");   break;
    case MIC_SAMPLING_TYPE_SIGNED_8BIT :    sprintf(m_TypeName, "s8bit (-128/ 127)    ");   break;
    case MIC_SAMPLING_TYPE_SIGNED_16BIT:    sprintf(m_TypeName, "s16bit(-32768/ 32767)");   break;
    default:                                sprintf(m_TypeName, "------( -----/ -----)");   break;
    }
    
    return m_TypeName;
}
int MicLib::GetSamplingRate()
{
    switch(m_SamplingRate)
    {
    case MIC_SAMPLING_RATE_32730:   m_Rate=32730;   break;
    case MIC_SAMPLING_RATE_16360:   m_Rate=16360;   break;
    case MIC_SAMPLING_RATE_10910:   m_Rate=10910;   break;
    case MIC_SAMPLING_RATE_8180 :   m_Rate=8180;    break;
    default:                        m_Rate=0;       break;
    }
    
    return m_Rate;
}
int MicLib::GetSamplingRateId()
{
    return m_SamplingRate;
}
bool MicLib::IsSamplingLoop(void)
{
    return m_Loop;
}
bool MicLib::IsSampling(void)
{
    nn::mic::IsSampling(&m_IsSampling);
    return m_IsSampling;
}
bool MicLib::GetAmp(void)
{
    nn::mic::GetAmp(&m_EnabledMic);
    return m_EnabledMic;
}
char* MicLib::GetSoundFileName()
{
    switch(m_SndFile)
    {
    case NO_SOUND :             sprintf(m_SndFileName, "No_Sound       ");  break;
    case LR_SIN_16BIT_1000HZ:   sprintf(m_SndFileName, "LR_Sin_16b_1kHz");  break;
    case L_SIN_16BIT_1000HZ:    sprintf(m_SndFileName, "L_Sin_16b_1kHz ");  break;
    case R_SIN_16BIT_1000HZ:    sprintf(m_SndFileName, "R_Sin_16b_1kHz ");  break;
    case NG_SOUND:              sprintf(m_SndFileName, "NG_SOUND       ");  break;
    case OK_SOUND:              sprintf(m_SndFileName, "OK_SOUND       ");  break;
    case LR_SIN_16BIT_100HZ:    sprintf(m_SndFileName, "LR_Sin_16_100Hz");  break;
    case LR_SIN_16BIT_200HZ:    sprintf(m_SndFileName, "LR_Sin_16_200Hz");  break;
    case LR_SIN_16BIT_500HZ:    sprintf(m_SndFileName, "LR_Sin_16_500Hz");  break;
    case LR_SIN_16BIT_4000HZ:   sprintf(m_SndFileName, "LR_Sin_16b_4kHz");  break;
    default:                    sprintf(m_SndFileName, "---------------");  break;
    }
    return m_SndFileName;
}

/************************************************************************
vCx[g֐iőɈړ悤j
************************************************************************/
void SetRenderingTargetPlus(const s32 display)
{
    uji::sys::GraphicsDrawing* gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    gfx->m_DrawFramework->SetRenderTarget(display);
    gfx->m_DrawFramework->Clear();
    
    switch (display)
    {
    case NN_GX_DISPLAY0:
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        break;
    case NN_GX_DISPLAY1:
        gfx->SetScreenSize(gfx->DISPLAY1_WIDTH, gfx->DISPLAY1_HEIGHT);
        break;
    default:
        break;
    }
}

void DrawLine_Y_Reverse(const nn::math::VEC2& p1, const nn::math::VEC2& p2)
{
    GraphicsDrawing* gfx = GraphicsDrawing::GetInstance();
    gfx->DrawLine(nn::math::VEC2(p1.x, (gfx->DISPLAY1_HEIGHT - p1.y)), 
                  nn::math::VEC2(p2.x, (gfx->DISPLAY1_HEIGHT - p2.y)));
}

u64 Pow(u32 X, u8 n)
{
    u64 ret = 1;
    while (n)
    {
        if (n % 2) ret *= X;
        X *= X;
        n >>= 1;
    }
    return ret;
}


} // namespace eva
} // namespace uji

