/*--------------------------------------------------------------------------*
 Project:
 File: mic_Menu.cpp

*--------------------------------------------------------------------------*/
#include "mic_Eva.h"
#include "mic_SamplingGraph.h"
#include "mic_TesterCommand.h"
#include "mic_BoardInterface.h"
#include "mic_TesterCalibrator.h"    
#include "mic_Tester.h"

namespace uji {
namespace eva {

static void FixMicTesterCalibrator()
{
    uji::sys::Pad pad;
    
    // Oɏ
    uji::seq::ProductionLog* pdl = new uji::seq::ProductionLog();    
    pdl->Initialize();
    pdl->Add_1Line(0, "MicCalib", "CALIBRATOR", "0.00", "", "", "", "The special calibrator.");
    pdl->Finalize();
    delete pdl;
    
    Menu::m_SubWindow->Printf("\f");
    Menu::m_SubWindow->Printf(" - MESSAGE - \n");
    Menu::m_SubWindow->Printf("     Completed!\n");
    Menu::m_SubWindow->Printf("\n");
    Menu::m_SubWindow->Printf(" - OPERATION METHOD - \n");
    Menu::m_SubWindow->Printf("     B : Exit\n");
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    sys::Menu::m_WindowManager.Update();
    sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();        
    sys::Menu::m_WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    
    do{
        pad.UpdatePad();
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));
    }while(!pad.IsButtonDown(Pad::BUTTON_B));
}

/************************************************************************
    EC^[tFCX̋@\mFpj[
************************************************************************/
void OpenBITestCheckoutMenu(void)
{
    sys::ClassMenu *m = new sys::ClassMenu( "B/I-Test Checkout Menu" );
    m->Add( " (15-3) MIC1/2 SAMPLING ", mic::CheckSamplingData);
    m->Open();
    delete m;
}

/************************************************************************
    }CN]pj[
************************************************************************/
void OpenMicMenu(void)
{
    sys::ClassMenu *m = new sys::ClassMenu( "Mic Evaluation Menu" );
    m->Add( " Sampling Data Graph    ", Eva_DrawSamplingGraph );
    m->Add( " SPI Command Test       ", Eva_CheckCommandTest );
    m->Add( " B/I-Test Checkout Menu ", OpenBITestCheckoutMenu );
    m->Add( " Tester Calibration     ", MicTesterCalibrator::sRun);
    m->Add( " PGA Gain Calibration   ", mic_t::MicTester::sCalibratePgaGain);
    m->Add( " PGA Gain Cal(Reset)    ", mic_t::MicTester::sCalibratePgaGainReset);
    m->Add( " Fix TesterCalibrator   ", FixMicTesterCalibrator);

#if 0
    m->Add( " Stable Time          ", NULL );
    m->Add( " Spectrum Analyzer    ", NULL );
    m->Add( " CODEC IIR Filter     ", NULL );
    m->Add( " -------------------- ", NULL );
    m->Add( " CODEC Go DS Mode     ", NULL );
    m->Add( " Eva DS Mode          ", NULL );
    m->Add( " -------------------- ", NULL );
    m->Add( " SPI Port Checker     ", NULL );
#endif
    m->Open();
    delete m;
}


/************************************************************************
    T[rXZ^[p}CN]pj[
************************************************************************/
void OpenMicMenuForService(void)
{
    sys::ClassMenu *m = new sys::ClassMenu( "Mic Evaluation Menu" );
    m->Add( " Sampling Data Graph    ", Eva_DrawSamplingGraph );

    m->Open();
    delete m;
}

} // namespace eva
} // namespace uji

