

#include "mic_BoardInterface.h"
#include "../seq/Reception_board_interface.h"
#include "mic_Tester.h"

// ȉ}CNƒږ֌WAŋNPt߂ł
// TEhn̏܂ȂׁA}CNNƓ
// TEhn̏{B
#include "../eva/sound/SoundInitializer.h"
#include <nn/csnd.h>

using namespace uji;
using namespace uji::sys;
using namespace uji::seq;

namespace uji {
namespace eva {
namespace mic {


/*---------------------------------------------------------------------------
  Desc: MxTvOi15-3/15-4 ̃{fBj
---------------------------------------------------------------------------*/
bool BodyOfTestSampling(u8 micWriteDpramBinary[12])
{
    s32 micData[static_cast<size_t>(256.f)];
    u8 micGain[2];					// QC
    u8 micSamplingRate[2];			// TvO[g
    u8 micSamplingPointNum[2];		// TvO|Cg
    u8 micOffsetAve[2];				// ItZbgϒl
    u8 micOffsetMax[2];				// ItZbgől
    u8 micOffsetMin[2];				// ItZbgŏl
    
    MicLib *pMl = MicLib::GetInstance();
    
    /*
    	TvO(32.0dbE16360HzE256pts)
    	
    	L̎ATvOJn֐Ăłf[^WO
    	  120`150msec҂Ȃ΂ȂȂ
    */
    pMl->StartSampling();
    WaitMilliSeconds(150);
    pMl->GetMicData(micData, static_cast<size_t>(256.f));
    pMl->StopSampling();
    
    /*
    	ep[^i[
    */
    micGain[0] = nn::mic::AMP_GAIN_DEFAULT_VALUE;	// 43
    micGain[1] = 0x00;
    
    micSamplingRate[0] = pMl->GetSamplingRateId();	// MicLib::MIC_SAMPLING_RATE_16360==2
    micSamplingRate[1] = 0x00;
    
    micSamplingPointNum[0] = 0x00;
    micSamplingPointNum[1] = 0x01;
    
    micOffsetAve[0] = static_cast<u16>(pMl->m_AveMicData);
    micOffsetAve[1] = static_cast<u16>(pMl->m_AveMicData)>>8;
    
    micOffsetMax[0] = static_cast<u16>(micData[pMl->m_MaxIndex]);
    micOffsetMax[1] = static_cast<u16>(micData[pMl->m_MaxIndex])>>8;
    
    micOffsetMin[0] = static_cast<u16>(micData[pMl->m_MinIndex]);
    micOffsetMin[1] = static_cast<u16>(micData[pMl->m_MinIndex])>>8;
    
    
    // DPRAM
    micWriteDpramBinary[ 0] = micGain[0];
    micWriteDpramBinary[ 1] = micGain[1];
    micWriteDpramBinary[ 2] = micSamplingRate[0];
    micWriteDpramBinary[ 3] = micSamplingRate[1];
    micWriteDpramBinary[ 4] = micSamplingPointNum[0];
    micWriteDpramBinary[ 5] = micSamplingPointNum[1];
    micWriteDpramBinary[ 6] = micOffsetAve[0];
    micWriteDpramBinary[ 7] = micOffsetAve[1];
    micWriteDpramBinary[ 8] = micOffsetMax[0];
    micWriteDpramBinary[ 9] = micOffsetMax[1];
    micWriteDpramBinary[10] = micOffsetMin[0];
    micWriteDpramBinary[11] = micOffsetMin[1];
    
    return true;
}

/*---------------------------------------------------------------------------
  Desc: QCATvO[gATvOAItZbgύőŏ
        ̒lOɏo͂B
        i15-3/15-4 ̕]p֐BuB/I-Test Checkout MenuvIj
---------------------------------------------------------------------------*/
void CheckSamplingData()
{
    uji::sys::Pad pad;
    nn::os::Tick start;
    nn::os::Tick current;
    u8 array[12];
    
    NN_LOG("\n\n");
    NN_LOG("@ You will can stop test by pressing (B) button.");
    NN_LOG("\n\n");
    
    MicLib *pMl = MicLib::GetInstance();
    
    /*
    	(CjVCYƃ}CNdI)
    */
    pMl->Initialize();
    pMl->TurnOnMic();
    WaitMilliSeconds(3000);		// }CNdonA3bԂ̓TvO
                                // JnȂƂĂ
    
    /*
    	ݒyуTvO
    */
    start = nn::os::Tick::GetSystemCurrent();
    do
    {
        pad.UpdatePad();
        BodyOfTestSampling(array);
        current = nn::os::Tick::GetSystemCurrent();
        NN_LOG("---------------------------------------------\n");
        NN_LOG("[ %d (msec) ]\n", static_cast<int>((current-start).ToTimeSpan().GetMilliSeconds()));
        NN_LOG("micGain = %02x%02x\n", 				array[1], 	array[0]);
        NN_LOG("micSamplingRate = %02x%02x\n", 		array[3], 	array[2]);
        NN_LOG("micSamplingPointNum = %02x%02x\n", 	array[5], 	array[4]);
        NN_LOG("micOffsetAve = %02x%02x\n", 		array[7],	array[6]);
        NN_LOG("micOffsetMax = %02x%02x\n", 		array[9], 	array[8]);
        NN_LOG("micOffsetMin = %02x%02x\n", 		array[11], 	array[10]);
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
    NN_LOG("---------------------------------------------\n");
    
    /*
    	I
    */
    pMl->TurnOffMic();
    pMl->Finalize();
    
}

/*---------------------------------------------------------------------------
  Desc: (15-1) }CNēdONA
               500msec҂ĂV[PT֒ʒm
---------------------------------------------------------------------------*/
bool TestPowerOn(uji::seq::TestResult &result)
{
    MicLib *pMl = MicLib::GetInstance();
    
    pMl->Initialize();
    pMl->TurnOnMic();
    
#if 0    
    // dsp, snd, csnd::init ̏łɎs
    // NA1o߂ƏłȂȂ邩iSDK0.14.6݁j
    uji::eva::SoundInitializer().InitSDK();
    nn::csnd::init::Initialize();
#endif    
    
    result.m_Result = true;
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: (15-2) }CNIēdOFFA
               500msec҂ĂV[PT֒ʒm
---------------------------------------------------------------------------*/
bool TestPowerOff(uji::seq::TestResult &result)
{
    MicLib *pMl = MicLib::GetInstance();
    
    pMl->TurnOffMic();
    pMl->Finalize();
    
    WaitMilliSeconds(1000);
    
    result.m_Result = true;
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: (15-3) ԂɂMxTvO
    
    	擪Ԓn			}CNQC
    	擪Ԓn + 2		}CNTvO[g
    	擪Ԓn + 4		TvO|Cg
    	擪Ԓn + 6		ItZbgϒl(u16)
    	擪Ԓn + 8		ItZbgől(u16)
    	擪Ԓn +10		ItZbgŏl(u16)
    	
---------------------------------------------------------------------------*/
bool TestSamplingSilent(uji::seq::TestResult &result)
{
    u8 micWriteDpramBinary[12];
    
    BodyOfTestSampling(micWriteDpramBinary);
    g_CommC2T->WriteDpramBinary(micWriteDpramBinary, sizeof(micWriteDpramBinary));
    
    result.m_Result = true;
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: (15-4) ^MԂɂMxTvOi15-3Ɠej
---------------------------------------------------------------------------*/
bool TestSamplingFalseSignal(uji::seq::TestResult &result)
{
    u8 micWriteDpramBinary[12];
    
    BodyOfTestSampling(micWriteDpramBinary);
    g_CommC2T->WriteDpramBinary(micWriteDpramBinary, sizeof(micWriteDpramBinary));
    
    result.m_Result = true;
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: TvOMxԂ
  (FTRɒǉ)
  
---------------------------------------------------------------------------*/
bool TestSamplingFTR(uji::seq::TestResult &result, u16* ampAve )
{    
    int sampleDataNum = 256;
    int sampling_count = 50;
    int i, invalid_count = 0;
    int invalid_samp_count = 0;                         // ͒lɂLłȂf[^Ɣ肳ꂽ
    const int INVALID_SAMPLING_COUNT_MAX    = 5;        // ͒l̔肪̉񐔈ȏ㑱NGƂ
    const u16 INVALID_THRESHOLD_MAX         = 62000;    // ͒l臒l
    u32 amp_sum = 0;
    u32 invalid_amp_sum = 0;
    s32 micData[static_cast<size_t>(sampleDataNum)];
    bool IsThreshChk = true;


    MicLib *m_pMicLib = MicLib::GetInstance();
    
    // }CN
    // TvO(**dbE32730HzE)
    u8 defaultAmp = nn::mic::AMP_GAIN_DEFAULT_VALUE + 24;
    m_pMicLib = MicLib::GetInstance();
    m_pMicLib->PresetSamplingType(m_pMicLib->MIC_SAMPLING_TYPE_16BIT);
    m_pMicLib->PresetSamplingRate(m_pMicLib->MIC_SAMPLING_RATE_32730);
    nn::mic::SetAmpGain(defaultAmp);

    // Jn
    m_pMicLib->StartSampling();
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));
    
    // Uf[^̕ςZo
    for(i = 0; i < sampling_count; i++)
    {
        nn::os::Thread::Sleep(
            nn::fnd::TimeSpan::FromMilliSeconds((sampleDataNum / 16) + 5));
        
        // TvOĐUZo
        m_pMicLib->GetMicData(micData, static_cast<size_t>(sampleDataNum));
        if ((IsThreshChk && (m_pMicLib->m_Amplitude < INVALID_THRESHOLD_MAX)) || !IsThreshChk)
        {
            amp_sum += m_pMicLib->m_Amplitude; 
        }
        else
        {
            invalid_amp_sum += m_pMicLib->m_Amplitude; 
            invalid_count++;
        }
    }
    
    // I
    m_pMicLib->StopSampling();
    
    if( invalid_count > (sampling_count/5) )    // TvO20%ȏオlłNG
    {
        *ampAve = (u16)(invalid_amp_sum/invalid_count);
        result.m_Result = false;
        return result.m_Result;
    }
    else
    {
        *ampAve = (u16)(amp_sum/(sampling_count - invalid_count));
        result.m_Result = true;
        return result.m_Result;
    }
}

} // namespace mic
} // namespace eva
} // namespace uji
