/*--------------------------------------------------------------------------*
 Project:
 File: McuPort.cpp

*--------------------------------------------------------------------------*/

#include <nn.h>
#include <nn/fnd.h>
#include <nn/gx.h>
#include <nn/gx/CTR/gx_LcdBacklight.h>
#include <nn/gx/CTR/gx_LcdPowerManager.h>
#include <nn/hid.h>
#include <nn/hid/CTR/hid_ApiWithPrivilege.h>
#include <nn/hid/CTR/hid_AccelerometerCalibrator.h>
#include <nn/hid/CTR/hid_HidBase.h>
#include <nn/mcu.h>
#include <nn/os.h>
#include <nn/os/os_Thread.h>
#include <nn/srv.h>
#include <nw/types.h>
#include <nn/uds.h>
#include <stdlib.h>
#include <vector>

#include "McuPort.h"
#include "sys_App.h"
#include "sys_Pad.h"
#include "../mcu/McuInitializer.h"
#include "../seq/Config.h"
#include "../seq/ConfigDefine.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../seq/TestIdDefine.h"
#include "../seq/TestListManager.h"
#include "../seq/TestResult.h"
#include "../seq/TestSequencer.h"
#include "../sys/sys_SoundPlayer.h"

using namespace nn;
using namespace nn::dbg::detail;
using namespace nn::gx;
using namespace nn::os;
using namespace nn::svc;
using namespace uji::eva::mcu;
using namespace uji::seq;
using namespace uji::sys;
using nn::Handle;


namespace uji {
namespace eva {


static void    ResetAllLed();

// NGR[h
enum
{
    RESULT_OK = 0,
    DEFAULT_NG,
    UNSTABLE_X = 11,
    UNSTABLE_Y,
    UNSTABLE_Z,
    UNSTABLE_XY,
    UNSTABLE_XZ,
    UNSTABLE_YZ,
    UNSTABLE_XYZ,
    AXIS_X = 21,
    AXIS_Y,
    AXIS_Z,
    AXIS_XY,
    AXIS_YZ,
    AXIS_XZ,
    AXIS_XYZ,
    TIME_OUT = 99,
    OTHER_NG

};



namespace
{

    // {^̎擾
    class ButtonHandler : public nn::srv::NotificationHandler
    {
    public:
        virtual void HandleNotification(bit32 message)
        {
            switch( message )
            {
              case nn::srv::NOTIFICATION_SHELL_OPEN:
                Printf("[HwCheck]: Shell is opened\n");
                break;
              case nn::srv::NOTIFICATION_SHELL_CLOSE:
                Printf("[HwCheck]: Shell is closed\n");
                break;
              case nn::srv::NOTIFICATION_HOME_BUTTON:
                Printf("[HwCheck]: Home button is pushed\n");
                break;
              case nn::srv::NOTIFICATION_WIFI_BUTTON:
                Printf("[HwCheck]: Wifi button is pushed\n");
                break;

            }
        }
    };

    ButtonHandler     s_ShellOpenHandler;
    ButtonHandler     s_ShellCloseHandler;
    ButtonHandler     s_HomeButtonHandler;
    ButtonHandler     s_WifiButtonOpenHandler;

    const int STACK_SIZE = 4096;

    void IrqThread(uptr param NN_IS_UNUSED_VAR)
    {
        nn::Result result;

        nn::os::Semaphore notificationSem;

        // ӂJAӂAHOME{^AWIFI{^nhݒ
        RegisterNotificationHandler(&s_ShellOpenHandler, nn::srv::NOTIFICATION_SHELL_OPEN);
        RegisterNotificationHandler(&s_ShellCloseHandler, nn::srv::NOTIFICATION_SHELL_CLOSE);
        RegisterNotificationHandler(&s_HomeButtonHandler, nn::srv::NOTIFICATION_HOME_BUTTON);
        RegisterNotificationHandler(&s_WifiButtonOpenHandler, nn::srv::NOTIFICATION_WIFI_BUTTON);

        // ʒmL
        result = nn::srv::EnableNotification(&notificationSem);
        NN_UTIL_PANIC_IF_FAILED(result);

        // }`LXgbZ[W̎Mo^
        result = nn::srv::Subscribe(nn::srv::NOTIFICATION_SHELL_OPEN);
        NN_UTIL_PANIC_IF_FAILED(result);
        result = nn::srv::Subscribe(nn::srv::NOTIFICATION_SHELL_CLOSE);
        NN_UTIL_PANIC_IF_FAILED(result);
        result = nn::srv::Subscribe(nn::srv::NOTIFICATION_HOME_BUTTON);
        NN_UTIL_PANIC_IF_FAILED(result);
        result = nn::srv::Subscribe(nn::srv::NOTIFICATION_WIFI_BUTTON);
        NN_UTIL_PANIC_IF_FAILED(result);

        while(1)
        {
            s32 index;

            // Notification̒ʒm҂
            notificationSem.Acquire();

            Printf("[HwCheck]:catch Notificaion. Dispatch now\n");
            result = nn::srv::DispatchNotification();
            NN_UTIL_PANIC_IF_FAILED(result);
        }
    }

}


/*---------------------------------------------------------------------------
 Desc:  MCŨ|[g@֐
        IAA{^ōČAB{^Ńj[ʂɕA
---------------------------------------------------------------------------*/
void DemoMcuPort::Run()
{
    Result result;
    uji::sys::Point cursorPos;  // J[\ʒup
    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;

    uji::sys::SoundPlayer *q = new uji::sys::SoundPlayer;

    nn::fs::Initialize();

    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    // }X^[ߓxύX܂
    m_WindowManager.SetAlpha(196);

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    u8 mcu_addres = 0;      // MCŨAhX
    u8 mcu_write_data = 0;  // MCUɏޒl
    u8 mcu_read_data = 0;   // MCUǂݏol
    u8 step = 1;            // 菇ԍ 1:AhX 2:f[^
    u8 place_number = 1;    // 
    u8 first_flag = 1;

    do
    {
        gfx->m_DrawFramework->Clear();

        //  EChE
        m_WindowManager.UpdatePad(pad);
        m_WindowManager.Update();
        m_WindowManager.DrawDisplay0();

        //  `
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

        // `̑O
        gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);
        gfx->SetFixedWidthFont(16);
        gfx->m_TextWriter.SetCursor(10, 20);

        gfx->BeginDrawingString();
        (void)gfx->m_TextWriter.Printf( "step1:ADDRESS  step2:DATA\n A:READ  B:WRITE  X:STEP  "
                                        "\nUP:VALUE_UP  DOWN:VALUE_DOUW  \nLEFT:place_UP  RIGHT:place_DOWN\n\n\n" );

        // j[
        if( first_flag == 1 )
        {
            gfx->EndDrawingString();
            glFlush();
            gfx->m_DrawFramework->SwapBuffers();
            first_flag = 0;
        }

        while(1)
        {
            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);

            // {^ {
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_UP))
            {
                if( step == 1 )
                {
                    mcu_addres = mcu_addres + place_number;
                }

                if( step == 2 )
                {
                    mcu_write_data = mcu_write_data + place_number;
                    if( mcu_write_data > 0xFF ) mcu_write_data = 0xFF;
                }

                Printf( "step:%d  place:%02X  addres:%02X  write_data:%02X  read_data:%02X\n\n",
                         step, place_number, mcu_addres, mcu_write_data, mcu_read_data );

                (void)gfx->m_TextWriter.Printf( "step:%d  place:%02X  \n addres:%02X  write_data:%02X  read_data:%02X\n\n",
                                                step, place_number, mcu_addres, mcu_write_data, mcu_read_data );
                break;
            }

            // {^ |
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_DOWN))
            {
                if( step == 1 )
                {
                    mcu_addres = mcu_addres - place_number;
                }

                if( step == 2 )
                {
                    mcu_write_data = mcu_write_data - place_number;
                }

                if( mcu_write_data < 0 )
                {
                    mcu_write_data = 0;
                }

                Printf( "step:%d  place:%02X  addres:%02X  write_data:%02X  read_data:%02X\n\n",
                         step, place_number, mcu_addres, mcu_write_data, mcu_read_data );

                (void)gfx->m_TextWriter.Printf( "step:%d  place:%02X  \n addres:%02X  write_data:%02X  read_data:%02X\n\n",
                                                 step, place_number, mcu_addres, mcu_write_data, mcu_read_data );
                break;
            }

            // {^ ʂグ
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_LEFT))
            {
                place_number = place_number * 0x10;
                if( (place_number > 0x10) || (place_number == 0) )
                {
                    place_number = 0x10;
                }

                Printf( "step:%d  place:%02X  addres:%02X  write_data:%02X  read_data:%02X\n\n",
                         step, place_number, mcu_addres, mcu_write_data, mcu_read_data );

                (void)gfx->m_TextWriter.Printf( "step:%d  place:%02X  \n addres:%02X  write_data:%02X  read_data:%02X\n\n",
                                                 step, place_number, mcu_addres, mcu_write_data, mcu_read_data );
                break;
            }

            // E{^ ʂ
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_RIGHT))
            {
                place_number = place_number / 0x10;
                if( place_number < 1) place_number = 1;

                Printf( "step:%d  place:%02X  addres:%02X  write_data:%02X  read_data:%02X\n\n",
                         step, place_number, mcu_addres, mcu_write_data, mcu_read_data );
                (void)gfx->m_TextWriter.Printf( "step:%d  place:%02X  \n addres:%02X  write_data:%02X  read_data:%02X\n\n",
                                                 step, place_number, mcu_addres, mcu_write_data, mcu_read_data );
                break;
            }

            // X{^ f[^𑀍삷邩AAhX𑀍삷邩؂ւ
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_X))
            {
                // STEP1̏ԂXꂽƂSTEP2ɐ؂ւăf[^𑀍삷Ԃɂ
                if( step == 1 )
                {
                    step = 2;
                    (void)gfx->m_TextWriter.Printf( "STEP 1->2 step:%d  place:%02X  \n addres:%02X  write_data:%02X  read_data:%02X\n\n",
                                                        step, place_number, mcu_addres, mcu_write_data, mcu_read_data );
                }
                // ȊȌԂXꂽƂSTEP1ɐ؂ւăAhX𑀍삷Ԃɂ
                else
                {
                    step = 1;
                    (void)gfx->m_TextWriter.Printf( "STEP 2->1 step:%d  place:%02X  \n addres:%02X  write_data:%02X  read_data:%02X\n\n",
                                                                step, place_number, mcu_addres, mcu_write_data, mcu_read_data );
                }

                Printf( "step:%d  place:%02X  addres:%02X  write_data:%02X  read_data:%02X\n\n",
                         step, place_number, mcu_addres, mcu_write_data, mcu_read_data );
                break;
            }

            // A{^ Read
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_A))
            {
                NN_UTIL_PANIC_IF_FAILED(result);
                (void)gfx->m_TextWriter.Printf  ( "READ \n addres:%02X  write_data:%02X  read_data:%02X\n\n",
                                                            mcu_addres, mcu_write_data, mcu_read_data );
                Printf                          ( "READ   mcu_addres:%02X  mcu_write_data:%02X  mcu_read_data:%02X\n\n",
                                                            mcu_addres, mcu_write_data, mcu_read_data );
                break;
            }

            // B{^ Write
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_B))
            {
                //
               result = mcu.WriteBySend(mcu_addres, &mcu_write_data, sizeof(mcu_write_data));
                NN_UTIL_PANIC_IF_FAILED(result);
                Printf( "WRITE  mcu_addres:%02X  mcu_write_data:%02X  mcu_read_data:%02X\n\n",
                                    mcu_addres, mcu_write_data, mcu_read_data );

                (void)gfx->m_TextWriter.Printf( "WRITE \n addres:%02X  write_data:%02X  read_data:%02X\n\n",
                                                            mcu_addres, mcu_write_data, mcu_read_data );
                break;
            }

        };

        gfx->EndDrawingString();
        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        // Sleep
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromNanoSeconds(200 * 1000 * 1000));

    // R{^B{^𓯎ꂽꍇ͌rłj[ɖ߂
    } while( !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) );

    NN_LOG("end...\n");

    delete q;

    return;
}


/*---------------------------------------------------------------------------
    eLEDON/OFF֐j[ɓo^ׂ̊֐
---------------------------------------------------------------------------*/
void LEDTest()
{
    uji::eva::DemoMcuPort *p = new uji::eva::DemoMcuPort;

    p->TestLedOnOff();

    delete p;    //DemoMcuPort::Run2();

    return;
}


/*---------------------------------------------------------------------------
 Desc:  eLEDON/OFF֐
---------------------------------------------------------------------------*/
void DemoMcuPort::TestLedOnOff()
{
    uji::sys::Point cursorPos;    // J[\ʒup
    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;
    TestResult test_result;
    u8 first_flag = 1;
    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    // }X^[ߓxύX܂
    m_WindowManager.SetAlpha(196);

    do
    {
        gfx->m_DrawFramework->Clear();

        //  EChE
        m_WindowManager.UpdatePad(pad);  // pbh
        m_WindowManager.Update();        // XV
        m_WindowManager.DrawDisplay0();

        //  `
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

        // `̑O
        gfx->BeginDrawingString();
        gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);
        gfx->SetFixedWidthFont(16);
        gfx->m_TextWriter.SetCursor(10, 20);

        (void)gfx->m_TextWriter.Printf( "A   :NotifyLedRed     B    :CameraLedPink \n"
                                        "X   :NotifyLedGreen   Y    :NotifyLedBlue \n"
                                        "UP  :PowerLedRed      DOWN :PowerLedBlue  \n"
                                        "LEFT:WiFiLedYellow    RIGHT:TuneLedGreen  \n"
                                        "R   :Return To Menu\n\n" );

        // j[
        if( first_flag == 1 )
        {
            gfx->EndDrawingString();
            glFlush();
            gfx->m_DrawFramework->SwapBuffers();
            first_flag = 0;
            gfx->BeginDrawingString();
        }

        while(1)
        {
            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);

            // {^ PowerLedRed
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_UP))
            {
                static u32 up_button = 0;

                if(up_button == 0)
                {
                    (void)gfx->m_TextWriter.Printf( "\n\nPowerLedRedOn" );
                    up_button = 1;
                    uji::eva::mcu::PowerLedRedOn(test_result);
                }
                else
                {
                    (void)gfx->m_TextWriter.Printf( "\n\nPowerLedRedOff" );
                    up_button = 0;
                    uji::eva::mcu::PowerLedRedOff(test_result);
                }

                break;
            }

            // {^ PowerLedBlue
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_DOWN))
            {

                static u32 down_button = 0;

                if(down_button == 0)
                {
                    (void)gfx->m_TextWriter.Printf( "\n\nPowerLedBlueOn" );
                    down_button = 1;
                    uji::eva::mcu::PowerLedBlueOn(test_result);
                }
                else
                {
                    (void)gfx->m_TextWriter.Printf( "\n\nPowerLedBlueOff" );
                    down_button = 0;
                    uji::eva::mcu::PowerLedBlueOff(test_result);
                }

                break;
            }

            // {^
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_LEFT))
            {

                static u32 left_button = 0;

                if(left_button == 0)
                {
                    (void)gfx->m_TextWriter.Printf( "\n\nWiFiLedYellowOn" );
                    left_button = 1;
                    uji::eva::mcu::WiFiLedYellowOn(test_result);
                }
                else
                {
                    (void)gfx->m_TextWriter.Printf( "\n\nWiFiLedYellowOff" );
                    left_button = 0;
                    uji::eva::mcu::WiFiLedYellowOff(test_result);
                }

                break;
            }

            // E{^  TuneLedGreen
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_RIGHT))
            {
                static u32 right_button = 0;

                if(right_button == 0)
                {
                    (void)gfx->m_TextWriter.Printf( "\n\nTuneLedGreenOn" );
                    right_button = 1;
                    uji::eva::mcu::TuneLedGreenOn(test_result);
                }
                else
                {
                    (void)gfx->m_TextWriter.Printf( "\n\n TuneLedGreenOff" );
                    right_button = 0;
                    uji::eva::mcu::TuneLedGreenOff(test_result);
                }

                break;
            }

            // X{^ NotifyLedGreen
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_X))
            {
                static u32 X_button = 0;

                if(X_button == 0)
                {
                    (void)gfx->m_TextWriter.Printf( "\n\n NotifyLedGreenOn" );
                    X_button = 1;
                    uji::eva::mcu::NotifyLedGreenOn(test_result);
                }
                else
                {
                    (void)gfx->m_TextWriter.Printf( "\n\n NotifyLedGreenOff" );
                    X_button = 0;
                    uji::eva::mcu::NotifyLedGreenOff(test_result);
                }

                break;
            }

            // A{^ NotifyLedRed
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_A))
            {
                static u32 A_button = 0;

                if(A_button == 0)
                {
                    (void)gfx->m_TextWriter.Printf( "\n\n NotifyLedRedOn" );
                    A_button = 1;
                    uji::eva::mcu::NotifyLedRedOn(test_result);
                }
                else
                {
                    (void)gfx->m_TextWriter.Printf( "\n\n NotifyLedRedOff" );
                    A_button = 0;
                    uji::eva::mcu::NotifyLedRedOff(test_result);
                }

                break;
            }


            // B{^ CameraLedPink
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_B))
            {
                static u32 B_button = 0;

                if(B_button == 0)
                {
                    (void)gfx->m_TextWriter.Printf( "\n\n CameraLedPinkOn" );
                    B_button = 1;
                    uji::eva::mcu::CameraLedPinkOn(test_result);
                }
                else
                {
                    (void)gfx->m_TextWriter.Printf( "\n\n CameraLedPinkOff" );
                    B_button = 0;
                    uji::eva::mcu::CameraLedPinkOff(test_result);
                }

                break;
            }

            // Y{^ NotifyLedBlue
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_Y))
            {
                static u32 Y_button = 0;

                if(Y_button == 0)
                {
                    (void)gfx->m_TextWriter.Printf( "\n\n NotifyLedBlueOn" );
                    Y_button = 1;
                    uji::eva::mcu::NotifyLedBlueOn(test_result);
                }
                else
                {
                    (void)gfx->m_TextWriter.Printf( "\n\n NotifyLedBlueOff" );
                    Y_button = 0;
                    uji::eva::mcu::NotifyLedBlueOff(test_result);
                }

                break;
            }

            // R{^
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_R))
            {
                break;
            }

        };

        gfx->EndDrawingString();
        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        // Sleep
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromNanoSeconds(200 * 1000 * 1000));

    // R{^ꂽꍇ͌rłj[ɖ߂
    } while(  ! (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R))  );

    //eLEDʏ펞̏(dLEDFALED ONAm点LED)ɂ
    ResetAllLed();

    NN_LOG("end...\n");

    return;
}



/*---------------------------------------------------------------------------
    RTCɊւ\֐
---------------------------------------------------------------------------*/
void DemoMcuPort::ShowRTC()
{
    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    // }X^[ߓxύX܂
    m_WindowManager.SetAlpha(196);

    // J[\ʒup
    uji::sys::Point cursorPos;

    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;

    u8 mcu_read_data[20];

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    do
    {
        // ------------------------------------\------------------------------------
        gfx->m_DrawFramework->Clear();

        //  EChE
        m_WindowManager.UpdatePad(pad);  // pbh
        m_WindowManager.Update();        // XV
        m_WindowManager.DrawDisplay0();

        //  `
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

        // `̑O
        gfx->BeginDrawingString();
        gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);
        gfx->SetFixedWidthFont(16);
        gfx->m_TextWriter.SetCursor(10, 20);

        // ------------------------------------\ ܂------------------------------------

        mcu.ReadByReceive(0x19,  &mcu_read_data[0], sizeof(u8));

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

        mcu.ReadByReceive(0x30,  &mcu_read_data[1], sizeof(u8));

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

        mcu.ReadByReceive(0x31,  &mcu_read_data[2], sizeof(u8));

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

        mcu.ReadByReceive(0x32,  &mcu_read_data[3], sizeof(u8));

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

        mcu.ReadByReceive(0x33,  &mcu_read_data[4], sizeof(u8));

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

        mcu.ReadByReceive(0x34,  &mcu_read_data[5], sizeof(u8));

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

        mcu.ReadByReceive(0x35,  &mcu_read_data[6], sizeof(u8));

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

        mcu.ReadByReceive(0x36,  &mcu_read_data[7], sizeof(u8));

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

        mcu.ReadByReceive(0x38,  &mcu_read_data[8], sizeof(u8));

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

        mcu.ReadByReceive(0x39,  &mcu_read_data[9], sizeof(u8));

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

        mcu.ReadByReceive(0x3A,  &mcu_read_data[10], sizeof(u8));

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

        mcu.ReadByReceive(0x3B,  &mcu_read_data[11], sizeof(u8));

        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

        mcu.ReadByReceive(0x3C,  &mcu_read_data[12], sizeof(u8));


        (void)gfx->m_TextWriter.Printf  ( "\nIRQMASK1(0x19):%02X\n\n", mcu_read_data[0]);
        (void)gfx->m_TextWriter.Printf  ( "TIME   %02X/%02X/%02X(%02X)  %02X:%02X:%02X\n",
                                                mcu_read_data[7],  mcu_read_data[6], mcu_read_data[5], mcu_read_data[4],
                                                mcu_read_data[3], mcu_read_data[2], mcu_read_data[1], mcu_read_data[0]);
        (void)gfx->m_TextWriter.Printf  ( "ALARM  %02X/%02X/%02X      %02X:%02X\n",
                                                mcu_read_data[12], mcu_read_data[11], mcu_read_data[10], mcu_read_data[9], mcu_read_data[8] );

        (void)gfx->m_TextWriter.Printf  ( "\n\n0x19:%02X\n0x30:%02X  0x31:%02X  0x32:%02X  0x33:%02X  0x34:%02X\n0x35:%02X  "
                                              "0x36:%02X\n0x38:%02X  0x39:%02X  0x3A:%02X  0x3B:%02X  0x3C:%02X \n\n",
                    mcu_read_data[0], mcu_read_data[1], mcu_read_data[2], mcu_read_data[3], mcu_read_data[4], mcu_read_data[5], mcu_read_data[6],
                    mcu_read_data[7], mcu_read_data[8], mcu_read_data[9], mcu_read_data[10], mcu_read_data[11], mcu_read_data[12] );

        gfx->EndDrawingString();
        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        while(1)
        {
            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);

            // B{^
            if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_B))
            {
                break;
            }
        };

        // Sleep
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromNanoSeconds(200 * 1000 * 1000));

    // B{^ꂽꍇ͌rłj[ɖ߂
    } while( ! (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) );

    NN_LOG("end...\n");

    return;
}


/*---------------------------------------------------------------------------
    LCD&KEYōsĂLEDmFj[ɓo^ׂ̊֐
---------------------------------------------------------------------------*/
void DemoMcuPort::CheckLedOnOff()
{

    TestResult test_result;

    uji::eva::mcu::CheckLedOnOff(test_result);

    return;
}


/*---------------------------------------------------------------------------
    LED̏ԂԂɖ߂֐
---------------------------------------------------------------------------*/
static void    ResetAllLed()
{
    TestResult dummy_result;

    uji::eva::mcu::NotifyLedWhiteOff();
    uji::eva::mcu::WiFiLedYellowOnNoWait(dummy_result);
    uji::eva::mcu::PowerLedBlueOn(dummy_result);
    uji::eva::mcu::TuneLedGreenOn(dummy_result);

    return;
}


}   // usingnamespace eva
}   // usingnamespace uji

