/*--------------------------------------------------------------------------*
 Project:
 File: mcu_Menu.cpp


*--------------------------------------------------------------------------*/
#include <nn/Result.h>
#include "mcu_Menu.h"
#include "TestMcu.h"
#include "TestMcuNotification.h"
#include "TestPowerOff.h"
#include "TestRtc.h"
#include "../accelerator/TestAcc.h"
#include "../eva/backlight/BackLightTest.h"
#include "../mcuport/McuPort.h"
#include "../seq/TestResult.h"

static void AccTest(void);
static void McuTest(void);
static void McuPortChecker(void);
static void McuLEDChecker(void);
static void GetAccelXYZ_Menu(void);
static void WaitSoundVolMax_Menu(void);
static void AdjustFlicker_Menu(void);
static void TestBackLightOnOff_Menu(void);
static void ShowRTC(void);
static void LedOnOff(void);


namespace uji {
namespace eva {
namespace mcu {

using namespace uji::sys;

/*--------------------------------------------------------------------------*
    Desc: MCU̕]p
*--------------------------------------------------------------------------*/
void OpenEvaMenu()
{
    ClassMenu *m = new ClassMenu( "MCU Evaluation Menu" );
    m->SetColumn(2);

    m->Add( " [RTC] ReadRegister",      ShowRtc);
    m->Add( " [RTC] SetRtc for HwChk",  SetRtcTime);
    m->Add( " [RTC] 1secCountupTest",   EvaRTCCountupTest);
    m->Add( " [RTC] SetCal",            EvaRTCSetCal);      // TODO: fobOIɍ폜
    m->Add( " [ACC] AccTest",           AccTest);
    m->Add( " [ACC] GetAccelXYZ",       GetAccelXYZ_Menu);
    m->Add( " [MCU] McuTest",           McuTest);
    m->Add( " [MCU] PortChecker",       McuPortChecker);
    m->Add( " [MCU] LEDChecker",        McuLEDChecker);
    m->Add( " [MCU] Notification",      EvaNotification);
    m->Add( " [MCU] Power Off",         EvaPowerOff);
    m->Add( " [MCU] ShowRTC",           ShowRTC);
    m->Add( " [SND] WaitSoundVolMax",   WaitSoundVolMax_Menu);
    m->Add( " [LCD] AdjustFlicker",     AdjustFlicker_Menu);
    m->Add( " [BL]  BackLight",         TestBackLightOnOff_Menu);
    m->Add( " [MCU] LED ON/OFF",        LedOnOff);
    m->Open();

    delete m;
}

} // namespace
}
}


/************************************************************************
    xZT[
 ************************************************************************/
static void AccTest(void)
{
    uji::eva::acc::DemoAcc *p = new uji::eva::acc::DemoAcc;

    p->Run();

    delete p;
}

/************************************************************************
    MCU
 ************************************************************************/
static void McuTest(void)
{
    uji::eva::DemoMcu *p = new uji::eva::DemoMcu;

    p->Run();

    delete p;
}

/************************************************************************
    MCU PortChecker
 ************************************************************************/
static void McuPortChecker(void)
{
    uji::eva::DemoMcuPort *p = new uji::eva::DemoMcuPort;

    p->Run();

    delete p;
}

/************************************************************************
    McuLEDChecker
 ************************************************************************/
static void McuLEDChecker(void)
{
    uji::eva::DemoMcuPort *p = new uji::eva::DemoMcuPort;

    p->TestLedOnOff();

    delete p;
}

/************************************************************************
    RTCɊւ\
 ************************************************************************/
static void ShowRTC(void)
{
    uji::eva::DemoMcuPort *p = new uji::eva::DemoMcuPort;

    p->ShowRTC();

    delete p;
}

/************************************************************************
    C^[tFCXp 3xZTXYZ̒l擾
 ************************************************************************/
static void GetAccelXYZ_Menu(void)
{
    uji::seq::TestResult result_check;

    uji::eva::mcu::GetAccelXYZ(result_check);
}

/************************************************************************
    C^[tFCXŎg鉹ʌp֐
 ************************************************************************/
static void WaitSoundVolMax_Menu(void)
{
    uji::seq::TestResult result_check;

    uji::eva::mcu::WaitSoundVolMax(result_check);
}

/************************************************************************
    C^[tFCXōstbJ[p֐
 ************************************************************************/
static void AdjustFlicker_Menu(void)
{
    uji::seq::TestResult result_check;

    uji::eva::mcu::AdjustFlicker(result_check);
}

/************************************************************************
    obNCgpeXg
 ************************************************************************/
static void TestBackLightOnOff_Menu(void)
{
    uji::eva::DemoBackLight *p = new uji::eva::DemoBackLight;

    p->TestBackLightOnOff();

    delete p;
}

/************************************************************************
    eLED{^ON/OFF֐
 ************************************************************************/
static void LedOnOff(void)
{
    uji::eva::DemoMcuPort *p = new uji::eva::DemoMcuPort;

    p->CheckLedOnOff();

    delete p;
}
