/*--------------------------------------------------------------------------*
 Project:
 File: TestRtc.cpp

       
*--------------------------------------------------------------------------*/
#include "TestRtc.h"
#include "../seq/Reception_board_interface.h"
#include "McuInitializer.h"    
#include <nn/os.h>
#include <nn/os/os_Thread.h>
#include <nn/srv.h>
#include <nn/mcu.h>
#include <nn/drivers/cal/CTR/cal_Api.h>

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;
    

namespace uji {
namespace eva {
namespace mcu {    


// ֐̐錾
namespace internal {
    
s32 RTCSetCal(nn::drivers::cal::CTR::RtcCompensation rtcCompensation);    
nn::Result GetRtcAll(nn::mcu::CTR::RtcData* data);
u8 BCD2Dec(u8 bcd);
void rtcBCD2Dec(nn::mcu::CTR::RtcData* data);

}
   
/*
    Desc: RTCPbJEgAbveXg
*/
bool RTCCountupTest(seq::TestResult &result)
{
    nn::mcu::CTR::RtcData start, end;    
    nn::Result nnResult;            
                    
    // HwCheck
    McuInitializer().HwCheckInit();
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw
                    
    // RTCf[^擾
    nnResult = mcu.GetRtcAll(&start);
    if (nnResult.IsFailure())
    {
        sprintf(result.m_String, "Fail Read McuReg 1(GetLevel:%d)", nnResult.GetLevel());
        return result.m_Result = false; 
    }

    // 1bȏ҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1010));
    
    // ēxRTCf[^擾
    nnResult = mcu.GetRtcAll(&end);
    if (nnResult.IsFailure())
    {
        sprintf(result.m_String, "Fail Read McuReg 2(GetLevel:%d)", nnResult.GetLevel());
        return result.m_Result = false; 
    }

    // 
    s32 diff = static_cast<s32>(  end.m_Hour*60*60 +   end.m_Minute*60 +   end.m_Second) -
               static_cast<s32>(start.m_Hour*60*60 + start.m_Minute*60 + start.m_Second);
    result.m_Result = (diff >= 1) ? true : false;
    sprintf(result.m_String, "diff(%d)", diff);

    return result.m_Result;
}

/*
    Desc: RTCJEgAbveXgj[Ăяo
*/
void EvaRTCCountupTest()
{
    seq::TestResult result;
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    RTCCountupTest(result);

    sys::Menu::m_SubWindow->Printf("\f");
    sys::Menu::m_SubWindow->Printf("<RTC 1sec Countup Test>\n"); 
    sys::Menu::m_SubWindow->Printf("Result(%s) Msg:%s\n", result.m_Result ? "PASS" : "FAIL", result.m_String);
    sys::Menu::m_SubWindow->Printf("\n - Push B Button To Exit -");            

    // ʍXV
	sys::Menu::m_WindowManager.Update();
	sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
	gfx->m_DrawFramework->Clear();        
	sys::Menu::m_WindowManager.DrawDisplay1();
	gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH); 
                
    do {        
        sys::Pad().UpdatePad();
    }
    while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_B));    
}

/*
    Desc: RTCl\
*/
void ShowRtc()
{
    nn::mcu::CTR::RtcData rtc, rtcHwChk;
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        
    do
    {
        sys::Pad().UpdatePad();
        
        // RTC擾
        internal::GetRtcAll(&rtc);
        
        sys::Menu::m_SubWindow->Printf("\f");
        sys::Menu::m_SubWindow->Printf("<RTC EVA>\n");  
        
        // SDK
        nn::fnd::DateTime now = nn::fnd::DateTime::GetNow();
        sys::Menu::m_SubWindow->Printf("GET_NOW %04d/%02d/%02d %02d:%02d:%02d\n", 
            now.GetYear(), now.GetMonth(), now.GetDay(), now.GetHour(), now.GetMinute(),now.GetSecond());    
               
        // HwCheck
        McuInitializer().HwCheckInit();
        nn::mcu::CTR::HwCheck mcu(
            McuInitializer().GetHSession()      // mꂽZbṼnh
        );                                      // RXgN^Ɏw
        mcu.GetRtcAll(&rtcHwChk);
        sys::Menu::m_SubWindow->Printf(
            " HW_CHK 20%02d/%02d/%02d %02d:%02d:%02d\n", 
            rtcHwChk.m_Year, rtcHwChk.m_Month, rtcHwChk.m_Day, rtcHwChk.m_Hour, rtcHwChk.m_Minute, rtcHwChk.m_Second
        );                            

        // BCD/DEC                
        sys::Menu::m_SubWindow->Printf(
            "RTC_BCD 20%02X/%02X/%02X %02X:%02X:%02X\n"
            "RTC_DEC 20%02d/%02d/%02d %02d:%02d:%02d\n",             
            rtc.m_Year, rtc.m_Month, rtc.m_Day, rtc.m_Hour, rtc.m_Minute, rtc.m_Second,
            rtc.m_Year, rtc.m_Month, rtc.m_Day, rtc.m_Hour, rtc.m_Minute, rtc.m_Second            
        );
               
        // 10iɕϊ
        internal::rtcBCD2Dec(&rtc);                          
        sys::Menu::m_SubWindow->Printf(
            "RTC_EVA 20%02d/%02d/%02d %02d:%02d:%02d\n", 
            rtc.m_Year, rtc.m_Month, rtc.m_Day, rtc.m_Hour, rtc.m_Minute, rtc.m_Second
        );

        sys::Menu::m_SubWindow->Printf("\n - Push B Button To Exit -");            
    
        // ʍXV
	    sys::Menu::m_WindowManager.Update();
	    sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
	    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
	    gfx->m_DrawFramework->Clear();        
	    sys::Menu::m_WindowManager.DrawDisplay1();
	    gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);    
    }
    while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_B));
}

/*
    Desc: Lu[VlCaliNANDjۑ
          Ăяop
*/
bool RTCSetCalTest(seq::TestResult &result)
{
    using namespace nn::drivers::cal::CTR;
    
    u8 cal_dpsram;
    RtcCompensation rtcCompensation;

    // V[PTCall擾
	seq::g_CommC2T->ReadDpramBinary(&cal_dpsram, sizeof(cal_dpsram));    
    rtcCompensation.RTCCompensationValue = cal_dpsram;
    
    // ␳lCalۑ
    s32 ret = internal::RTCSetCal(rtcCompensation);
    
    sprintf(result.m_String, "DPSRAM(%Xh) Ret(%d)", cal_dpsram, ret);
    result.m_Result = (ret == 0) ? true : false;
    return result.m_Result;
}

/*
    Desc: Evaj[ĂяopLul̐ݒ
*/
void EvaRTCSetCal()
{    
    using namespace nn::drivers::cal::CTR;
    
    const u8 RTC_CAL_VAL_MIN = 0xc2;
    const u8 RTC_CAL_VAL_MAX = 0xbf;
    const u8 RTC_CAL_VAL_0   = 0x0;    
    
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();    
    RtcCompensation rtcCompensation;
    rtcCompensation.RTCCompensationValue = 0xff;
    s32 ret = -128;

    do 
    {
        sys::Pad().UpdatePad();        
        
        if ( sys::Pad().IsButtonDown( sys::Pad::BUTTON_A ) )
        {
            rtcCompensation.RTCCompensationValue = RTC_CAL_VAL_MIN;
            ret = internal::RTCSetCal(rtcCompensation);            
        }
        if ( sys::Pad().IsButtonDown( sys::Pad::BUTTON_X ) )
        {
            rtcCompensation.RTCCompensationValue = RTC_CAL_VAL_MAX;
            ret = internal::RTCSetCal(rtcCompensation);            
        }
        if ( sys::Pad().IsButtonDown( sys::Pad::BUTTON_B ) )
        {
            rtcCompensation.RTCCompensationValue = RTC_CAL_VAL_0;
            ret = internal::RTCSetCal(rtcCompensation);            
        }        
        
        u8 cal_val = rtcCompensation.RTCCompensationValue;
        
        sys::Menu::m_SubWindow->Printf ("\f");
        sys::Menu::m_SubWindow->Printf (" RTC Set Cal(for Debug Only)\n\n");
        sys::Menu::m_SubWindow->Printf ("    -- usage --\n\n");
        sys::Menu::m_SubWindow->Printf ("    [A] Set 0x%X\n", RTC_CAL_VAL_MIN);
        sys::Menu::m_SubWindow->Printf ("    [X] Set 0x%X\n", RTC_CAL_VAL_MAX);
        sys::Menu::m_SubWindow->Printf ("    [B] Set 0x%X\n", RTC_CAL_VAL_0);
        sys::Menu::m_SubWindow->Printf ("    [S] Exit\n\n");
        sys::Menu::m_SubWindow->Printf ("    0x%X:Result(%d)= %s", cal_val, ret, ret==0?"PASS":"FAIL");
	    sys::Menu::m_WindowManager.Update();
	    sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
	    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
	    gfx->m_DrawFramework->Clear();        
	    sys::Menu::m_WindowManager.DrawDisplay1();
	    gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);   
    }
    while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_START));
}



//============================================================================
//      ֐
//============================================================================
namespace internal {

/*
    Desc: RTC␳f[^NAND(Cal)ɕۑ܂
*/
s32 RTCSetCal(nn::drivers::cal::CTR::RtcCompensation cal_rtc)
{
    enum ERROR_SEQ {
        ERROR_GET   = -1,
        ERROR_SET   = -2,
        ERROR_FLUSH = -3
    };
    
    using namespace nn::drivers::cal::CTR;

    Calibration calibration;
    RtcCompensation rtcCompensation;
    
    // Cal ̏
    // Lȃf[^x[XΓǂݍ
    // Lȃf[^x[XȂ΃ftHglŖ߂f[^x[X쐬    
    calibration.Initialize();
    
    // l̎擾
    if (!calibration.Get(&rtcCompensation, CAL_DATA_RTC)) { return ERROR_GET; }
        
    // l̐ݒ
    rtcCompensation = cal_rtc;    
    if (!calibration.Set(&rtcCompensation, CAL_DATA_RTC)) { return ERROR_SET; }

    // t@Cɕۑ
    if (!calibration.Flush()) { return ERROR_FLUSH; }    
    
    return 0;
}

/*
    Desc: 10ilBCDɕϊ
*/
u8 Dec2BCD(u8 dec)
{
 int i,m,n;
 n = (int)dec;
 m = 0;
 
 for(i = 100; i > 0; i /= 10) 
 {
    m += n / i;
    n -= m * i;
    m *= 16;
 }
 return (m / 16);
}

/*
    Desc: BCD10ilɕϊ
*/
u8 BCD2Dec(u8 bcd)
{
    int n = bcd;
    int m = 0;
    
    m += n/16;
    n -= m*16;
            
    m *= 10;    
    
    return  m + n;
}

/*
    Desc: RTC̃f[^10iBCDɕϊ
*/
void rtcDec2BCD(nn::mcu::CTR::RtcData* data)
{
    data->m_Second  = Dec2BCD(data->m_Second);
    data->m_Minute  = Dec2BCD(data->m_Minute);
    data->m_Hour    = Dec2BCD(data->m_Hour);
    data->m_Week    = Dec2BCD(data->m_Week);
    data->m_Day     = Dec2BCD(data->m_Day);
    data->m_Month   = Dec2BCD(data->m_Month);    
    data->m_Year    = Dec2BCD(data->m_Year);        
}

/*
    Desc: RTC̃f[^BCD10iɕϊ
*/
void rtcBCD2Dec(nn::mcu::CTR::RtcData* data)
{
    data->m_Second  = BCD2Dec(data->m_Second);
    data->m_Minute  = BCD2Dec(data->m_Minute);
    data->m_Hour    = BCD2Dec(data->m_Hour);
    data->m_Week    = BCD2Dec(data->m_Week);
    data->m_Day     = BCD2Dec(data->m_Day);
    data->m_Month   = BCD2Dec(data->m_Month);    
    data->m_Year    = BCD2Dec(data->m_Year);        
}
    
/*
    Desc: RTClMCU璼ǂ݂Ď擾܂
*/
nn::Result GetRtcAll(nn::mcu::CTR::RtcData* data)
{
    nn::Result nnResult;            
    
    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    /*
        RTCf[^MCU擾
    */
    // b
    nnResult = mcu.ReadByReceive(nn::mcu::CTR::MCU_RTC_SEC_ADDR, &(data->m_Second), sizeof(u8));
    if (nnResult.IsFailure()) { return nnResult; }    
    // 
    nnResult = mcu.ReadByReceive(nn::mcu::CTR::MCU_RTC_MIN_ADDR, &(data->m_Minute), sizeof(u8));
    if (nnResult.IsFailure()) { return nnResult; }
    // 
    nnResult = mcu.ReadByReceive(nn::mcu::CTR::MCU_RTC_HOUR_ADDR, &(data->m_Hour), sizeof(u8));
    if (nnResult.IsFailure()) { return nnResult; }
    // j
    nnResult = mcu.ReadByReceive(nn::mcu::CTR::MCU_RTC_WEEK_ADDR, &(data->m_Week), sizeof(u8));
    if (nnResult.IsFailure()) { return nnResult; }
    // 
    nnResult = mcu.ReadByReceive(nn::mcu::CTR::MCU_RTC_DAY_ADDR, &(data->m_Day), sizeof(u8));
    if (nnResult.IsFailure()) { return nnResult; }
    // 
    nnResult = mcu.ReadByReceive(nn::mcu::CTR::MCU_RTC_MONTH_ADDR, &(data->m_Month), sizeof(u8));
    if (nnResult.IsFailure()) { return nnResult; }
    // N
    nnResult = mcu.ReadByReceive(nn::mcu::CTR::MCU_RTC_YEAR_ADDR, &(data->m_Year), sizeof(u8));
    if (nnResult.IsFailure()) { return nnResult; }
    
    return nnResult;
}

} // namespace internal
        
        
//============================================================================
//      RTCݒ
//============================================================================

// [NH
static int IsLeapYear(int year)
{
	return (0 == (year % 400)) || ((0 != (year % 100)) && (0 == (year % 4)));
}

// w茎̍ŏI擾
static int GetDaysInMonth(int nYear, int nMonth)
{
	const int nDaysInMonth[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

	if ((nMonth < 1) || (12 < nMonth))
    {
		return 0;
    }
	if ((2 == nMonth) && IsLeapYear(nYear))
    {  
		return 29;
    }
	return nDaysInMonth[nMonth-1];
}

// LȓtH
static int IsValidDate(int year, int month, int day)
{
    return ((month>=1) && (month<=12) && (day>=1) && (day <= GetDaysInMonth(year,month)));
}

/*
  RTC̎ݒ肵܂B
  }CRRTCl𒼐ڏׁAGetNow()ɂ͔f܂B
*/
void SetRtcTime()
{
    nn::mcu::CTR::RtcData rtc;
    enum RTCItem {I_YEAR=0, I_MONTH, I_DAY, I_HOUR, I_MINUTE, I_SECOND, I_MAX};
    
    int sel_item = I_YEAR;
    bool bSaved = false;
    
    // ݎ̃[h
    McuInitializer().HwCheckInit();
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw
    mcu.GetRtcAll(&rtc);

    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();         
    gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 0.00f, 0.00f, 0.0f, 1.0f);
      
    nn::os::Timer timer;
    timer.Initialize(false);
                 
    do
    {
        sys::Pad().UpdatePad();
        
        // ͍ڂ̕ύX
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_RIGHT) && sel_item < I_SECOND)
        {
            ++sel_item;
        }            
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_LEFT) && sel_item > I_YEAR)
        {
            --sel_item;
        }            
                
        // p[^ύX
        if (sys::Pad().IsButtonRepeat(sys::Pad::BUTTON_UP))
        {            
            u8 tmp;            
            switch (sel_item)
            {
            case I_YEAR:
                tmp = rtc.m_Year;                
                if (++rtc.m_Year > 99) rtc.m_Year = 0;
                if (!IsValidDate(rtc.m_Year + 2000, rtc.m_Month, rtc.m_Day)) rtc.m_Year = tmp;               
                break;
            case I_MONTH:
                tmp = rtc.m_Month;                
                if (++rtc.m_Month > 12) rtc.m_Month = 1;
                if (!IsValidDate(rtc.m_Year + 2000, rtc.m_Month, rtc.m_Day)) rtc.m_Month = tmp;               
                break;
            case I_DAY:
                tmp = rtc.m_Day;                
                if (++rtc.m_Day > GetDaysInMonth(rtc.m_Year+2000, rtc.m_Month)) rtc.m_Day = 1;
                if (!IsValidDate(rtc.m_Year + 2000, rtc.m_Month, rtc.m_Day)) rtc.m_Day = tmp;               
                break;
            case I_HOUR:    
                if (++rtc.m_Hour > 23) rtc.m_Hour = 0;
                break;
            case I_MINUTE:  
                if (++rtc.m_Minute > 59) rtc.m_Minute = 0;
                break;
            case I_SECOND: 
                if (++rtc.m_Second > 59) rtc.m_Second = 0;
                 break;            
            }
        }
        if (sys::Pad().IsButtonRepeat(sys::Pad::BUTTON_DOWN))
        {
            u8 tmp;
            switch (sel_item)
            {
            case I_YEAR:
                tmp = rtc.m_Year;
                if (rtc.m_Year == 0) rtc.m_Year = 99;
                else                 rtc.m_Year--;
                if (!IsValidDate(rtc.m_Year + 2000, rtc.m_Month, rtc.m_Day)) rtc.m_Year = tmp;
                break;
            case I_MONTH:   
                tmp = rtc.m_Month;                
                if (rtc.m_Month == 1) rtc.m_Month = 12;
                else                  rtc.m_Month--;
                if (!IsValidDate(rtc.m_Year + 2000, rtc.m_Month, rtc.m_Day)) rtc.m_Month = tmp;                
                break;
            case I_DAY:
                tmp = rtc.m_Day;
                if (rtc.m_Day == 1) rtc.m_Day = GetDaysInMonth(rtc.m_Year+2000, rtc.m_Month); 
                else                rtc.m_Day--;
                if (!IsValidDate(rtc.m_Year + 2000, rtc.m_Month, rtc.m_Day)) rtc.m_Day = tmp;                
                break;
            case I_HOUR:    
                if (rtc.m_Hour == 0) rtc.m_Hour = 23;
                else                 rtc.m_Hour--;
                break;
            case I_MINUTE:  
                if (rtc.m_Minute == 0) rtc.m_Minute = 59;
                else                   rtc.m_Minute--;
                break;
            case I_SECOND: 
                if (rtc.m_Second == 0) rtc.m_Second = 59;
                else                   rtc.m_Second--;
                break;            
            }            
        }  
            
        // ̕ۑ
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_A))
        {
            internal::rtcDec2BCD(&rtc);
            mcu.WriteBySend(nn::mcu::CTR::MCU_RTC_SEC_ADDR,   &rtc.m_Second,  sizeof(u8));
            mcu.WriteBySend(nn::mcu::CTR::MCU_RTC_MIN_ADDR,   &rtc.m_Minute,  sizeof(u8));
            mcu.WriteBySend(nn::mcu::CTR::MCU_RTC_HOUR_ADDR,  &rtc.m_Hour,    sizeof(u8));
            mcu.WriteBySend(nn::mcu::CTR::MCU_RTC_WEEK_ADDR,  &rtc.m_Week,    sizeof(u8));
            mcu.WriteBySend(nn::mcu::CTR::MCU_RTC_DAY_ADDR,   &rtc.m_Day,     sizeof(u8));
            mcu.WriteBySend(nn::mcu::CTR::MCU_RTC_MONTH_ADDR, &rtc.m_Month,   sizeof(u8));
            mcu.WriteBySend(nn::mcu::CTR::MCU_RTC_YEAR_ADDR,  &rtc.m_Year,    sizeof(u8));
            internal::rtcBCD2Dec(&rtc);
            
            timer.StartOneShot(nn::fnd::TimeSpan::FromMilliSeconds(1500));            
            bSaved = true;                     
        }
        
        // \
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
        {
            gfx->m_DrawFramework->Clear();
            gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
         
            gfx->BeginDrawingString();  
               
            gfx->SetFixedWidthFont(14);               
            gfx->m_TextWriter.SetCursor(0, 10);   
            gfx->m_TextWriter.SetTextColor(nw::ut::Color8::WHITE);
            (void)gfx->m_TextWriter.Printf("< RTC Setting >\n\n");
            (void)gfx->m_TextWriter.Printf("- Usage -\n");            
            (void)gfx->m_TextWriter.Printf("+ Key: Change Parameter\n");
            (void)gfx->m_TextWriter.Printf("A Btn: Save\n");                                
            (void)gfx->m_TextWriter.Printf("B Btn: Exit");                                
   
            if (bSaved)
            {
                gfx->m_TextWriter.SetCursor(280, 200);   
                gfx->m_TextWriter.SetTextColor(nw::ut::Color8::GREEN);
                (void)gfx->m_TextWriter.Printf("- Saved -");                
            }
   
            gfx->SetFixedWidthFont(16);   
            gfx->m_TextWriter.SetCursor(120, 140);   
            gfx->m_TextWriter.SetTextColor(sel_item == I_YEAR ? nw::ut::Color8::YELLOW : nw::ut::Color8::WHITE);
            (void)gfx->m_TextWriter.Printf("%04d", rtc.m_Year+2000);
            gfx->m_TextWriter.SetTextColor(nw::ut::Color8::WHITE);
            (void)gfx->m_TextWriter.Printf("/");        
            gfx->m_TextWriter.SetTextColor(sel_item == I_MONTH ? nw::ut::Color8::YELLOW : nw::ut::Color8::WHITE);
            (void)gfx->m_TextWriter.Printf("%02d", rtc.m_Month);
            gfx->m_TextWriter.SetTextColor(nw::ut::Color8::WHITE);
            (void)gfx->m_TextWriter.Printf("/");        
            gfx->m_TextWriter.SetTextColor(sel_item == I_DAY ? nw::ut::Color8::YELLOW : nw::ut::Color8::WHITE);
            (void)gfx->m_TextWriter.Printf("%02d", rtc.m_Day);
            (void)gfx->m_TextWriter.Printf(" ");        
            gfx->m_TextWriter.SetTextColor(sel_item == I_HOUR ? nw::ut::Color8::YELLOW : nw::ut::Color8::WHITE);
            (void)gfx->m_TextWriter.Printf("%02d", rtc.m_Hour);
            gfx->m_TextWriter.SetTextColor(nw::ut::Color8::WHITE);
            (void)gfx->m_TextWriter.Printf(":");
            gfx->m_TextWriter.SetTextColor(sel_item == I_MINUTE ? nw::ut::Color8::YELLOW : nw::ut::Color8::WHITE);
            (void)gfx->m_TextWriter.Printf("%02d", rtc.m_Minute);              
            gfx->m_TextWriter.SetTextColor(nw::ut::Color8::WHITE);
            (void)gfx->m_TextWriter.Printf(":");
            gfx->m_TextWriter.SetTextColor(sel_item == I_SECOND ? nw::ut::Color8::YELLOW : nw::ut::Color8::WHITE);
            (void)gfx->m_TextWriter.Printf("%02d", rtc.m_Second);                    
        
             gfx->EndDrawingString();  
        }
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
        
        if (bSaved)
        {
            timer.Wait();
            timer.Stop();
            bSaved = false;
        }
    }
    while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_B));
    
    gfx->m_DrawFramework->SetClearColor(NN_GX_DISPLAY0, 
        sys::GraphicsDrawing::DEFAULT_CLEAR_COLOR_RED, 
        sys::GraphicsDrawing::DEFAULT_CLEAR_COLOR_GREEN, 
        sys::GraphicsDrawing::DEFAULT_CLEAR_COLOR_BLUE, 
        sys::GraphicsDrawing::DEFAULT_CLEAR_COLOR_ALPHA);

    // pmcun̏I
    eva::mcu::McuInitializer().HwCheckEnd();
    timer.Finalize();    
}
        
        
        
} // namespace
}
}
