/*--------------------------------------------------------------------------*
 Project:
 File: TestPowerOff.cpp

       
*--------------------------------------------------------------------------*/
#include "TestPowerOff.h"
#include "../seq/Reception_board_interface.h"
#include "McuInitializer.h"    
#include <nn/os.h>
#include <nn/os/os_Thread.h>
#include <nn/srv.h>
#include <nn/mcu.h>

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;
    

namespace uji {
namespace eva {
namespace mcu {    

   
/*===========================================================================
  !
  
  MCU@ɂVbg_E͊J珳F𓾂gp@ł͂܂B
  
===========================================================================*/   
   
/*
    Desc: Power Off eXg
*/
bool McuPowerOffTest(seq::TestResult &result)
{
    // V[PTɃbZ[W󂯎Ƃʒm܂
    seq::g_CommC2T->Send((u16)true, (u8*)(&result.m_String[0]), strlen(result.m_String)+1);
    
    // Vbg_E
    PowerOff();

    // ɂ͗܂
    return result.m_Result;
}

/*
    Desc: Evaj[ Power Off
*/
void EvaPowerOff()
{    
    PowerOff();
}

/*
    Desc: MCU Power Off
*/
nn::Result PowerOff()
{
    // HwCheck
    McuInitializer().HwCheckInit();
    nn::mcu::CTR::HwCheck mcu(McuInitializer().GetHSession()); 
    
    // MCUɏޒl
    const u8 data = 0x01;
    nn::Result result = mcu.WriteBySend(nn::mcu::CTR::MCU_COMMAND0_ADDR, &data, sizeof(data));    

    return result;
}

/*
    Desc: Evaj[ Reset
*/
void EvaReset()
{    
    Reset();
}

/*
    Desc: MCU Reset
*/
nn::Result Reset()
{
    // HwCheck
    McuInitializer().HwCheckInit();
    nn::mcu::CTR::HwCheck mcu(McuInitializer().GetHSession()); 
    
    // MCUɏޒl
    const u8 data = 0x02;
    nn::Result result = mcu.WriteBySend(nn::mcu::CTR::MCU_COMMAND0_ADDR, &data, sizeof(data));    

    return result;
}



        
} // namespace
}
}
