/*--------------------------------------------------------------------------*
 Project:
 File: TestMcuNotification.cpp

       
*--------------------------------------------------------------------------*/
#include "TestMcuNotification.h"
#include "../seq/Reception_board_interface.h"
#include "McuInitializer.h"    
#include <nn/os.h>
#include <nn/os/os_Thread.h>
#include <nn/srv.h>
#include <nn/mcu.h>
#include <nn/nwm.h>    
#include <nn/applet.h>

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

namespace uji {
namespace eva {
namespace mcu {    

namespace internal {

// ֐̐錾
void UpdateScreen(sys::JpegDrawer* jpegDrawer);
void Initialize();
void Finalize();

}

namespace {
    nn::os::LightEvent s_EventIrqThreadBreak;
    nn::os::BlockingQueue s_Queue;
    nn::os::Thread s_Thread;
    uptr buffer[1];

    enum {
        EVA_NOTIFICATION_ELEMS_SHELL_OPEN,
        EVA_NOTIFICATION_ELEMS_SHELL_CLOSE,
        EVA_NOTIFICATION_ELEMS_HOME_BUTTON,
        EVA_NOTIFICATION_ELEMS_WIFI_BUTTON,
        EVA_NOTIFICATION_ELEMS_MAX    
    };
}

   
// {^̎擾
class ButtonHandler : public nn::srv::NotificationHandler
{
public:
    virtual void HandleNotification(bit32 message)
        {
        switch( message )
        {
        case nn::srv::NOTIFICATION_SHELL_OPEN:
            nn::dbg::detail::Printf("[HwCheck]: Shell is opened\n");
            break;
        case nn::srv::NOTIFICATION_SHELL_CLOSE:
            nn::dbg::detail::Printf("[HwCheck]: Shell is closed\n");
            break;
        case nn::srv::NOTIFICATION_HOME_BUTTON:
            nn::dbg::detail::Printf("[HwCheck]: Home button is pushed\n");
            break;
        case nn::srv::NOTIFICATION_WIFI_BUTTON:
            nn::dbg::detail::Printf("[HwCheck]: Wifi button is pushed\n");
            break;
        }
    }
};

// bZ[W̎ނɂăL[ɐl}
class EvaButtonHandler : public ButtonHandler
{
public:
    EvaButtonHandler(){}
    virtual ~EvaButtonHandler(){}
        
    virtual void HandleNotification(bit32 message)
    {
        switch( message )
        {
        case nn::srv::NOTIFICATION_SHELL_OPEN:
            s_Queue.Enqueue(EVA_NOTIFICATION_ELEMS_SHELL_OPEN);         
            break;
        case nn::srv::NOTIFICATION_SHELL_CLOSE:
            s_Queue.Enqueue(EVA_NOTIFICATION_ELEMS_SHELL_CLOSE);         
            break;
        case nn::srv::NOTIFICATION_HOME_BUTTON:
            s_Queue.Enqueue(EVA_NOTIFICATION_ELEMS_HOME_BUTTON);
            break;
        case nn::srv::NOTIFICATION_WIFI_BUTTON:
            s_Queue.Enqueue(EVA_NOTIFICATION_ELEMS_WIFI_BUTTON);
            break;
        }       
    }
private:

};


namespace{
    EvaButtonHandler     s_ShellOpenHandler;
    EvaButtonHandler     s_ShellCloseHandler;
    EvaButtonHandler     s_HomeButtonHandler;
    EvaButtonHandler     s_WifiButtonOpenHandler;    
}

namespace internal {

/*
    Desc: ʍXV
*/
void UpdateScreen(sys::JpegDrawer* jpegDrawer)
{
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    // ʍXV
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->Clear();      
    jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);            
        
}

/*
    Desc: 荞݃Xbh
*/
void IrqThread(uptr param NN_IS_UNUSED_VAR)
{
    nn::Result result;

    nn::os::Semaphore notificationSem;

    // ӂJAӂAHOME{^AWIFI{^nhݒ
    RegisterNotificationHandler(&s_ShellOpenHandler, nn::srv::NOTIFICATION_SHELL_OPEN);
    RegisterNotificationHandler(&s_ShellCloseHandler, nn::srv::NOTIFICATION_SHELL_CLOSE);
    RegisterNotificationHandler(&s_HomeButtonHandler, nn::srv::NOTIFICATION_HOME_BUTTON);
    RegisterNotificationHandler(&s_WifiButtonOpenHandler, nn::srv::NOTIFICATION_WIFI_BUTTON);
        
    // ʒmL    
    result = nn::srv::EnableNotification(&notificationSem);    
    NN_UTIL_PANIC_IF_FAILED(result);

    static bool init_subscribe = false;
    if (!init_subscribe)
    {
        // }`LXgbZ[W̎Mo^
        result = nn::srv::Subscribe(nn::srv::NOTIFICATION_SHELL_OPEN);
        NN_UTIL_PANIC_IF_FAILED(result);
        result = nn::srv::Subscribe(nn::srv::NOTIFICATION_SHELL_CLOSE);
        NN_UTIL_PANIC_IF_FAILED(result);
        result = nn::srv::Subscribe(nn::srv::NOTIFICATION_HOME_BUTTON);
        NN_UTIL_PANIC_IF_FAILED(result);
        result = nn::srv::Subscribe(nn::srv::NOTIFICATION_WIFI_BUTTON);
        NN_UTIL_PANIC_IF_FAILED(result);
        init_subscribe = true;
    }
    
    while(1)
    {
        // Notification̒ʒm҂
        if (notificationSem.TryAcquire(nn::fnd::TimeSpan::FromMilliSeconds(16)))
        {
            nn::dbg::detail::Printf("[HwCheck]:catch Notificaion. Dispatch now\n");
            result = nn::srv::DispatchNotification();
            NN_UTIL_PANIC_IF_FAILED(result);
        }
            
        if (s_EventIrqThreadBreak.TryWait())
        {            
            // ӂJAӂAHOME{^AWIFI{^nh܂B
            UnregisterNotificationHandler(nn::srv::NOTIFICATION_SHELL_OPEN);
            UnregisterNotificationHandler(nn::srv::NOTIFICATION_SHELL_CLOSE);
            UnregisterNotificationHandler(nn::srv::NOTIFICATION_HOME_BUTTON);
            UnregisterNotificationHandler(nn::srv::NOTIFICATION_WIFI_BUTTON);
                
            nn::dbg::detail::Printf("[HwCheck]:unregister all\n");
            break;
        }
    }
    
    nn::dbg::detail::Printf("[HwCheck]:IrqThread ended\n");
}

/*
    Desc: 
*/
void Initialize()
{
    const int STACK_SIZE = 4096;    
    const size_t SIZE = 1;
    
    s_Queue.Initialize(buffer, SIZE);
    
    // Cxg̏
    s_EventIrqThreadBreak.Initialize(false);    
    
    // MCU HwCheckp̏
    McuInitializer().HwCheckInit();
    
    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    // mꂽZbṼnhRXgN^Ɏw
    nn::mcu::CTR::HwCheck mcu(McuInitializer().GetHSession());      

    // MCU荞ݑ҂Xbh
    s_Thread.StartUsingAutoStack(&internal::IrqThread, reinterpret_cast<uptr>(&mcu), STACK_SIZE);
    
}

/*
    Desc: I
*/
void Finalize()
{
    s_EventIrqThreadBreak.Signal();     // XbhIʒm
    s_Thread.Join();                    // XbhI҂
    s_Thread.Finalize();                // Xbhj
      
    // ubLOL[̔j
    s_Queue.Finalize();

    // CxgI
    s_EventIrqThreadBreak.Finalize();     
}

}   // namespace internal


/*
    Desc: Notification]j[
*/
void EvaNotification()
{        
    internal::Initialize();
    
    sys::Menu::m_SubWindow->Printf("\f");
    sys::Menu::m_SubWindow->Printf("Notification HOME / Wifi Button\n");
    
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    do
    {
        uptr data;
        sys::Pad().UpdatePad();
      
        if (s_Queue.TryDequeue(&data))
        {
            switch (data)
            {
            case EVA_NOTIFICATION_ELEMS_SHELL_OPEN:
                sys::Menu::m_SubWindow->Printf("[TryDeque(%d)]: Shell is opened\n", data);
                break;
            case EVA_NOTIFICATION_ELEMS_SHELL_CLOSE:            
                sys::Menu::m_SubWindow->Printf("[TryDeque(%d)]: Shell is closed\n", data);
                break;
            case EVA_NOTIFICATION_ELEMS_HOME_BUTTON:
                sys::Menu::m_SubWindow->Printf("[TryDeque(%d)]: Home button is pushed\n", data);
                break;
            case EVA_NOTIFICATION_ELEMS_WIFI_BUTTON:
                sys::Menu::m_SubWindow->Printf("[TryDeque(%d)]: Wifi button is pushed\n", data);
                break;
            default:
                sys::Menu::m_SubWindow->Printf("[TryDeque(%d)]: ERROR!\n", data);                
                break;
            }                
        }
        
        // ʍXV
        sys::Menu::m_WindowManager.Update();
        sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->m_DrawFramework->Clear();        
        sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);            
    }
    while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_B));    
               
    internal::Finalize();
}

/*
    Desc: WifiXCb`eXgij
*/
bool WifiButtonSimpleTest(seq::TestResult &result)
{
    internal::Initialize();
    
    // 摜\p
    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
    
    // wʂ\
    jpegDrawer->OpenPicture(L"rom:/jpeg/WifiButtonForCheck.jpg");    
    internal::UpdateScreen(jpegDrawer);
    
    result.m_Result = false;
    do
    {
        uptr data;
      
        if (s_Queue.TryDequeue(&data))
        {
            switch (data)
            {
            case EVA_NOTIFICATION_ELEMS_WIFI_BUTTON:
                result.m_Result = true;
                break;
            default:
                break;
            }                
        }        
    }
    while (!result.m_Result);    
                   
    internal::Finalize();                   
                   
    jpegDrawer->ClosePicture();
    delete jpegDrawer; 
    
    return result.m_Result;
}

/*
    Desc: WifiXCb`eXg
*/
bool WifiButtonTest(seq::TestResult &result)
{
    enum MICRO_CODE{
        ERROR_MICRO_WIFI_PRECHECK   = 1,        
        ERROR_MICRO_WIFI_OFF        = 2,
        ERROR_MICRO_BUTTON_COUNT    = 3  
    };
 
    const int EXECUTE_TEST_COUNT = 2;
    int test_count = 0;
    
    if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType() ||
        uji::sys::PLATFORM_KTR == uji::sys::GetPlatformType())
    {
        result.m_Result = true;
        return result.m_Result;
    }
    
    // Wifi̎O`FbN
    if (!nn::nwm::CTR::IsWifiOn())
    {
        sprintf(result.m_String, "Error: PreChk WirelessOff(nwm)\n");
        result.m_Micro = ERROR_MICRO_WIFI_PRECHECK;        
        return result.m_Result = false;
    }    
    
    internal::Initialize();
    
    // 摜\p
    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
    
    // wʂ\
    jpegDrawer->OpenPicture(L"rom:/jpeg/WifiButton.jpg");    
    internal::UpdateScreen(jpegDrawer);
    
    uptr data;    
    do
    {      
        if (s_Queue.TryDequeue(&data))
        {
            switch (data)
            {
            case EVA_NOTIFICATION_ELEMS_WIFI_BUTTON:
                test_count++;
                break;
            default:
                break;
            }                
        }
        
        if (test_count == EXECUTE_TEST_COUNT)
        {
            jpegDrawer->OpenPicture(L"rom:/jpeg/WifiButtonA.jpg");
            internal::UpdateScreen(jpegDrawer);        
        }        
        sys::Pad().UpdatePad();        
    }
    while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_A) || test_count < EXECUTE_TEST_COUNT);

    internal::Finalize();                   
                     
    // WifiL
    if (!nn::nwm::CTR::IsWifiOn())
    {
        sprintf(result.m_String, "Error: WirelessOff(nwm)\n");
        result.m_Micro = ERROR_MICRO_WIFI_OFF;
        result.m_Result = false;
    }
    else
    {
        // {^F񐔂̔
        if (test_count > EXECUTE_TEST_COUNT)
        {
            sprintf(result.m_String, "Error: Button Count(%d)\n", test_count); 
            result.m_Micro = ERROR_MICRO_BUTTON_COUNT;     
            result.m_Result = false;        
        }
        // PASS
        else
        {
            result.m_Result = true;        
        }
    }    
                           
    jpegDrawer->ClosePicture();
    delete jpegDrawer; 
    
    return result.m_Result;
}

/*
    Desc: HOME{^eXg
*/
bool HomeButtonTest(seq::TestResult &result)
{
#if 0            
    internal::Initialize();
    
    // 摜\p
    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
    
    // wʂ\
    jpegDrawer->OpenPicture(L"rom:/jpeg/HomeButton.jpg");    
    internal::UpdateScreen(jpegDrawer);

    result.m_Result = false;
    do
    {
        uptr data;
      
        if (s_Queue.TryDequeue(&data))
        {
            switch (data)
            {
            case EVA_NOTIFICATION_ELEMS_HOME_BUTTON:
                result.m_Result = true;
                break;
            default:
                break;
            }                
        }        
    }
    while (!result.m_Result);    
                   
    internal::Finalize();                   
                   
    jpegDrawer->ClosePicture();
    delete jpegDrawer; 
    
    return result.m_Result;
#else
    // 摜\p
    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
    
    // wʂ\
    jpegDrawer->OpenPicture(L"rom:/jpeg/HomeButton.jpg");    
    internal::UpdateScreen(jpegDrawer);
    
    nn::applet::ClearHomeButtonState();  
    
    // HOME{^
    while(true)
    {    
        if ( nn::applet::IsExpectedToProcessHomeButton() )
        {
/*            
            // z[j[ɑJڂꍇ
            nn::applet::ProcessHomeButton();
            AppletWakeupState r = nn::applet::WaitForStarting();
            NN_UNUSED_VAR(r);

            // ҂̖߂I`FbN
            if ( nn::applet::IsExpectedToCloseApplication() )
            {
                break;
            }

            // GPU WX^ݒ̕A
            nngxUpdateState(NN_GX_STATE_ALL);
            nngxValidateState(NN_GX_STATE_ALL,GL_TRUE);
*/        
            //z[{^Ԃ̃NA
            nn::applet::ClearHomeButtonState();  
        
            break;      
        }
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));         
    }        
    jpegDrawer->ClosePicture();
    delete jpegDrawer; 
    
    return result.m_Result = true;
#endif    
}

/*
    Desc: Evaj[ĂяopWifi{^eXg
*/
void EvaWifiButtonTest()
{
    seq::TestResult result;
    WifiButtonTest(result);
    
    sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    sys::Menu::m_SubWindow->Printf("\f");
    sys::Menu::m_SubWindow->Printf("<WIFI BUTTON EVA>\n");    
    sys::Menu::m_SubWindow->Printf("Result(%s)\n%s\n", result.m_Result ? "PASS" : "FAIL", result.m_String);
    sys::Menu::m_SubWindow->Printf("\n - Push B Button To Exit -");            
    
    // ʍXV
    sys::Menu::m_WindowManager.Update();
    sys::Menu::m_WindowManager.UpdatePad(sys::Pad());
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();        
    sys::Menu::m_WindowManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

    do
    {
        sys::Pad().UpdatePad();
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));        
    }
    while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_B));   
    
}

/*
    Desc: Evaj[ĂяopHOME{^eXg
*/
void EvaHomeButtonTest()
{
    seq::TestResult result;
    HomeButtonTest(result);
}

        
} // namespace
}
}
