/*--------------------------------------------------------------------------*
 Project:
 File: TestMcu.h


*--------------------------------------------------------------------------*/
#ifndef TEST_MCU_H_INCLUDED
#define TEST_MCU_H_INCLUDED

#include "sys_GraphicsDrawing.h"
#include "sys_WindowManager.h"
#include "sys_Window.h"
#include "sys_MessageLogWindow.h"
#include "sys_TextWindow.h"
#include "sys_Pad.h"

#include "../seq/TestResult.h"
#include <nn/mcu.h>


#define MCU_DEBUG

namespace uji {
namespace eva {


// WindowNXpVvȃNX
class TestMcu : public sys::Window
{
public:
    /*
        RXgN^
        mgr : j[}l[W̃CX^X̃AhX
    */
    TestMcu(sys::WindowManager& mgr, s32 width, s32 height)
    : Window("SIMPLE WINDOW", width, height), m_MesgCount(0), m_FrameCount(0),
      m_WindowManager(mgr), m_MessageLogWindow(0), m_TextWindow(0)
    {}
    virtual ~TestMcu(){}

    // o͐̃eLXgEChEݒ肵܂
    void SetTextWindow(sys::TextWindow& wnd) { m_TextWindow = &wnd; }
    // o͐̃bZ[WOEChEݒ肵܂
    void SetMessageLogWindow(sys::MessageLogWindow& wnd) { m_MessageLogWindow = &wnd; }

protected:
    // eI[o[ChƎ̏܂
//    virtual void OnDraw(sys::GraphicsDrawing* gfx);
//    virtual void OnUpdatePad(const sys::Pad& pad);
//    virtual void OnUpdate();

private:
    int m_MesgCount;
    int m_FrameCount;

    sys::WindowManager&     m_WindowManager;
    sys::MessageLogWindow*  m_MessageLogWindow;
    sys::TextWindow*        m_TextWindow;
};

// EChEfNX
class DemoMcu
{
public:
    DemoMcu()
    :
        m_frameCount(0),
        /*
            eLXgEChE
            1ʂɉ23~c8\\BtHgTCY16B
        */
        m_TextWindow(23, 8, 16),

        /*
            bZ[WOEChE
            1ʂɉ20~c10\\B100s̃obt@BtHgTCY14B
            EChEɃtH[JXꍇ́AXN[\B
        */
        m_MessageLogWindow(20, 10, 100, 14),

        /*
            EChEhVvEChE
            TCY200dot~140dotB
        */
        m_TestMcu(this->m_WindowManager, 200, 140)
    {}
    virtual ~DemoMcu(){}

    void Run();
    void Run2();

private:
    int m_frameCount;

    sys::WindowManager      m_WindowManager;
    sys::TextWindow         m_TextWindow;
    sys::MessageLogWindow   m_MessageLogWindow;
    TestMcu                 m_TestMcu;
};


/* MCU_ADDRESS_MAP */

const u8  MCU_MAJOR_VERSION_ADDR      = 0x00;
const u8  MCU_MINOR_VERSION_ADDR      = 0x01;
const u8  MCU_MCU_STATUS_ADDR         = 0x02;
const u8  MCU_VCOM_TOP_ADDR           = 0x03;
const u8  MCU_VCOM_BOTTOM_ADDR        = 0x04;
const u8  MCU_FIRM_RESERVE_ADDR       = 0x05;
const u8  MCU_SVR2_VOLUME_ADDR        = 0x08;
const u8  MCU_SOUND_VOLUME_ADDR       = 0x09;
const u8  MCU_BATTERY_TEMP_ADDR       = 0x0A;
const u8  MCU_BATTERY_REMAIN_LO_ADDR  = 0x0B;
const u8  MCU_BATTERY_REMAIN_HI_ADDR  = 0x0C;
const u8  MCU_BATTERY_VOLTAGE_ADDR    = 0x0D;
const u8  MCU_PERIPHERAL_STATUS2_ADDR = 0x0E;
const u8  MCU_PERIPHERAL_STATUS_ADDR  = 0x0F;

const u8  MCU_IRQ0_ADDR               = 0x10;
const u8  MCU_IRQ1_ADDR               = 0x11;
const u8  MCU_IRQ2_ADDR               = 0x12;
const u8  MCU_IRQ3_ADDR               = 0x13;
const u8  MCU_IRQ_MASK0_ADDR          = 0x18;
const u8  MCU_IRQ_MASK1_ADDR          = 0x19;
const u8  MCU_IRQ_MASK2_ADDR          = 0x1A;
const u8  MCU_IRQ_MASK3_ADDR          = 0x1B;

const u8  MCU_COMMAND0_ADDR           = 0x20;
const u8  MCU_COMMAND1_ADDR           = 0x21;
const u8  MCU_COMMAND2_ADDR           = 0x22;
const u8  MCU_COMMAND3_ADDR           = 0x23;
const u8  MCU_FORCE_OFF_DELAY_ADDR    = 0x24;
const u8  MCU_VOLUME_SETTING_ADDR     = 0x25;
const u8  MCU_TEMP2_ADDR              = 0x26;
const u8  MCU_TEMP3_ADDR              = 0x27;
const u8  MCU_LED_MASTER_ADDR         = 0x28;
const u8  MCU_LED_POWER_ADDR          = 0x29;
const u8  MCU_LED_WIFI_ADDR           = 0x2A;
const u8  MCU_LED_CAMERA_ADDR         = 0x2B;
const u8  MCU_LED_SVR2_ADDR           = 0x2C;
const u8  MCU_LED_INFO_ADDR           = 0x2D;
const u8  MCU_LED_INFO2_ADDR          = 0x2E;

const u8  MCU_RTC_SEC_ADDR            = 0x30;
const u8  MCU_RTC_MIN_ADDR            = 0x31;
const u8  MCU_RTC_HOUR_ADDR           = 0x32;
const u8  MCU_RTC_WEEK_ADDR           = 0x33;
const u8  MCU_RTC_DAY_ADDR            = 0x34;
const u8  MCU_RTC_MONTH_ADDR          = 0x35;
const u8  MCU_RTC_YEAR_ADDR           = 0x36;
const u8  MCU_RTC_CONPENSATION_ADDR   = 0x37;
const u8  MCU_ALARM_MIN_ADDR          = 0x38;
const u8  MCU_ALARM_HOUR_ADDR         = 0x39;
const u8  MCU_ALARM_DAY_ADDR          = 0x3A;
const u8  MCU_ALARM_MONTH_ADDR        = 0x3B;
const u8  MCU_ALARM_YEAR_ADDR         = 0x3C;
const u8  MCU_ALARM_SUBSEC_L          = 0x3D;
const u8  MCU_ALARM_SUBSEC_H          = 0x3E;

const u8  MCU_ACC_CONFIG_ADDR         = 0x40;
const u8  MCU_ACC_READ_ADDR_ADDR      = 0x41;
const u8  MCU_ACC_WRITE_ADDR_ADDR     = 0x43;
const u8  MCU_ACC_DATA_ADDR           = 0x44;
const u8  MCU_ACC_X_LO_ADDR           = 0x45;
const u8  MCU_ACC_X_HI_ADDR           = 0x46;
const u8  MCU_ACC_Y_LO_ADDR           = 0x47;
const u8  MCU_ACC_Y_HI_ADDR           = 0x48;
const u8  MCU_ACC_Z_LO_ADDR           = 0x49;
const u8  MCU_ACC_Z_HI_ADDR           = 0x4A;
const u8  MCU_PEDOMETER_LO_ADDR       = 0x4B;
const u8  MCU_PEDOMETER_MIDDLE_ADDR   = 0x4C;
const u8  MCU_PEDOMETER_HI_ADDR       = 0x4D;
const u8  MCU_PEDOMETER_CLEAR_ADDR    = 0x4E;
const u8  MCU_PEDOMETER_HISTORY_ADDR  = 0x4F;

const u8  MCU_BOUNDARY_MIN_ADDR       = 0x50;

const u8  MCU_FREE_REG_ADDR_ADDR      = 0x60;
const u8  MCU_FREE_REG_DATA_ADDR      = 0x61;

const u8  MCU_INFO_ADDR               = 0x7F;

// MCU
const u8  MCU_0_5_BATTERY_REMAIN_ADDR = 0x0A;
const u8  MCU_0_5_BATTERY_TEMP_ADDR   = 0x0B;




namespace mcu {
    extern u8   ReadMcu(u8 address);

    extern bool GetMgicVersion( uji::seq::TestResult &result );         // 35-001
    extern bool GetPmicVersion( uji::seq::TestResult &result );         // 35-002
    extern bool GetMcuVersion( uji::seq::TestResult &result );          // 35-003
    extern bool GetConsoleType( uji::seq::TestResult &result );         // 35-004
    extern bool GetBatteryType( uji::seq::TestResult &result );         // 35-005
    extern bool GetBatteryTemp( uji::seq::TestResult &result );         // 35-006
    extern bool GetVcellBoard( uji::seq::TestResult &result );          // 35-007
    extern bool GetBatteryRemainBoard( uji::seq::TestResult &result );  // 35-008
    extern bool ResetViaMcu( uji::seq::TestResult &result );            // 35-009
    extern bool SetMasterLedMax( uji::seq::TestResult &result );        // 35-010
    extern bool PowerLedRedOn( uji::seq::TestResult &result );          // 35-011
    extern bool PowerLedRedOff( uji::seq::TestResult &result );         // 35-012
    extern bool PowerLedBlueOn( uji::seq::TestResult &result );         // 35-013
    extern bool PowerLedBlueOff( uji::seq::TestResult &result );        // 35-014
    extern bool WiFiLedYellowOn( uji::seq::TestResult &result );        // 35-015
    extern bool WiFiLedYellowOff( uji::seq::TestResult &result );       // 35-016
    extern bool TuneLedGreenOn( uji::seq::TestResult &result );         // 35-017
    extern bool TuneLedGreenOff( uji::seq::TestResult &result );        // 35-018
    extern bool CameraLedPinkOn( uji::seq::TestResult &result );        // 35-019
    extern bool CameraLedPinkOff( uji::seq::TestResult &result );       // 35-020
    extern bool NotifyLedRedOn( uji::seq::TestResult &result );         // 35-021
    extern bool NotifyLedRedOff( uji::seq::TestResult &result );        // 35-022
    extern bool NotifyLedGreenOn( uji::seq::TestResult &result );       // 35-023
    extern bool NotifyLedGreenOff( uji::seq::TestResult &result );      // 35-024
    extern bool NotifyLedBlueOn( uji::seq::TestResult &result );        // 35-025
    extern bool NotifyLedBlueOff( uji::seq::TestResult &result );       // 35-026
    extern bool FlickerAdjustMax( uji::seq::TestResult &result );       // 35-027
    extern bool FlickerAdjustMin( uji::seq::TestResult &result );       // 35-028
    extern bool GetTuneVol( uji::seq::TestResult &result );             // 35-029
    extern bool GetSoundVol( uji::seq::TestResult &result );            // 35-030
    extern bool WaitSoundVolMax( uji::seq::TestResult &result );        // 35-031
    extern bool DetectOpen( uji::seq::TestResult &result );             // 35-032
    extern bool DetectFold( uji::seq::TestResult &result );             // 35-033
    extern bool LedOnTest_NEC(uji::seq::TestResult &result);            // 35-034
    extern bool LedOffTest_NEC(uji::seq::TestResult &result);           // 35-035
    extern bool FlickerAdjustMax_NEC( uji::seq::TestResult &result );   // 35-036
    extern bool FlickerAdjustMin_NEC( uji::seq::TestResult &result );   // 35-037

    extern bool GetAccelXYZ( uji::seq::TestResult &result );            // 39-001

    extern bool CheckLedOnOff( uji::seq::TestResult &result );          //
    extern bool AdjustFlicker( uji::seq::TestResult &result );          //
    extern bool DetectFoldWithPicture( uji::seq::TestResult &result );  //

    extern void NotifyLedRedBlinker( void );        //
    extern void NotifyLedGreenBlinker( void );      //
    extern void NotifyLedBlueBlinker( void );       //
    extern void NotifyLedRGBBlinker( void );        //
    extern void NotifyLedWhiteOn( void );           //
    extern void NotifyLedWhiteOff(void);            //

    extern void DetectOpenFold(void);
    extern void ShowRemainderOfBattery(void);

    extern nn::Result GetRemainingBatteryLv( u8* val );

    extern bool WiFiLedYellowOnNoWait(uji::seq::TestResult &result);
    extern bool WiFiLedYellowOffNoWait(uji::seq::TestResult &result);
    extern void NotifyLedRedOnNoWait(void);
    extern void NotifyLedBlueOnNoWait(void);
    extern void NotifyLedGreenOnNoWait(void);
    extern void NotifyLedRedBlinkerNoWait(void);

    extern void WaitOpenState(void);
    extern void WaitCloseState(sys::GraphicsDrawing *gfx);

}




}
}

#endif

