/*--------------------------------------------------------------------------*
 Project:
 File: TestMcu.cpp

*--------------------------------------------------------------------------*/

#include <stdlib.h>
#include <vector>
#include <nn.h>
#include <nn/srv.h>
#include <nn/mcu.h>
#include <nn/fnd.h>
#include <nn/gx.h>
#include <nn/hid.h>
#include <nn/os.h>
#include <nn/os/os_Thread.h>
#include <nw/types.h>

#include "McuInitializer.h"
#include "sys.h"
#include "TestMcu.h"
#include "../seq/Config.h"
#include "../seq/ConfigDefine.h"
#include "../seq/Reception_board_interface.h"
#include "../seq/TestListManager.h"
#include "../seq/TestIdDefine.h"
#include "../seq/TestResult.h"
#include "../seq/TestSequencer.h"
#include "../sys/sys_SoundPlayer.h"
#include "../sys/sys_InputTextWindow.h"
#include "../sys/sys_App.h"
#include "../eva/mcuport/McuPort.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace nn::svc;
using namespace nn::dbg::detail;
using namespace nn::os;
using namespace nn;
using namespace uji::sys;
using namespace uji::seq;
using namespace uji::eva::mcu;
using nn::Handle;


namespace
{

    //  dLED̃p^[
    const char* PowerLedPatternMsg[] =
    {
        "POWER_LED_PATTERN_AUTO",
        "POWER_LED_PATTERN_ON",
        "POWER_LED_PATTERN_SLEEP",
        "POWER_LED_PATTERN_OFF",
        "POWER_LED_PATTERN_RED",
        "POWER_LED_PATTERN_BLUE"
    };

    //  LED̃p^[
    const char* CameraLedPatternMsg[] =
    {
        "CAMERA_LED_PATTERN_OFF",
        "CAMERA_LED_PATTERN_BLINKING",
        "CAMERA_LED_PATTERN_ON",
        "CAMERA_LED_PATTERN_TWL"
    };

    //  LED̃p^[
    const char* WifiLedPatternMsg[] =
    {
        "WIFI_LED_PATTERN_OFF",
        "WIFI_LED_PATTERN_ON",
    };

    const char* SVR2LedPatternMsg[] =
    {
        "SVR2_LED_PATTERN_OFF",
        "SVR2_LED_PATTERN_ON"
    };

    enum
    {
        INFO_LED_SLOW_BLINKING,
        INFO_LED_FAST_BLINKING,
        INFO_LED_ON,
        INFO_LED_NUM
    };

    const char* InfoLedPatternMsg[] =
    {
        "INFO_LED_SLOW_BLINKING",
        "INFO_LED_FAST_BLINKING",
        "INFO_LED_COLORFUL"
    };

    nn::mcu::CTR::InfoLedPattern infoLedPattern[4] =
    {
        {
            0,           // 1t[̒(PMCU`bN/2ms)
            0,           // ݂̐Ft[wFɓB܂ł̎
                         // ʏframeTimeƓlw肵Ă
            0,           // ŏIt[JԂ(255Ȃ疳ɌJԂ)
            0,           // \
            0,           // R1,R2..R32, G1,G2..G32, B1,B2..B32
        },
        {
            0,           // 1t[̒(PMCU`bN/2ms)
            0,           // ݂̐Ft[wFɓB܂ł̎
                         // ʏframeTimeƓlw肵Ă
            0,           // ŏIt[JԂ(255Ȃ疳ɌJԂ)
            0,           // \
            0,           // R1,R2..R32, G1,G2..G32, B1,B2..B32
        },
        {
            0,           // 1t[̒(PMCU`bN/2ms)
            0,           // ݂̐Ft[wFɓB܂ł̎
                         // ʏframeTimeƓlw肵Ă
            0,           // ŏIt[JԂ(255Ȃ疳ɌJԂ)
            0,           // \
            0,           // R1,R2..R32, G1,G2..G32, B1,B2..B32
        },
        {
            10,           // 1t[̒(PMCU`bN/2ms)
            0,           // ݂̐Ft[wFɓB܂ł̎
                         // ʏframeTimeƓlw肵Ă
            0,           // ŏIt[JԂ(255Ȃ疳ɌJԂ)
            0,           // \
            0,           // R1,R2..R32, G1,G2..G32, B1,B2..B32
        }
    };


    // {^̎擾
    class ButtonHandler : public nn::srv::NotificationHandler
    {
    public:
        virtual void HandleNotification(bit32 message)
        {
            switch( message )
            {
              case nn::srv::NOTIFICATION_SHELL_OPEN:
                Printf("[HwCheck]: Shell is opened\n");
                break;
              case nn::srv::NOTIFICATION_SHELL_CLOSE:
                Printf("[HwCheck]: Shell is closed\n");
                break;
              case nn::srv::NOTIFICATION_HOME_BUTTON:
                Printf("[HwCheck]: Home button is pushed\n");
                break;
              case nn::srv::NOTIFICATION_WIFI_BUTTON:
                Printf("[HwCheck]: Wifi button is pushed\n");
                break;

            }
        }
    };

    ButtonHandler     s_ShellOpenHandler;
    ButtonHandler     s_ShellCloseHandler;
    ButtonHandler     s_HomeButtonHandler;
    ButtonHandler     s_WifiButtonOpenHandler;

    const int STACK_SIZE = 4096;

    void IrqThread(uptr param NN_IS_UNUSED_VAR)
    {
        nn::Result result;

        nn::os::Semaphore notificationSem;

        // ӂJAӂAHOME{^AWIFI{^nhݒ
        RegisterNotificationHandler(&s_ShellOpenHandler, nn::srv::NOTIFICATION_SHELL_OPEN);
        RegisterNotificationHandler(&s_ShellCloseHandler, nn::srv::NOTIFICATION_SHELL_CLOSE);
        RegisterNotificationHandler(&s_HomeButtonHandler, nn::srv::NOTIFICATION_HOME_BUTTON);
        RegisterNotificationHandler(&s_WifiButtonOpenHandler, nn::srv::NOTIFICATION_WIFI_BUTTON);

        // ʒmL
        result = nn::srv::EnableNotification(&notificationSem);
        NN_UTIL_PANIC_IF_FAILED(result);

        // }`LXgbZ[W̎Mo^
        result = nn::srv::Subscribe(nn::srv::NOTIFICATION_SHELL_OPEN);
        NN_UTIL_PANIC_IF_FAILED(result);
        result = nn::srv::Subscribe(nn::srv::NOTIFICATION_SHELL_CLOSE);
        NN_UTIL_PANIC_IF_FAILED(result);
        result = nn::srv::Subscribe(nn::srv::NOTIFICATION_HOME_BUTTON);
        NN_UTIL_PANIC_IF_FAILED(result);
        result = nn::srv::Subscribe(nn::srv::NOTIFICATION_WIFI_BUTTON);
        NN_UTIL_PANIC_IF_FAILED(result);

        while(1)
        {
            s32 index;

            // Notification̒ʒm҂
            notificationSem.Acquire();

            Printf("[HwCheck]:catch Notificaion. Dispatch now\n");
            result = nn::srv::DispatchNotification();
            NN_UTIL_PANIC_IF_FAILED(result);
        }
    }

}


namespace uji {
namespace eva {


// NGR[h
enum
{
    RESULT_OK = 0,
    DEFAULT_NG,
    TIME_OUT = 99,
    OTHER_NG
};


/*--------------------------------------------------------------------------*

  LED_֐(MCU֘A)

*--------------------------------------------------------------------------*/
void  DemoMcu::Run(void)
{

    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;

    Result result;

    for(int j = 0; j < 3; j++)
    {
        for(int i = 0; i < 96; i++)
        {
            if( i%3 == j )
            {
                infoLedPattern[j].frameColors[i] = 255; // R
            }
            else
            {
                infoLedPattern[j].frameColors[i] = 0; // R
            }
        }
    }

    Printf("[HwCheck]:mcu_test Connectiong to mcu...\n");

    nn::os::Initialize();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    Printf("[HwCheck]:RIGHT Button:SetPowerLEDPattern test\n");
    Printf("[HwCheck]:UP Button   :SetCameraLEDPattern test\n");
    Printf("[HwCheck]:LEFT Button :SetWifiLEDPattern test\n");
    Printf("[HwCheck]:DOWN Button :SetSVR2LEDPattern test\n");
    Printf("[HwCheck]:A Button    :SetInfoLEDPattern test\n");

    Printf("[HwCheck]:B Button    :GetBatteryVoltage GetBatteryRemain test\n");
    Printf("[HwCheck]:X Button    :Read and Write test\n");

    Printf("[HwCheck]:R Button    :GetFreeRegisters GetInfoRegisters test\n");
    Printf("[HwCheck]:L Button    :SetVcomTop SetVcomBottom test\n");
    Printf("[HwCheck]:START Button:GetSoundVolume test\n");

    u32 setPowerPattern  = nn::mcu::CTR::POWER_LED_PATTERN_AUTO;
    u32 setCameraPattern = nn::mcu::CTR::CAMERA_LED_PATTERN_OFF;
    u32 setWifiPattern   = nn::mcu::CTR::WIFI_LED_PATTERN_OFF;
    u32 setSVR2Pattern   = nn::mcu::CTR::SVR2_LED_PATTERN_OFF;
    u32 infoPattern = INFO_LED_SLOW_BLINKING;
    u8  setBrightness = 0;
    u8  setParam = 0; // 0`255 ?

    while(1)
    {

        // L[͂̊mF
        padReader.ReadLatest(&padStatus);
        pad.UpdatePad(padStatus);

        // Eꍇ  dLED  (2) 0x5œ_   (6) 0x4œ_
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_RIGHT))
        {
            result = mcu.SetPowerLEDPattern( static_cast<nn::mcu::CTR::PowerLedPattern>(setPowerPattern) );
            NN_UTIL_PANIC_IF_FAILED(result);
            Printf("[HwCheck]:SetPowerLEDPattern():0x%x:%s\n", setPowerPattern, PowerLedPatternMsg[setPowerPattern]);

            if (++setPowerPattern >= nn::mcu::CTR::POWER_LED_PATTERN_NUM)
            {
                setPowerPattern = nn::mcu::CTR::POWER_LED_PATTERN_AUTO;
            }
        }

        // ꍇ  JLED    sN(7FE[) 0x2œ_
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_UP))
        {
            result = mcu.SetCameraLEDPattern(static_cast<nn::mcu::CTR::CameraLedPattern>(setCameraPattern));
            NN_UTIL_PANIC_IF_FAILED(result);
            Printf("[HwCheck]:SetCameraLEDPattern():0x%x:%s\n", setCameraPattern, CameraLedPatternMsg[setCameraPattern]);

            if (++setCameraPattern >= nn::mcu::CTR::CAMERA_LED_PATTERN_NUM)
            {
                setCameraPattern = nn::mcu::CTR::CAMERA_LED_PATTERN_OFF;
            }
        }

        // ꍇ  Wifi LED     F(1:[) 0x1œ_
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_LEFT))
        {
            result = mcu.SetWifiLEDPattern(static_cast<nn::mcu::CTR::WifiLedPattern>(setWifiPattern));
            NN_UTIL_PANIC_IF_FAILED(result);
            Printf("[HwCheck] SetWifiLEDPattern():0x%x:%s\n", setWifiPattern, WifiLedPatternMsg[setWifiPattern]);

            if (++setWifiPattern >= nn::mcu::CTR::WIFI_LED_PATTERN_NUM)
            {
                setWifiPattern = nn::mcu::CTR::WIFI_LED_PATTERN_OFF;
            }
        }

        // ꍇ  3D LED   (3) 0x1œ_
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_DOWN))
        {
            result = mcu.SetSVR2LEDPattern(static_cast<nn::mcu::CTR::SVR2LedPattern>(setSVR2Pattern));
            NN_UTIL_PANIC_IF_FAILED(result);
            Printf("[Camera]:SetSVR2LedPattern():0x%x:%s\n", setSVR2Pattern, SVR2LedPatternMsg[setSVR2Pattern]);

            if (++setSVR2Pattern >= nn::mcu::CTR::SVR2_LED_PATTERN_NUM)
            {
                setSVR2Pattern = nn::mcu::CTR::SVR2_LED_PATTERN_OFF;
            }
        }

        // A{^  m点LED     F4
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_A))
        {
            result = mcu.SetInfoLEDPattern( infoLedPattern[infoPattern] );
            NN_UTIL_PANIC_IF_FAILED(result);
            Printf("[HwCheck]:SetInfoLEDPattern():0x%x:%s\n", infoLedPattern, InfoLedPatternMsg[infoPattern]);

            if (++infoPattern >= INFO_LED_NUM)
            {
                infoPattern = INFO_LED_SLOW_BLINKING;
            }
        }

        // X{^  LED̋Pxݒ/擾 { PxXɃAbv
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_X))
        {
            // LED̋Pxݒ/擾܂
           result = mcu.WriteBySend(0x28,
                                     &setBrightness, sizeof(setBrightness));
            NN_UTIL_PANIC_IF_FAILED(result);
            Printf("[HwCheck] WriteBySend():0x%x\n", setBrightness);

            u8 brightness;
            result = mcu.ReadByReceive(0x28,
                                       &brightness, sizeof(brightness));
            NN_UTIL_PANIC_IF_FAILED(result);
            Printf("[HwCheck] ReadByReceive():0x%x\n", brightness);

            if ((u32)setBrightness + 0x11 > 0xFF)
            {
                setBrightness = 0x0;
            }
            else
            {
                setBrightness += 0x11;
            }
        }

        // START{^  {[ǂݎ
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_START))
        {
            u8 volume;
            result = mcu.GetSoundVolume(&volume);
            NN_UTIL_PANIC_IF_FAILED(result);
            Printf("[HwCheck] GetSoundVolume():0x%x\n", volume);
        }

        // R{^
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_R))
        {
            const char* msgConsole[] =
            {
                "RETAIL", "TS-Board", "White Board", "Reserved"
            };

            u8 param[5];
            result = mcu.GetInfoRegisters(param, 5);
            NN_UTIL_PANIC_IF_FAILED(result);

            NN_ASSERT(param[0] < 4);
            Printf("[HwCheck]:GetInfoRegisters: Console type   :%s\n", msgConsole[param[0]]);
            Printf("[HwCheck]:GetInfoRegisters: PMIC vendor    :%x\n", param[1]);
            Printf("[HwCheck]:GetInfoRegisters: Battery vendoor:%x\n", param[2]);
            Printf("[HwCheck]:GetInfoRegisters: MGIC version(8):%x\n", param[3]);
            Printf("[HwCheck]:GetInfoRegisters: MGIC version(9):%x\n", param[4]);


            /*  0: {̎ʏ         (0:@ 1:TS{[h 2:  3` \)
                1: PMICx_       (PMIC̃WX^0x01)
                2: drx_       (0`7)
                3: MGICo[W   (MGIC̃WX^0x08)
                4:                  (MGIC̃WX^0x09) */
        }

        // B{^
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_B))
        {
            u8 data;
            result = mcu.GetBatteryRemain(&data);
            NN_UTIL_PANIC_IF_FAILED(result);
            Printf("[HwCheck] GetBatteryRemain():0x%x\n", data);

            // obed擾܂B
            result = mcu.GetBatteryVoltage(&data);
            NN_UTIL_PANIC_IF_FAILED(result);
            Printf("[HwCheck] GetBatteryVoltage():0x%x\n", data);
        }

        //  L{^
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_L))
        {
            result = mcu.SetVcomTop( setParam );
            NN_UTIL_PANIC_IF_FAILED(result);
            Printf("[HwCheck] SetVcomTop():0x%x\n", setParam);

            result = mcu.SetVcomBottom( setParam );
            NN_UTIL_PANIC_IF_FAILED(result);
            Printf("[HwCheck] SetVcomBottom():0x%x\n", setParam);

            setParam += 30;
        }

        if  ( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) break;

        // Sleep
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromNanoSeconds(200 * 1000 * 1000));
    }
}


/*---------------------------------------------------------------------------
 Desc:  MCŨ|[g@֐
        IAA{^ōČAB{^Ńj[ʂɕA
---------------------------------------------------------------------------*/
void  DemoMcu::Run2()
{

    Result result_check;

    // ServiceManagervZX̏
    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

#if 1   // ʂ̃[hp
    // Read

    // MCUǂݏol
    u8 mcu_read_data1 = 0xff;
    u8 mcu_read_data2 = 0xff;
    u8 mcu_version[2];

    result_check = mcu.ReadByReceive(0x00,  &mcu_read_data1, sizeof(mcu_read_data1));
    NN_UTIL_PANIC_IF_FAILED(result_check);
    Printf("test1\n");

    // Read
    result_check = mcu.ReadByReceive(0x01,  &mcu_read_data2, sizeof(mcu_read_data2));
    NN_UTIL_PANIC_IF_FAILED(result_check);
    Printf("test2\n");

    mcu_read_data1 = mcu_read_data1 & 0x0f;

    mcu_version[0] = mcu_read_data1;
    mcu_version[1] = mcu_read_data2;

    mcu.SetPowerLEDPattern( static_cast<nn::mcu::CTR::PowerLedPattern>(4) );

    Printf("end3  1:%x 2:%x 3:%x 3:%x \n", mcu_read_data1, mcu_read_data2, mcu_version[0], mcu_version[1] );
#else   // o[Xg[hp
    u8 mcu_version[6];

    // Read
    result_check = mcu.ReadByReceive(0x7F,  mcu_version, sizeof(mcu_version));
    NN_UTIL_PANIC_IF_FAILED(result_check);
    Printf("end3  1:%x 2:%x 3:%x 4:%x 5:%x 6:%x \n", mcu_version[0], mcu_version[1], mcu_version[2], mcu_version[3], mcu_version[4], mcu_version[5] );

#endif

}


}   // eva
}   // uji





/*--------------------------------------------------------------------------*
    MCŨ[h֐
*--------------------------------------------------------------------------*/
u8 uji::eva::mcu::ReadMcu(u8 address)
{

    Result result_check;
    u8 mcu_read_data = 0xff;    // MCUǂݏol

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // Read
    result_check = mcu.ReadByReceive(address, &mcu_read_data, sizeof(mcu_read_data));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    return mcu_read_data;

}


//------------------------------------------------------------------------------
//  ȉAEC^[tF[Xp֐
//------------------------------------------------------------------------------


//---------------------------------------------------------------------------
// CTR:73-002  NTR:35-001  GET MGIC VERSION   MGIC̃o[W擾
//---------------------------------------------------------------------------
bool uji::eva::mcu::GetMgicVersion(TestResult &result)
{

    Result result_check;
    u8 burst_data[4];

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // o[Xg[h
    u8 read_7F_data[6];

    // Read
    result_check = mcu.ReadByReceive(0x7F,  read_7F_data, sizeof(read_7F_data));

    burst_data[1] = 0x00;
    burst_data[0] = read_7F_data[3];
    burst_data[3] = 0x00;
    burst_data[2] = read_7F_data[4];

    g_CommC2T->WriteDpramBinary( burst_data, sizeof(burst_data) );

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:73-003  NTR:35-002  GET PMIC VERSION   PMIC̃o[W擾
//---------------------------------------------------------------------------
bool uji::eva::mcu::GetPmicVersion(TestResult &result)
{

    Result result_check;
    u8 burst_data[2];

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // o[Xg[h
    u8 read_7F_data[6];

    // Read
    result_check = mcu.ReadByReceive(0x7F,  read_7F_data, sizeof(read_7F_data));

    burst_data[1] = 0x00;
    burst_data[0] = read_7F_data[1];

    g_CommC2T->WriteDpramBinary( burst_data, sizeof(burst_data) );

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:73-005  NTR:35-003  GET MCU VERSION   MCŨo[W擾
//---------------------------------------------------------------------------
bool uji::eva::mcu::GetMcuVersion(TestResult &result)
{

    Result result_check;
    u8 mcu_addres = 0;  // MCŨAhX
    u8 mcu_write_data = 0;  // MCUɏޒl
    u8 mcu_read_data1 = 0xff;   // MCUǂݏol1
    u8 mcu_read_data2 = 0xff;   // MCUǂݏol2
    u8 mcu_version[4];

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // Read
    result_check = mcu.ReadByReceive(0x00,  &mcu_read_data1, sizeof(mcu_read_data1));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    // Read
    result_check = mcu.ReadByReceive(0x01,  &mcu_read_data2, sizeof(mcu_read_data2));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    mcu_version[1] = 0x00;
    mcu_version[0] = mcu_read_data1 & 0x0f;
    mcu_version[3] = 0x00;
    mcu_version[2] = mcu_read_data2;

    g_CommC2T->WriteDpramBinary( mcu_version, sizeof(mcu_version) );

    result.m_Result = true;
    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:73-006  NTR:35-004  GET CONSOLE TYPE   PMIC̃o[W擾
//---------------------------------------------------------------------------
bool uji::eva::mcu::GetConsoleType(TestResult &result)
{

    Result result_check;
    u8 burst_data[2];

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // o[Xg[h
    u8 read_7F_data[6];

    // Read
    result_check = mcu.ReadByReceive(0x7F,  read_7F_data, sizeof(read_7F_data));

    burst_data[1] = 0x00;
    burst_data[0] = read_7F_data[0];

    g_CommC2T->WriteDpramBinary( burst_data, sizeof(burst_data) );

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:72-004  NTR:35-005  GET BATTERY TYPE   dr̃x_擾
//---------------------------------------------------------------------------
bool uji::eva::mcu::GetBatteryType(TestResult &result)
{

    Result result_check;
    u8 burst_data[2];

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // o[Xg[h
    u8 read_7F_data[6];

    // Read
    result_check = mcu.ReadByReceive(0x7F,  read_7F_data, sizeof(read_7F_data));

    burst_data[1] = 0x00;
    burst_data[0] = read_7F_data[2];

    g_CommC2T->WriteDpramBinary( burst_data, sizeof(burst_data) );

// FTR JI/Fp
#ifdef EVA_CAM_AND_IF
    result.Pad[0] = read_7F_data[2];
#endif

    result.m_Result = true;

    return result.m_Result;

}


//--------------------------------------------------------------------------------------------------
// CTR:72-011  NTR:35-006  GET BATTERY TEMP   팟̓drx擾܂        ʂ̃[h
//--------------------------------------------------------------------------------------------------
bool uji::eva::mcu::GetBatteryTemp(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUǂݏol
    u8 mcu_read_data1 = 0xff;
    u8 mcu_data[2];

    result_check = mcu.ReadByReceive(0x0a,  &mcu_read_data1, sizeof(mcu_read_data1));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    mcu_data[1] = 0x00;
    mcu_data[0] = mcu_read_data1;

    g_CommC2T->WriteDpramBinary( mcu_data, sizeof(mcu_data) );

    result.m_Result = true;

    return result.m_Result;

}


//--------------------------------------------------------------------------------------------------
// CTR:72-005,6  NTR:35-007  GET VCELL BOARD   팟̓drdx擾܂     ʂ̃[h
//--------------------------------------------------------------------------------------------------
bool uji::eva::mcu::GetVcellBoard(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUǂݏol
    u8 mcu_read_data1 = 0xff;
    u8 mcu_data[2];

    result_check = mcu.ReadByReceive(0x0d,  &mcu_read_data1, sizeof(mcu_read_data1));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    mcu_data[1] = (mcu_read_data1 * 20) / 0x100;
    mcu_data[0] = (mcu_read_data1 * 20) % 0x100;

    g_CommC2T->WriteDpramBinary( mcu_data, sizeof(mcu_data) );

// FTR JI/Fp
#ifdef EVA_CAM_AND_IF
    result.Pad[0] = mcu_read_data1;
#endif

    result.m_Result = true;

    return result.m_Result;

}


//----------------------------------------------------------------------------------------------------------------
// CTR:72-007,8  NTR:35-008  GET BATTERY REMAIN BOARD   팟̓drcʃx擾܂        ʂ̃[h
//----------------------------------------------------------------------------------------------------------------
bool uji::eva::mcu::GetBatteryRemainBoard(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUǂݏol
    u8 mcu_read_data1 = 0xff;
    u8 mcu_data[2];

    result_check = mcu.ReadByReceive(0x0b,  &mcu_read_data1, sizeof(mcu_read_data1));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    mcu_data[1] = 0x00;
    mcu_data[0] = mcu_read_data1;

    g_CommC2T->WriteDpramBinary( mcu_data, sizeof(mcu_data) );

// FTR JI/Fp
#ifdef EVA_CAM_AND_IF
    result.Pad[0] = mcu_read_data1;
#endif

    result.m_Result = true;

    return result.m_Result;

}


//----------------------------------------------------------------------------------------------------------------
// NTR:35-009  RESET VIA MCU   MCUɑ΂AZbgR}h𔭂܂ MCU_COMMAND0_ADDR
//----------------------------------------------------------------------------------------------------------------
bool uji::eva::mcu::ResetViaMcu(TestResult &result)
{
    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUɏޒl
    u8 mcu_write_data = 0x02;

    result_check = mcu.WriteBySend(MCU_COMMAND0_ADDR,  &mcu_write_data, sizeof(mcu_write_data));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    result.m_Result = true;

    return result.m_Result;
}


//----------------------------------------------------------------------------------------------------------------
// NTR:35-010  SET MASTER_LED MAX   LED_̋Pxݒőɂ܂       ʂ̃Cg
//----------------------------------------------------------------------------------------------------------------
bool uji::eva::mcu::SetMasterLedMax(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUɏޒl
    u8 mcu_write_data = 0xff;

    result_check = mcu.WriteBySend(0x28,  &mcu_write_data, sizeof(mcu_write_data));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-001  NTR:35-011     dԐFLED̓_
//---------------------------------------------------------------------------
bool uji::eva::mcu::PowerLedRedOn(TestResult &result)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    mcu.SetPowerLEDPattern( static_cast<nn::mcu::CTR::PowerLedPattern>(4) );

    // 100msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-001  NTR:35-012     dԐFLED̏
//---------------------------------------------------------------------------
bool uji::eva::mcu::PowerLedRedOff(TestResult &result)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    mcu.SetPowerLEDPattern( static_cast<nn::mcu::CTR::PowerLedPattern>(3) );

    // 100msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-002  NTR:35-013     dFLED̓_
//---------------------------------------------------------------------------
bool uji::eva::mcu::PowerLedBlueOn(TestResult &result)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    mcu.SetPowerLEDPattern( static_cast<nn::mcu::CTR::PowerLedPattern>(5) );

    // 100msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-002  NTR:35-014     dFLED̏
//---------------------------------------------------------------------------
bool uji::eva::mcu::PowerLedBlueOff(TestResult &result)
{

    // RtBOp
    Config::Member mcuMember;
    Config mcuConfig;
    mcuMember = mcuConfig.Get();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    mcu.SetPowerLEDPattern( static_cast<nn::mcu::CTR::PowerLedPattern>(3) );

    // WaitPowerBlueOff msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(mcuMember.WaitPowerBlueOff));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-003  NTR:35-015     LEDiFj̓_
//---------------------------------------------------------------------------
bool uji::eva::mcu::WiFiLedYellowOn(TestResult &result)
{

    // RtBOp
    Config::Member mcuMember;
    Config mcuConfig;
    mcuMember = mcuConfig.Get();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    mcu.SetWifiLEDPattern(static_cast<nn::mcu::CTR::WifiLedPattern>(1));

    // WaitWiFiYellowOn msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(mcuMember.WaitWiFiYellowOn));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-003  NTR:35-016     LEDiFj̏
//---------------------------------------------------------------------------
bool uji::eva::mcu::WiFiLedYellowOff(TestResult &result)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    mcu.SetWifiLEDPattern(static_cast<nn::mcu::CTR::WifiLedPattern>(0));

    // 100msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-004  NTR:35-017     TUNEpLEDiΐFj̓_
//---------------------------------------------------------------------------
bool uji::eva::mcu::TuneLedGreenOn(TestResult &result)
{

    // RtBOp
    Config::Member mcuMember;
    Config mcuConfig;
    mcuMember = mcuConfig.Get();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    mcu.SetSVR2LEDPattern(static_cast<nn::mcu::CTR::SVR2LedPattern>(1));

    // WaitTuneGreenOn msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(mcuMember.WaitTuneGreenOn));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-004  NTR:35-018     TUNEpLEDiΐFj̏
//---------------------------------------------------------------------------
bool uji::eva::mcu::TuneLedGreenOff(TestResult &result)
{

    // RtBOp
    Config::Member mcuMember;
    Config mcuConfig;
    mcuMember = mcuConfig.Get();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    mcu.SetSVR2LEDPattern(static_cast<nn::mcu::CTR::SVR2LedPattern>(0));

    // WaitTuneGreenOff msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(mcuMember.WaitTuneGreenOff));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-005  NTR:35-019     JpLEDisNj̓_
//---------------------------------------------------------------------------
bool uji::eva::mcu::CameraLedPinkOn(TestResult &result)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    mcu.SetCameraLEDPattern(static_cast<nn::mcu::CTR::CameraLedPattern>(2));

    // 100msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-005  NTR:35-020     JpLEDisNj̏
//---------------------------------------------------------------------------
bool uji::eva::mcu::CameraLedPinkOff(TestResult &result)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    mcu.SetCameraLEDPattern(static_cast<nn::mcu::CTR::CameraLedPattern>(0));

    // 100msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-006  NTR:35-021     m点vLEDiԁj̓_
//---------------------------------------------------------------------------
bool uji::eva::mcu::NotifyLedRedOn(TestResult &result)
{

    // RtBOp
    Config::Member mcuMember;
    Config mcuConfig;
    mcuMember = mcuConfig.Get();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 32; i++)
    {
        infoLedPattern[0].frameColors[i] = 255;
    }

    for(int i = 32; i < 96; i++)
    {
        infoLedPattern[0].frameColors[i] = 0;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[0] );

    // WaitNotifyRedOn msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(mcuMember.WaitNotifyRedOn));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-006  NTR:35-022     m点vLEDiԐFj̏
//---------------------------------------------------------------------------
bool uji::eva::mcu::NotifyLedRedOff(TestResult &result)
{

    // RtBOp
    Config::Member mcuMember;
    Config mcuConfig;
    mcuMember = mcuConfig.Get();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 96; i++)
    {
        infoLedPattern[0].frameColors[i] = 0;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[0] );

    // WaitNotifyRedOff msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(mcuMember.WaitNotifyRedOff));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// c[     m点vLEDiԐFj̓_
//---------------------------------------------------------------------------
void uji::eva::mcu::NotifyLedRedBlinker(void)
{

    // RtBOp
    Config::Member mcuMember;
    Config mcuConfig;
    mcuMember = mcuConfig.Get();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 32; i++)
    {
        if(i%2)infoLedPattern[0].frameColors[i] = 255;
        else   infoLedPattern[0].frameColors[i] = 0;
    }

    for(int i = 32; i < 96; i++)
    {
        if(i%2)infoLedPattern[0].frameColors[i] = 0;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[0] );

    // WaitNotifyRedOff msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(mcuMember.WaitNotifyRedOff));

    return;

}


//---------------------------------------------------------------------------
// CTR:74-007  NTR:35-023     m点vLED()̓_
//---------------------------------------------------------------------------
bool uji::eva::mcu::NotifyLedGreenOn(TestResult &result)
{

    // RtBOp
    Config::Member mcuMember;
    Config mcuConfig;
    mcuMember = mcuConfig.Get();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 32; i++)
    {
        infoLedPattern[1].frameColors[i] = 0;
    }

    for(int i = 32; i < 64; i++)
    {
        infoLedPattern[1].frameColors[i] = 255;
    }

    for(int i = 64; i < 96; i++)
    {
        infoLedPattern[1].frameColors[i] = 0;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[1] );

    // WaitNotifyGreenOn msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(mcuMember.WaitNotifyGreenOn));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-007  NTR:35-024     m点vLED()̏
//---------------------------------------------------------------------------
bool uji::eva::mcu::NotifyLedGreenOff(TestResult &result)
{

    // RtBOp
    Config::Member mcuMember;
    Config mcuConfig;
    mcuMember = mcuConfig.Get();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 96; i++)
    {
        infoLedPattern[1].frameColors[i] = 0;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[1] );

    // WaitNotifyGreenOff msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(mcuMember.WaitNotifyGreenOff));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// c[     m点vLEDiΐFj̓_
//---------------------------------------------------------------------------
void uji::eva::mcu::NotifyLedGreenBlinker(void)
{

    // RtBOp
    Config::Member mcuMember;
    Config mcuConfig;
    mcuMember = mcuConfig.Get();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 32; i++)
    {
        infoLedPattern[1].frameColors[i] = 0;
    }

    for(int i = 32; i < 64; i++)
    {
        if(i%2)infoLedPattern[1].frameColors[i] = 255;
        else   infoLedPattern[1].frameColors[i] = 0;
    }

    for(int i = 64; i < 96; i++)
    {
        infoLedPattern[1].frameColors[i] = 0;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[1] );

    // WaitNotifyRedOff msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(mcuMember.WaitNotifyRedOff));

    return ;

}


//---------------------------------------------------------------------------
// CTR:74-008  NTR:35-025     m点vLED()̓_
//---------------------------------------------------------------------------
bool uji::eva::mcu::NotifyLedBlueOn(TestResult &result)
{

    // RtBOp
    Config::Member mcuMember;
    Config mcuConfig;
    mcuMember = mcuConfig.Get();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 32; i++)
    {
        infoLedPattern[2].frameColors[i] = 0;
    }

    for(int i = 32; i < 64; i++)
    {
        infoLedPattern[2].frameColors[i] = 0;
    }

    for(int i = 64; i < 96; i++)
    {
        infoLedPattern[2].frameColors[i] = 255;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[2] );

    // WaitNotifyBlueOn msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(mcuMember.WaitNotifyBlueOn));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// CTR:74-008  NTR:35-026     m点vLED()̏
//---------------------------------------------------------------------------
bool uji::eva::mcu::NotifyLedBlueOff(TestResult &result)
{

    // RtBOp
    Config::Member mcuMember;
    Config mcuConfig;
    mcuMember = mcuConfig.Get();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 96; i++)
    {
        infoLedPattern[2].frameColors[i] = 0;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[2] );

    // WaitNotifyBlueOff msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(mcuMember.WaitNotifyBlueOff));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// c[     m点vLEDiFj̓_
//---------------------------------------------------------------------------
void uji::eva::mcu::NotifyLedBlueBlinker(void)
{

    // RtBOp
    Config::Member mcuMember;
    Config mcuConfig;
    mcuMember = mcuConfig.Get();

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 64; i++)
    {
        if(i%2)infoLedPattern[2].frameColors[i] = 0;
    }

    for(int i = 64; i < 96; i++)
    {
        if(i%2)infoLedPattern[2].frameColors[i] = 255;
        else   infoLedPattern[2].frameColors[i] = 0;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[2] );

    // WaitNotifyRedOff msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(mcuMember.WaitNotifyRedOff));

    return;

}


//---------------------------------------------------------------------------
// c[     m点vLEDiԁ΁Fj̓_
//---------------------------------------------------------------------------
void uji::eva::mcu::NotifyLedRGBBlinker(void)
{

    // RtBOp
    Config mcuConfig;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // 
    for(int i = 0; i < 32; i++)
    {

        // 0-10
        if(i<9) infoLedPattern[3].frameColors[i] = 255;
        else    infoLedPattern[3].frameColors[i] = 0;
    }

    // 
    for(int i = 32; i < 64; i++)
    {
        // 43-53
        if( (42<i) && (i<52) ) infoLedPattern[3].frameColors[i] = 255;
        else                   infoLedPattern[3].frameColors[i] = 0;
    }

    // 
    for(int i = 64; i < 96; i++)
    {
        // 86-95
        if(i>85)               infoLedPattern[3].frameColors[i] = 255;
        if( (85<i) && (i<94) ) infoLedPattern[3].frameColors[i] = 255;
        else                   infoLedPattern[3].frameColors[i] = 0;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[3] );

    return;

}


//---------------------------------------------------------------------------
// c[     m点vLED()̓_
//---------------------------------------------------------------------------
void uji::eva::mcu::NotifyLedWhiteOn(void)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 32; i++)
    {
        infoLedPattern[0].frameColors[i] = 255;
    }

    for(int i = 32; i < 64; i++)
    {
        infoLedPattern[0].frameColors[i] = 255;
    }

    for(int i = 64; i < 96; i++)
    {
        infoLedPattern[0].frameColors[i] = 255;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[0] );

}


//---------------------------------------------------------------------------
// c[     m点vLED()̏
//---------------------------------------------------------------------------
void uji::eva::mcu::NotifyLedWhiteOff(void)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 32; i++)
    {
        infoLedPattern[0].frameColors[i] = 0;
    }

    for(int i = 32; i < 64; i++)
    {
        infoLedPattern[0].frameColors[i] = 0;
    }

    for(int i = 64; i < 96; i++)
    {
        infoLedPattern[0].frameColors[i] = 0;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[0] );

}


//--------------------------------------------------------------------------------------------------
// CTR:80-001  NTR:35-027  FLICKER ADJUST MAX   tbJ[@\iőݒǰ        ʂ̃[h
//--------------------------------------------------------------------------------------------------
bool uji::eva::mcu::FlickerAdjustMax(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUɏޒl
    u8 mcu_write_data = 0xff;

    result_check = mcu.WriteBySend(MCU_VCOM_TOP_ADDR,  &mcu_write_data, sizeof(mcu_write_data));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    // 20msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

    result_check = mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,  &mcu_write_data, sizeof(mcu_write_data));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    // MCUǂݏol
    u8 mcu_read_data[2] = { 0x11, 0x11 };
    u8 mcu_data[4];

    result_check = mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,  &mcu_read_data[0], sizeof(mcu_read_data[0]));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    result_check = mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR,  &mcu_read_data[1], sizeof(mcu_read_data[1]));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    mcu_data[1] = 0x00;
    mcu_data[0] = mcu_read_data[0];

    mcu_data[3] = 0x00;
    mcu_data[2] = mcu_read_data[1];

    g_CommC2T->WriteDpramBinary( mcu_data, sizeof(mcu_data) );

    // 500msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));

    result.m_Result = true;

    return result.m_Result;

}


//--------------------------------------------------------------------------------------------------
// CTR:80-002  NTR:35-028  FLICKER ADJUST MIN   tbJ[@\iŏݒǰ        ʂ̃[h
//--------------------------------------------------------------------------------------------------
bool uji::eva::mcu::FlickerAdjustMin(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUɏޒl
    u8 mcu_write_data = 0x00;

    result_check = mcu.WriteBySend(MCU_VCOM_TOP_ADDR,  &mcu_write_data, sizeof(mcu_write_data));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    // 20msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

    result_check = mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,  &mcu_write_data, sizeof(mcu_write_data));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    // MCUǂݏol
    u8 mcu_read_data[2] = { 0x11, 0x11 };
    u8 mcu_data[4];

    result_check = mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,  &mcu_read_data[0], sizeof(mcu_read_data[0]));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    result_check = mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR,  &mcu_read_data[1], sizeof(mcu_read_data[1]));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    mcu_data[1] = 0x00;
    mcu_data[0] = mcu_read_data[0];

    mcu_data[3] = 0x00;
    mcu_data[2] = mcu_read_data[1];

    g_CommC2T->WriteDpramBinary( mcu_data, sizeof(mcu_data) );

    // 500msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));

    result.m_Result = true;

    return result.m_Result;

}

//--------------------------------------------------------------------------------------------------
// CTR:80-010  NTR:35-036  FLICKER ADJUST MAX   tbJ[@\iőݒǰ        ʂ̃[h
//--------------------------------------------------------------------------------------------------
bool uji::eva::mcu::FlickerAdjustMax_NEC(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUɏޒl
    u8 mcu_write_data = 0xff;

    result_check = mcu.WriteBySend(MCU_VCOM_TOP_ADDR,  &mcu_write_data, sizeof(mcu_write_data));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    // 20msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

    result_check = mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,  &mcu_write_data, sizeof(mcu_write_data));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    // MCUǂݏol
    u8 mcu_read_data[2] = { 0x11, 0x11 };
    u8 mcu_data[4];

    result_check = mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,  &mcu_read_data[0], sizeof(mcu_read_data[0]));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    result_check = mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR,  &mcu_read_data[1], sizeof(mcu_read_data[1]));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    mcu_data[1] = 0x00;
    mcu_data[0] = mcu_read_data[0];

    mcu_data[3] = 0x00;
    mcu_data[2] = mcu_read_data[1];

    g_CommC2T->WriteDpramBinary( mcu_data, sizeof(mcu_data) );

    result.m_Result = true;

    return result.m_Result;

}


//--------------------------------------------------------------------------------------------------
// CTR:80-011  NTR:35-037  FLICKER ADJUST MIN   tbJ[@\iŏݒǰ        ʂ̃[h
//--------------------------------------------------------------------------------------------------
bool uji::eva::mcu::FlickerAdjustMin_NEC(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUɏޒl
    u8 mcu_write_data = 0x00;

    result_check = mcu.WriteBySend(MCU_VCOM_TOP_ADDR,  &mcu_write_data, sizeof(mcu_write_data));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    // 20msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(20));

    result_check = mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,  &mcu_write_data, sizeof(mcu_write_data));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    // MCUǂݏol
    u8 mcu_read_data[2] = { 0x11, 0x11 };
    u8 mcu_data[4];

    result_check = mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,  &mcu_read_data[0], sizeof(mcu_read_data[0]));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    result_check = mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR,  &mcu_read_data[1], sizeof(mcu_read_data[1]));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    mcu_data[1] = 0x00;
    mcu_data[0] = mcu_read_data[0];

    mcu_data[3] = 0x00;
    mcu_data[2] = mcu_read_data[1];

    g_CommC2T->WriteDpramBinary( mcu_data, sizeof(mcu_data) );

    result.m_Result = true;

    return result.m_Result;

}

//--------------------------------------------------------------------------------------------------
// CTR:86-004  NTR:35-029  GET TUNE VOLUME   팟TUNE{[擾܂       ʂ̃[h
//--------------------------------------------------------------------------------------------------
bool uji::eva::mcu::GetTuneVol(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUǂݏol
    u8 mcu_read_data1 = 0xff;
    u8 mcu_data[2];

    result_check = mcu.ReadByReceive(0x08,  &mcu_read_data1, sizeof(mcu_read_data1));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    mcu_data[1] = 0x00;
    mcu_data[0] = mcu_read_data1;

    g_CommC2T->WriteDpramBinary( mcu_data, sizeof(mcu_data) );

    result.m_Result = true;

    return result.m_Result;

}


//--------------------------------------------------------------------------------------------------
// CTR:78-002,003  NTR:35-030  GET SOUND VOLUME   팟̉ʒ{[擾܂      ʂ̃[h
//--------------------------------------------------------------------------------------------------
bool uji::eva::mcu::GetSoundVol(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUǂݏol
    u8 mcu_read_data1 = 0xff;
    u8 mcu_data[2];

    result_check = mcu.ReadByReceive(0x09,  &mcu_read_data1, sizeof(mcu_read_data1));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    mcu_data[1] = 0x00;
    mcu_data[0] = mcu_read_data1;

    g_CommC2T->WriteDpramBinary( mcu_data, sizeof(mcu_data) );

    result.m_Result = true;

    return result.m_Result;

}


//--------------------------------------------------------------------------------------------------
// CTR:78-004  NTR:35-031  WAIT SOUND VOLUME MAX  ʃ{[őʒuǂ`FbNAőłȂꍇ͍őʒuɂ悤܂  ʂ̃[h
//--------------------------------------------------------------------------------------------------
bool uji::eva::mcu::WaitSoundVolMax(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUǂݏol
    u8 mcu_read_data1 = 0xff;
    u8 mcu_data[2];
    u8 dpram_data = 0x00;

    g_CommC2T->ReadDpramBinary( &dpram_data, sizeof(dpram_data) );

    // ʃ{[őɒB܂ő肵
    while(1)
    {
        result_check = mcu.ReadByReceive(MCU_SOUND_VOLUME_ADDR,  &mcu_read_data1, sizeof(mcu_read_data1));
        NN_UTIL_PANIC_IF_FAILED(result_check);

        if(mcu_read_data1 > dpram_data) break;
    }

    // 500msec҂ĂAēxTEh{[ʒu擾
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));

    result_check = mcu.ReadByReceive(MCU_SOUND_VOLUME_ADDR,  &mcu_read_data1, sizeof(mcu_read_data1));
    NN_UTIL_PANIC_IF_FAILED(result_check);

    mcu_data[1] = dpram_data;
    mcu_data[0] = mcu_read_data1;

    g_CommC2T->WriteDpramBinary( mcu_data, sizeof(mcu_data) );

    result.m_Result = true;

    return result.m_Result;

}


//--------------------------------------------------------------------------------------------------
// CTR:74-011  NTR:35-032  DETECT OPEN tWJƂoł邱Ƃ܂
//--------------------------------------------------------------------------------------------------
bool uji::eva::mcu::DetectOpen(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUǂݏol
    u8 mcu_read_data1 = 0xff;
    u8 mcu_data[2];

    while(1)
    {
        result_check = mcu.ReadByReceive(0x0F,  &mcu_read_data1, sizeof(mcu_read_data1));
        NN_UTIL_PANIC_IF_FAILED(result_check);
        if( (mcu_read_data1 & 0x02) == 0x02 ) break;
    }

    mcu_data[1] = 0x00;
    mcu_data[0] = mcu_read_data1;

    g_CommC2T->WriteDpramBinary( mcu_data, sizeof(mcu_data) );

    result.m_Result = true;
    return result.m_Result;
}


//--------------------------------------------------------------------------------------------------
// CTR:74-010  NTR:35-033  DETECT FOLD tWoł邱Ƃ܂
//--------------------------------------------------------------------------------------------------
bool uji::eva::mcu::DetectFold(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUǂݏol
    u8 mcu_read_data1 = 0xff;
    u8 mcu_data[2];

    while(1)
    {
        result_check = mcu.ReadByReceive(0x0F, &mcu_read_data1, sizeof(mcu_read_data1));
        NN_UTIL_PANIC_IF_FAILED(result_check);
        if( (mcu_read_data1 & 0x02) == 0x00 ) break;
    }

    mcu_data[1] = 0x00;
    mcu_data[0] = mcu_read_data1;

    g_CommC2T->WriteDpramBinary( mcu_data, sizeof(mcu_data) );

    result.m_Result = true;
    return result.m_Result;

}

//---------------------------------------------------------------------------
// CTR:74-012  NTR:35-034     LED̓_
//---------------------------------------------------------------------------
bool uji::eva::mcu::LedOnTest_NEC(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // dԐFLED̓_
    mcu.SetPowerLEDPattern( static_cast<nn::mcu::CTR::PowerLedPattern>(4) );

    // m点vLED̓_
    for(int i = 0; i < 96; i++)
    {
        infoLedPattern[0].frameColors[i] = 255;
    }
    mcu.SetInfoLEDPattern( infoLedPattern[0] );

    // 1000msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1000));

    result.m_Result = true;

    return result.m_Result;

}

//---------------------------------------------------------------------------
// CTR:74-012  NTR:35-035     LED̏
//---------------------------------------------------------------------------
bool uji::eva::mcu::LedOffTest_NEC(TestResult &result)
{

    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // dԐF/FLED̏
    mcu.SetPowerLEDPattern( static_cast<nn::mcu::CTR::PowerLedPattern>(3) );

    // m点vLED̏
    for(int i = 0; i < 96; i++)
    {
        infoLedPattern[0].frameColors[i] = 0;
        infoLedPattern[1].frameColors[i] = 0;
        infoLedPattern[2].frameColors[i] = 0;
    }
    mcu.SetInfoLEDPattern( infoLedPattern[0] );
    mcu.SetInfoLEDPattern( infoLedPattern[1] );
    mcu.SetInfoLEDPattern( infoLedPattern[2] );

    // 1000msec҂
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(1000));

    result.m_Result = true;

    return result.m_Result;

}

//----------------------------------------------------------------------------------------------------------------
// CTR:73-008  NTR:39-001  GET ACCEL XYZ   3xZTXYZf[^擾܂
//----------------------------------------------------------------------------------------------------------------
bool uji::eva::mcu::GetAccelXYZ(TestResult &result)
{

    Result result_check;

    // CX^X̃^C~OŉxTvOSDK-0.12
    nn::hid::AccelerometerReader accReader;

    // WaitSamplingp
    nn::hid::Accelerometer& accelerometer = nn::hid::GetAccelerometer( );

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    //
    u8 mcu_data[6];
    u8 burst_data[6];
    u8 test_data;
    s16 x = 0;
    s16 y = 0;
    s16 z = 0;

    u16 x_u = 0;
    u16 y_u = 0;
    u16 z_u = 0;

    s16 sampling_sum_x = 0;
    s16 sampling_sum_y = 0;
    s16 sampling_sum_z = 0;

    s16 average_x = 0;
    s16 average_y = 0;
    s16 average_z = 0;

    s16 sampling_buf_x[30];
    s16 sampling_buf_y[30];
    s16 sampling_buf_z[30];

    // xZT
    s16 gx = 0;
    s16 gx_max = 0;
    s16 gx_min = 0;
    s16 gy = 0;
    s16 gy_max = 0;
    s16 gy_min = 0;
    s16 gz = 0;
    s16 gz_max = 0;
    s16 gz_min = 0;

    // Ԉ莞̃JEgi[ϐ
    u32 stability_count_gx = 0;
    u32 stability_count_gy = 0;
    u32 stability_count_gz = 0;
    u32 stability_ok_flag = 0;

    // f[^p̃JE^[
    s32 data_counter = 0;

    while(1)
    {

        result_check = mcu.ReadByReceive(0x45,  burst_data, sizeof(burst_data));
        NN_UTIL_PANIC_IF_FAILED(result_check);

        x = burst_data[0] + burst_data[1]*0x100;
        y = burst_data[2] + burst_data[3]*0x100;
        z = burst_data[4] + burst_data[5]*0x100;

        x = x >> 4;
        y = y >> 4;
        z = z >> 4;

        sampling_buf_x[data_counter] = gx = x;
        sampling_buf_y[data_counter] = gy = y;
        sampling_buf_z[data_counter] = gz = z;

        // ------------------ẍmF--------------------
        if(gx_max < gx) gx_max = gx;
        if(gx_min > gx) gx_min = gx;

        if( (gx_max - gx_min) > 200 )
        {
            gx_max = gx;
            gx_min = gx;
            stability_count_gx = 0;
            data_counter = -1;
        }
        else
        {
            stability_count_gx++;
        }

        // ------------------ÿmF--------------------
        if(gy_max < gy) gy_max = gy;
        if(gy_min > gy) gy_min = gy;

        if( (gy_max - gy_min) > 200 )
        {
            gy_max = gy;
            gy_min = gy;
            stability_count_gy = 0;
            data_counter = -1;
        }
        else
        {
            stability_count_gy++;
        }

        // ------------------z̈mF--------------------
        if(gz_max < gz) gz_max = gz;
        if(gz_min > gz) gz_min = gz;

        if( (gz_max - gz_min) > 200 )
        {
            gz_max = gz;
            gz_min = gz;
            stability_count_gz = 0;
            data_counter = -1;
        }
        else
        {
            stability_count_gz++;
        }

        data_counter++;

        Printf("\n\n xl:%02x xh:%02x -> %04x  %d",  burst_data[0], burst_data[1], burst_data[0] + burst_data[1]*0x100, x  );
        Printf(  "\n yl:%02x yh:%02x -> %04x  %d",  burst_data[2], burst_data[3], burst_data[2] + burst_data[3]*0x100, y  );
        Printf(  "\n zl:%02x zh:%02x -> %04x  %d",  burst_data[4], burst_data[5], burst_data[4] + burst_data[5]*0x100, z  );

        // 萔̃Tv̒l肵Ăꍇbreak
        if( data_counter >= 30 )
        {
          break;
        }
    }


    for(u8 k=0;k<10;k++)
    {
        sampling_sum_x += sampling_buf_x[29-k];
        sampling_sum_y += sampling_buf_y[29-k];
        sampling_sum_z += sampling_buf_z[29-k];
        Printf( "\n k:%d %d %d %d", k, sampling_buf_x[29-k], sampling_buf_y[29-k], sampling_buf_z[29-k] );
    }

    average_x = sampling_sum_x / 10;
    average_y = sampling_sum_y / 10;
    average_z = sampling_sum_z / 10;

    average_x = abs(average_x);
    average_y = abs(average_y);
    average_z = abs(average_z);

    x_u = average_x;
    y_u = average_y;
    z_u = average_z;

    Printf( "\n s %d %d %d", sampling_sum_x, sampling_sum_y, sampling_sum_z );
    Printf( "\n a %d %d %d", average_x, average_y, average_z );
    Printf( "\n a %x %x %x", average_x, average_y, average_z );
    Printf( "\n u %x %x %x", x, y, z );
    Printf( "\n u %x %x %x", x_u, y_u, z_u );

    mcu_data[1] = (average_x & 0xff00) / 0x100;
    mcu_data[0] = average_x & 0x00ff;
    mcu_data[3] = (average_y & 0xff00) / 0x100;
    mcu_data[2] = average_y & 0x00ff;
    mcu_data[5] = (average_z & 0xff00) / 0x100;
    mcu_data[4] = average_z & 0x00ff;

    x = mcu_data[0] + mcu_data[1]*0x100;
    y = mcu_data[2] + mcu_data[3]*0x100;
    z = mcu_data[4] + mcu_data[5]*0x100;

    Printf("\n\n xl:%02x xh:%02x -> %04x  %d %d",  mcu_data[0], mcu_data[1], mcu_data[0] + mcu_data[1]*0x100, x, average_x );
    Printf(  "\n yl:%02x yh:%02x -> %04x  %d %d",  mcu_data[2], mcu_data[3], mcu_data[2] + mcu_data[3]*0x100, y, average_y );
    Printf(  "\n zl:%02x zh:%02x -> %04x  %d %d",  mcu_data[4], mcu_data[5], mcu_data[4] + mcu_data[5]*0x100, z, average_z );

    g_CommC2T->WriteDpramBinary( mcu_data, sizeof(mcu_data) );

    result.m_Result = true;

    return result.m_Result;

}

/*---------------------------------------------------------------------------*
  @brief        Ԍv֐
        vJn_
  ߂l    start_timeo߂(mS)
 *---------------------------------------------------------------------------*/
static s64 GetMicroSecond( nn::os::Tick start_time )
{

    nn::os::Tick currentTick = nn::os::Tick::GetSystemCurrent();

    float millisecond = (float)((currentTick - start_time).ToTimeSpan().GetMicroSeconds() / 1000.0);

    return millisecond;

}

//----------------------------------------------------------------------------------------------------------------
// LCD&KEYp  LED ON/OFFmF֐
//----------------------------------------------------------------------------------------------------------------
bool uji::eva::mcu::CheckLedOnOff(TestResult &result)
{

    //j[p̃EChE}l[W
    static uji::sys::WindowManager m_WindowManager;

    // Ԍvp
    nn::os::Tick start_tick;
    s64 test_time = 0;
    bool led_switch = 0;

    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    // }X^[ߓxύX܂
    m_WindowManager.SetAlpha(196);

    // J[\ʒup
    uji::sys::Point cursorPos;

    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;

    TestResult test_result;

    const u8 MAX_PATH_SIZE = 100;
    wchar_t ledPicMode1Path[ MAX_PATH_SIZE ];
    wchar_t ledPicMode2Path[ MAX_PATH_SIZE ];

    if( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
    {
        std::wcscpy( ledPicMode1Path, L"rom:/jpeg/CheckLed1_SPR.jpg");
        std::wcscpy( ledPicMode2Path, L"rom:/jpeg/CheckLed2_SPR.jpg");
    }else if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        std::wcscpy( ledPicMode1Path, L"rom:/jpeg/CheckLed1_FTR.jpg");
        std::wcscpy( ledPicMode2Path, L"rom:/jpeg/CheckLed2_FTR.jpg");
    }else if( uji::sys::PLATFORM_KTR == uji::sys::GetPlatformType())
    {
        std::wcscpy( ledPicMode1Path, L"rom:/jpeg/CheckLed1_KTR.jpg");
        std::wcscpy( ledPicMode2Path, L"rom:/jpeg/CheckLed2_KTR.jpg");
    }else
    {
        std::wcscpy( ledPicMode1Path, L"rom:/jpeg/CheckLed1_CTR.jpg");
        std::wcscpy( ledPicMode2Path, L"rom:/jpeg/CheckLed2_CTR.jpg");
    }

    // ------------------------------------\------------------------------------
    gfx->m_DrawFramework->Clear();

    //  EChE
    m_WindowManager.UpdatePad(pad);  // pbh
    m_WindowManager.Update();        // XV
    m_WindowManager.DrawDisplay0();

    //  `
    gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

    // `̑O
    gfx->SetFixedWidthFont(16);
    gfx->m_TextWriter.SetCursor(10, 20);

    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;
    // ------------------------------------\ ܂------------------------------------

    // 摜XV
    jpegDrawer->OpenPicture( ledPicMode1Path );
    jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
    glFlush();
    gfx->m_DrawFramework->SwapBuffers();

    uji::eva::mcu::PowerLedBlueOn(test_result);
    uji::eva::mcu::CameraLedPinkOn(test_result);
    uji::eva::mcu::NotifyLedRGBBlinker();
    uji::eva::mcu::TuneLedGreenOn(test_result);

    // ԌvJn
    start_tick = nn::os::Tick::GetSystemCurrent();

    while(1)
    {
        test_time = GetMicroSecond(start_tick);

        // Jn莞Ԃo߂Ăꍇ
        if ( test_time >= 500 )
        {
            if( led_switch == 0)
            {
                uji::eva::mcu::PowerLedRedOn(test_result);
                led_switch = 1;
                start_tick = nn::os::Tick::GetSystemCurrent();
            }
            else
            {
                uji::eva::mcu::PowerLedBlueOn(test_result);
                led_switch = 0;
                start_tick = nn::os::Tick::GetSystemCurrent();
            }

            start_tick = nn::os::Tick::GetSystemCurrent();
        }
        // L[͂̊mF
        padReader.ReadLatest(&padStatus);
        pad.UpdatePad(padStatus);

        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_A))
        {
            break;
        }
    };

    // 摜XV
    jpegDrawer->OpenPicture( ledPicMode2Path );
    jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
    glFlush();
    gfx->m_DrawFramework->SwapBuffers();

    uji::eva::mcu::NotifyLedWhiteOn();
    uji::eva::mcu::PowerLedBlueOff(test_result);
    uji::eva::mcu::PowerLedRedOff(test_result);
    uji::eva::mcu::CameraLedPinkOff(test_result);
    uji::eva::mcu::TuneLedGreenOff(test_result);

    while(1)
    {
        // L[͂̊mF
        padReader.ReadLatest(&padStatus);
        pad.UpdatePad(padStatus);

        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_A))
        {
            break;
        }
    };

    uji::eva::mcu::NotifyLedGreenOff(test_result);
    uji::eva::mcu::PowerLedBlueOn(test_result);

    jpegDrawer->ClosePicture();
    delete jpegDrawer;

    result.m_Result = true;
    return result.m_Result;

}


//---------------------------------------------------------------------------------------------------
// C^[tF[XLCD&L[DETECT OPEN,FOLDڍs邽߁Aw摜ǉ
// Open͌ȂFold̂ݕ\
//---------------------------------------------------------------------------------------------------
bool uji::eva::mcu::DetectFoldWithPicture(TestResult &result)
{

    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();
    sys::JpegDrawer* jpegDrawer = new sys::JpegDrawer;

    if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        jpegDrawer->OpenPicture(L"rom:/jpeg/SleepSwitchOnOff.jpg");
    }
    else
    {
        jpegDrawer->OpenPicture(L"rom:/jpeg/FoldAndOpen.jpg");
    }

    jpegDrawer->DrawPicture(NN_GX_DISPLAY0);
    glFlush();
    gfx->m_DrawFramework->SwapBuffers();

    DetectFold(result);

    jpegDrawer->ClosePicture();
    delete jpegDrawer;

    return result.m_Result;
}


//---------------------------------------------------------------------------------------------------
// C^[tF[Xŉʕ\ꍇ͉LύX
// tbJ[
//---------------------------------------------------------------------------------------------------
bool uji::eva::mcu::AdjustFlicker(TestResult &result)
{

    //j[p̃EChE}l[W
    static uji::sys::WindowManager m_WindowManager;

    uji::sys::GraphicsDrawing* gfx = uji::sys::GraphicsDrawing::GetInstance();

    // }X^[ߓxύX܂
    m_WindowManager.SetAlpha(196);

    // J[\ʒup
    uji::sys::Point cursorPos;

    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;

    // MCU֘A
    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    Result result_check;
    u8 change_value = 1;

    //
    u8 first_flag = 1;

    // MCUɏޒl
    u8 mcu_write_data = 0;

    // TOP/BOTTOMǂɏނ߂ϐ
    u8 write_address = MCU_VCOM_TOP_ADDR;

    result_check = mcu.ReadByReceive(MCU_VCOM_TOP_ADDR, &mcu_write_data,  sizeof(mcu_write_data));

    do
    {

        // ------------------------------------\------------------------------------
        gfx->m_DrawFramework->Clear();

        //  EChE
        m_WindowManager.UpdatePad(pad);  // pbh
        m_WindowManager.Update();        // XV
        m_WindowManager.DrawDisplay0();

        //  `
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

        // `̑O
        gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);
        gfx->SetFixedWidthFont(16);
        gfx->m_TextWriter.SetCursor(10, 20);

        // ------------------------------------\ ܂------------------------------------
        gfx->BeginDrawingString();

        (void)gfx->m_TextWriter.Printf( "\n X:VALUE_UP&WRITE  Y:VALUE_DOUW&WRITE  "
                                        "\nUP:VALUE_UP  DOWN:VALUE_DOUW  "
                                        "\nLEFT:TOP SCREEN  RIGHT:BOTTOM SCREEN \n\n\n" );

        while( !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ))
        {

            // j[
            if( first_flag == 1)
            {
                Printf( "\n1 VOLUME:%d", mcu_write_data );
                (void)gfx->m_TextWriter.Printf( "\n change_value:%d", change_value );
                (void)gfx->m_TextWriter.Printf( "\n VOLUME:%d", mcu_write_data );
                (void)gfx->m_TextWriter.Printf( "\n address:%d", write_address );
                first_flag = 0;
                break;
            }

            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);

            // X{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_X))
            {

                Printf( "\n0 VOLUME:%d", mcu_write_data );

                if( mcu_write_data + change_value > 0xFF ) mcu_write_data = 0xFF;
                else mcu_write_data += change_value;

                result_check = mcu.WriteBySend(write_address,  &mcu_write_data, sizeof(mcu_write_data));
                NN_UTIL_PANIC_IF_FAILED(result_check);

                Printf( "\n2 VOLUME:%d", mcu_write_data );
                (void)gfx->m_TextWriter.Printf( "\n change_value:%d", change_value );
                (void)gfx->m_TextWriter.Printf( "\n VOLUME:%d", mcu_write_data );
                (void)gfx->m_TextWriter.Printf( "\n address:%d", write_address );
                break;
            }

            // Y{^
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_Y))
            {
                if( mcu_write_data < change_value ) mcu_write_data = 0;
                else mcu_write_data -= change_value;

                result_check = mcu.WriteBySend(write_address,  &mcu_write_data, sizeof(mcu_write_data));
                NN_UTIL_PANIC_IF_FAILED(result_check);

                Printf( "\n VOLUME:%d", mcu_write_data );
                (void)gfx->m_TextWriter.Printf( "\n change_value:%d", change_value );
                (void)gfx->m_TextWriter.Printf( "\n VOLUME:%d", mcu_write_data );
                (void)gfx->m_TextWriter.Printf( "\n address:%d", write_address );
                break;
            }

            // {^ |
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_DOWN))
            {
                change_value--;
                if(change_value<1)change_value = 1;
                (void)gfx->m_TextWriter.Printf( "\n change_value:%d", change_value );
                (void)gfx->m_TextWriter.Printf( "\n VOLUME:%d", mcu_write_data );
                (void)gfx->m_TextWriter.Printf( "\n address:%d", write_address );
                break;
            }

            // {^ {
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_UP))
            {
                change_value++;
                if(change_value>0xff)change_value = 0xff;
                (void)gfx->m_TextWriter.Printf( "\n change_value:%d", change_value );
                (void)gfx->m_TextWriter.Printf( "\n VOLUME:%d", mcu_write_data );
                (void)gfx->m_TextWriter.Printf( "\n address:%d", write_address );
                break;
            }

            // 
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_LEFT))
            {
                write_address = MCU_VCOM_TOP_ADDR;
                result_check = mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,  &mcu_write_data, sizeof(mcu_write_data));
                (void)gfx->m_TextWriter.Printf( "\n change_value:%d", change_value );
                (void)gfx->m_TextWriter.Printf( "\n VOLUME:%d", mcu_write_data );
                (void)gfx->m_TextWriter.Printf( "\n address:%d", write_address );
                break;
            }

            // E
            if (sys::Pad().IsButtonPress(sys::Pad::BUTTON_RIGHT))
            {
                write_address = MCU_VCOM_BOTTOM_ADDR;
                result_check = mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR,  &mcu_write_data, sizeof(mcu_write_data));
                (void)gfx->m_TextWriter.Printf( "\n change_value:%d", change_value );
                (void)gfx->m_TextWriter.Printf( "\n VOLUME:%d", mcu_write_data );
                (void)gfx->m_TextWriter.Printf( "\n address:%d", write_address );
                break;
            }

        };

        gfx->EndDrawingString();

        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        // Sleep
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromNanoSeconds(200 * 1000 * 1000));

    // R{^B{^𓯎ꂽꍇ͌rłj[ɖ߂
    } while(  !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) );

    NN_LOG("end...\n");

    result.m_Result = true;
    return result.m_Result;

}



/*--------------------------------------------------------------------------*


*--------------------------------------------------------------------------*/
void uji::eva::mcu::DetectOpenFold(void)
{
    int i = 0;
    Result result_check;

    //j[p̃EChE}l[W
    static uji::sys::WindowManager m_WindowManager;

    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    // }X^[ߓxύX܂
    m_WindowManager.SetAlpha(196);

    // J[\ʒup
    uji::sys::Point cursorPos;

    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;

    do
    {
        // ------------------------------------\------------------------------------
        gfx->m_DrawFramework->Clear();

        //  EChE
        m_WindowManager.UpdatePad(pad);  // pbh
        m_WindowManager.Update();        // XV
        m_WindowManager.DrawDisplay0();

        //  `
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

        // `̑O
        gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);
        gfx->SetFixedWidthFont(50);
        gfx->m_TextWriter.SetCursor(10, 20);

        gfx->BeginDrawingString();
        (void)gfx->m_TextWriter.Printf( "\n  CLOSE&OPEN\n" );
        gfx->SetFixedWidthFont(40);
        (void)gfx->m_TextWriter.Printf( "\n  PUSH B -> EXIT\n" );
        gfx->EndDrawingString();

        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        McuInitializer().HwCheckInit();

        // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
        nn::mcu::CTR::HwCheck mcu(
            McuInitializer().GetHSession()      // mꂽZbṼnh
        );                                      // RXgN^Ɏw

        // MCUǂݏol
        u8 mcu_read_data1 = 0xff;
        u8 mcu_data[2];

        // WĂ邱ƂmF
        while(1)
        {
            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);

            NN_LOG("%x\n", mcu_read_data1);
            result_check = mcu.ReadByReceive(0x0F,  &mcu_read_data1, sizeof(mcu_read_data1));
            NN_UTIL_PANIC_IF_FAILED(result_check);
            NN_LOG("&2: %x\n", (mcu_read_data1 & 0x02));
            if( (mcu_read_data1 & 0x02) == 0x00) break;
            if(  (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B))   ) return;
        };

        gfx->m_DrawFramework->Clear();
        gfx->m_TextWriter.SetCursor(10, 20);
        gfx->SetFixedWidthFont(50);

        gfx->BeginDrawingString();
        (void)gfx->m_TextWriter.Printf( "\n  CLOSED\n" );
        gfx->SetFixedWidthFont(40);
        (void)gfx->m_TextWriter.Printf( "\n  PUSH B -> EXIT\n" );
        gfx->EndDrawingString();

        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        // WJĂ邱ƂmF
        while(1)
        {
            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);

            NN_LOG("OPEN %x\n", mcu_read_data1);
            result_check = mcu.ReadByReceive(0x0F,  &mcu_read_data1, sizeof(mcu_read_data1));
            NN_UTIL_PANIC_IF_FAILED(result_check);
            if( (mcu_read_data1 & 0x02) == 0x02) break;
            if( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) return;
        };

        gfx->m_DrawFramework->Clear();
        gfx->m_TextWriter.SetCursor(10, 20);
        gfx->SetFixedWidthFont(100);

        gfx->BeginDrawingString();
        (void)gfx->m_TextWriter.Printf( "   OK\n" );
        gfx->SetFixedWidthFont(40);
        (void)gfx->m_TextWriter.Printf( "  PUSH A -> AGAIN\n  PUSH B -> EXIT\n" );
        gfx->EndDrawingString();

        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        // A{^܂Ń[v
        do
        {
            i++;

            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);

            NN_LOG("A%04d %x\n", i, ( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_A))));
            NN_LOG("AA%04d %x\n", i, ( sys::Pad().IsButtonPress(sys::Pad::BUTTON_A)) );

            if(  (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B))   ) return;

        }while( !(sys::Pad().IsButtonPress(sys::Pad::BUTTON_A)) );

        i = 0;

    // R{^B{^𓯎ꂽꍇ͌rłj[ɖ߂
    }while(  !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) );

    return;
}




/*--------------------------------------------------------------------------*


*--------------------------------------------------------------------------*/
void uji::eva::mcu::ShowRemainderOfBattery(void)
{
    int i = 0;
    Result result_check;

    //j[p̃EChE}l[W
    static uji::sys::WindowManager m_WindowManager;

    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    // }X^[ߓxύX܂
    m_WindowManager.SetAlpha(196);

    // J[\ʒup
    uji::sys::Point cursorPos;

    nn::hid::CTR::PadReader padReader;
    nn::hid::CTR::PadStatus padStatus;
    uji::sys::Pad pad;

    do
    {
        // ------------------------------------\------------------------------------
        gfx->m_DrawFramework->Clear();

        //  EChE
        m_WindowManager.UpdatePad(pad);  // pbh
        m_WindowManager.Update();        // XV
        m_WindowManager.DrawDisplay0();

        //  `
        gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);

        // `̑O
        gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);
        gfx->SetFixedWidthFont(50);
        gfx->m_TextWriter.SetCursor(10, 20);


        McuInitializer().HwCheckInit();

        // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
        nn::mcu::CTR::HwCheck mcu(
            McuInitializer().GetHSession()      // mꂽZbṼnh
        );                                      // RXgN^Ɏw

        // MCUǂݏol
        u8 mcu_read_data1 = 0xff;
        u8 mcu_read_data2 = 0xff;

        result_check = mcu.ReadByReceive(0x0B,  &mcu_read_data1, sizeof(mcu_read_data1));
        result_check = mcu.ReadByReceive(0x0C,  &mcu_read_data2, sizeof(mcu_read_data2));

        gfx->m_DrawFramework->Clear();
        gfx->m_TextWriter.SetCursor(10, 20);
        gfx->SetFixedWidthFont(28);

        gfx->BeginDrawingString();
        (void)gfx->m_TextWriter.Printf( "\n BATTERY RESIDUAL QUANTITY\n\n" );
        gfx->SetFixedWidthFont(40);
        (void)gfx->m_TextWriter.Printf( "        %d %%\n", mcu_read_data1 );
        (void)gfx->m_TextWriter.Printf( "\n  PUSH B -> EXIT\n" );
        gfx->EndDrawingString();

        glFlush();
        gfx->m_DrawFramework->SwapBuffers();

        NN_LOG("l:%04f \n", mcu_read_data2);

        // A{^܂Ń[v
        do
        {
            i++;

            // L[͂̊mF
            padReader.ReadLatest(&padStatus);
            pad.UpdatePad(padStatus);


            if(  (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B))   ) return;

        }while( !(sys::Pad().IsButtonPress(sys::Pad::BUTTON_A)) );

        i = 0;


    // R{^B{^𓯎ꂽꍇ͌rłj[ɖ߂
    }while(  !( (sys::Pad().IsButtonPress(sys::Pad::BUTTON_R)) && (sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)) ) );

    return;
}


/*--------------------------------------------------------------------------*


*--------------------------------------------------------------------------*/
Result uji::eva::mcu::GetRemainingBatteryLv( u8* val )
{
    Result nnr;

    McuInitializer().HwCheckInit();
    nn::mcu::CTR::HwCheck mcu(McuInitializer().GetHSession());

    nnr = mcu.ReadByReceive(MCU_BATTERY_REMAIN_LO_ADDR, val, sizeof(*val));

    return nnr;
}


//---------------------------------------------------------------------------
// LEDiFj̓_ Wait
//---------------------------------------------------------------------------
bool uji::eva::mcu::WiFiLedYellowOnNoWait(TestResult &result)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    mcu.SetWifiLEDPattern(static_cast<nn::mcu::CTR::WifiLedPattern>(1));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
// LEDiFj̏ Wait
//---------------------------------------------------------------------------
bool uji::eva::mcu::WiFiLedYellowOffNoWait(TestResult &result)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    mcu.SetWifiLEDPattern(static_cast<nn::mcu::CTR::WifiLedPattern>(0));

    result.m_Result = true;

    return result.m_Result;

}


//---------------------------------------------------------------------------
//   m点vLEDiԁj̓_(҂ԂȂ)
//---------------------------------------------------------------------------
void uji::eva::mcu::NotifyLedRedOnNoWait(void)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 32; i++)
    {
        infoLedPattern[0].frameColors[i] = 255;
    }
    for(int i = 32; i < 96; i++)
    {
        infoLedPattern[0].frameColors[i] = 0;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[0] );

    return ;

}


//---------------------------------------------------------------------------
//     m点vLED()̓_(҂ԂȂ)
//---------------------------------------------------------------------------
void uji::eva::mcu::NotifyLedBlueOnNoWait(void)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 32; i++)
    {
        infoLedPattern[2].frameColors[i] = 0;
    }
    for(int i = 32; i < 64; i++)
    {
        infoLedPattern[2].frameColors[i] = 0;
    }
    for(int i = 64; i < 96; i++)
    {
        infoLedPattern[2].frameColors[i] = 255;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[2] );

    return ;

}


//---------------------------------------------------------------------------
//     m点vLED()̓_(҂ԂȂ)
//---------------------------------------------------------------------------
void uji::eva::mcu::NotifyLedGreenOnNoWait(void)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 32; i++)
    {
        infoLedPattern[1].frameColors[i] = 0;
    }
    for(int i = 32; i < 64; i++)
    {
        infoLedPattern[1].frameColors[i] = 255;
    }
    for(int i = 64; i < 96; i++)
    {
        infoLedPattern[1].frameColors[i] = 0;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[1] );

    return ;

}


//---------------------------------------------------------------------------
// c[     m点vLEDiԐFj̓_
//---------------------------------------------------------------------------
void uji::eva::mcu::NotifyLedRedBlinkerNoWait(void)
{

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    for(int i = 0; i < 32; i++)
    {
        if(i%2)infoLedPattern[0].frameColors[i] = 255;
        else   infoLedPattern[0].frameColors[i] = 0;
    }
    for(int i = 32; i < 96; i++)
    {
        if(i%2)infoLedPattern[0].frameColors[i] = 0;
    }

    mcu.SetInfoLEDPattern( infoLedPattern[0] );

    return;

}


/*---------------------------------------------------------------------------
  Desc: OPENԂɂȂ܂ő҂֐
---------------------------------------------------------------------------*/
void uji::eva::mcu::WaitOpenState(void)
{
    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // MCUǂݏol
    u8 mcu_read_data1 = 0xff;

    // OPENԂɂȂ܂Ń[v
    while(1)
    {
        result_check = mcu.ReadByReceive(0x0F,  &mcu_read_data1, sizeof(mcu_read_data1));
        NN_UTIL_PANIC_IF_FAILED(result_check);
        if( (mcu_read_data1 & 0x02) == 0x02)
        {
            break;
        }
    };

    return;

}


/*---------------------------------------------------------------------------
  Desc: CLOSEԂɂȂ܂ő҂֐
---------------------------------------------------------------------------*/
void uji::eva::mcu::WaitCloseState(sys::GraphicsDrawing *gfx)
{
    Result result_check;

    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    gfx->m_DrawFramework->Clear();
    gfx->m_TextWriter.SetCursor(8, 5);
    gfx->m_TextWriter.SetTextColor(nw::ut::Color8::BLACK, nw::ut::Color8::BLACK);
    gfx->SetFixedWidthFont(80);

    gfx->BeginDrawingString();
    (void)gfx->m_TextWriter.Printf( "\n  CLOSE\n" );
    gfx->EndDrawingString();

    glFlush();
    gfx->m_DrawFramework->SwapBuffers();

    // MCUǂݏol
    u8 mcu_read_data1 = 0xff;

    // WĂ邱ƂmF
    while(1)
    {
        result_check = mcu.ReadByReceive(0x0F,  &mcu_read_data1, sizeof(mcu_read_data1));
        NN_UTIL_PANIC_IF_FAILED(result_check);
        if( (mcu_read_data1 & 0x02) == 0x00) break;
    };

    // WaitȂAccSoundFinalizȅɈڍŝSetHeadphoneOutOnShellCloseɂȂ܂B
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(300));

    return;

}










