/*--------------------------------------------------------------------------*
 Project:
 File: McuInitializer.h


*--------------------------------------------------------------------------*/
#ifndef __MCU_INITIALIZER_H__
#define __MCU_INITIALIZER_H__

#include <nn/types.h>
#include <nn/mcu.h>
#include <nn/srv.h>


namespace uji {
namespace eva {
namespace mcu {


/*
    Desc: HwCheck֐gpMCU
*/
class McuInitializer
{
public:
    McuInitializer(){}
    virtual ~McuInitializer(){}
    
    static void HwCheckInit()
    {
        nn::Result nnResult;            

        if (initialize)
        {
            return;
        }
    
        // ServiceManagervZX̏
        nnResult = nn::srv::Initialize();
        NN_UTIL_PANIC_IF_FAILED(nnResult);

        // MCU vZXɐڑ
        nnResult = nn::mcu::CTR::InitializeHwCheck(&m_hSession);
        NN_UTIL_PANIC_IF_FAILED(nnResult);    
    
        initialize = true;
    }
    
    static void HwCheckEnd()
    {
        if (!initialize)
        {
            return;   
        }
        
        nn::Result nnResult = nn::mcu::CTR::FinalizeHwCheck(&m_hSession);
        NN_UTIL_PANIC_IF_FAILED(nnResult);        
        initialize = false;        
    }
    
    static nn::Handle GetHSession() { return m_hSession; }
    
private:
    static nn::Handle m_hSession;
    static bool initialize;
};


} // namespace
}
}

#endif
