/********************************************************************
	t(JZp̈˗ver)
********************************************************************/

#include <wchar.h>
#include <stdlib.h>

#include <nn.h>
#include "sys.h"
#include "TestLcd_RED.h"
#include "../backlight/BackLightTest.h"
#include "../sec/FileViewer.h"
#include <nn/gx/CTR/gx_LcdBacklight.h>

using namespace uji;
using namespace uji::sys;
using namespace uji::seq;
using namespace uji::eva;



bool TestLcd_RED::IsBmp( const wchar_t* openPath )
{
	const wchar_t* cmp_bmp = L".bmp";
    int pathLength = std::wcslen( openPath ) - 1;  // pXz̖̓Y
    if( openPath[ pathLength ] == L'p' )
	{
		pathLength--;
	    if( openPath[ pathLength ] == L'm' )
		{
			pathLength--;
			if( openPath[ pathLength ] == L'b' )
			{
				pathLength--;
				if( openPath[ pathLength ] == L'.' )
				{
					return true;
				}
				else	return false;
			}
			else	return false;
		}
		else	return false;
	}
	else	return false;
}

bool TestLcd_RED::IsLeft( const wchar_t* openPath )
{
	const wchar_t* cmp_left = L".left";
    int pathLength = std::wcslen( openPath ) - 5;  // pXz̖̓Y
    if( openPath[ pathLength ] == L't' )
	{
		pathLength--;
		    if( openPath[ pathLength ] == L'f' )
			{
				pathLength--;
				if( openPath[ pathLength ] == L'e' )
				{
					pathLength--;
					if( openPath[ pathLength ] == L'l' )
					{
						pathLength--;
						if( openPath[ pathLength ] == L'_' )
						{
							return true;
						}
						else	return false;
					}
					else	return false;
				}
				else	return false;
			}
			else	return false;
	}
	else	return false;
}

/*
	3D\pvO
*/
void TestLcd_RED::OpenBmp3D( const wchar_t* openPath )
{
	// bmpȂI
	if( !TestLcd_RED::IsBmp(openPath) )		return;
	if( !TestLcd_RED::IsLeft(openPath) )	return;

	bool loop_once = true; 
	bool flag_BmpTop = false;
	bool abl_flag = false;	// ANeBuobNCgON/OFFp
	int light_level = 5;	// Pxݒp

	BmpTexture *s_BmpTop      = 0;
	GLuint s_TextureIdTop     = 0;
	BmpTexture *s_BmpTop2     = 0;
	GLuint s_TextureIdTop2    = 0;

	uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::sys::Pad pad;

	// ʂɉ摜\
	s_BmpTop  = new BmpTexture();
	// openPath̃t@CJ
	s_BmpTop -> Open( openPath );

	if( s_TextureIdTop != 0 )	gfx->m_DrawFramework->DeleteTexture(s_TextureIdTop );
	gfx->m_DrawFramework->GenerateTexture(	GL_TEXTURE_2D, 
											s_BmpTop->INTERNAL_FORMAT,
											s_BmpTop->GetTextureWidth(),
											s_BmpTop->GetTextureHeight(),
											s_BmpTop->FORMAT,
											s_BmpTop->TYPE,
											s_BmpTop->GetTextureDataPointer(),
											s_TextureIdTop );
    wchar_t* dirPath  = new wchar_t[ 256 ];
    std::wcscpy( dirPath, openPath );
	int pathLength = std::wcslen( dirPath ) - 1;  // pXz̖̓Y
    do{
        dirPath[ pathLength ] = L'\0';
        pathLength--;
    }while( dirPath[ pathLength ] != L'_' );  // A_[o[̎O܂ł\0Ŗ߂
	std::wcscat( dirPath, L"right.bmp" );
	// 3DpA2̉摜ǂݍ݁E\
	s_BmpTop2  = new BmpTexture();
	// EڗpJ
	if( !s_BmpTop2 -> Open( dirPath ) )
	{
        NN_LOG("Failed to open File.\n");
		gfx->m_DrawFramework->DeleteTexture( s_TextureIdTop );
		s_BmpTop -> Close();
		delete s_BmpTop;
		return;
	}
	if( s_TextureIdTop2 != 0 )	gfx->m_DrawFramework->DeleteTexture(s_TextureIdTop2 );
	gfx->m_DrawFramework->GenerateTexture(	GL_TEXTURE_2D, 
											s_BmpTop2->INTERNAL_FORMAT,
											s_BmpTop2->GetTextureWidth(),
											s_BmpTop2->GetTextureHeight(),
											s_BmpTop2->FORMAT,
											s_BmpTop2->TYPE,
											s_BmpTop2->GetTextureDataPointer(),
											s_TextureIdTop2 );
	flag_BmpTop = true;

	do{
		// X[v[h̗L
		if (sys::SleepHandler::IsSleepRequested())
		{
			// X[v[hɓ
			sys::SleepHandler::SleepSystem();
			// ĊJ̏
			nn::gx::StartLcdDisplay();
		}
        //--------------------------------------------------------------------------
        // L[֘A
        //--------------------------------------------------------------------------
        Pad().UpdatePad();
		// ㉺L[ŋPx1`5ɕύX
		if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_UP))
		{
			light_level = uji::eva::backlight::UpLightLevel( light_level );
		}
		if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_DOWN))
		{
			light_level = uji::eva::backlight::DownLightLevel( light_level );
		}
		// L{^ŃANeBuobNCgON
		if( sys::Pad().IsButtonRepeat( Pad::BUTTON_L ) )
		{
			nn::gx::CTR::Backlight::EnableActiveBl(nn::gx::CTR::LCD_BOTH);
			abl_flag = true;
		}
		// R{^ŃANeBuobNCgOFF
		if( sys::Pad().IsButtonRepeat( Pad::BUTTON_R ) )
		{
			nn::gx::CTR::Backlight::DisableActiveBl(nn::gx::CTR::LCD_BOTH);
			abl_flag = false;
		}

        //--------------------------------------------------------------------------
        // \
        //--------------------------------------------------------------------------

		// 3D[h
		gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_STEREO);
		gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
		gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
													0.0f, 0.0f, 400.0f, 240.0f,
													400.0f, 240.0f,
													s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
		gfx->m_DrawFramework->Transfer();

		gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0_EXT );
        gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
		gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop2,
													0.0f, 0.0f, 400.0f, 240.0f,
													400.0f, 240.0f,
													s_BmpTop2->GetTextureWidth(), s_BmpTop2->GetTextureHeight() );
		gfx->m_DrawFramework->Transfer();
		gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();


		// ʂɕ\쐬
		gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
		gfx->m_DrawFramework->Clear();
		if( loop_once )
		{
			m_WindowManager.CreateWindow( &m_LowerWindow, NN_GX_DISPLAY1, 0, 0 );
			loop_once = false;
		}
		m_LowerWindow.SetTitle( "HOW TO USE" );
		m_LowerWindow.Gotoxy(0,0);
		m_LowerWindow.Printf("    B:Back\n");
		m_LowerWindow.Printf("    L:Active Backlight ON\n");
		m_LowerWindow.Printf("    R:Active Backlight OFF\n");
		m_LowerWindow.Printf("   UP:Increase Brightness Level\n");
		m_LowerWindow.Printf(" DOWN:Decrease Brightness Level\n\n");
		m_LowerWindow.Printf("Brightness Level : %d\n", light_level );
		if( abl_flag )	m_LowerWindow.Printf("Active Backlight : ON\n");
		else			m_LowerWindow.Printf("Active Backlight : OFF\n");
		m_LowerWindow.Printf("    Top LCD Mode : 3D\n");
		m_WindowManager.Update();
		m_WindowManager.DrawDisplay1();	
		gfx->m_DrawFramework->SwapBuffers();

		gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);


	// B{^Ńt@CXgɖ߂
    }while( !Pad().IsButtonRepeat( Pad::BUTTON_B ) );
	// 摜
	if( s_TextureIdTop != 0 )gfx->m_DrawFramework->DeleteTexture( s_TextureIdTop );
	if( s_TextureIdTop2 != 0 )gfx->m_DrawFramework->DeleteTexture( s_TextureIdTop2 );
	if( flag_BmpTop )
	{
		s_BmpTop -> Close();
		delete s_BmpTop;
		s_BmpTop2 -> Close();
		delete s_BmpTop2;
		NN_LOG("BmpTop*2_deleted\n");
		flag_BmpTop = false;
	}
	gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
	// obNCgPxő
	nn::gx::CTR::Backlight::SetLuminanceLevel(nn::gx::CTR::LCD_BOTH, 5);
	// ANeBuobNCgOFF
	nn::gx::CTR::Backlight::DisableActiveBl(nn::gx::CTR::LCD_BOTH);

}

/*---------------------------------------------------------------------------
  name: OpenBmpViewer
  Desc: I摜(.bmp)\

  Args: openPath = Jt@C̃pX
        
  Rtns: Ȃ
---------------------------------------------------------------------------*/  
void TestLcd_RED::OpenBmpViewer( const wchar_t* openPath )
{
	// bmpȂI
	if( !TestLcd_RED::IsBmp(openPath) )		return;

	bool loop_once = true; 
	bool flag_BmpTop = false;
	bool flag_BmpBottom = false; 
	bool abl_flag = false;	// ANeBuobNCgON/OFFp
	int lcd_mode  = 0;		// ㉺ʂ̕\؂ւ
	int upper_mode = 0;		// ʂ̕\؂ւ
	int light_level = 5;	// Pxݒp

	BmpTexture *s_BmpTop      = 0;
	GLuint s_TextureIdTop     = 0;
	BmpTexture *s_BmpBottom   = 0;
	GLuint s_TextureIdBottom  = 0;
	BmpTexture *s_BmpTop2     = 0;
	GLuint s_TextureIdTop2    = 0;

	uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::sys::Pad pad;

	// ʂɉ摜\
	s_BmpTop  = new BmpTexture();
	// openPath̃t@CJ
	s_BmpTop -> Open( openPath );
	// 3DpA2̉摜ǂݍ݁E\
	s_BmpTop2  = new BmpTexture();
	// ܂t@CJ
	s_BmpTop2 -> Open( L"rom:/bmp/ColorBar_400x240.bmp" );
	flag_BmpTop = true;
	// ʂɂ摜[h
	s_BmpBottom  = new BmpTexture();
	s_BmpBottom -> Open( openPath );
	flag_BmpBottom = true;

	if( s_TextureIdTop != 0 )	gfx->m_DrawFramework->DeleteTexture(s_TextureIdTop );
	gfx->m_DrawFramework->GenerateTexture(	GL_TEXTURE_2D, 
											s_BmpTop->INTERNAL_FORMAT,
											s_BmpTop->GetTextureWidth(),
											s_BmpTop->GetTextureHeight(),
											s_BmpTop->FORMAT,
											s_BmpTop->TYPE,
											s_BmpTop->GetTextureDataPointer(),
											s_TextureIdTop );
	if( s_TextureIdTop2 != 0 )	gfx->m_DrawFramework->DeleteTexture(s_TextureIdTop2 );
	gfx->m_DrawFramework->GenerateTexture(	GL_TEXTURE_2D, 
											s_BmpTop2->INTERNAL_FORMAT,
											s_BmpTop2->GetTextureWidth(),
											s_BmpTop2->GetTextureHeight(),
											s_BmpTop2->FORMAT,
											s_BmpTop2->TYPE,
											s_BmpTop2->GetTextureDataPointer(),
											s_TextureIdTop2 );
	if( s_TextureIdBottom != 0 )	gfx->m_DrawFramework->DeleteTexture(s_TextureIdBottom );
	gfx->m_DrawFramework->GenerateTexture(	GL_TEXTURE_2D, 
											s_BmpBottom->INTERNAL_FORMAT,
											s_BmpBottom->GetTextureWidth(),
											s_BmpBottom->GetTextureHeight(),
											s_BmpBottom->FORMAT,
											s_BmpBottom->TYPE,
											s_BmpBottom->GetTextureDataPointer(),
											s_TextureIdBottom );

    do{
		// X[v[h̗L
		if (sys::SleepHandler::IsSleepRequested())
		{
			// X[v[hɓ
			sys::SleepHandler::SleepSystem();
			// ĊJ̏
			nn::gx::StartLcdDisplay();
		}
        //--------------------------------------------------------------------------
        // L[֘A
        //--------------------------------------------------------------------------
        Pad().UpdatePad();
		// ㉺L[ŋPx1`5ɕύX
		if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_UP))
		{
			light_level = uji::eva::backlight::UpLightLevel( light_level );
		}
		if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_DOWN))
		{
			light_level = uji::eva::backlight::DownLightLevel( light_level );
		}
		// L{^ŃANeBuobNCgON
		if( sys::Pad().IsButtonRepeat( Pad::BUTTON_L ) )
		{
			nn::gx::CTR::Backlight::EnableActiveBl(nn::gx::CTR::LCD_BOTH);
			abl_flag = true;
		}
		// R{^ŃANeBuobNCgOFF
		if( sys::Pad().IsButtonRepeat( Pad::BUTTON_R ) )
		{
			nn::gx::CTR::Backlight::DisableActiveBl(nn::gx::CTR::LCD_BOTH);
			abl_flag = false;
		}
		// START{^ŉ摜\[hؑ
		if( pad.IsButtonRepeat( Pad::BUTTON_START ) )
		{
			if( lcd_mode == 0 )
			{
				m_WindowManager.DestroyWindow( &m_LowerWindow );
			}
			else if( lcd_mode == 1 )
			{
				m_WindowManager.DestroyWindow( &m_UpperWindow );
			}
			lcd_mode++;
			loop_once = true;
			if( lcd_mode > 2 )	lcd_mode = 0;
		}

		// ʂɉ摜\AA{^Ń[h؂ւ(4008003D)
		if( lcd_mode == 0 || lcd_mode == 2 )
		{
			if( pad.IsButtonRepeat( Pad::BUTTON_A ) )
			{
				if( lcd_mode == 0 )
				{
					m_WindowManager.DestroyWindow( &m_LowerWindow );
				}
				loop_once = true;
				upper_mode ++;
				if( upper_mode > 2 )	upper_mode = 0;
			}
		}

        //--------------------------------------------------------------------------
        // \
        //--------------------------------------------------------------------------

		if( lcd_mode == 0 )
		{
			if( upper_mode == 0 )
			{
				// Jēǂݍ񂾉摜ʂɕ\ 400[h
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 400.0f, 240.0f,
															400.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
			}
			else if( upper_mode == 1 )
			{
				// 800[h 2񏑂ȂƍXVȂH
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_RESERVED);
				gfx->m_DrawFramework->SetRenderTarget( demo::RenderSystemUji::NN_GX_DISPLAY0_HD );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH*2, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 800.0f, 240.0f,
															800.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
				gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_RESERVED);
				gfx->m_DrawFramework->SetRenderTarget( demo::RenderSystemUji::NN_GX_DISPLAY0_HD );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH*2, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 800.0f, 240.0f,
															800.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
			}
			else
			{
				// 3D[h
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_STEREO);
				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
	            gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 400.0f, 240.0f,
															400.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->Transfer();

				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0_EXT );
	            gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop2,
															0.0f, 0.0f, 400.0f, 240.0f,
															400.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->Transfer();
				gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();
			}
			// ʂɕ\쐬
			gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
			gfx->m_DrawFramework->Clear();
			if( loop_once )
			{
				m_WindowManager.CreateWindow( &m_LowerWindow, NN_GX_DISPLAY1, 0, 0 );
				loop_once = false;
			}
			m_LowerWindow.SetTitle( "HOW TO USE" );
			m_LowerWindow.Gotoxy(0,0);
			m_LowerWindow.Printf("    B:Back\n");
			m_LowerWindow.Printf("    A:Change Top LCD Mode\n");
			m_LowerWindow.Printf("    L:Active Backlight ON\n");
			m_LowerWindow.Printf("    R:Active Backlight OFF\n");
			m_LowerWindow.Printf("   UP:Increase Brightness Level\n");
			m_LowerWindow.Printf(" DOWN:Decrease Brightness Level\n");
			m_LowerWindow.Printf("START:Change Display Mode\n\n");
			m_LowerWindow.Printf("Brightness Level : %d\n", light_level );
			if( abl_flag )	m_LowerWindow.Printf("Active Backlight : ON\n");
			else			m_LowerWindow.Printf("Active Backlight : OFF\n");
			if( upper_mode == 0 )		m_LowerWindow.Printf("    Top LCD Mode : 2D(400LINE)\n");
			else if( upper_mode == 1 )	m_LowerWindow.Printf("    Top LCD Mode : 2D(800LINE)\n");
			else						m_LowerWindow.Printf("    Top LCD Mode : 3D\n");
			m_WindowManager.Update();
			m_WindowManager.DrawDisplay1();	
			gfx->m_DrawFramework->SwapBuffers();	    
			gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
		}
		else if( lcd_mode == 1 )
		{
			// Jēǂݍ񂾉摜ʂɕ\
			gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
			gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
			gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
			gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdBottom,
														0.0f, 0.0f, 320.0f, 240.0f, 
														320.0f, 240.0f,
														s_BmpBottom->GetTextureWidth(), s_BmpBottom->GetTextureHeight() );
			gfx->m_DrawFramework->SwapBuffers();

			// ʂɕ\쐬
			gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
			gfx->m_DrawFramework->Clear();
			if( loop_once )
			{
				m_WindowManager.CreateWindow( &m_UpperWindow, NN_GX_DISPLAY0, 0, 0 );
				loop_once = false;
			}
			m_UpperWindow.SetTitle( "HOW TO USE" );
			m_UpperWindow.Gotoxy(0,0);
			m_UpperWindow.Printf("    B:Back\n");
			m_UpperWindow.Printf("    L:Active Backlight ON\n");
			m_UpperWindow.Printf("    R:Active Backlight OFF\n");
			m_UpperWindow.Printf("   UP:Increase Brightness Level\n");
			m_UpperWindow.Printf(" DOWN:Decrease Brightness Level\n");
			m_UpperWindow.Printf("START:Change Display Mode\n\n");
			m_UpperWindow.Printf("Brightness Level : %d\n", light_level );
			if( abl_flag )	m_UpperWindow.Printf("Active Backlight : ON\n");
			else			m_UpperWindow.Printf("Active Backlight : OFF\n");
			m_WindowManager.Update();
			m_WindowManager.DrawDisplay0();	
			gfx->m_DrawFramework->SwapBuffers();	    
			gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
		}
		else if( lcd_mode == 2 )
		{
			if( upper_mode == 0 )
			{
				// Jēǂݍ񂾉摜ʂɕ\ 400[h
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
				gfx->m_DrawFramework->Clear();
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 400.0f, 240.0f,
															400.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
				gfx->m_DrawFramework->Clear();
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdBottom,
															0.0f, 0.0f, 320.0f, 240.0f, 
															320.0f, 240.0f,
															s_BmpBottom->GetTextureWidth(), s_BmpBottom->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
				gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
			}
			else if( upper_mode == 1 )
			{
				// 800[h 2񏑂ȂƍXVȂH
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_RESERVED);
				gfx->m_DrawFramework->SetRenderTarget( demo::RenderSystemUji::NN_GX_DISPLAY0_HD );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH*2, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 800.0f, 240.0f,
															800.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();

				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdBottom,
															0.0f, 0.0f, 320.0f, 240.0f, 
															320.0f, 240.0f,
															s_BmpBottom->GetTextureWidth(), s_BmpBottom->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
				gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_RESERVED);
				gfx->m_DrawFramework->SetRenderTarget( demo::RenderSystemUji::NN_GX_DISPLAY0_HD );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH*2, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 800.0f, 240.0f,
															800.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();

				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdBottom,
															0.0f, 0.0f, 320.0f, 240.0f, 
															320.0f, 240.0f,
															s_BmpBottom->GetTextureWidth(), s_BmpBottom->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
				gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
			}
			else
			{
				// 3D[h
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_STEREO);
				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
	            gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 400.0f, 240.0f,
															400.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->Transfer();

				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0_EXT );
	            gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop2,
															0.0f, 0.0f, 400.0f, 240.0f,
															400.0f, 240.0f,
															s_BmpTop2->GetTextureWidth(), s_BmpTop2->GetTextureHeight() );
				gfx->m_DrawFramework->Transfer();

				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdBottom,
															0.0f, 0.0f, 320.0f, 240.0f, 
															320.0f, 240.0f,
															s_BmpBottom->GetTextureWidth(), s_BmpBottom->GetTextureHeight() );
				gfx->m_DrawFramework->Transfer();

				gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();
				gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
			}
		}
	// B{^Ńt@CXgɖ߂
    }while( !Pad().IsButtonRepeat( Pad::BUTTON_B ) );
	// 摜
	if( s_TextureIdTop != 0 )gfx->m_DrawFramework->DeleteTexture( s_TextureIdTop );
	if( s_TextureIdTop2 != 0 )gfx->m_DrawFramework->DeleteTexture( s_TextureIdTop2 );
	if( flag_BmpTop )
	{
		s_BmpTop -> Close();
		delete s_BmpTop;
		s_BmpTop2 -> Close();
		delete s_BmpTop2;
		NN_LOG("BmpTop*2_deleted\n");
		flag_BmpTop = false;
	}
	if( s_TextureIdBottom  != 0 )gfx->m_DrawFramework->DeleteTexture(s_TextureIdBottom );
	if( flag_BmpBottom )
	{
		s_BmpBottom  -> Close();
		delete s_BmpBottom;
		NN_LOG("BmpBottom_deleted\n");
		flag_BmpBottom = false;
	}
	gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
	// obNCgPxő
	nn::gx::CTR::Backlight::SetLuminanceLevel(nn::gx::CTR::LCD_BOTH, 5);
	// ANeBuobNCgOFF
	nn::gx::CTR::Backlight::DisableActiveBl(nn::gx::CTR::LCD_BOTH);
}

/*---------------------------------------------------------------------------
  name: NumberBmpViewer
  Desc: ԍɉ摜(.bmp)\

  Args: openPath = Jt@C̃pX
        
  Rtns: Ȃ
---------------------------------------------------------------------------*/  
void TestLcd_RED::NumberBmpViewer( const wchar_t* rootPath )
{
	bool loop_once = true; 
	bool flag_BmpTop = false;
	bool flag_BmpBottom = false; 
	bool abl_flag = false;	// ANeBuobNCgON/OFFp
	int lcd_mode  = 0;		// ㉺ʂ̕\؂ւ
	int upper_mode = 0;		// ʂ̕\؂ւ
	int light_level = 5;	// Pxݒp
	int bmp_num = 0;
    wchar_t* tempPath  = new wchar_t[ 256 ];
    wchar_t* openPath  = new wchar_t[ 256 ];
    std::wcscpy( openPath, rootPath );
	swprintf( tempPath, 256, L"%d.bmp", bmp_num );
	int pathLength = std::wcslen( openPath ) - 1;  // pXz̖̓Y
    do{
        openPath[ pathLength ] = L'\0';
        pathLength--;
	}while( openPath[ pathLength ] != L'/' );  // /̎O܂ł\0Ŗ߂
	std::wcscat( openPath, tempPath );

	BmpTexture *s_BmpTop      = 0;
	GLuint s_TextureIdTop     = 0;
	BmpTexture *s_BmpBottom   = 0;
	GLuint s_TextureIdBottom  = 0;
	BmpTexture *s_BmpTop2     = 0;
	GLuint s_TextureIdTop2    = 0;

	uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::sys::Pad pad;

	// ʂɉ摜\
	s_BmpTop  = new BmpTexture();
	// openPath̃t@CJ
    if( !s_BmpTop -> Open( openPath ) )		return;
	// 3DpA2̉摜ǂݍ݁E\
	s_BmpTop2  = new BmpTexture();
	// ܂t@CJ
	s_BmpTop2 -> Open( L"rom:/bmp/ColorBar_400x240.bmp" );
	flag_BmpTop = true;
	// ʂɂ摜[h
	s_BmpBottom  = new BmpTexture();
	s_BmpBottom -> Open( openPath );
	flag_BmpBottom = true;

	if( s_TextureIdTop != 0 )	gfx->m_DrawFramework->DeleteTexture(s_TextureIdTop );
	gfx->m_DrawFramework->GenerateTexture(	GL_TEXTURE_2D, 
											s_BmpTop->INTERNAL_FORMAT,
											s_BmpTop->GetTextureWidth(),
											s_BmpTop->GetTextureHeight(),
											s_BmpTop->FORMAT,
											s_BmpTop->TYPE,
											s_BmpTop->GetTextureDataPointer(),
											s_TextureIdTop );
	if( s_TextureIdTop2 != 0 )	gfx->m_DrawFramework->DeleteTexture(s_TextureIdTop2 );
	gfx->m_DrawFramework->GenerateTexture(	GL_TEXTURE_2D, 
											s_BmpTop2->INTERNAL_FORMAT,
											s_BmpTop2->GetTextureWidth(),
											s_BmpTop2->GetTextureHeight(),
											s_BmpTop2->FORMAT,
											s_BmpTop2->TYPE,
											s_BmpTop2->GetTextureDataPointer(),
											s_TextureIdTop2 );
	if( s_TextureIdBottom != 0 )	gfx->m_DrawFramework->DeleteTexture(s_TextureIdBottom );
	gfx->m_DrawFramework->GenerateTexture(	GL_TEXTURE_2D, 
											s_BmpBottom->INTERNAL_FORMAT,
											s_BmpBottom->GetTextureWidth(),
											s_BmpBottom->GetTextureHeight(),
											s_BmpBottom->FORMAT,
											s_BmpBottom->TYPE,
											s_BmpBottom->GetTextureDataPointer(),
											s_TextureIdBottom );

    do{
		// X[v[h̗L
		if (sys::SleepHandler::IsSleepRequested())
		{
			// X[v[hɓ
			sys::SleepHandler::SleepSystem();
			// ĊJ̏
			nn::gx::StartLcdDisplay();
		}
        //--------------------------------------------------------------------------
        // L[֘A
        //--------------------------------------------------------------------------
        Pad().UpdatePad();
		// ㉺L[ŋPx1`5ɕύX
		if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_UP))
		{
			light_level = uji::eva::backlight::UpLightLevel( light_level );
		}
		if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_DOWN))
		{
			light_level = uji::eva::backlight::DownLightLevel( light_level );
		}
		// L[Ŗ߂
		if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_LEFT))
		{
			if( bmp_num == 0 )
			{
			}
			else
			{
				bmp_num --;
				swprintf( tempPath, 256, L"%d.bmp", bmp_num );
				pathLength = std::wcslen( openPath ) - 1;  // pXz̖̓Y
				do{
					openPath[ pathLength ] = L'\0';
					pathLength--;
				}while( openPath[ pathLength ] != L'/' );  // /̎O܂ł\0Ŗ߂
				std::wcscat( openPath, tempPath );
				// ߂t@C̃pXݒ芮

				// ǂݍݒOɌ݃[hĂ摜
				if( s_TextureIdTop != 0 )gfx->m_DrawFramework->DeleteTexture( s_TextureIdTop );
				if( flag_BmpTop )
				{
					s_BmpTop -> Close();
					delete s_BmpTop;
					NN_LOG("BmpTop_deleted\n");
					flag_BmpTop = false;
				}
				if( s_TextureIdBottom  != 0 )gfx->m_DrawFramework->DeleteTexture(s_TextureIdBottom );
				if( flag_BmpBottom )
				{
					s_BmpBottom  -> Close();
					delete s_BmpBottom;
					NN_LOG("BmpBottom_deleted\n");
					flag_BmpBottom = false;
				}

				// ʗp̉摜[h
				s_BmpTop  = new BmpTexture();
				// openPath̃t@CJ
				if( !s_BmpTop -> Open( openPath ) )		return;
				flag_BmpTop = true;
				// ʂɂ摜[h
				s_BmpBottom  = new BmpTexture();
				s_BmpBottom -> Open( openPath );
				flag_BmpBottom = true;
				// ㉺ʂɃ[h摜Zbg
				if( s_TextureIdTop != 0 )	gfx->m_DrawFramework->DeleteTexture(s_TextureIdTop );
				gfx->m_DrawFramework->GenerateTexture(	GL_TEXTURE_2D, 
														s_BmpTop->INTERNAL_FORMAT,
														s_BmpTop->GetTextureWidth(),
														s_BmpTop->GetTextureHeight(),
														s_BmpTop->FORMAT,
														s_BmpTop->TYPE,
														s_BmpTop->GetTextureDataPointer(),
														s_TextureIdTop );
				if( s_TextureIdBottom != 0 )	gfx->m_DrawFramework->DeleteTexture(s_TextureIdBottom );
				gfx->m_DrawFramework->GenerateTexture(	GL_TEXTURE_2D, 
														s_BmpBottom->INTERNAL_FORMAT,
														s_BmpBottom->GetTextureWidth(),
														s_BmpBottom->GetTextureHeight(),
														s_BmpBottom->FORMAT,
														s_BmpBottom->TYPE,
														s_BmpBottom->GetTextureDataPointer(),
														s_TextureIdBottom );
			}
		}
		// EL[Ői
		if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_RIGHT))
		{
			bmp_num ++;
			swprintf( tempPath, 256, L"%d.bmp", bmp_num );
			pathLength = std::wcslen( openPath ) - 1;  // pXz̖̓Y
			do{
				openPath[ pathLength ] = L'\0';
				pathLength--;
			}while( openPath[ pathLength ] != L'/' );  // /̎O܂ł\0Ŗ߂
			std::wcscat( openPath, tempPath );
			// i񂾃t@C̃pXݒ芮

			// 摜
			if( s_TextureIdTop != 0 )gfx->m_DrawFramework->DeleteTexture( s_TextureIdTop );
			if( flag_BmpTop )
			{
				s_BmpTop -> Close();
				delete s_BmpTop;
				NN_LOG("BmpTop_deleted\n");
				flag_BmpTop = false;
			}
			if( s_TextureIdBottom  != 0 )gfx->m_DrawFramework->DeleteTexture(s_TextureIdBottom );
			if( flag_BmpBottom )
			{
				s_BmpBottom  -> Close();
				delete s_BmpBottom;
				NN_LOG("BmpBottom_deleted\n");
				flag_BmpBottom = false;
			}


			// ʂɉ摜\
			s_BmpTop  = new BmpTexture();
			// openPath̃t@CJ
			if( !s_BmpTop -> Open( openPath ) )
			{
				bmp_num --;
				swprintf( tempPath, 256, L"%d.bmp", bmp_num );
				pathLength = std::wcslen( openPath ) - 1;  // pXz̖̓Y
				do{
					openPath[ pathLength ] = L'\0';
					pathLength--;
				}while( openPath[ pathLength ] != L'/' );  // /̎O܂ł\0Ŗ߂
				std::wcscat( openPath, tempPath );
				if( !s_BmpTop -> Open( openPath ) )		return;
			}
			flag_BmpTop = true;
			// ʂɂ摜[h
			s_BmpBottom  = new BmpTexture();
			s_BmpBottom -> Open( openPath );
			flag_BmpBottom = true;

			if( s_TextureIdTop != 0 )	gfx->m_DrawFramework->DeleteTexture(s_TextureIdTop );
			gfx->m_DrawFramework->GenerateTexture(	GL_TEXTURE_2D, 
													s_BmpTop->INTERNAL_FORMAT,
													s_BmpTop->GetTextureWidth(),
													s_BmpTop->GetTextureHeight(),
													s_BmpTop->FORMAT,
													s_BmpTop->TYPE,
													s_BmpTop->GetTextureDataPointer(),
													s_TextureIdTop );
			if( s_TextureIdBottom != 0 )	gfx->m_DrawFramework->DeleteTexture(s_TextureIdBottom );
			gfx->m_DrawFramework->GenerateTexture(	GL_TEXTURE_2D, 
													s_BmpBottom->INTERNAL_FORMAT,
													s_BmpBottom->GetTextureWidth(),
													s_BmpBottom->GetTextureHeight(),
													s_BmpBottom->FORMAT,
													s_BmpBottom->TYPE,
													s_BmpBottom->GetTextureDataPointer(),
													s_TextureIdBottom );

		}
		// L{^ŃANeBuobNCgON
		if( sys::Pad().IsButtonRepeat( Pad::BUTTON_L ) )
		{
			nn::gx::CTR::Backlight::EnableActiveBl(nn::gx::CTR::LCD_BOTH);
			abl_flag = true;
		}
		// R{^ŃANeBuobNCgOFF
		if( sys::Pad().IsButtonRepeat( Pad::BUTTON_R ) )
		{
			nn::gx::CTR::Backlight::DisableActiveBl(nn::gx::CTR::LCD_BOTH);
			abl_flag = false;
		}
		// START{^ŉ摜\[hؑ
		if( pad.IsButtonRepeat( Pad::BUTTON_START ) )
		{
			if( lcd_mode == 0 )
			{
				m_WindowManager.DestroyWindow( &m_LowerWindow );
			}
			else if( lcd_mode == 1 )
			{
				m_WindowManager.DestroyWindow( &m_UpperWindow );
			}
			lcd_mode++;
			loop_once = true;
			if( lcd_mode > 2 )	lcd_mode = 0;
		}
		// ʂɉ摜\AA{^Ń[h؂ւ(4008003D)
		if( lcd_mode == 0 || lcd_mode == 2 )
		{
			if( pad.IsButtonRepeat( Pad::BUTTON_A ) )
			{
				if( lcd_mode == 0 )
				{
					m_WindowManager.DestroyWindow( &m_LowerWindow );
				}
				loop_once = true;
				upper_mode ++;
				if( upper_mode > 2 )	upper_mode = 0;
			}
		}

        //--------------------------------------------------------------------------
        // \
        //--------------------------------------------------------------------------

		if( lcd_mode == 0 )
		{
			if( upper_mode == 0 )
			{
				// Jēǂݍ񂾉摜ʂɕ\ 400[h
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 400.0f, 240.0f,
															400.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
			}
			else if( upper_mode == 1 )
			{
				// 800[h 2񏑂ȂƍXVȂH
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_RESERVED);
				gfx->m_DrawFramework->SetRenderTarget( demo::RenderSystemUji::NN_GX_DISPLAY0_HD );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH*2, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 800.0f, 240.0f,
															800.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
				gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_RESERVED);
				gfx->m_DrawFramework->SetRenderTarget( demo::RenderSystemUji::NN_GX_DISPLAY0_HD );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH*2, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 800.0f, 240.0f,
															800.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
			}
			else
			{
				// 3D[h
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_STEREO);
				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
	            gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 400.0f, 240.0f,
															400.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->Transfer();

				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0_EXT );
	            gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop2,
															0.0f, 0.0f, 400.0f, 240.0f,
															400.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->Transfer();
				gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();
			}
			// ʂɕ\쐬
			gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
			gfx->m_DrawFramework->Clear();
			if( loop_once )
			{
				m_WindowManager.CreateWindow( &m_LowerWindow, NN_GX_DISPLAY1, 0, 0 );
				loop_once = false;
			}
			m_LowerWindow.SetTitle( "HOW TO USE" );
			m_LowerWindow.Gotoxy(0,0);
			m_LowerWindow.Printf(" LEFT:PREV\n");
			m_LowerWindow.Printf("RIGHT:NEXT\n");
			m_LowerWindow.Printf("    B:Back to List\n");
			m_LowerWindow.Printf("    A:Change Top LCD Mode\n");
			m_LowerWindow.Printf("    L:Active Backlight ON\n");
			m_LowerWindow.Printf("    R:Active Backlight OFF\n");
			m_LowerWindow.Printf("   UP:Increase Brightness Level\n");
			m_LowerWindow.Printf(" DOWN:Decrease Brightness Level\n");
			m_LowerWindow.Printf("START:Change Display Mode\n\n");
			m_LowerWindow.Printf("Brightness Level : %d\n", light_level );
			if( abl_flag )	m_LowerWindow.Printf("Active Backlight : ON\n");
			else			m_LowerWindow.Printf("Active Backlight : OFF\n");
			if( upper_mode == 0 )		m_LowerWindow.Printf("    Top LCD Mode : 2D(400LINE)\n");
			else if( upper_mode == 1 )	m_LowerWindow.Printf("    Top LCD Mode : 2D(800LINE)\n");
			else						m_LowerWindow.Printf("    Top LCD Mode : 3D\n");
			m_WindowManager.Update();
			m_WindowManager.DrawDisplay1();	
			gfx->m_DrawFramework->SwapBuffers();	    
			gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
		}
		else if( lcd_mode == 1 )
		{
			// Jēǂݍ񂾉摜ʂɕ\
			gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
			gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
			gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
			gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdBottom,
														0.0f, 0.0f, 320.0f, 240.0f, 
														320.0f, 240.0f,
														s_BmpBottom->GetTextureWidth(), s_BmpBottom->GetTextureHeight() );
			gfx->m_DrawFramework->SwapBuffers();

			// ʂɕ\쐬
			gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
			gfx->m_DrawFramework->Clear();
			if( loop_once )
			{
				m_WindowManager.CreateWindow( &m_UpperWindow, NN_GX_DISPLAY0, 0, 0 );
				loop_once = false;
			}
			m_UpperWindow.SetTitle( "HOW TO USE" );
			m_UpperWindow.Gotoxy(0,0);
			m_UpperWindow.Printf(" LEFT:PREV\n");
			m_UpperWindow.Printf("RIGHT:NEXT\n");
			m_UpperWindow.Printf("    B:Back to List\n");
			m_UpperWindow.Printf("    L:Active Backlight ON\n");
			m_UpperWindow.Printf("    R:Active Backlight OFF\n");
			m_UpperWindow.Printf("   UP:Increase Brightness Level\n");
			m_UpperWindow.Printf(" DOWN:Decrease Brightness Level\n");
			m_UpperWindow.Printf("START:Change Display Mode\n\n");
			m_UpperWindow.Printf("Brightness Level : %d\n", light_level );
			if( abl_flag )	m_UpperWindow.Printf("Active Backlight : ON\n");
			else			m_UpperWindow.Printf("Active Backlight : OFF\n");
			m_WindowManager.Update();
			m_WindowManager.DrawDisplay0();	
			gfx->m_DrawFramework->SwapBuffers();	    
			gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
		}
		else if( lcd_mode == 2 )
		{
			if( upper_mode == 0 )
			{
				// Jēǂݍ񂾉摜ʂɕ\ 400[h
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
				gfx->m_DrawFramework->Clear();
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 400.0f, 240.0f,
															400.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
				gfx->m_DrawFramework->Clear();
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdBottom,
															0.0f, 0.0f, 320.0f, 240.0f, 
															320.0f, 240.0f,
															s_BmpBottom->GetTextureWidth(), s_BmpBottom->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
				gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
			}
			else if( upper_mode == 1 )
			{
				// 800[h 2񏑂ȂƍXVȂH
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_RESERVED);
				gfx->m_DrawFramework->SetRenderTarget( demo::RenderSystemUji::NN_GX_DISPLAY0_HD );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH*2, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 800.0f, 240.0f,
															800.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();

				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdBottom,
															0.0f, 0.0f, 320.0f, 240.0f, 
															320.0f, 240.0f,
															s_BmpBottom->GetTextureWidth(), s_BmpBottom->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
				gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_RESERVED);
				gfx->m_DrawFramework->SetRenderTarget( demo::RenderSystemUji::NN_GX_DISPLAY0_HD );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH*2, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 800.0f, 240.0f,
															800.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();

				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdBottom,
															0.0f, 0.0f, 320.0f, 240.0f, 
															320.0f, 240.0f,
															s_BmpBottom->GetTextureWidth(), s_BmpBottom->GetTextureHeight() );
				gfx->m_DrawFramework->SwapBuffers();
				gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
			}
			else
			{
				// 3D[h
				gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_STEREO);
				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
	            gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
															0.0f, 0.0f, 400.0f, 240.0f,
															400.0f, 240.0f,
															s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
				gfx->m_DrawFramework->Transfer();

				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0_EXT );
	            gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop2,
															0.0f, 0.0f, 400.0f, 240.0f,
															400.0f, 240.0f,
															s_BmpTop2->GetTextureWidth(), s_BmpTop2->GetTextureHeight() );
				gfx->m_DrawFramework->Transfer();

				gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
				gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
				gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdBottom,
															0.0f, 0.0f, 320.0f, 240.0f, 
															320.0f, 240.0f,
															s_BmpBottom->GetTextureWidth(), s_BmpBottom->GetTextureHeight() );
				gfx->m_DrawFramework->Transfer();

				gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();
				gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
			}
		}
	// B{^Ńt@CXgɖ߂
    }while( !Pad().IsButtonRepeat( Pad::BUTTON_B ) );
	// 摜
	if( s_TextureIdTop != 0 )gfx->m_DrawFramework->DeleteTexture( s_TextureIdTop );
	if( s_TextureIdTop2 != 0 )gfx->m_DrawFramework->DeleteTexture( s_TextureIdTop2 );
	if( flag_BmpTop )
	{
		s_BmpTop -> Close();
		delete s_BmpTop;
		s_BmpTop2 -> Close();
		delete s_BmpTop2;
		NN_LOG("BmpTop*2_deleted\n");
		flag_BmpTop = false;
	}
	if( s_TextureIdBottom  != 0 )gfx->m_DrawFramework->DeleteTexture(s_TextureIdBottom );
	if( flag_BmpBottom )
	{
		s_BmpBottom  -> Close();
		delete s_BmpBottom;
		NN_LOG("BmpBottom_deleted\n");
		flag_BmpBottom = false;
	}
	gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
	// obNCgPxő
	nn::gx::CTR::Backlight::SetLuminanceLevel(nn::gx::CTR::LCD_BOTH, 5);
	// ANeBuobNCgOFF
	nn::gx::CTR::Backlight::DisableActiveBl(nn::gx::CTR::LCD_BOTH);
}
