/************************************************************************
tsǌP\tg
  ************************************************************************/
/* dCN[h̉ */
#ifndef TESTLCD_TRAINING_H_INCLUDED
#define TESTLCD_TRAINING_H_INCLUDED

#include "TestLcd.h"

namespace{
    const int MAX_DOT_NUM = 5;
}

namespace uji{
namespace eva{


struct LightPointInfo
{
    int x;
    int y;
    float R;
    float G;
    float B;
};

struct DarkPointInfo
{
    int x;
    int y;
};

struct MultiLightPoints
{
    int num;
    LightPointInfo info[ MAX_DOT_NUM ];
};

struct MultiDarkPoints
{
    int num;
    DarkPointInfo info[ MAX_DOT_NUM ];
};


struct LineInfo
{
    int x;
    int y;
};

struct OneLightPattern
{
    LightPointInfo bla;
    LightPointInfo whi;
    LightPointInfo red;
    LightPointInfo gre;
    LightPointInfo blu;
};

struct OneDarkPattern
{
    LightPointInfo whi;
    LightPointInfo red;
    LightPointInfo gre;
    LightPointInfo blu;
};

struct MultiLightPattern
{
    MultiLightPoints bla;
    MultiLightPoints whi;
    MultiLightPoints red;
    MultiLightPoints gre;
    MultiLightPoints blu;
};

struct MultiDarkPattern
{
    MultiDarkPoints whi;
    MultiDarkPoints red;
    MultiDarkPoints gre;
    MultiDarkPoints blu;
};

struct LineLack
{
    int x;
    int y;
};

struct PatternInfo
{
    OneLightPattern  oneL;
    OneDarkPattern   oneD;
    MultiLightPattern mulL;
    MultiDarkPattern  mulD;
    LineLack          lLack;
};

#ifdef TEST_LCD_TRAINING_CPP
namespace
{
extern struct PatternInfo testpoint[10] = 
{
    // p^[1
    {
        {   //OneLightPattern(BWRGB)
            { 20, 230, 1.0f, 0.0f, 0.0f }, { 160, 10, 0.0f, 0.0f, 1.0f }, { 10, 10, 0.0f, 1.0f, 0.0f }, { 310, 230, 1.0f, 1.0f, 1.0f }, { 5, 5, 1.0f, 0.0f, 0.0f }
        },
        {   //OneDarkPattern(WRGB)
            { 110, 220 }, { 315, 5 }, { 110, 90 }, { 160, 235 }
        },
        {   //SomeLightPattern
            { 3, //P_̐(Black)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 300, 20, 1.0f, 1.0f, 1.0f }, { 140, 130, 0.0f, 1.0f, 0.0f }, { 310, 235, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(White)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 40, 20, 0.0f, 1.0f, 0.0f }, { 180, 230, 0.0f, 0.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Red)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 175, 10, 0.0f, 1.0f, 0.0f }, { 300, 20, 1.0f, 1.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Green)
                {   //(P_̐Ŏw肵𖄂߂)
                    { 40, 20, 1.0f, 1.0f, 1.0f }, { 310, 235, 0.0f, 0.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(Blue)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 15, 10, 0.0f, 1.0f, 0.0f }, { 310, 15, 1.0f, 0.0f, 0.0f }, { 40, 230, 1.0f, 1.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
        },
        {
            { 2, //_̐(White)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 120, 15 }, { 180, 230 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Red)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 170, 110 }, { 130, 130 }, { 310, 238 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Green)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 20, 10 }, { 310, 8 }, { 120, 220 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Blue)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 170, 120 }, { 10, 235 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },

        },
        { 10, 30 },
    },
    // p^[2
    {
        {   //OneLightPattern(BWRGB)
            { 280, 20, 0.0f, 0.0f, 1.0f }, { 160, 230, 1.0f, 0.0f, 0.0f }, { 310, 120, 1.0f, 1.0f, 1.0f }, { 20, 235, 0.0f, 0.0f, 1.0f }, { 165, 5, 0.0f, 1.0f, 0.0f }
        },
        {   //OneDarkPattern(WRGB)
            { 160, 120 }, { 40, 5 }, { 300, 235 }, { 5, 120 }
        },
        {   //SomeLightPattern
            { 2, //P_̐(Black)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 10, 5, 1.0f, 1.0f, 1.0f }, { 310, 200, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(White)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 60, 60, 1.0f, 0.0f, 0.0f }, { 260, 55, 0.0f, 0.0f, 1.0f }, { 310, 230, 0.0f, 1.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Red)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 10, 10, 1.0f, 1.0f, 1.0f }, { 310, 235, 0.0f, 0.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(Green)
                {   //(P_̐Ŏw肵𖄂߂)
                    { 15, 10, 0.0f, 0.0f, 1.0f }, { 315, 120, 1.0f, 1.0f, 1.0f }, { 170, 230, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Blue)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 10, 120, 0.0f, 1.0f, 0.0f }, { 300, 10, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
        },
        {
            { 3, //_̐(White)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 240, 80 }, { 160, 120 }, { 220, 130 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Red)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 310, 5 }, { 80, 20 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Green)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 310, 5 }, { 140, 120 }, { 300, 230 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Blue)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 160, 5 }, { 220, 220 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
        },
        { 110, 130 },
    },
    // p^[3
    {
        {   //OneLightPattern(BWRGB)
            { 310, 230, 0.0f, 1.0f, 0.0f }, { 120, 5, 0.0f, 1.0f, 0.0f }, { 60, 235, 0.0f, 0.0f, 1.0f }, { 280, 235, 1.0f, 0.0f, 0.0f }, { 315, 110, 1.0f, 1.0f, 1.0f }
        },
        {   //OneDarkPattern(WRGB)
            { 300, 20 }, { 280, 220 }, { 80, 20 }, { 20, 225 }
        },
        {   //SomeLightPattern
            { 3, //P_̐(Black)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 210, 30, 0.0f, 1.0f, 0.0f }, { 140, 130, 1.0f, 1.0f, 1.0f }, { 200, 235, 0.0f, 0.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(White)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 200, 140, 1.0f, 0.0f, 0.0f }, { 30, 160, 0.0f, 1.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(Red)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 140, 20, 0.0f, 0.0f, 1.0f }, { 170, 130, 1.0f, 1.0f, 1.0f }, { 120, 180, 0.0f, 1.0f, 0.0f }, { 220, 200, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Green)
                {   //(P_̐Ŏw肵𖄂߂)
                    { 40, 10, 1.0f, 1.0f, 1.0f }, { 200, 180, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(Blue)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 35, 20, 0.0f, 1.0f, 0.0f }, { 210, 150, 1.0f, 0.0f, 0.0f }, { 120, 210, 1.0f, 1.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
        },
        {
            { 3, //_̐(White)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 160, 5 }, { 310, 10 }, { 10, 170 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Red)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 280, 10 }, { 260, 180 }, { 30, 230 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Green)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 10, 10 }, { 315, 5 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Blue)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 140, 120 }, { 180, 115 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
        },
        { 2, 200 },
    },
    // p^[4
    {
        {   //OneLightPattern(BWRGB)
            { 160, 5, 1.0f, 0.0f, 0.0f }, { 5, 135, 0.0f, 1.0f, 0.0f }, { 120, 5, 1.0f, 1.0f, 1.0f }, { 160, 120, 0.0f, 0.0f, 1.0f }, { 315, 125, 1.0f, 1.0f, 1.0f }
        },
        {   //OneDarkPattern(WRGB)
            { 60, 60 }, { 280, 20 }, { 60, 220 }, { 220, 120 }
        },
        {   //SomeLightPattern
            { 4, //P_̐(Black)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 20, 10, 0.0f, 1.0f, 0.0f }, { 170, 80, 0.0f, 0.0f, 1.0f }, { 140, 130, 1.0f, 0.0f, 0.0f }, { 180, 220, 1.0f, 1.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(White)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 200, 30, 0.0f, 0.0f, 1.0f }, { 150, 120, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Red)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 180, 60, 0.0f, 0.0f, 1.0f }, { 140, 160, 0.0f, 1.0f, 0.0f }, { 290, 10, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(Green)
                {   //(P_̐Ŏw肵𖄂߂)
                    { 290, 10, 1.0f, 0.0f, 0.0f }, { 80, 100, 0.0f, 0.0f, 1.0f }, { 160, 120, 1.0f, 1.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Blue)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 60, 40, 1.0f, 1.0f, 1.0f }, { 55, 50, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
        },
        {
            { 2, //_̐(White)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 310, 130 }, { 10, 235 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Red)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 120, 10 }, { 170, 220 }, { 160, 230 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Green)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 160, 120 }, { 80, 220 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Blue)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 140, 30 }, { 135, 50 }, { 300, 235 }, { 0, 0 }, { 0, 0 }
                },
            },
        },
        { 162, 70 },
    },
    // p^[5
    {
        {   //OneLightPattern(BWRGB)
            { 155, 120, 0.0f, 1.0f, 0.0f }, { 310, 10, 0.0f, 0.0f, 1.0f }, { 160, 230, 0.0f, 0.0f, 1.0f }, { 10, 235, 1.0f, 1.0f, 1.0f }, { 200, 130, 1.0f, 0.0f, 0.0f }
        },
        {   //OneDarkPattern(WRGB)
            { 180, 120 }, { 20, 120 }, { 180, 110 }, { 180, 220 }
        },
        {   //SomeLightPattern
            { 3, //P_̐(Black)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 160, 10, 1.0f, 1.0f, 1.0f }, { 10, 130, 1.0f, 0.0f, 0.0f }, { 150, 220, 0.0f, 0.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(White)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 300, 5, 1.0f, 0.0f, 0.0f }, { 110, 130, 0.0f, 1.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(Red)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 300, 10, 1.0f, 1.0f, 1.0f }, { 140, 20, 0.0f, 1.0f, 0.0f }, { 30, 235, 0.0f, 0.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Green)
                {   //(P_̐Ŏw肵𖄂߂)
                    { 160, 5, 1.0f, 0.0f, 0.0f }, { 40, 200, 1.0f, 1.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Blue)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 280, 20, 0.0f, 1.0f, 0.0f }, { 160, 230, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
        },
        {
            { 3, //_̐(White)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 140, 100 }, { 180, 110 }, { 160, 140 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Red)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 20, 20 }, { 240, 100 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Green)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 310, 5 }, { 160, 120 }, { 305, 235 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Blue)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 110, 230 }, { 190, 235 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
        },
        { 316, 3 },
    },
    // p^[6
    {
        {   //OneLightPattern(BWRGB)
            { 140, 235, 0.0f, 0.0f, 1.0f }, { 140, 120, 0.0f, 1.0f, 0.0f }, { 260, 40, 0.0f, 0.0f, 1.0f }, { 40, 120, 1.0f, 0.0f, 0.0f }, { 280, 20, 0.0f, 1.0f, 0.0f }
        },
        {   //OneDarkPattern(WRGB)
            { 130, 140 }, { 260, 20 }, { 30, 120 }, { 260, 180 }
        },
        {   //SomeLightPattern
            { 2, //P_̐(Black)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 265, 80, 1.0f, 0.0f, 0.0f }, { 280, 120, 1.0f, 1.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(White)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 20, 10, 1.0f, 0.0f, 0.0f }, { 260, 30, 0.0f, 1.0f, 0.0f }, { 270, 180, 0.0f, 0.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Red)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 140, 100, 0.0f, 0.0f, 1.0f }, { 200, 230, 0.0f, 1.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(Green)
                {   //(P_̐Ŏw肵𖄂߂)
                    { 280, 3, 1.0f, 0.0f, 0.0f }, { 40, 40, 1.0f, 1.0f, 1.0f }, { 150, 220, 0.0f, 0.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(Blue)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 40, 120, 1.0f, 1.0f, 1.0f }, { 160, 220, 1.0f, 0.0f, 0.0f }, { 200, 215, 0.0f, 1.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
        },
        {
            { 2, //_̐(White)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 310, 20 }, { 30, 220 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Red)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 240, 230 }, { 300, 235 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Green)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 30, 130 }, { 20, 160 }, { 280, 40 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Blue)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 90, 20 }, { 2, 120 }, { 180, 110 }, { 0, 0 }, { 0, 0 }
                },
            },
        },
        { 260, 80 },
    },
    // p^[7
    {
        {   //OneLightPattern(BWRGB)
            { 318, 120, 1.0f, 1.0f, 1.0f }, { 160, 230, 0.0f, 0.0f, 1.0f }, { 40, 210, 0.0f, 1.0f, 0.0f }, { 290, 20, 1.0f, 0.0f, 0.0f }, { 90, 10, 1.0f, 1.0f, 1.0f }
        },
        {   //OneDarkPattern(WRGB)
            { 310, 10 }, { 15, 230 }, { 150, 10 }, { 150, 225 }
        },
        {   //SomeLightPattern
            { 3, //P_̐(Black)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 130, 30, 1.0f, 0.0f, 0.0f }, { 280, 130, 0.0f, 1.0f, 0.0f }, { 110, 140, 1.0f, 1.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(White)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 140, 20, 1.0f, 0.0f, 0.0f }, { 260, 180, 0.0f, 1.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(Red)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 100, 10, 0.0f, 0.0f, 1.0f }, { 240, 120, 1.0f, 1.0f, 1.0f }, { 120, 160, 0.0f, 1.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Green)
                {   //(P_̐Ŏw肵𖄂߂)
                    { 10, 100, 0.0f, 0.0f, 1.0f }, { 170, 220, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Blue)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 140, 20, 1.0f, 1.0f, 1.0f }, { 240, 25, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
        },
        {
            { 3, //_̐(White)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 190, 20 }, { 135, 130 }, { 100, 210 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Red)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 10, 30 }, { 300, 30 }, { 180, 220 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Green)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 10, 20 }, { 40, 220 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Blue)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 140, 130 }, { 310, 110 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
        },
        { 140, 90 },
    },
    // p^[8
    {
        {   //OneLightPattern(BWRGB)
            { 15, 15, 1.0f, 1.0f, 1.0f }, { 300, 20, 1.0f, 0.0f, 0.0f }, { 120, 110, 0.0f, 1.0f, 0.0f }, { 290, 30, 1.0f, 1.0f, 1.0f }, { 20, 220, 1.0f, 0.0f, 0.0f }
        },
        {   //OneDarkPattern(WRGB)
            { 100, 60 }, { 240, 230 }, { 90, 120 }, { 290, 20 }
        },
        {   //SomeLightPattern
            { 3, //P_̐(Black)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 120, 30, 0.0f, 1.0f, 0.0f }, { 200, 120, 0.0f, 0.0f, 1.0f }, { 160, 230, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(White)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 280, 30, 0.0f, 1.0f, 0.0f }, { 130, 120, 0.0f, 0.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Red)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 285, 30, 0.0f, 0.0f, 1.0f }, { 150, 130, 1.0f, 1.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(Green)
                {   //(P_̐Ŏw肵𖄂߂)
                    { 10, 5, 1.0f, 1.0f, 1.0f }, { 310, 115, 1.0f, 0.0f, 0.0f }, { 140, 130, 0.0f, 0.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(Blue)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 40, 20, 0.0f, 1.0f, 0.0f }, { 300, 100, 1.0f, 0.0f, 0.0f }, { 290, 220, 1.0f, 1.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
        },
        {
            { 3, //_̐(White)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 10, 10 }, { 20, 70 }, { 300, 235 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Red)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 315, 40 }, { 300, 210 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Green)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 90, 100 }, { 310, 120 }, { 95, 200 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Blue)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 30, 210 }, { 10, 215 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
        },
        { 225, 160 },
    },
    // p^[9
    {
        {   //OneLightPattern(BWRGB)
            { 5, 200, 1.0f, 1.0f, 1.0f }, { 40, 230, 1.0f, 0.0f, 0.0f }, { 180, 50, 1.0f, 1.0f, 1.0f }, { 310, 230, 0.0f, 0.0f, 1.0f }, { 160, 120, 0.0f, 1.0f, 0.0f }
        },
        {   //OneDarkPattern(WRGB)
            { 180, 140 }, { 60, 60 }, { 160, 230 }, { 300, 10 }
        },
        {   //SomeLightPattern
            { 4, //P_̐(Black)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 290, 20, 0.0f, 0.0f, 1.0f }, { 140, 120, 1.0f, 1.0f, 1.0f }, { 290, 210, 1.0f, 0.0f, 0.0f }, { 30, 220, 0.0f, 1.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(White)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 290, 20, 0.0f, 0.0f, 1.0f }, { 40, 210, 1.0f, 0.0f, 0.0f }, { 310, 230, 0.0f, 1.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Red)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 80, 70, 0.0f, 0.0f, 1.0f }, { 280, 210, 0.0f, 1.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(Green)
                {   //(P_̐Ŏw肵𖄂߂)
                    { 20, 10, 1.0f, 0.0f, 0.0f }, { 290, 20, 0.0f, 0.0f, 1.0f }, { 180, 220, 1.0f, 1.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Blue)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 40, 230, 1.0f, 1.0f, 1.0f }, { 290, 225, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
        },
        {
            { 2, //_̐(White)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 35, 5 }, { 310, 235 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Red)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 200, 10 }, { 240, 200 }, { 120, 220 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Green)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 40, 2 }, { 60, 230 }, { 280, 230 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Blue)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 310, 5 }, { 10, 235 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
        },
        { 25, 48 },
    },
    // p^[10
    {
        {   //OneLightPattern(BWRGB)
            { 315, 5, 0.0f, 0.0f, 1.0f }, { 40, 40, 0.0f, 1.0f, 0.0f }, { 180, 60, 1.0f, 1.0f, 1.0f }, { 25, 230, 1.0f, 0.0f, 0.0f }, { 310, 70, 1.0f, 1.0f, 1.0f }
        },
        {   //OneDarkPattern(WRGB)
            { 60, 20 }, { 180, 140 }, { 140, 100 }, { 300, 220 }
        },
        {   //SomeLightPattern
            { 3, //P_̐(Black)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 40, 50, 1.0f, 0.0f, 0.0f }, { 170, 100, 0.0f, 0.0f, 1.0f }, { 300, 210, 0.0f, 1.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(White)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 290, 25, 0.0f, 1.0f, 0.0f }, { 30, 220, 0.0f, 0.0f, 1.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 3, //P_̐(Red)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 30, 10, 1.0f, 1.0f, 1.0f }, { 240, 40, 0.0f, 0.0f, 1.0f }, { 280, 210, 0.0f, 1.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Green)
                {   //(P_̐Ŏw肵𖄂߂)
                    { 80, 90, 0.0f, 0.0f, 1.0f }, { 160, 225, 1.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
            { 2, //P_̐(Blue)
                {   // LightPointInfo(P_̐Ŏw肵𖄂߂)
                    { 200, 8, 1.0f, 1.0f, 1.0f }, { 80, 210, 0.0f, 1.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }, { 0, 0, 0.0f, 0.0f, 0.0f }
                },
            },
        },
        {
            { 2, //_̐(White)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 30, 220 }, { 290, 230 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Red)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 15, 15 }, { 150, 115 }, { 315, 70 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 2, //_̐(Green)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 180, 20 }, { 300, 235 }, { 0, 0 }, { 0, 0 }, { 0, 0 }
                },
            },
            { 3, //_̐(Blue)
                {   // DarkPointInfo(w肵𖄂߂)
                    { 80, 10 }, { 20, 110 }, { 70, 238 }, { 0, 0 }, { 0, 0 }
                },
            },
        },
        { 180, 190 },
    },
};

}
#endif

class TestLcdTraining : public TestLcd
{
public:
    TestLcdTraining()
    {}
    
    ~TestLcdTraining()
    {}
    static void ShowTestPattern();
    static void TestList();
private:

    static int  m_testPattern;
    
    static void OneLightBlack();
    static void OneLightWhite();
    static void OneLightRed();
    static void OneLightGreen();
    static void OneLightBlue();
    
    static void OneDarkWhite();
    static void OneDarkRed();
    static void OneDarkGreen();
    static void OneDarkBlue();
    
    static void MultiLightBlack();
    static void MultiLightWhite();
    static void MultiLightRed();
    static void MultiLightGreen();
    static void MultiLightBlue();
    
    static void MultiDarkWhite();
    static void MultiDarkRed();
    static void MultiDarkGreen();
    static void MultiDarkBlue();
    
    static void LineLackHorizontal();
    static void LineLackVertical();
    
    static void GradationHorizontal();
    static void GradationVertical();
    
    static void PlayOkSound();
    
    static void Pattern0() { m_testPattern = 0; ShowTestPattern(); };
    static void Pattern1() { m_testPattern = 1; ShowTestPattern(); };
    static void Pattern2() { m_testPattern = 2; ShowTestPattern(); };
    static void Pattern3() { m_testPattern = 3; ShowTestPattern(); };
    static void Pattern4() { m_testPattern = 4; ShowTestPattern(); };
    static void Pattern5() { m_testPattern = 5; ShowTestPattern(); };
    static void Pattern6() { m_testPattern = 6; ShowTestPattern(); };
    static void Pattern7() { m_testPattern = 7; ShowTestPattern(); };
    static void Pattern8() { m_testPattern = 8; ShowTestPattern(); };
    static void Pattern9() { m_testPattern = 9; ShowTestPattern(); };

    static void FillAnyColor( uji::sys::GraphicsDrawing *gfx, f32 r, f32 g, f32 b);
    
    static void FillWhite( uji::sys::GraphicsDrawing *gfx ){ FillAnyColor( gfx, 1.0f, 1.0f, 1.0f ); }
    static void FillBlack( uji::sys::GraphicsDrawing *gfx ){ FillAnyColor( gfx, 0.0f, 0.0f, 0.0f ); }
    static void FillRed( uji::sys::GraphicsDrawing *gfx )  { FillAnyColor( gfx, 1.0f, 0.0f, 0.0f ); }
    static void FillGreen( uji::sys::GraphicsDrawing *gfx ){ FillAnyColor( gfx, 0.0f, 1.0f, 0.0f ); }
    static void FillBlue( uji::sys::GraphicsDrawing *gfx ) { FillAnyColor( gfx, 0.0f, 0.0f, 1.0f ); }
};

}
}

#endif
