#define TEST_LCD_TRAINING_CPP
#include <nn.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include "sys.h"
#include "TestLcdTraining.h"
#include "../backlight/BackLightTest.h"
#include "../sys/sys_SoundPlayer.h"

int uji::eva::TestLcdTraining::m_testPattern = 0;

namespace
{
    uji::sys::BmpTexture *s_BmpBottom_V = 0;
    uji::sys::BmpTexture *s_BmpBottom_H = 0;
    GLuint s_TextureIdBottom_V = 0;
    GLuint s_TextureIdBottom_H = 0;
}

void uji::eva::TestLcdTraining::TestList()
{
    uji::sys::ClassMenu *m = new uji::sys::ClassMenu( "LcdMenu" );
    m->SetColumn(2);
    m->Add( " Test Pattern 1  ", Pattern0 );
    m->Add( " Test Pattern 2  ", Pattern1 );
    m->Add( " Test Pattern 3  ", Pattern2 );
    m->Add( " Test Pattern 4  ", Pattern3 );
    m->Add( " Test Pattern 5  ", Pattern4 );
    m->Add( " Test Pattern 6  ", Pattern5 );
    m->Add( " Test Pattern 7  ", Pattern6 );
    m->Add( " Test Pattern 8  ", Pattern7 );
    m->Add( " Test Pattern 9  ", Pattern8 );
    m->Add( " Test Pattern 10 ", Pattern9 );
    m->Open();
    delete m;
    
}

void uji::eva::TestLcdTraining::OneLightBlack()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillBlack( gfx );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor(  testpoint[m_testPattern].oneL.bla.R,
                                     testpoint[m_testPattern].oneL.bla.G,
                                     testpoint[m_testPattern].oneL.bla.B );
                                    
    gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].oneL.bla.x, 
                                     testpoint[m_testPattern].oneL.bla.y );
                                     
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}


void uji::eva::TestLcdTraining::OneLightWhite()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillWhite( gfx );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor(  testpoint[m_testPattern].oneL.whi.R,
                                     testpoint[m_testPattern].oneL.whi.G,
                                     testpoint[m_testPattern].oneL.whi.B );
                                    
    gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].oneL.whi.x, 
                                     testpoint[m_testPattern].oneL.whi.y );
                                     
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}

void uji::eva::TestLcdTraining::OneLightRed()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillRed( gfx );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor(  testpoint[m_testPattern].oneL.red.R,
                                     testpoint[m_testPattern].oneL.red.G,
                                     testpoint[m_testPattern].oneL.red.B );
                                    
    gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].oneL.red.x, 
                                     testpoint[m_testPattern].oneL.red.y );
                                     
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    
}

void uji::eva::TestLcdTraining::OneLightGreen()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillGreen( gfx );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor(  testpoint[m_testPattern].oneL.gre.R,
                                     testpoint[m_testPattern].oneL.gre.G,
                                     testpoint[m_testPattern].oneL.gre.B );
                                    
    gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].oneL.gre.x, 
                                     testpoint[m_testPattern].oneL.gre.y );
                                     
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

void uji::eva::TestLcdTraining::OneLightBlue()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillBlue( gfx );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor(  testpoint[m_testPattern].oneL.blu.R,
                                     testpoint[m_testPattern].oneL.blu.G,
                                     testpoint[m_testPattern].oneL.blu.B );
                                    
    gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].oneL.blu.x, 
                                     testpoint[m_testPattern].oneL.blu.y );

    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}

void uji::eva::TestLcdTraining::OneDarkWhite()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillWhite( gfx );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f );
                                    
    gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].oneD.whi.x, 
                                     testpoint[m_testPattern].oneD.whi.y );
                                     
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    
}

void uji::eva::TestLcdTraining::OneDarkRed()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillRed( gfx );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f );
    gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].oneD.red.x, 
                                     testpoint[m_testPattern].oneD.red.y );
                                     
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

void uji::eva::TestLcdTraining::OneDarkGreen()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillGreen( gfx );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f );
    gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].oneD.gre.x, 
                                     testpoint[m_testPattern].oneD.gre.y );
                                     
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

void uji::eva::TestLcdTraining::OneDarkBlue()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillBlue( gfx );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f );
    gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].oneD.blu.x, 
                                     testpoint[m_testPattern].oneD.blu.y );
                                     
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    
}

void uji::eva::TestLcdTraining::MultiLightBlack()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillBlack( gfx );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    for( int i = 0;                  i < testpoint[m_testPattern].mulL.bla.num; i++ )
    {
        gfx->m_DrawFramework->SetColor(  testpoint[m_testPattern].mulL.bla.info[i].R,
                                         testpoint[m_testPattern].mulL.bla.info[i].G,
                                         testpoint[m_testPattern].mulL.bla.info[i].B );
                                        
        gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].mulL.bla.info[i].x, 
                                         testpoint[m_testPattern].mulL.bla.info[i].y );
    }
    
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    
}


void uji::eva::TestLcdTraining::MultiLightWhite()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillWhite( gfx );

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    for( int i = 0;                  i < testpoint[m_testPattern].mulL.whi.num; i++ )
    {
        gfx->m_DrawFramework->SetColor(  testpoint[m_testPattern].mulL.whi.info[i].R,
                                         testpoint[m_testPattern].mulL.whi.info[i].G,
                                         testpoint[m_testPattern].mulL.whi.info[i].B );
                                        
        gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].mulL.whi.info[i].x, 
                                         testpoint[m_testPattern].mulL.whi.info[i].y );
    }
    
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    
}

void uji::eva::TestLcdTraining::MultiLightRed()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillRed( gfx );

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    for( int i = 0;                  i < testpoint[m_testPattern].mulL.red.num; i++ )
    {
        gfx->m_DrawFramework->SetColor(  testpoint[m_testPattern].mulL.red.info[i].R,
                                         testpoint[m_testPattern].mulL.red.info[i].G,
                                         testpoint[m_testPattern].mulL.red.info[i].B );
                                        
        gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].mulL.red.info[i].x, 
                                         testpoint[m_testPattern].mulL.red.info[i].y );
    }
    
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

void uji::eva::TestLcdTraining::MultiLightGreen()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillGreen( gfx );

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    for( int i = 0;                  i < testpoint[m_testPattern].mulL.gre.num; i++ )
    {
        gfx->m_DrawFramework->SetColor(  testpoint[m_testPattern].mulL.gre.info[i].R,
                                         testpoint[m_testPattern].mulL.gre.info[i].G,
                                         testpoint[m_testPattern].mulL.gre.info[i].B );
                                        
        gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].mulL.gre.info[i].x, 
                                         testpoint[m_testPattern].mulL.gre.info[i].y );
    }
    
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

void uji::eva::TestLcdTraining::MultiLightBlue()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillBlue( gfx );

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    for( int i = 0;                  i < testpoint[m_testPattern].mulL.blu.num; i++ )
    {
        gfx->m_DrawFramework->SetColor(  testpoint[m_testPattern].mulL.blu.info[i].R,
                                         testpoint[m_testPattern].mulL.blu.info[i].G,
                                         testpoint[m_testPattern].mulL.blu.info[i].B );
                                        
        gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].mulL.blu.info[i].x, 
                                         testpoint[m_testPattern].mulL.blu.info[i].y );
    }
    
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}

void uji::eva::TestLcdTraining::MultiDarkWhite()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillWhite( gfx );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f );
    for( int i = 0;                  i < testpoint[m_testPattern].mulD.whi.num; i++ )
    {                                    
        gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].mulD.whi.info[i].x, 
                                         testpoint[m_testPattern].mulD.whi.info[i].y );
    }
    
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}

void uji::eva::TestLcdTraining::MultiDarkRed()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillRed( gfx );

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f );
    for( int i = 0;                  i < testpoint[m_testPattern].mulD.red.num; i++ )
    {                                    
        gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].mulD.red.info[i].x, 
                                         testpoint[m_testPattern].mulD.red.info[i].y );
    }
    
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}

void uji::eva::TestLcdTraining::MultiDarkGreen()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillGreen( gfx );

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f );
    for( int i = 0;                  i < testpoint[m_testPattern].mulD.gre.num; i++ )
    {                                    
        gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].mulD.gre.info[i].x, 
                                         testpoint[m_testPattern].mulD.gre.info[i].y );
    }
    
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}

void uji::eva::TestLcdTraining::MultiDarkBlue()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillBlue( gfx );

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f );
    for( int i = 0;                  i < testpoint[m_testPattern].mulD.blu.num; i++ )
    {                                    
        gfx->m_DrawFramework->DrawPoint( testpoint[m_testPattern].mulD.blu.info[i].x, 
                                         testpoint[m_testPattern].mulD.blu.info[i].y );
    }
    
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}

void uji::eva::TestLcdTraining::LineLackHorizontal()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillWhite( gfx );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f );
    gfx->m_DrawFramework->DrawLine( testpoint[m_testPattern].lLack.x, 0.0f, testpoint[m_testPattern].lLack.x, 240.0f );
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

void uji::eva::TestLcdTraining::LineLackVertical()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    FillWhite( gfx );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f );
    gfx->m_DrawFramework->DrawLine( 0.0f, testpoint[m_testPattern].lLack.y, 320.0f, testpoint[m_testPattern].lLack.y );
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}


void uji::eva::TestLcdTraining::GradationHorizontal()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->SetScreenSize( uji::sys::GraphicsDrawing::DISPLAY0_WIDTH, uji::sys::GraphicsDrawing::DISPLAY0_HEIGHT );
    gfx->BeginDrawingShape();
    gfx->SetColor(nw::ut::Color8(0xff, 0xff, 0xff, 0xff),
                  nw::ut::Color8(0x00, 0x00, 0x00, 0xff),
                  nw::ut::Color8(0x00, 0x00, 0x00, 0xff),
                  nw::ut::Color8(0xff, 0xff, 0xff, 0xff) );
    gfx->FillRectangle(0.0f, 0.0f, 400.0f, 240.0f);
    gfx->m_DrawFramework->SwapBuffers();
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->SetScreenSize( uji::sys::GraphicsDrawing::DISPLAY1_WIDTH, uji::sys::GraphicsDrawing::DISPLAY1_HEIGHT );
    gfx->m_DrawFramework->FillTexturedRectangle( s_TextureIdBottom_H,
                                                 0.0f, 0.0f, 320.0f, 240.0f,
                                                 s_BmpBottom_H->GetBmpWidth(), s_BmpBottom_H->GetBmpHeight(),
                                                 s_BmpBottom_H->GetTextureWidth(), s_BmpBottom_H->GetTextureHeight() );
        
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    
}

void uji::eva::TestLcdTraining::GradationVertical()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->SetScreenSize( uji::sys::GraphicsDrawing::DISPLAY0_WIDTH, uji::sys::GraphicsDrawing::DISPLAY0_HEIGHT );
    gfx->BeginDrawingShape();
    gfx->SetColor(nw::ut::Color8(0xff, 0xff, 0xff, 0xff),
                  nw::ut::Color8(0xff, 0xff, 0xff, 0xff),
                  nw::ut::Color8(0x00, 0x00, 0x00, 0xff),
                  nw::ut::Color8(0x00, 0x00, 0x00, 0xff) );
    gfx->FillRectangle(0.0f, 0.0f, 400.0f, 240.0f);
    gfx->m_DrawFramework->SwapBuffers();
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->SetScreenSize( uji::sys::GraphicsDrawing::DISPLAY1_WIDTH, uji::sys::GraphicsDrawing::DISPLAY1_HEIGHT );
    gfx->m_DrawFramework->FillTexturedRectangle( s_TextureIdBottom_V,
                                                 0.0f, 0.0f, 320.0f, 240.0f,
                                                 s_BmpBottom_V->GetBmpWidth(), s_BmpBottom_V->GetBmpHeight(),
                                                 s_BmpBottom_V->GetTextureWidth(), s_BmpBottom_V->GetTextureHeight() );
        
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    
}

void uji::eva::TestLcdTraining::PlayOkSound()
{
    uji::sys::SoundPlayer *sp = new uji::sys::SoundPlayer;
    sp->UjiSoundPlayer( "rom:/SoundPlayer/ok.wav", 1500 );
    delete sp;
    NN_LOG("Play OK Sound");
}

void uji::eva::TestLcdTraining::ShowTestPattern()
{
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    
    typedef void (*FunctionPointer)( void );

    const FunctionPointer list[]=
    {
        OneLightBlack,
        OneLightWhite,
        OneLightRed,
        OneLightGreen,
        OneLightBlue,
        OneDarkWhite,
        OneDarkRed,
        OneDarkGreen,
        OneDarkBlue,
        MultiLightBlack,
        MultiLightWhite,
        MultiLightRed,
        MultiLightGreen,
        MultiLightBlue,
        MultiDarkWhite,
        MultiDarkRed,
        MultiDarkGreen,
        MultiDarkBlue,
        LineLackHorizontal,
        LineLackVertical,
        GradationHorizontal,
        GradationVertical
    };

    int pattern = 0;
    bool isQuit = false;
    
    uji::seq::TestResult dummy_result;
    // obNCgPxő
    uji::eva::backlight::SetMaxBrightness(dummy_result);

    // ANeBuobNCg@\OFF
    uji::eva::backlight::SetActiveBackLightOff(dummy_result);
    
    s_BmpBottom_V = new uji::sys::BmpTexture();
    s_BmpBottom_H = new uji::sys::BmpTexture();
    switch( m_testPattern )
    {
        case 0: s_BmpBottom_V->Open( L"rom:/bmp/lcdTraining/Pattern01_V.bmp" ); s_BmpBottom_H->Open( L"rom:/bmp/lcdTraining/Pattern01_H.bmp" ); break;
        case 1: s_BmpBottom_V->Open( L"rom:/bmp/lcdTraining/Pattern02_V.bmp" ); s_BmpBottom_H->Open( L"rom:/bmp/lcdTraining/Pattern02_H.bmp" ); break;
        case 2: s_BmpBottom_V->Open( L"rom:/bmp/lcdTraining/Pattern03_V.bmp" ); s_BmpBottom_H->Open( L"rom:/bmp/lcdTraining/Pattern03_H.bmp" ); break;
        case 3: s_BmpBottom_V->Open( L"rom:/bmp/lcdTraining/Pattern04_V.bmp" ); s_BmpBottom_H->Open( L"rom:/bmp/lcdTraining/Pattern04_H.bmp" ); break;
        case 4: s_BmpBottom_V->Open( L"rom:/bmp/lcdTraining/Pattern05_V.bmp" ); s_BmpBottom_H->Open( L"rom:/bmp/lcdTraining/Pattern05_H.bmp" ); break;
        case 5: s_BmpBottom_V->Open( L"rom:/bmp/lcdTraining/Pattern06_V.bmp" ); s_BmpBottom_H->Open( L"rom:/bmp/lcdTraining/Pattern06_H.bmp" ); break;
        case 6: s_BmpBottom_V->Open( L"rom:/bmp/lcdTraining/Pattern07_V.bmp" ); s_BmpBottom_H->Open( L"rom:/bmp/lcdTraining/Pattern07_H.bmp" ); break;
        case 7: s_BmpBottom_V->Open( L"rom:/bmp/lcdTraining/Pattern08_V.bmp" ); s_BmpBottom_H->Open( L"rom:/bmp/lcdTraining/Pattern08_H.bmp" ); break;
        case 8: s_BmpBottom_V->Open( L"rom:/bmp/lcdTraining/Pattern09_V.bmp" ); s_BmpBottom_H->Open( L"rom:/bmp/lcdTraining/Pattern09_H.bmp" ); break;
        case 9: s_BmpBottom_V->Open( L"rom:/bmp/lcdTraining/Pattern10_V.bmp" ); s_BmpBottom_H->Open( L"rom:/bmp/lcdTraining/Pattern10_H.bmp" ); break;
    }
    
    if( s_TextureIdBottom_V != 0 )
    {   
        gfx->m_DrawFramework->DeleteTexture( s_TextureIdBottom_V );
    }
    if( s_TextureIdBottom_H != 0 )
    {   
        gfx->m_DrawFramework->DeleteTexture( s_TextureIdBottom_H );
    }
    
    gfx->m_DrawFramework->GenerateTexture( GL_TEXTURE_2D,
                                           s_BmpBottom_V->INTERNAL_FORMAT,
                                           s_BmpBottom_V->GetTextureWidth(),
                                           s_BmpBottom_V->GetTextureHeight(),
                                           s_BmpBottom_V->FORMAT,
                                           s_BmpBottom_V->TYPE,
                                           s_BmpBottom_V->GetTextureDataPointer(),
                                           s_TextureIdBottom_V );

    gfx->m_DrawFramework->GenerateTexture( GL_TEXTURE_2D,
                                           s_BmpBottom_H->INTERNAL_FORMAT,
                                           s_BmpBottom_H->GetTextureWidth(),
                                           s_BmpBottom_H->GetTextureHeight(),
                                           s_BmpBottom_H->FORMAT,
                                           s_BmpBottom_H->TYPE,
                                           s_BmpBottom_H->GetTextureDataPointer(),
                                           s_TextureIdBottom_H );

    do
    {
        //pbhXV
        pad.UpdatePad();

        (*list[pattern])();
        if( pad.IsButtonRepeat( uji::sys::Pad::BUTTON_A ) )
        {
            pattern++;
            if( pattern >= ( sizeof(list) / sizeof(list[0])) )
            {
                isQuit = true;
            }
        }

        if( pad.IsButtonRepeat( uji::sys::Pad::BUTTON_B ) )
        {
            pattern--;
            if( pattern < 0 )
            {
                pattern = 0;
            }
        }

    }while( !isQuit );
    PlayOkSound();
    
    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
    
    gfx->m_DrawFramework->DeleteTexture( s_TextureIdBottom_V );
    gfx->m_DrawFramework->DeleteTexture( s_TextureIdBottom_H );

    s_TextureIdBottom_V = 0;
    s_TextureIdBottom_H = 0;
    s_BmpBottom_V->Close();
    s_BmpBottom_H->Close();
    s_BmpBottom_V = 0;
    s_BmpBottom_H = 0;
    
    //pbhXV
    pad.UpdatePad();
    gfx->ReInitRenderSystem();
    
}

/************************************************************************
 wFŉʓhԂ
 ***********************************************************************/
void uji::eva::TestLcdTraining::FillAnyColor( uji::sys::GraphicsDrawing *gfx, f32 r, f32 g, f32 b )
{
    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->m_DrawFramework->SetColor( r, g, b, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 400.0f, 240.0f );
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor( r, g, b, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 320.0f, 240.0f );
    gfx->m_DrawFramework->SwapBuffers();

}


