//-----------------------------------------------------------
// HT Wv]̉t]vO
//-----------------------------------------------------------


#include <nn.h>
#include "sys.h"
#include "TestLcdQuality.h"

void uji::eva::TestLcdQuality::TestLcdCommon()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::sys::BmpTexture bmpBottom1;
    uji::sys::BmpTexture bmpBottom2;
    GLuint textureIdBottom1 = 1;
    GLuint textureIdBottom2 = 2;
    
    bmpBottom1.Open( L"rom:/bmp/lcd_quality_test_pattern1.bmp" );
    bmpBottom2.Open( L"rom:/bmp/lcd_quality_test_pattern2.bmp" );
    
    const int FONT_SIZE = 16;
    
    uji::sys::TextWindow upperWindow( 400/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE );
    upperWindow.SetTitle("Lcd Quality Checker");
    uji::sys::Menu::m_WindowManager.CreateWindow( &upperWindow, NN_GX_DISPLAY0, 0, 0 );
    upperWindow.Printf("GenerateTexture...");
    
    {
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        uji::sys::Menu::m_WindowManager.Update();
        uji::sys::Menu::m_WindowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
        gfx->m_DrawFramework->Clear();
        gfx->m_DrawFramework->SwapBuffers();
    }

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
    
    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            bmpBottom1.INTERNAL_FORMAT,
                                            bmpBottom1.GetTextureWidth(),
                                            bmpBottom1.GetTextureHeight(),
                                            bmpBottom1.FORMAT,
                                            bmpBottom1.TYPE,
                                            bmpBottom1.GetTextureDataPointer(),
                                            textureIdBottom1 );
                                            
    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            bmpBottom2.INTERNAL_FORMAT,
                                            bmpBottom2.GetTextureWidth(),
                                            bmpBottom2.GetTextureHeight(),
                                            bmpBottom2.FORMAT,
                                            bmpBottom2.TYPE,
                                            bmpBottom2.GetTextureDataPointer(),
                                            textureIdBottom2 );
    
    
    uji::seq::TestResult dummyResult;
    
    // MCU֘A
    uji::eva::mcu::McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        uji::eva::mcu::McuInitializer().GetHSession()      // mꂽZbṼnh
    );         
    // obNCgPxő
    uji::eva::backlight::SetMaxBrightness( dummyResult );

    // ANeBuobNCg@\OFF
    uji::eva::backlight::SetActiveBackLightOff( dummyResult );
    
    upperWindow.Printf("\f");
    upperWindow.Printf("Press A to Change Graphics\n");
    
    {
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        uji::sys::Menu::m_WindowManager.Update();
        uji::sys::Menu::m_WindowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
        
    }
    
    
    bool isTest1 = true;
    
    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );

    while(1)
    {
        uji::sys::Pad().UpdatePad();
        if( uji::sys::Pad().IsButtonDown( uji::sys::Pad::BUTTON_A ))
        {
            isTest1 = !isTest1;
        }
        if( uji::sys::Pad().IsButtonPress( uji::sys::Pad::BUTTON_START )
            && uji::sys::Pad().IsButtonPress( uji::sys::Pad::BUTTON_L )
            && uji::sys::Pad().IsButtonPress( uji::sys::Pad::BUTTON_R ))
        {
            break;
        }
        
        
        if( isTest1 )
        {
            gfx->SetScreenSize( uji::sys::GraphicsDrawing::DISPLAY1_WIDTH, uji::sys::GraphicsDrawing::DISPLAY1_HEIGHT );
            gfx->m_DrawFramework->FillTexturedRectangle( textureIdBottom1,
            0.0f, 0.0f, 320.0f, 240.0f,
            bmpBottom1.GetBmpWidth(),     bmpBottom1.GetBmpHeight(),
            bmpBottom1.GetTextureWidth(), bmpBottom1.GetTextureHeight() );
            
        }else
        {
            gfx->SetScreenSize( uji::sys::GraphicsDrawing::DISPLAY1_WIDTH, uji::sys::GraphicsDrawing::DISPLAY1_HEIGHT );
            gfx->m_DrawFramework->FillTexturedRectangle( textureIdBottom2,
            0.0f, 0.0f, 320.0f, 240.0f,
            bmpBottom2.GetBmpWidth(),     bmpBottom2.GetBmpHeight(),
            bmpBottom2.GetTextureWidth(), bmpBottom2.GetTextureHeight() );
            
        }
        gfx->m_DrawFramework->SwapBuffers();

        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
            
    }
    
    gfx->m_DrawFramework->DeleteTexture( textureIdBottom1 );
    gfx->m_DrawFramework->DeleteTexture( textureIdBottom2 );
    
    bmpBottom1.Close();
    bmpBottom2.Close();
    uji::sys::Menu::m_WindowManager.DestroyWindow( &upperWindow );
    upperWindow.Destroy();
        
}
