/************************************************************************
t
  ************************************************************************/
/* dCN[h̉ */
#ifndef TESTLCD_H_INCLUDED
#define TESTLCD_H_INCLUDED

#include <nn.h>
#include "sys.h"
#include "../seq/TestResult.h"

namespace uji{
namespace eva{


class TestLcd
{
public:
	static void Execute(void);
	static bool ShowTestPattern( uji::seq::TestResult &result );
	static bool TestBackLight( uji::seq::TestResult &result );
	static bool ShowTestPattern_Body( uji::seq::TestResult &result );
	static void ShowBmpFile(void);

	static bool TestEnable3D( uji::seq::TestResult &result );
	static bool TestDisable3D( uji::seq::TestResult &result );
	static bool TestWhite( uji::seq::TestResult &result );
	static bool TestBlack( uji::seq::TestResult &result );
	static bool TestRed( uji::seq::TestResult &result );
	static bool TestGreen( uji::seq::TestResult &result );
	static bool TestBlue( uji::seq::TestResult &result );
	static bool TestBegin( uji::seq::TestResult &result );
	static bool TestEnd( uji::seq::TestResult &result );
	static bool ShowFlickerPattern( uji::seq::TestResult &result );

protected:
	TestLcd(){}
	~TestLcd(){}
	static void DrawFlicker(uji::sys::GraphicsDrawing *gfx );
	static void DrawFlickerWithVcom( uji::sys::GraphicsDrawing *gfx, s16 vcomTop, s16 vcomBottom );
	static void FillAnyColor( uji::sys::GraphicsDrawing *gfx, f32 r, f32 g, f32 b);
	static void FillWhite( uji::sys::GraphicsDrawing *gfx ){	FillAnyColor( gfx, 1.0f, 1.0f, 1.0f ); }
	static void FillBlack( uji::sys::GraphicsDrawing *gfx ){	FillAnyColor( gfx, 0.0f, 0.0f, 0.0f ); }
	static void FillRed( uji::sys::GraphicsDrawing *gfx ){		FillAnyColor( gfx, 1.0f, 0.0f, 0.0f ); }
	static void FillGreen( uji::sys::GraphicsDrawing *gfx ){	FillAnyColor( gfx, 0.0f, 1.0f, 0.0f ); }
	static void FillBlue( uji::sys::GraphicsDrawing *gfx ){		FillAnyColor( gfx, 0.0f, 0.0f, 1.0f ); }
	static void DrawOutLine( uji::sys::GraphicsDrawing *gfx );
	static void DrawOutLineAlt( uji::sys::GraphicsDrawing *gfx );
	static void DrawVerticalGradation( uji::sys::GraphicsDrawing *gfx );
	static void DrawHorizontalGradation( uji::sys::GraphicsDrawing *gfx );
	static void DrawParallaxBarrier( uji::sys::GraphicsDrawing *gfx );
	static void DrawParallaxBarrierDust1( uji::sys::GraphicsDrawing *gfx );
	static void DrawParallaxBarrierDust2( uji::sys::GraphicsDrawing *gfx );
};

} //eva
} //uji

/* dCN[h̉ */
#endif
