/********************************************************************
t
********************************************************************/

#include <nn.h>
#include <nn/drivers/cal/CTR/cal_Api.h>
#include "sys.h"
#include "../seq/reception_board_interface.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "TestLcd.h"
#include "../mcu/McuInitializer.h"
#include "../mcu/TestMcu.h"
#include "../seq/TestResult.h"
#include "../seq/Config.h"
#include "../seq/ConfigDefine.h"
#include "../backlight/BackLightTest.h"


using namespace uji;
using namespace uji::sys;
using namespace uji::seq;
using namespace uji::eva;
using namespace uji::eva::mcu;



//z̗vf߂  'Code Complete @Ł@P379 p
#define ARRAY_LENGTH(x) (sizeof(x)/sizeof(x[0]))

namespace{
BmpTexture *s_BmpTop=0;
BmpTexture *s_BmpBottom=0;
GLuint s_TextureIdTop=0;
GLuint s_TextureIdBottom=0;
}

const int INDICATE_TERM = 60; //tbJɒl\鎞(frame)

/************************************************************************
 wFŉʓhԂ
 ***********************************************************************/
void TestLcd::FillAnyColor( GraphicsDrawing *gfx, f32 r, f32 g, f32 b )
{
    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->m_DrawFramework->SetColor( r, g, b, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 400.0f, 240.0f );
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor( r, g, b, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 320.0f, 240.0f );
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}

/************************************************************************
 Og\
 ***********************************************************************/
void TestLcd::DrawOutLine( GraphicsDrawing *gfx )
{
    if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);

        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        gfx->m_DrawFramework->SetColor( 1.0f, 1.0f, 1.0f, 1.0f );
        gfx->m_DrawFramework->DrawLine( 0.0f, 0.0f, 0.0f, 239.0f );
        gfx->m_DrawFramework->DrawLine( 0.0f, 239.0f, 399.0f, 239.0f );
        gfx->m_DrawFramework->DrawLine( 399.0f, 239.0f, 399.0f, 0.0f );
        gfx->m_DrawFramework->DrawLine( 399.0f, 0.0f, 0.0f, 0.0f );
        gfx->m_DrawFramework->SwapBuffers();
        
    }else
    {
        gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_RESERVED);

        gfx->m_DrawFramework->SetRenderTarget( demo::RenderSystemUji::NN_GX_DISPLAY0_HD );
        gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY0, 0.0f, 0.0f, 0.0f, 1.0f );
        gfx->m_DrawFramework->Clear();
        gfx->m_DrawFramework->SetColor( 1.0f, 1.0f, 1.0f, 1.0f );
        gfx->m_DrawFramework->DrawLine( 0.0f, 0.0f, 0.0f, 239.0f );
        gfx->m_DrawFramework->DrawLine( 0.0f, 239.0f, 799.0f, 239.0f );
        gfx->m_DrawFramework->DrawLine( 799.0f, 239.0f, 799.0f, 0.0f );
        gfx->m_DrawFramework->DrawLine( 799.0f, 0.0f, 0.0f, 0.0f );
        gfx->m_DrawFramework->SwapBuffers();
    }

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetClearColor( NN_GX_DISPLAY1, 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->Clear();
    gfx->m_DrawFramework->SetColor( 1.0f, 1.0f, 1.0f, 1.0f );
    gfx->m_DrawFramework->DrawLine( 0.0f, 0.0f, 0.0f, 239.0f );
    gfx->m_DrawFramework->DrawLine( 0.0f, 239.0f, 319.0f, 239.0f );
    gfx->m_DrawFramework->DrawLine( 319.0f, 239.0f, 319.0f, 0.0f );
    gfx->m_DrawFramework->DrawLine( 319.0f, 0.0f, 0.0f, 0.0f );

    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}

/************************************************************************
 cOf[V\
 ***********************************************************************/
void TestLcd::DrawVerticalGradation( GraphicsDrawing *gfx )
{
    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
    gfx->BeginDrawingShape();
    gfx->SetColor(nw::ut::Color8(0xff, 0xff, 0xff, 0xff),
                  nw::ut::Color8(0xff, 0xff, 0xff, 0xff),
                  nw::ut::Color8(0x00, 0x00, 0x00, 0xff),
                  nw::ut::Color8(0x00, 0x00, 0x00, 0xff) );
    gfx->FillRectangle(0.0f, 0.0f, 400.0f, 240.0f);
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
    gfx->BeginDrawingShape();
    gfx->SetColor(nw::ut::Color8(0xff, 0xff, 0xff, 0xff),
                  nw::ut::Color8(0xff, 0xff, 0xff, 0xff),
                  nw::ut::Color8(0x00, 0x00, 0x00, 0xff),
                  nw::ut::Color8(0x00, 0x00, 0x00, 0xff) );
    gfx->FillRectangle(0.0f, 0.0f, 320.0f, 240.0f);
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}


/************************************************************************
 cOf[V\
 ***********************************************************************/
void TestLcd::DrawHorizontalGradation( GraphicsDrawing *gfx )
{
    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
    gfx->BeginDrawingShape();
    gfx->SetColor(nw::ut::Color8(0xff, 0xff, 0xff, 0xff),
                  nw::ut::Color8(0x00, 0x00, 0x00, 0xff),
                  nw::ut::Color8(0x00, 0x00, 0x00, 0xff),
                  nw::ut::Color8(0xff, 0xff, 0xff, 0xff) );
    gfx->FillRectangle(0.0f, 0.0f, 400.0f, 240.0f);
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
    gfx->BeginDrawingShape();
    gfx->SetColor(nw::ut::Color8(0xff, 0xff, 0xff, 0xff),
                  nw::ut::Color8(0x00, 0x00, 0x00, 0xff),
                  nw::ut::Color8(0x00, 0x00, 0x00, 0xff),
                  nw::ut::Color8(0xff, 0xff, 0xff, 0xff) );
    gfx->FillRectangle(0.0f, 0.0f, 320.0f, 240.0f);
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}


/************************************************************************
 tbJʕ\
 ***********************************************************************/
void TestLcd::DrawFlicker( GraphicsDrawing *gfx )
{
    if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
        gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
            0.0f, 0.0f, 400.0f, 240.0f,
            s_BmpTop->GetBmpWidth()/2, s_BmpTop->GetBmpHeight(),
            s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
        gfx->m_DrawFramework->SwapBuffers();
    }else
    {
        gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_RESERVED);

        gfx->m_DrawFramework->SetRenderTarget( demo::RenderSystemUji::NN_GX_DISPLAY0_HD );
        gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH*2, GraphicsDrawing::DISPLAY0_HEIGHT );
        gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
            0.0f, 0.0f, 800.0f, 240.0f,
            s_BmpTop->GetBmpWidth(), s_BmpTop->GetBmpHeight(),
            s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
        gfx->m_DrawFramework->SwapBuffers();
    }

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
    gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdBottom,
        0.0f, 0.0f, 320.0f, 240.0f,
        s_BmpBottom->GetBmpWidth(), s_BmpBottom->GetBmpHeight(),
        s_BmpBottom->GetTextureWidth(), s_BmpBottom->GetTextureHeight() );
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/************************************************************************
 tbJʕ\iubnl\j
 ***********************************************************************/
void TestLcd::DrawFlickerWithVcom( GraphicsDrawing *gfx, s16 vcomTop, s16 vcomBottom )
{
    char str[100];

    sprintf( str, "[%d,%d]", (int)vcomTop, (int)vcomBottom );

    if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
        gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
            0.0f, 0.0f, 400.0f, 240.0f,
            s_BmpTop->GetBmpWidth()/2, s_BmpTop->GetBmpHeight(),
            s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
        gfx->m_DrawFramework->SwapBuffers();
    }else
    {
        gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_RESERVED);

        gfx->m_DrawFramework->SetRenderTarget( demo::RenderSystemUji::NN_GX_DISPLAY0_HD );
        gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH*2, GraphicsDrawing::DISPLAY0_HEIGHT );
        gfx->m_DrawFramework->FillTexturedRectangle(s_TextureIdTop,
            0.0f, 0.0f, 800.0f, 240.0f,
            s_BmpTop->GetBmpWidth(), s_BmpTop->GetBmpHeight(),
            s_BmpTop->GetTextureWidth(), s_BmpTop->GetTextureHeight() );
        gfx->m_DrawFramework->SwapBuffers();
    }

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );

    gfx->BeginDrawingString();
    gfx->m_TextWriter.SetFontSize(28);
    gfx->m_TextWriter.SetCharSpace(8);
    gfx->m_TextWriter.SetGradationMode(nn::font::CharWriter::GRADMODE_V);
    gfx->m_TextWriter.SetTextColor(nn::util::Color8::YELLOW, nn::util::Color8::RED);
    gfx->m_TextWriter.SetCursor(0, 0);
    gfx->m_TextWriter.Print( str );
    gfx->m_TextWriter.SetGradationMode(nn::font::CharWriter::GRADMODE_NONE);
    gfx->m_TextWriter.SetCharSpace(0);
    gfx->EndDrawingString();

    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}


/************************************************************************
 oAeXgʕ\
 ***********************************************************************/
void TestLcd::DrawParallaxBarrier( GraphicsDrawing *gfx )
{
    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_STEREO);

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->m_DrawFramework->SetColor( 1.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 400.0f, 240.0f );
    gfx->m_DrawFramework->Transfer();

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0_EXT );
    gfx->m_DrawFramework->SetColor( 0.0f, 1.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 400.0f, 240.0f );
    gfx->m_DrawFramework->Transfer();
    gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 1.0f, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 320.0f, 240.0f );
    gfx->m_DrawFramework->Transfer();
    gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}

/************************************************************************
 oAeXgʕ\݂P
 ***********************************************************************/
void TestLcd::DrawParallaxBarrierDust1( GraphicsDrawing *gfx )
{
    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_STEREO);

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 400.0f, 240.0f );
    gfx->m_DrawFramework->Transfer();

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0_EXT );
    gfx->m_DrawFramework->SetColor( 1.0f, 1.0f, 1.0f, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 400.0f, 240.0f );
    gfx->m_DrawFramework->Transfer();
    gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 1.0f, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 320.0f, 240.0f );
    gfx->m_DrawFramework->Transfer();
    gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}

/************************************************************************
 oAeXgʕ\݂Q
 ***********************************************************************/
void TestLcd::DrawParallaxBarrierDust2( GraphicsDrawing *gfx )
{
    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_STEREO);

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
    gfx->m_DrawFramework->SetColor( 1.0f, 1.0f, 1.0f, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 400.0f, 240.0f );
    gfx->m_DrawFramework->Transfer();

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0_EXT );
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 0.0f, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 400.0f, 240.0f );
    gfx->m_DrawFramework->Transfer();
    gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();

    gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
    gfx->m_DrawFramework->SetColor( 0.0f, 0.0f, 1.0f, 1.0f );
    gfx->m_DrawFramework->FillRectangle( 0.0f, 0.0f, 320.0f, 240.0f );
    gfx->m_DrawFramework->Transfer();
    gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

}

/************************************************************************
 kbcSp^[\
 ***********************************************************************/
void TestLcd::Execute(void)
{
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    uji::seq::Config config;

    typedef void (*FunctionPointer)( uji::sys::GraphicsDrawing *gfx );

    const FunctionPointer listTop[]=
    {
        DrawFlicker,
        FillWhite,
        FillBlack,
        FillRed,
        FillGreen,
        FillBlue,
        DrawOutLine,
        DrawVerticalGradation,
        DrawHorizontalGradation,
        DrawParallaxBarrier,
        DrawParallaxBarrierDust1,
        DrawParallaxBarrierDust2,

    };

    const FunctionPointer listBottom[]=
    {
        DrawFlicker,
        FillWhite,
        FillBlack,
        FillRed,
        FillGreen,
        FillBlue,
        DrawOutLine,
        DrawVerticalGradation,
        DrawHorizontalGradation,
    };

    int listSize;
    const FunctionPointer *currentList;

    //RtBOɉăXgύX
    if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        currentList = listBottom;
        listSize = ARRAY_LENGTH(listBottom);
    }
    else if( config.Get().LcdModuleTestPattern==1 )
    {
        currentList = listBottom;
        listSize = ARRAY_LENGTH(listBottom);
    }else{
        currentList = listTop;
        listSize = ARRAY_LENGTH(listTop);
    }


    //eNX`ݒ
    s_BmpTop = new BmpTexture();
    s_BmpBottom = new BmpTexture();
    
    if( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType() ||
        uji::sys::PLATFORM_KTR == uji::sys::GetPlatformType() ||
        uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        s_BmpTop->Open( L"rom:/bmp/Upper_SPFL_flicker.bmp" );
        s_BmpBottom->Open( L"rom:/bmp/Lower_SPFL_flicker.bmp" );
    }
    else
    {
        s_BmpTop->Open( L"rom:/bmp/ctr_upper_flicker.bmp" );
        s_BmpBottom->Open( L"rom:/bmp/ctr_lower_flicker.bmp" );
    }
    

    if( s_TextureIdTop != 0 )   gfx->m_DrawFramework->DeleteTexture(s_TextureIdTop );
    if( s_TextureIdBottom != 0 )gfx->m_DrawFramework->DeleteTexture(s_TextureIdBottom );

    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            s_BmpTop->INTERNAL_FORMAT,
                                            s_BmpTop->GetTextureWidth(),
                                            s_BmpTop->GetTextureHeight(),
                                            s_BmpTop->FORMAT,
                                            s_BmpTop->TYPE,
                                            s_BmpTop->GetTextureDataPointer(),
                                            s_TextureIdTop );

    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            s_BmpBottom->INTERNAL_FORMAT,
                                            s_BmpBottom->GetTextureWidth(),
                                            s_BmpBottom->GetTextureHeight(),
                                            s_BmpBottom->FORMAT,
                                            s_BmpBottom->TYPE,
                                            s_BmpBottom->GetTextureDataPointer(),
                                            s_TextureIdBottom );


    int pattern=0;


    // RtBOp
    Config lcdConfig;
    if( !lcdConfig.Load() ) lcdConfig.Initialize();

    // MCU֘A
    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    uji::seq::TestResult dummy_result;

    // m点vF_
    uji::eva::mcu::NotifyLedBlueOn(dummy_result);

    // obNCgPxő
    uji::eva::backlight::SetMaxBrightness(dummy_result);

    // ANeBuobNCg@\OFF
    uji::eva::backlight::SetActiveBackLightOff(dummy_result);


    s16 vcomTop=0;
    s16 vcomBottom=0;
    if( mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,    (u8*)&vcomTop, 1 ).IsFailure() )                SYS_PANIC( "Fail to access MCU" );
    if( mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR, (u8*)&vcomBottom, 1 ).IsFailure() )             SYS_PANIC( "Fail to access MCU" );

    int indicateCounter = 0;
    GLenum selectedDisplay = NN_GX_DISPLAY0;
    
    bool isQuit = false;
    do
    {
        //pbhXV
        pad.UpdatePad();


        if( pad.IsButtonRepeat( Pad::BUTTON_A ) )
        {
            pattern++;
            if( pattern >=listSize ) pattern=0;
        }

        if( pad.IsButtonRepeat( Pad::BUTTON_B ) )
        {
            pattern--;
            if( pattern<0 ) pattern=listSize-1;
        }

        // R{^ŋPx1`5ɕύX
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_R))
        {
            uji::eva::backlight::ChangeLightLevel();
        }

        //Ώۂ̃p^[쐬
        if( pattern==0 && indicateCounter>0 )
        {
            DrawFlickerWithVcom( gfx, vcomTop, vcomBottom );
            indicateCounter--;
        }else{
            (*currentList[pattern])(gfx);
        }

#ifndef EVA_LCD_MODULE
        if( sys::Pad().IsButtonRepeatFast( sys::Pad::BUTTON_START ))
        {
            isQuit = true;
        }
#endif

#ifndef EVA_REPAIR
        Config::Member lcdMember = lcdConfig.Get();

        // tbJ[p
        if( pattern == 0)
        {
            if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType() )
            {
                // X{^
                if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_X))
                {
                    indicateCounter = INDICATE_TERM;

                    if( selectedDisplay == NN_GX_DISPLAY0 ){
                        if( mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,    (u8*)&vcomTop, 1 ).IsFailure() )                SYS_PANIC( "Fail to access MCU" );
                        vcomTop+=lcdMember.LcdFlicker;
                        if( vcomTop>0xff ) vcomTop=0xff;
                        if( mcu.WriteBySend(MCU_VCOM_TOP_ADDR,      (u8*)&vcomTop, sizeof(u8) ).IsFailure() )       SYS_PANIC( "Fail to access MCU" );
                    }else{
                        if( mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR, (u8*)&vcomBottom, 1 ).IsFailure() )             SYS_PANIC( "Fail to access MCU" );
                        vcomBottom+=lcdMember.LcdFlicker;
                        if( vcomBottom>0xff ) vcomBottom=0xff;
                        if( mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,   (u8*)&vcomBottom, sizeof(u8) ).IsFailure() )    SYS_PANIC( "Fail to access MCU" );
                    }

                }

                // Y{^
                if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_Y))
                {
                    indicateCounter = INDICATE_TERM;

                    if( selectedDisplay == NN_GX_DISPLAY0 ){
                        if( mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,    (u8*)&vcomTop, 1 ).IsFailure() )                SYS_PANIC( "Fail to access MCU" );
                        vcomTop-=lcdMember.LcdFlicker;
                        if( vcomTop<0 ) vcomTop=0;
                        if( mcu.WriteBySend(MCU_VCOM_TOP_ADDR,      (u8*)&vcomTop, sizeof(u8) ).IsFailure() )       SYS_PANIC( "Fail to access MCU" );
                    }else{
                        if( mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR, (u8*)&vcomBottom, 1 ).IsFailure() )             SYS_PANIC( "Fail to access MCU" );
                        vcomBottom-=lcdMember.LcdFlicker;
                        if( vcomBottom<0 ) vcomBottom=0;
                        if( mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,   (u8*)&vcomBottom, sizeof(u8) ).IsFailure() )    SYS_PANIC( "Fail to access MCU" );
                    }
                }


                // {^ {
                if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_UP))
                {
                    indicateCounter = INDICATE_TERM;
                    selectedDisplay = NN_GX_DISPLAY0;
                    uji::eva::mcu::NotifyLedBlueOn(dummy_result);
                }

                // {^ |
                if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_DOWN))
                {
                    indicateCounter = INDICATE_TERM;
                    selectedDisplay = NN_GX_DISPLAY1;
                    uji::eva::mcu::NotifyLedBlueOff(dummy_result);
                }
                
                if( sys::Pad().IsButtonRepeatFast( sys::Pad::BUTTON_START ))
                {
                    if( selectedDisplay == NN_GX_DISPLAY0 )
                    {
                        indicateCounter = INDICATE_TERM;
                        selectedDisplay = NN_GX_DISPLAY1;
                        uji::eva::mcu::NotifyLedBlueOff(dummy_result);
                    }else
                    {
                        indicateCounter = INDICATE_TERM;
                        selectedDisplay = NN_GX_DISPLAY0;
                        uji::eva::mcu::NotifyLedBlueOn(dummy_result);
                    }
                    
                }
            }
            else
            {
                
                // E{^
                if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_RIGHT))
                {
                    indicateCounter = INDICATE_TERM;

                    if( selectedDisplay == NN_GX_DISPLAY0 ){
                        if( mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,    (u8*)&vcomTop, 1 ).IsFailure() )                SYS_PANIC( "Fail to access MCU" );
                        vcomTop+=lcdMember.LcdFlicker;
                        if( vcomTop>0xff ) vcomTop=0xff;
                        if( mcu.WriteBySend(MCU_VCOM_TOP_ADDR,      (u8*)&vcomTop, sizeof(u8) ).IsFailure() )       SYS_PANIC( "Fail to access MCU" );
                    }else{
                        if( mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR, (u8*)&vcomBottom, 1 ).IsFailure() )             SYS_PANIC( "Fail to access MCU" );
                        vcomBottom+=lcdMember.LcdFlicker;
                        if( vcomBottom>0xff ) vcomBottom=0xff;
                        if( mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,   (u8*)&vcomBottom, sizeof(u8) ).IsFailure() )    SYS_PANIC( "Fail to access MCU" );
                    }
                }

                // {^
                if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_LEFT))
                {
                    indicateCounter = INDICATE_TERM;

                    if( selectedDisplay == NN_GX_DISPLAY0 ){
                        if( mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,    (u8*)&vcomTop, 1 ).IsFailure() )                SYS_PANIC( "Fail to access MCU" );
                        vcomTop-=lcdMember.LcdFlicker;
                        if( vcomTop<0 ) vcomTop=0;
                        if( mcu.WriteBySend(MCU_VCOM_TOP_ADDR,      (u8*)&vcomTop, sizeof(u8) ).IsFailure() )       SYS_PANIC( "Fail to access MCU" );
                    }else{
                        if( mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR, (u8*)&vcomBottom, 1 ).IsFailure() )             SYS_PANIC( "Fail to access MCU" );
                        vcomBottom-=lcdMember.LcdFlicker;
                        if( vcomBottom<0 ) vcomBottom=0;
                        if( mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,   (u8*)&vcomBottom, sizeof(u8) ).IsFailure() )    SYS_PANIC( "Fail to access MCU" );
                    }
                }


                // {^ {
                if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_UP))
                {
                    indicateCounter = INDICATE_TERM;
                    selectedDisplay = NN_GX_DISPLAY0;
                    uji::eva::mcu::NotifyLedBlueOn(dummy_result);
                }

                // {^ |
                if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_DOWN))
                {
                    indicateCounter = INDICATE_TERM;
                    selectedDisplay = NN_GX_DISPLAY1;
                    uji::eva::mcu::NotifyLedBlueOff(dummy_result);
                }

                // w{^ ㉺Ɂ{
                if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_X))
                {
                    indicateCounter = INDICATE_TERM;

                    if( mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,    (u8*)&vcomTop, 1 ).IsFailure() )                SYS_PANIC( "Fail to access MCU" );
                    if( mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR, (u8*)&vcomBottom, 1 ).IsFailure() )             SYS_PANIC( "Fail to access MCU" );

                    vcomTop+=lcdMember.LcdFlicker;
                    if( vcomTop>0xff ) vcomTop=0xff;

                    vcomBottom+=lcdMember.LcdFlicker;
                    if( vcomBottom>0xff ) vcomBottom=0xff;

                    if( mcu.WriteBySend(MCU_VCOM_TOP_ADDR,      (u8*)&vcomTop, sizeof(u8) ).IsFailure() )       SYS_PANIC( "Fail to access MCU" );
                    if( mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,   (u8*)&vcomBottom, sizeof(u8) ).IsFailure() )    SYS_PANIC( "Fail to access MCU" );
                }

                // x{^ ㉺Ɂ|
                if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_Y))
                {
                    indicateCounter = INDICATE_TERM;

                    if( mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,    (u8*)&vcomTop, 1 ).IsFailure() )                SYS_PANIC( "Fail to access MCU" );
                    if( mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR, (u8*)&vcomBottom, 1 ).IsFailure() )             SYS_PANIC( "Fail to access MCU" );

                    vcomTop-=lcdMember.LcdFlicker;
                    if( vcomTop<0 ) vcomTop=0;

                    vcomBottom-=lcdMember.LcdFlicker;
                    if( vcomBottom<0 ) vcomBottom=0;

                    if( mcu.WriteBySend(MCU_VCOM_TOP_ADDR,      (u8*)&vcomTop, sizeof(u8) ).IsFailure() )       SYS_PANIC( "Fail to access MCU" );
                    if( mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,   (u8*)&vcomBottom, sizeof(u8) ).IsFailure() )    SYS_PANIC( "Fail to access MCU" );
                }
            }

        }
#endif
    }
    while( !isQuit );


    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);

    //pbhXV
    pad.UpdatePad();


    if( s_TextureIdTop != 0 ) gfx->m_DrawFramework->DeleteTexture(s_TextureIdTop );
    if( s_TextureIdBottom != 0 )gfx->m_DrawFramework->DeleteTexture(s_TextureIdBottom );
    s_TextureIdTop=0;
    s_TextureIdBottom=0;
    s_BmpBottom->Close();
    s_BmpTop->Close();
    delete s_BmpBottom;
    delete s_BmpTop;
    gfx->ReInitRenderSystem();
}

/************************************************************************
 eXgp^[\
 ***********************************************************************/
bool TestLcd::ShowTestPattern( TestResult &result )
{
    TestResult dummy;
    
    ShowTestPattern_Body( dummy );
    TestBackLight( dummy );
    
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    gfx->ReInitRenderSystem();
    
    result.m_Result = true;
    return result.m_Result;

}
/************************************************************************
 eXgp^[\
 ***********************************************************************/
bool TestLcd::ShowTestPattern_Body( TestResult &result )
{
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    typedef void (*FunctionPointer)( uji::sys::GraphicsDrawing *gfx );

    const FunctionPointer list3d[]=
    {
        DrawFlicker,
        FillWhite,
        FillBlack,
        FillRed,
        FillGreen,
        FillBlue,
        DrawOutLine,
        DrawVerticalGradation,
        DrawHorizontalGradation,
        DrawParallaxBarrier,
        DrawParallaxBarrierDust1,
        DrawParallaxBarrierDust2,

    };

    const FunctionPointer list2d[]=
    {
        DrawFlicker,
        FillWhite,
        FillBlack,
        FillRed,
        FillGreen,
        FillBlue,
        DrawOutLine,
        DrawVerticalGradation,
        DrawHorizontalGradation,
    };

    int listSize;
    const FunctionPointer *currentList;

    //vbgtH[ɉăXgύX
    if( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        currentList = list2d;
        listSize = ARRAY_LENGTH(list2d);
    }
    else
    {
        currentList = list3d;
        listSize = ARRAY_LENGTH(list3d);
    }

    nn::Result result_check;
    nn::drivers::cal::CTR::Calibration calibration;
    nn::drivers::cal::CTR::LcdFlickerInfo lcdFlickerInfo;
    calibration.Initialize();

    //eNX`ݒ
    s_BmpTop = new BmpTexture();
    s_BmpBottom = new BmpTexture();
    
    if( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType() ||
        uji::sys::PLATFORM_KTR == uji::sys::GetPlatformType() ||
        uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        s_BmpTop->Open( L"rom:/bmp/Upper_SPFL_flicker.bmp" );
        s_BmpBottom->Open( L"rom:/bmp/Lower_SPFL_flicker.bmp" );
    }
    else
    {
        s_BmpTop->Open( L"rom:/bmp/ctr_upper_flicker.bmp" );
        s_BmpBottom->Open( L"rom:/bmp/ctr_lower_flicker.bmp" );
    }

    if( s_TextureIdTop != 0 )   gfx->m_DrawFramework->DeleteTexture(s_TextureIdTop );
    if( s_TextureIdBottom != 0 )gfx->m_DrawFramework->DeleteTexture(s_TextureIdBottom );

    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            s_BmpTop->INTERNAL_FORMAT,
                                            s_BmpTop->GetTextureWidth(),
                                            s_BmpTop->GetTextureHeight(),
                                            s_BmpTop->FORMAT,
                                            s_BmpTop->TYPE,
                                            s_BmpTop->GetTextureDataPointer(),
                                            s_TextureIdTop );

    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            s_BmpBottom->INTERNAL_FORMAT,
                                            s_BmpBottom->GetTextureWidth(),
                                            s_BmpBottom->GetTextureHeight(),
                                            s_BmpBottom->FORMAT,
                                            s_BmpBottom->TYPE,
                                            s_BmpBottom->GetTextureDataPointer(),
                                            s_TextureIdBottom );



    int pattern=0;
    uji::seq::TestResult dummy_result;

    // RtBOp
    Config::Member lcdMember;
    Config lcdConfig;
    lcdMember = lcdConfig.Get();

    // MCU֘A
    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw



    // m点vF_
    uji::eva::mcu::NotifyLedBlueOn(dummy_result);

    // obNCgPxő
    uji::eva::backlight::SetMaxBrightness(dummy_result);

    // ANeBuobNCg@\OFF
    uji::eva::backlight::SetActiveBackLightOff(dummy_result);

    s16 vcomTop;
    s16 vcomBottom;

    //ubnllb`k擾A}CRɐݒ
    if( !calibration.Get(&lcdFlickerInfo, nn::drivers::cal::CTR::CAL_DATA_LCD_FLICKER) )    SYS_PANIC( "CAL FAIL" );
    vcomTop    = (s16)lcdFlickerInfo.vcomTop;
    vcomBottom = (s16)lcdFlickerInfo.vcomBottom;
    if( mcu.WriteBySend(MCU_VCOM_TOP_ADDR,      (u8*)&vcomTop, sizeof(u8) ).IsFailure() )       SYS_PANIC( "Fail to access MCU" );
    if( mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,   (u8*)&vcomBottom, sizeof(u8) ).IsFailure() )    SYS_PANIC( "Fail to access MCU" );


    int indicateCounter = 0;

    int waitTime = lcdMember.LcdTimeWait;
    GLenum selectedDisplay = NN_GX_DISPLAY0;

    bool canForward;
    if( lcdConfig.Get().TestMode==uji::seq::pl::LINE )
    {
        canForward = false;
    }else{
        canForward = true;
    }

    do
    {
        //pbhXV
        pad.UpdatePad();
        if( waitTime>0 ) waitTime--;

        if( pad.IsButtonRepeat( Pad::BUTTON_A ) && canForward && waitTime==0 )
        {
            pattern++;
            waitTime = lcdMember.LcdTimeWait;
        }
        else if( pad.IsButtonRepeat( Pad::BUTTON_B ) )
        {
            pattern--;
            if( pattern<0 ) pattern=0;
            waitTime = lcdMember.LcdTimeWait;
        }else{

            //Ώۂ̃p^[쐬
            if( pattern==0 && indicateCounter>0 )
            {
                DrawFlickerWithVcom( gfx, vcomTop, vcomBottom );
                indicateCounter--;
            }else{
                (*currentList[pattern])(gfx);
            }
        }

        // tbJ[p
        if( pattern==0 && lcdConfig.Get().TestMode==uji::seq::pl::LINE )
        {
            // X{^
            if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_X))
            {
                indicateCounter = INDICATE_TERM;

                if( selectedDisplay == NN_GX_DISPLAY0 ){
                    if( mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,    (u8*)&vcomTop, 1 ).IsFailure() )                SYS_PANIC( "Fail to access MCU" );
                    vcomTop+=lcdMember.LcdFlicker;
                    if( vcomTop>0xff ) vcomTop=0xff;
                    if( mcu.WriteBySend(MCU_VCOM_TOP_ADDR,      (u8*)&vcomTop, sizeof(u8) ).IsFailure() )       SYS_PANIC( "Fail to access MCU" );
                }else{
                    if( mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR, (u8*)&vcomBottom, 1 ).IsFailure() )             SYS_PANIC( "Fail to access MCU" );
                    vcomBottom+=lcdMember.LcdFlicker;
                    if( vcomBottom>0xff ) vcomBottom=0xff;
                    if( mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,   (u8*)&vcomBottom, sizeof(u8) ).IsFailure() )    SYS_PANIC( "Fail to access MCU" );
                }

            }

            // Y{^
            if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_Y))
            {
                indicateCounter = INDICATE_TERM;

                if( selectedDisplay == NN_GX_DISPLAY0 ){
                    if( mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,    (u8*)&vcomTop, 1 ).IsFailure() )                SYS_PANIC( "Fail to access MCU" );
                    vcomTop-=lcdMember.LcdFlicker;
                    if( vcomTop<0 ) vcomTop=0;
                    if( mcu.WriteBySend(MCU_VCOM_TOP_ADDR,      (u8*)&vcomTop, sizeof(u8) ).IsFailure() )       SYS_PANIC( "Fail to access MCU" );
                }else{
                    if( mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR, (u8*)&vcomBottom, 1 ).IsFailure() )             SYS_PANIC( "Fail to access MCU" );
                    vcomBottom-=lcdMember.LcdFlicker;
                    if( vcomBottom<0 ) vcomBottom=0;
                    if( mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,   (u8*)&vcomBottom, sizeof(u8) ).IsFailure() )    SYS_PANIC( "Fail to access MCU" );
                }
            }


            // {^ {
            if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_UP))
            {
                canForward      = true;
                indicateCounter = INDICATE_TERM;
                selectedDisplay = NN_GX_DISPLAY0;
                uji::eva::mcu::NotifyLedBlueOn(dummy_result);
            }

            // {^ |
            if (sys::Pad().IsButtonRepeatFast(sys::Pad::BUTTON_DOWN))
            {
                canForward      = true;
                indicateCounter = INDICATE_TERM;
                selectedDisplay = NN_GX_DISPLAY1;
                uji::eva::mcu::NotifyLedBlueOff(dummy_result);
            }
        }

    }while( pattern<listSize );

    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);

    //Cݒ莞̓tbJlb`kɕۑ
    if( lcdConfig.Get().TestMode == uji::seq::pl::LINE )
    {
        if( !calibration.Get(&lcdFlickerInfo, nn::drivers::cal::CTR::CAL_DATA_LCD_FLICKER) )    SYS_PANIC( "CAL FAIL" );

        result_check = mcu.ReadByReceive(MCU_VCOM_TOP_ADDR,  &lcdFlickerInfo.vcomTop, sizeof(u8) );
        if( result_check.IsFailure() )                                                          SYS_PANIC( "Fail to read mcu register" );
        result_check = mcu.ReadByReceive(MCU_VCOM_BOTTOM_ADDR,  &lcdFlickerInfo.vcomBottom, sizeof(u8) );
        if( result_check.IsFailure() )                                                          SYS_PANIC( "Fail to read mcu register" );

        if( !calibration.Set(&lcdFlickerInfo, nn::drivers::cal::CTR::CAL_DATA_LCD_FLICKER) )    SYS_PANIC( "CAL FAIL" ) ;
        if( !calibration.Flush() )                                                              SYS_PANIC( "CAL FAIL" );
    }

    //pbhXV
    pad.UpdatePad();

    if( s_TextureIdTop != 0 ) gfx->m_DrawFramework->DeleteTexture(s_TextureIdTop );
    if( s_TextureIdBottom != 0 )gfx->m_DrawFramework->DeleteTexture(s_TextureIdBottom );
    s_TextureIdTop=0;
    s_TextureIdBottom=0;
    s_BmpBottom->Close();
    s_BmpTop->Close();
    delete s_BmpBottom;
    delete s_BmpTop;

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
 obNCg
 ***********************************************************************/
bool TestLcd::TestBackLight( TestResult &result )
{
    const int BACK_LIGHT_CONTROL_STEP = 5;
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    uji::seq::TestResult dummy_result;

    // MCU֘A
    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    //PF\
    FillWhite(gfx);
    FillWhite(gfx);


    // obNCgPxőEANeBuobNCg@\OFF
    uji::eva::backlight::SetMaxBrightness(dummy_result);
    uji::eva::backlight::SetActiveBackLightOff(dummy_result);


    for( int i=0 ; i<BACK_LIGHT_CONTROL_STEP ; i++ )
    {
        pad.WaitAnyKey();
        pad.WaitReleaseKey();

        //obNCg
        uji::eva::backlight::ChangeLightLevel();
    }

    pad.WaitAnyKey();
    pad.WaitReleaseKey();

    result.m_Result = true;
    return result.m_Result;
}


/************************************************************************
 kbcMp@PF\
 ***********************************************************************/
bool TestLcd::TestWhite( TestResult &result )
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    FillWhite( gfx );
    FillWhite( gfx );

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
 kbcMp@PF\
 ***********************************************************************/
bool TestLcd::TestBlack( TestResult &result )
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    FillBlack( gfx );
    FillBlack( gfx );

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
 kbcMp@ԒPF\
 ***********************************************************************/
bool TestLcd::TestRed( TestResult &result )
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    FillRed( gfx );
    FillRed( gfx );

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
 kbcMp@ΒPF\
 ***********************************************************************/
bool TestLcd::TestGreen( TestResult &result )
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    FillGreen( gfx );
    FillGreen( gfx );

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
 kbcMp@PF\
 ***********************************************************************/
bool TestLcd::TestBlue( TestResult &result )
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    FillBlue( gfx );
    FillBlue( gfx );

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
 kbcMJn
 ***********************************************************************/
bool TestLcd::TestBegin( TestResult &result )
{
    uji::seq::g_IsGfxUpdate = false;    //ȍ~AҎ󂯂ŕ\XV~

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
 kbcMI
 ***********************************************************************/
bool TestLcd::TestEnd( TestResult &result )
{
    uji::seq::g_IsGfxUpdate = true; //ȍ~AҎ󂯂ŕ\XVĊJ

    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);  //ʏ탂[hɖ߂

    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
 kbcMp@Rc\

 ۂɂ̓tbJʂ\܂B
 ***********************************************************************/
bool TestLcd::TestEnable3D( TestResult &result )
{
    uji::seq::Config config;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    DrawParallaxBarrier( gfx );
    DrawParallaxBarrier( gfx );

    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(config.Get().LcdBarrierSwitch));
    result.m_Result = true;
    return result.m_Result;
}

/************************************************************************
 kbcMp@Rcnee\

 ۂɂ͔PFʂ\܂B
 ***********************************************************************/
bool TestLcd::TestDisable3D( TestResult &result )
{
    uji::seq::Config config;

    TestLcd::TestWhite( result );
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(config.Get().LcdBarrierSwitch));

    return result.m_Result;
}

/************************************************************************
 rbg}bv\
 ***********************************************************************/
void TestLcd::ShowBmpFile( void )
{
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    bool isStereo = false;
    BmpTexture *bmpTop;
    BmpTexture *bmpBottom;
    BmpTexture *bmpAlt;
    GLuint textureIdTop;
    GLuint textureIdBottom;
    GLuint textureIdAlt;

    if( nn::fs::MountSdmc().IsFailure() ) SYS_PANIC( "FAIL TO MOUNT SDMC" );


    //eNX`ݒ
    bmpTop = new BmpTexture();
    if( !bmpTop->Open( L"sdmc:/uji/lcd/top.bmp" ) ) SYS_PANIC( "FAIL TO OPEN top.bmp" );
    bmpBottom = new BmpTexture();
    if( !bmpBottom->Open( L"sdmc:/uji/lcd/bottom.bmp" ) ) SYS_PANIC( "FAIL TO OPEN bottom.bmp" );
    bmpAlt = new BmpTexture();
    if( bmpAlt->Open( L"sdmc:/uji/lcd/alt.bmp" ) )
    {
        isStereo = true;
    }


    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            bmpTop->INTERNAL_FORMAT,
                                            bmpTop->GetTextureWidth(),
                                            bmpTop->GetTextureHeight(),
                                            bmpTop->FORMAT,
                                            bmpTop->TYPE,
                                            bmpTop->GetTextureDataPointer(),
                                            textureIdTop );

    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            bmpBottom->INTERNAL_FORMAT,
                                            bmpBottom->GetTextureWidth(),
                                            bmpBottom->GetTextureHeight(),
                                            bmpBottom->FORMAT,
                                            bmpBottom->TYPE,
                                            bmpBottom->GetTextureDataPointer(),
                                            textureIdBottom );

    if( isStereo )
    {
        gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                                bmpAlt->INTERNAL_FORMAT,
                                                bmpAlt->GetTextureWidth(),
                                                bmpAlt->GetTextureHeight(),
                                                bmpAlt->FORMAT,
                                                bmpAlt->TYPE,
                                                bmpAlt->GetTextureDataPointer(),
                                                textureIdAlt );
    }

    do
    {
        if( isStereo )
        {
            gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_STEREO);
            gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
            gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
            gfx->m_DrawFramework->FillTexturedRectangle(textureIdTop,
                0.0f, 0.0f, 400.0f, 240.0f,
                bmpTop->GetBmpWidth(), bmpTop->GetBmpHeight(),
                bmpTop->GetTextureWidth(), bmpTop->GetTextureHeight() );
            gfx->m_DrawFramework->Transfer();

            gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0_EXT );
            gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
            gfx->m_DrawFramework->FillTexturedRectangle(textureIdAlt,
                0.0f, 0.0f, 400.0f, 240.0f,
                bmpAlt->GetBmpWidth(), bmpAlt->GetBmpHeight(),
                bmpAlt->GetTextureWidth(), bmpAlt->GetTextureHeight() );
            gfx->m_DrawFramework->Transfer();
            gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();

            gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
            gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
            gfx->m_DrawFramework->FillTexturedRectangle(textureIdBottom,
                0.0f, 0.0f, 320.0f, 240.0f,
                bmpBottom->GetBmpWidth(), bmpBottom->GetBmpHeight(),
                bmpBottom->GetTextureWidth(), bmpBottom->GetTextureHeight() );
            gfx->m_DrawFramework->Transfer();
            gfx->m_DrawFramework->SwapBuffers_ParallaxBarrier();

        }else{
            gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);

            gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
            gfx->SetScreenSize( GraphicsDrawing::DISPLAY0_WIDTH, GraphicsDrawing::DISPLAY0_HEIGHT );
            gfx->m_DrawFramework->FillTexturedRectangle(textureIdTop,
                0.0f, 0.0f, 400.0f, 240.0f,
                bmpTop->GetBmpWidth(), bmpTop->GetBmpHeight(),
                bmpTop->GetTextureWidth(), bmpTop->GetTextureHeight() );

            gfx->m_DrawFramework->SwapBuffers();

            gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
            gfx->SetScreenSize( GraphicsDrawing::DISPLAY1_WIDTH, GraphicsDrawing::DISPLAY1_HEIGHT );
            gfx->m_DrawFramework->FillTexturedRectangle(textureIdBottom,
                0.0f, 0.0f, 320.0f, 240.0f,
                bmpBottom->GetBmpWidth(), bmpBottom->GetBmpHeight(),
                bmpBottom->GetTextureWidth(), bmpBottom->GetTextureHeight() );
            gfx->m_DrawFramework->SwapBuffers();
        }


        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);

        pad.UpdatePad();
    }
    while( !pad.IsButtonRepeat(Pad::BUTTON_B) );


    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);
    gfx->m_DrawFramework->DeleteTexture( textureIdTop );
    gfx->m_DrawFramework->DeleteTexture( textureIdBottom );

    if( isStereo ) bmpAlt->Close();
    bmpBottom->Close();
    bmpTop->Close();
    delete bmpAlt;
    delete bmpBottom;
    delete bmpTop;

    nn::fs::Unmount("sdmc:");

    return;
}

/************************************************************************
tbJp^[\
 ***********************************************************************/
bool TestLcd::ShowFlickerPattern( TestResult &result )
{
    uji::sys::Pad pad;
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    typedef void (*FunctionPointer)( uji::sys::GraphicsDrawing *gfx );

    const FunctionPointer list[]=
    {
        DrawFlicker,
    };


    nn::Result result_check;
    nn::drivers::cal::CTR::Calibration calibration;
    nn::drivers::cal::CTR::LcdFlickerInfo lcdFlickerInfo;
    calibration.Initialize();
    
    

    //eNX`ݒ
    s_BmpTop = new BmpTexture();
    s_BmpBottom = new BmpTexture();
    
    if( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType() ||
        uji::sys::PLATFORM_KTR == uji::sys::GetPlatformType() ||
        uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
    {
        s_BmpTop->Open( L"rom:/bmp/Upper_SPFL_flicker.bmp" );
        s_BmpBottom->Open( L"rom:/bmp/Lower_SPFL_flicker.bmp" );
    }
    else
    {
        s_BmpTop->Open( L"rom:/bmp/ctr_upper_flicker.bmp" );
        s_BmpBottom->Open( L"rom:/bmp/ctr_lower_flicker.bmp" );
    }

    if( s_TextureIdTop != 0 )   gfx->m_DrawFramework->DeleteTexture( s_TextureIdTop );
    if( s_TextureIdBottom != 0 )gfx->m_DrawFramework->DeleteTexture( s_TextureIdBottom );

    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            s_BmpTop->INTERNAL_FORMAT,
                                            s_BmpTop->GetTextureWidth(),
                                            s_BmpTop->GetTextureHeight(),
                                            s_BmpTop->FORMAT,
                                            s_BmpTop->TYPE,
                                            s_BmpTop->GetTextureDataPointer(),
                                            s_TextureIdTop );

    gfx->m_DrawFramework->GenerateTexture(  GL_TEXTURE_2D,
                                            s_BmpBottom->INTERNAL_FORMAT,
                                            s_BmpBottom->GetTextureWidth(),
                                            s_BmpBottom->GetTextureHeight(),
                                            s_BmpBottom->FORMAT,
                                            s_BmpBottom->TYPE,
                                            s_BmpBottom->GetTextureDataPointer(),
                                            s_TextureIdBottom );


    uji::seq::TestResult dummy_result;

    // MCU֘A
    McuInitializer().HwCheckInit();

    // MCU vZXɃNGXg𑗂邽߂ Camera NX\zB̃NX͎
    nn::mcu::CTR::HwCheck mcu(
        McuInitializer().GetHSession()      // mꂽZbṼnh
    );                                      // RXgN^Ɏw

    // obNCgPxő
    uji::eva::backlight::SetMaxBrightness(dummy_result);

    // ANeBuobNCg@\OFF
    uji::eva::backlight::SetActiveBackLightOff(dummy_result);

    s16 vcomTop;
    s16 vcomBottom;

    //ubnllb`k擾A}CRɐݒ
    if( !calibration.Get(&lcdFlickerInfo, nn::drivers::cal::CTR::CAL_DATA_LCD_FLICKER) )    SYS_PANIC( "CAL FAIL" );
    vcomTop    = (s16)lcdFlickerInfo.vcomTop;
    vcomBottom = (s16)lcdFlickerInfo.vcomBottom;
    if( mcu.WriteBySend(MCU_VCOM_TOP_ADDR,      (u8*)&vcomTop, sizeof(u8) ).IsFailure() )       SYS_PANIC( "Fail to access MCU" );
    if( mcu.WriteBySend(MCU_VCOM_BOTTOM_ADDR,   (u8*)&vcomBottom, sizeof(u8) ).IsFailure() )    SYS_PANIC( "Fail to access MCU" );

    //tbJʕ\i_uobt@Ă̂łQ\AQ񂵂ȂƉʃ[h؂ւȂj
    DrawFlicker(gfx);
    DrawFlicker(gfx);
    
    uji::seq::Config config;
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(config.Get().LcdBarrierSwitch));
    
    do
    {
        //pbhXV
        pad.UpdatePad();
    }while( !pad.IsButtonRepeat( Pad::BUTTON_A ) );

    gfx->m_DrawFramework->SetLcdModeUji(NN_GX_DISPLAYMODE_NORMAL);


    //pbhXV
    pad.UpdatePad();

    if( s_TextureIdTop != 0 ) gfx->m_DrawFramework->DeleteTexture(s_TextureIdTop );
    if( s_TextureIdBottom != 0 )gfx->m_DrawFramework->DeleteTexture(s_TextureIdBottom );
    s_TextureIdTop=0;
    s_TextureIdBottom=0;
    s_BmpBottom->Close();
    s_BmpTop->Close();
    delete s_BmpBottom;
    delete s_BmpTop;

    result.m_Result = true;
    return result.m_Result;
}


