/*--------------------------------------------------------------------------*
 Project:
 File: TestKey.h
 

*--------------------------------------------------------------------------*/

#ifndef TESTKEY_H_INCLUDED
#define TESTKEY_H_INCLUDED


#include <nw/lyt.h>
#include <nw/ut/ut_MoveArray.h>
#include "sys.h"
#include "../seq/TestResult.h"    

namespace uji {
namespace eva {


// L[̕]j[
extern void OpenKeyMenu(void);
extern void KeyMenuForService(void);
// fW^L[̃eXg
extern bool TestDigitalKey(seq::TestResult &result);
extern bool TestDigitalKey_NEC(seq::TestResult &result);
extern bool TestDigitalKey_Push_Up(seq::TestResult &result);
extern bool TestDigitalKey_Push_Left_Up(seq::TestResult &result);
extern bool TestDigitalKey_Push_Left(seq::TestResult &result);
extern bool TestDigitalKey_Push_Left_Down(seq::TestResult &result);
extern bool TestDigitalKey_Push_Down(seq::TestResult &result);
extern bool TestDigitalKey_Push_Down_Right(seq::TestResult &result);
extern bool TestDigitalKey_Push_Right(seq::TestResult &result);
extern bool TestDigitalKey_Push_Right_Up(seq::TestResult &result);
extern bool TestDigitalKey_Push_Select(seq::TestResult &result);
extern bool TestDigitalKey_Push_Start(seq::TestResult &result);
extern bool TestDigitalKey_Push_X(seq::TestResult &result);
extern bool TestDigitalKey_Push_Y(seq::TestResult &result);
extern bool TestDigitalKey_Push_B(seq::TestResult &result);
extern bool TestDigitalKey_Push_A(seq::TestResult &result);
extern bool TestDigitalKey_Push_R(seq::TestResult &result);
extern bool TestDigitalKey_Push_L(seq::TestResult &result);
extern bool TestDigitalKey_Release_Up(seq::TestResult &result);
extern bool TestDigitalKey_Release_Left_up(seq::TestResult &result);
extern bool TestDigitalKey_Release_Left(seq::TestResult &result);
extern bool TestDigitalKey_Release_Left_Down(seq::TestResult &result);
extern bool TestDigitalKey_Release_Down(seq::TestResult &result);
extern bool TestDigitalKey_Release_Down_Right(seq::TestResult &result);
extern bool TestDigitalKey_Release_Right(seq::TestResult &result);
extern bool TestDigitalKey_Release_Right_Up(seq::TestResult &result);
extern bool TestDigitalKey_Release_Select(seq::TestResult &result);
extern bool TestDigitalKey_Release_Start(seq::TestResult &result);
extern bool TestDigitalKey_Release_X(seq::TestResult &result);
extern bool TestDigitalKey_Release_Y(seq::TestResult &result);
extern bool TestDigitalKey_Release_B(seq::TestResult &result);
extern bool TestDigitalKey_Release_A(seq::TestResult &result);
extern bool TestDigitalKey_Release_R(seq::TestResult &result);
extern bool TestDigitalKey_Release_L(seq::TestResult &result);

namespace key {
    // [gL[
    extern bool TestRemoteKey(seq::TestResult &result);
}

/*
    ẼvO̓L[͂eXgvOłB
    EL[̉摜A`12ނAɉʂɕ\ĂB
    EL[̉摜͓̓L[ƂP΂PőΉĂāAL[̗͂Lɂĉ摜ω
    EL[͉͂ʂɎwꂽԂǂɍsȂ΂ȂȂB
    E͂̊mF́A[XE͂̏ԂōsB
    EL[̏ԁiAj[Vj́AʏA͂AtH[JX3ޑ݂A
      12ނ̃L[őSēB
*/

const int MAX_BUTTON_NUM = 13;
const bit32 PROHIBITED_UD_MASK = nn::hid::CTR::BUTTON_UP | nn::hid::CTR::BUTTON_DOWN;
const bit32 PROHIBITED_LR_MASK = nn::hid::CTR::BUTTON_LEFT | nn::hid::CTR::BUTTON_RIGHT;    

// {^Aj[Vԍ
typedef enum {
    KEY_ANIM_RELEASE,   // ͖
    KEY_ANIM_INPUT,     // ͒
    KEY_ANIM_FOCUS      // tH[JXĂ
} KeyAnimation;


/*---------------------------------------------------------------------------
    {^NX
---------------------------------------------------------------------------*/
class Button
{
public:
    // RXgN^EfXgN^
    Button(char* paneName, bit32 bitButton)
    : m_PaneName(paneName), m_BitButton(bitButton), m_KeyAnim(KEY_ANIM_RELEASE), m_TriggerCount(0)
    {}
    virtual ~Button(){}

    // yC̎擾
    char* GetPaneName() { return m_PaneName; }
    // {^`̎擾
    bit32 GetBitButton() { return m_BitButton; }
    
    // Aj[Vԍ̐ݒE擾
    void SetKeyAnimation(KeyAnimation key_anim)
    {
        m_KeyAnim = key_anim;
    }
    KeyAnimation GetKeyAnimation()
    {
        return m_KeyAnim;
    }
    
    // gKJEg̃CNgE擾ENA
    void IncrementTriggerCount() { ++m_TriggerCount; }
    int GetTriggerCount() { return m_TriggerCount; }
    void ClearTriggerCount() { m_TriggerCount = 0; }
    
private:
    char*           m_PaneName;     // yC
    bit32           m_BitButton;    // {^`
    KeyAnimation    m_KeyAnim;      // Aj[Vԍ
    
    int             m_TriggerCount;
};

// Œ蒷̔zNXƂă{^`
typedef nw::ut::FixedSizeArray<Button*, MAX_BUTTON_NUM> ButtonArray;



// {^eXgV[PXԍ
typedef enum {
    CHK_SEQ_RELEASE,    // [X҂
    CHK_SEQ_PUSH,       // ͑҂
    CHK_SEQ_PROHIBITED, // ֑͂mFꂽ
    CHK_SEQ_END
} INPUT_CHECK_SEQUENCE;

typedef enum {
    CHK_INPUT_RELEASE,       // S{^[X
    CHK_INPUT_PUSH_BUTTON,   // eXg{^
    CHK_INPUT_INCOMPLETE,    // eXg{^̈ꕔ
    CHK_INPUT_ERROR          // ֑͂mFꂽ
} INPUT_CHECK_BUTTON;

/*---------------------------------------------------------------------------
    L[eXgNX
---------------------------------------------------------------------------*/
class TestKey
{
public:    
    TestKey() 
     : m_TestButtonOrderArray(&memAllocator), m_pCurrentTestButton(0), 
       m_InputCheckSequence(CHK_SEQ_PUSH), m_focusAnimFrame(0)
    {}
    virtual ~TestKey(){}
    
    // L[eXgs
    bool ExecuteTest();

    // ]pL[̓eXg
    void ExecuteInputCheck();
    bool InputCheck_NEC(u32 button, INPUT_CHECK_SEQUENCE seq);
    
private:
    uji::sys::DemoAllocator             memAllocator;
    uji::sys::DemoDeviceMemoryAllocator devMemAllocator;
    
    nw::lyt::Layout*                m_pLayout;
    nw::lyt::ArcResourceAccessor*   m_pResAccessor;
    nw::lyt::AnimResource           m_AnimRes;
    nw::lyt::DrawInfo               m_DrawInfo; 
    nw::lyt::GraphicsResource       m_GraphicsResource;
    
    ButtonArray m_ButtonArray;

    // eXg{^̑gi[邽߂̔z
    nw::ut::MoveArray<bit32>            m_TestButtonOrderArray; 
    nw::ut::MoveArray<bit32>::iterator  m_pCurrentTestButton;   // Ce[^

    INPUT_CHECK_SEQUENCE m_InputCheckSequence;
    
    f32 m_focusAnimFrame;
        
    sys::WindowManager  m_WindowManager;
    sys::TextWindow*    m_PutTriggerCountWindow;
    
    typedef nw::ut::MoveArray<u8> File;

    File m_fileLayout;

private:
    nw::ut::MoveArray<u8> LoadFile(nw::os::IAllocator* allocator, const wchar_t* filePath, u32 align = 32);
        
    void InitializeButtonArray();
    void InitializeLayoutResource();
    void InitDraw(int width, int height);
    void InitializeCommon();
    void FinalizeCommon();

    // O[ṽyCXV
    void UpdatePane(nw::lyt::Group* pGroup, const nw::lyt::AnimResource& animRes);

    // L[͂yC̃Aj[Vݒ
    void SetKeyInputAnimation(bit32 hold);
    
    // yC̃Aj[Vԍ̎擾Eݒ
    KeyAnimation GetKeyAnimation(nw::lyt::Pane* pPane);
    void SetKeyAnimation(nw::lyt::Pane* pPane, KeyAnimation keyAnim);    
    
    // L[̓͏Ԃ`FbN
    INPUT_CHECK_SEQUENCE InputCheck(bit32 bitButton, bit32 bitTestButton);
    int InputCheck_Button(bit32 bitButtonHold, bit32 bitTestButton);

    // wyC̃Aj[VXV
    void UpdateAnimationFrame(nw::lyt::Pane* pPane, const nw::lyt::AnimResource& animRes);    

    // ̓gKJEg̕\
    void PutInputCount(bit32 trigger);
    void PutInputCount_HOME();
    void PutInputCount_SEL(bit32 trigger);
    void PutInputCount_Sub(bit32 trigger);
};


}
}

#endif  // TESTKEY_H_INCLUDED
