/************************************************************************

 ԊOvO
 
 *************************************************************************/
 
#ifndef TEST_IR_H_INCLUDED
#define TEST_IR_H_INCLUDED

#include <nn.h>
#include <nn/ir/CTR/ir_API.h>
#include <nn/ir/CTR/ir_Types.h>
#include "sys.h"
#include "../seq/TestResult.h"

namespace uji{
namespace eva{

namespace ir
{
    extern bool TestIrAccess( uji::seq::TestResult &result );
    extern bool TestIrCommunication( uji::seq::TestResult &result );
    extern bool TestIrTxRc( uji::seq::TestResult &result );
    extern bool TestIrRxdReceive( uji::seq::TestResult &result );
    extern bool TestIrPowerDown( uji::seq::TestResult &result );
    extern bool TestIrSend( uji::seq::TestResult &result );
    extern bool TestIrRecv( uji::seq::TestResult &result );
    extern bool TestIrCommunication_NEC_1( uji::seq::TestResult &result );
    extern bool TestIrCommunication_NEC_2( uji::seq::TestResult &result );
    extern bool TestIrCommunication_NEC_3( uji::seq::TestResult &result );
    extern bool TestIrRecv_NEC_1( uji::seq::TestResult &result );
    extern bool TestIrRecv_NEC_2( uji::seq::TestResult &result );
}


void OpenIrMenu();

class TestIr
{
    public:
    TestIr() : m_UpperWindow( 400/(FONT_SIZE/2), 180/FONT_SIZE, FONT_SIZE ), m_LowerWindow( 320/(FONT_SIZE/2), 240/FONT_SIZE, FONT_SIZE ),
               m_RecvEvent(false), m_isReceivingMode(false),
               gfx( uji::sys::GraphicsDrawing::GetInstance())
               
    {
        m_UpperWindow.SetTitle("Ir Test For Repair");
        uji::sys::Menu::m_WindowManager.CreateWindow( &m_UpperWindow, NN_GX_DISPLAY0, 0, 0 );
        uji::sys::Menu::m_WindowManager.CreateWindow( &m_LowerWindow, NN_GX_DISPLAY1, 0, 0 );
        
    }
    
    ~TestIr()
    {
        uji::sys::Menu::m_WindowManager.DestroyWindow( &m_UpperWindow );
        uji::sys::Menu::m_WindowManager.DestroyWindow( &m_LowerWindow );
    }

    
    static void StartIrTestMaster();
    static void StartIrTestSlave();
    static void StartIrEchoBack();
    
    
    private:
    static const int FONT_SIZE = 12;
    static const int SEND_SIZE = 32;
    
    
    void StartIrTest();
    bool TestIrForSC_Master( uji::seq::TestResult &result );
    bool TestIrForSC_Slave( uji::seq::TestResult &result );
    bool TestIrSendForSC( uji::seq::TestResult &result );
    bool TestIrRecvForSC( uji::seq::TestResult &result );
    bool TestRxdReceiveForSC( uji::seq::TestResult &result );
    

    void TestIrEchoBack();
    static void WrappingExecuteEchobackThread( void* param );
    void EchobackThread();
    
    void DrawDisplays( s32 display );
    
    uji::sys::TextWindow    m_UpperWindow;
    uji::sys::TextWindow    m_LowerWindow;
    nn::os::Event           m_RecvEvent;
    bool                    m_isReceivingMode;
    
    uji::sys::GraphicsDrawing* gfx;

};









} // namespace eva
} // namespace uji

#endif
