/************************************************************************

 ԊOvO
 
 *************************************************************************/
#include "TestIr.h"
#include "../wireless/CommandUtil.h"
#include "../seq/Reception_board_interface.h"
#include "sys_ShowMessage.h"


namespace uji{
namespace eva{
    
using namespace uji::sys;
using namespace uji::seq;
using namespace nn::ir::CTR::Low;

#pragma diag_suppress 546


namespace 
{
    const int RECV_BUFFER_SIZE = 4096;
    u8 s_RecvBuffer[ RECV_BUFFER_SIZE ] NN_ATTRIBUTE_ALIGN(4096);
    u8 baudRate = nn::ir::CTR::BAUD_RATE_115200;
    nn::os::Event m_recvEvent;
}

namespace ir
{

/*------------------------------------------------------------------------------
  Desc  : CTRIreXg
          
  Code  : 88-002
  Return: result
------------------------------------------------------------------------------*/
bool TestIrAccess( uji::seq::TestResult &result )
{
    nn::Result nnResult;
    
    nnResult = nn::ir::CTR::Low::Initialize();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "Initialize Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    nnResult = nn::ir::CTR::Low::SetAutoPowerControl( true );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "Auto PowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    
    nnResult = nn::ir::CTR::Low::SetBaudRate( nn::ir::CTR::BAUD_RATE_115200 );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "SetBaudRate Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    result.m_Result = true;
    return result.m_Result;
}

/*------------------------------------------------------------------------------
  Desc  : ʏdlIrMeXg
          
  Code  : 88-003
  Return: result
------------------------------------------------------------------------------*/
bool TestIrCommunication( uji::seq::TestResult &result )
{
    
    TestIrRecv( result );

    /* TWLւ̒ʒm */
    g_CommC2T->Send( (u16)result.m_Result, (u8*)( &result.m_String[0] ), std::strlen( result.m_String )+1 );
    
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(100));
    
    return TestIrSend( result );
    

}

/*------------------------------------------------------------------------------
  Desc  : ʏdlIrMeXgP
          
  Code  : 88-007
  Return: result
------------------------------------------------------------------------------*/
bool TestIrCommunication_NEC_1( uji::seq::TestResult &result )
{
    return TestIrRecv_NEC_1( result );
}

/*------------------------------------------------------------------------------
  Desc  : ʏdlIrMeXgQ
          
  Code  : 88-007
  Return: result
------------------------------------------------------------------------------*/
bool TestIrCommunication_NEC_2( uji::seq::TestResult &result )
{
    return TestIrRecv_NEC_2( result );
}

/*------------------------------------------------------------------------------
  Desc  : ʏdlIrMeXgR
          
  Code  : 88-009
  Return: result
------------------------------------------------------------------------------*/
bool TestIrCommunication_NEC_3( uji::seq::TestResult &result )
{
    return TestIrSend( result );
}

/*------------------------------------------------------------------------------
  Desc  : _TxMeXg
          
  Code  : 88-004
  Return: result
------------------------------------------------------------------------------*/

bool TestIrTxRc( uji::seq::TestResult &result )
{
    nn::Result nnResult;
    
    nnResult = nn::ir::CTR::Low::PowerOn();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    
    
    uji::eva::TimeCounter counter;
    
    do
    {
        nnResult = nn::ir::CTR::Low::SetLevel( 1 );
        if( nnResult.IsFailure())
        {
            std::sprintf( result.m_String, "SetLevel Error");
            result.m_Result = false;
            return result.m_Result;
        }
        
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromNanoSeconds( 4500 ));  // BaudRateɍ킹
        
        nnResult = nn::ir::CTR::Low::SetLevel( 0 );
        if( nnResult.IsFailure())
        {
            std::sprintf( result.m_String, "SetLevel Error");
            result.m_Result = false;
            return result.m_Result;
        }
        
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromNanoSeconds( 4500 )); // BaudRateɍ킹
        
        
        
    }while( counter.GetTimeSpan().GetMilliSeconds() < 100 );
    
    
    
    result.m_Result = true;
    return result.m_Result;
}
/*------------------------------------------------------------------------------
  Desc  : _RxMeXg
          
  Code  : 88-005
  Return: result
------------------------------------------------------------------------------*/
bool TestIrRxdReceive( uji::seq::TestResult &result )
{
    nn::Result nnResult;
    
    nnResult = nn::ir::CTR::Low::PowerOn();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    nn::ir::CTR::Low::Status nowStatus = nn::ir::CTR::Low::GetStatus();
    if( nowStatus != STATUS_READY )
    {
        std::sprintf( result.m_String, "Status Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    bit32 level       = 0;
    bit32 lastLevel   = 0;
    
    u16   changeCount = 0;
    
    uji::eva::TimeCounter counter;
    while( counter.GetTimeSpan().GetMilliSeconds() < 1000 )
    {
        nnResult = nn::ir::CTR::Low::GetLevel( &level );
        if( nnResult.IsFailure() )
        {
            std::sprintf( result.m_String, "GetLevel Error");
            result.m_Result = false;
            return result.m_Result;
        }
        
        if( level != lastLevel )
        {
            changeCount++;
        }
        
        lastLevel = level;
    }
    
    u8 writeDpramData[2] = "";
    
    
    if( changeCount >= 255 )
    {
        writeDpramData[0] = 255;
    }else
    {
        writeDpramData[0] = changeCount;
    }
    writeDpramData[1] = 0x00;
    
    g_CommC2T->WriteDpramBinary( writeDpramData, sizeof( u16 ));
    
    std::sprintf( result.m_String, "Count = %d", changeCount );
    
    if( changeCount > 10 )
    {
        result.m_Result = true;
        return result.m_Result;
    }else
    {
        result.m_Result = false;
        return result.m_Result;
    }

}

/*------------------------------------------------------------------------------
  Desc  : IrW[̃p[_EeXg
          
  Code  : 88-005
  Return: result
------------------------------------------------------------------------------*/

extern bool TestIrPowerDown( uji::seq::TestResult &result )
{
    nn::Result nnResult;
    NN_LOG("TestIrPowerDonw Start\n");
    
    
    #if 1
    nnResult = nn::ir::CTR::Low::SetAutoPowerControl( false );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "SetAutoPowerControl Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("now = %d\n", __LINE__ );
    
    nnResult = nn::ir::CTR::Low::PowerOff();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOff Error");
        result.m_Result = false;
        return result.m_Result;
    }
    NN_LOG("now = %d\n", __LINE__ );
    
    #else  // PowerOffNGmF
    nnResult = nn::ir::CTR::Low::SetAutoPowerControl( true );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "SetAutoPowerControl Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    nnResult = nn::ir::CTR::Low::PowerOn();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOff Error");
        result.m_Result = false;
        return result.m_Result;
    }
    #endif
    //nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(100));
    
    nn::os::Event recvEvent( true );
    
    nnResult = nn::ir::CTR::Low::GetFinishedReceivingEvent( &recvEvent );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "GetReceiveEvent Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("now = %d\n", __LINE__ );

    std::memset( s_RecvBuffer, 0x00, sizeof( s_RecvBuffer ));
    
    
    NN_LOG("now = %d\n", __LINE__ );
    nnResult = nn::ir::CTR::Low::StartReceive( s_RecvBuffer, sizeof( s_RecvBuffer ), sizeof( s_RecvBuffer ), false );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "StartReceive Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("now = %d\n", __LINE__ );
    
    size_t recvSize = 0;
    
    if( recvEvent.Wait( nn::fnd::TimeSpan::FromMilliSeconds(500)))
    {
        nn::ir::CTR::Low::EndReceive( &recvSize );
        std::sprintf( result.m_String, "ReceiveEvent Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("now = %d\n", __LINE__ );

    nnResult = nn::ir::CTR::Low::EndReceive( &recvSize );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "ReceiveEnd Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("now = %d\n", __LINE__ );
    
    if( recvSize != 0 )
    {
        NN_LOG("Recv Size = %d\n", recvSize );
        std::sprintf( result.m_String, "ReceiveSize Error");
        result.m_Result = false;
        return result.m_Result;
    }
    NN_LOG("Recv Data = ");
    for( int i = 0; i < 255; i++ )
    {
        //NN_LOG("%x", s_RecvBuffer[i] );
        if( s_RecvBuffer[i] != 0x00 )
        {
            std::sprintf( result.m_String, "ReceiveData Error");
            result.m_Result = false;
            return result.m_Result;
        }
    }
    NN_LOG("\n");
    
    result.m_Result = true;
    return result.m_Result;
}

/*------------------------------------------------------------------------------
  Desc  : TestIrCommunication̑M
          
  Code  : none
  Return: result
------------------------------------------------------------------------------*/
bool TestIrSend( uji::seq::TestResult &result )
{
    nn::Result nnResult;
    
    u8 sendData[ 32 ];
    
    for( int i = 0x00; i<= 0x1F; i++ )
    {
        sendData[i] = i + 0x20;
    }
    
    nnResult = nn::ir::CTR::Low::PowerOn();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    nn::os::Event sendEvent( true );
    
    nnResult = nn::ir::CTR::Low::GetFinishedSendingEvent( &sendEvent );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "GetSendEvent Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    nnResult = nn::ir::CTR::Low::Send( sendData, 32 );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "Send Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    sendEvent.Wait();  // ł̑҂Ԃ́H
    
    nn::ir::CTR::Low::ErrorStatus errorStatus = nn::ir::CTR::Low::GetErrorStatus();
    
    if( errorStatus != STATUS_NO_ERROR )
    {
        std::sprintf( result.m_String, "Send Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(50));
    
    nnResult = nn::ir::CTR::Low::PowerOff();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOff Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    
    result.m_Result = true;
    return result.m_Result;

}



/*------------------------------------------------------------------------------
  Desc  : TestIrCommunication̎M
          
  Code  : none
  Return: result
------------------------------------------------------------------------------*/
bool TestIrRecv( uji::seq::TestResult &result )
{
    nn::Result nnResult;
    
    nnResult = nn::ir::CTR::Low::SetAutoPowerControl( true );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "SetAutoPowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    nnResult = nn::ir::CTR::Low::PowerOn();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("Line = %d\n", __LINE__ );

    nn::os::Event recvEvent( true );
    
    nnResult = nn::ir::CTR::Low::GetFinishedReceivingEvent( &recvEvent );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "GetReceiveEvent Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    std::memset( s_RecvBuffer, 0x00, sizeof( s_RecvBuffer ) );
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    nnResult = nn::ir::CTR::Low::StartReceive( s_RecvBuffer, sizeof( s_RecvBuffer ), 32, false );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "StartReceive Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    if( !recvEvent.Wait( nn::fnd::TimeSpan::FromMilliSeconds(1000)))
    {
        std::sprintf( result.m_String, "ReceiveTimeOut Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    size_t receivedSize;
    nnResult = nn::ir::CTR::Low::EndReceive( &receivedSize );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "ReceiveEnd Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    if( receivedSize != 32 )
    {
        std::sprintf( result.m_String, "ReceiveSize Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    char DataStr[100] = "";
    char putStr[6] = "";
    bool isDataCompare = true;
    
    for( int i = 0x00; i <= 0x1F; i++ )
    {
        sprintf( putStr,"%02X:", s_RecvBuffer[i] );
        strcat( DataStr, putStr );
        if(( s_RecvBuffer[i] != i ) && ( s_RecvBuffer[i] != i + 0x80 ))
        {
            isDataCompare = false;
        }
    }
    if( isDataCompare == false )
    {
        std::sprintf( result.m_String, "ReceiveData Error\ndata = %s", DataStr );
        result.m_Result = false;
        return result.m_Result;
    }else
    {
        std::sprintf( result.m_String, "data = %s\n", DataStr );
    }
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(50));
    
    nnResult = nn::ir::CTR::Low::PowerOff();
    if( nnResult.IsFailure())
    {
        std::strcat( result.m_String, "PowerOff Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    result.m_Result = true;
    return result.m_Result;
}

/*------------------------------------------------------------------------------
  Desc  : TestIrCommunication̎M
          
  Code  : none
  Return: result
------------------------------------------------------------------------------*/
bool TestIrRecv_NEC_1( uji::seq::TestResult &result )
{
    nn::Result nnResult;
    
    nnResult = nn::ir::CTR::Low::SetAutoPowerControl( true );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "SetAutoPowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    nnResult = nn::ir::CTR::Low::PowerOn();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("Line = %d\n", __LINE__ );

//    nn::os::Event recvEvent( true );
    m_recvEvent.Initialize ( true );
    
//    nnResult = nn::ir::CTR::Low::GetFinishedReceivingEvent( &recvEvent );
    nnResult = nn::ir::CTR::Low::GetFinishedReceivingEvent( &m_recvEvent );

    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "GetReceiveEvent Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    std::memset( s_RecvBuffer, 0x00, sizeof( s_RecvBuffer ) );
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    nnResult = nn::ir::CTR::Low::StartReceive( s_RecvBuffer, sizeof( s_RecvBuffer ), 32, false );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "StartReceive Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    result.m_Result = true;
    return result.m_Result;
}

/*------------------------------------------------------------------------------
  Desc  : TestIrCommunication̎M
          
  Code  : none
  Return: result
------------------------------------------------------------------------------*/
bool TestIrRecv_NEC_2( uji::seq::TestResult &result )
{
    nn::Result nnResult;
    
    NN_LOG("Line = %d\n", __LINE__ );
    
//    if( !recvEvent.Wait( nn::fnd::TimeSpan::FromMilliSeconds(1000)))
    if( !m_recvEvent.Wait( nn::fnd::TimeSpan::FromMilliSeconds(1000)))
    {
        std::sprintf( result.m_String, "ReceiveTimeOut Error");
        m_recvEvent.Finalize();
        
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    size_t receivedSize;
    nnResult = nn::ir::CTR::Low::EndReceive( &receivedSize );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "ReceiveEnd Error");
        m_recvEvent.Finalize();
        
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    if( receivedSize != 32 )
    {
        std::sprintf( result.m_String, "ReceiveSize Error");
        m_recvEvent.Finalize();
        
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    for( int i = 0x00; i <= 0x1F; i++ )
    {
        if( s_RecvBuffer[i] != i )
        {
            std::sprintf( result.m_String, "ReceiveData Error");
            m_recvEvent.Finalize();
            
            result.m_Result = false;
            return result.m_Result;
        }
    }
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(50));
    
    nnResult = nn::ir::CTR::Low::PowerOff();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOff Error");
        m_recvEvent.Finalize();
        
        result.m_Result = false;
        return result.m_Result;
    }
    
    NN_LOG("Line = %d\n", __LINE__ );
    
    m_recvEvent.Finalize();
    
    result.m_Result = true;
    return result.m_Result;
}

} // namespace ir

void OpenIrMenu()
{
    
    uji::sys::ClassMenu *m = new uji::sys::ClassMenu( "Ir TestMenu" );
    m->Add(" StartIrTestMaster ", uji::eva::TestIr::StartIrTestMaster );
    m->Add(" StartIrTestSlave ", uji::eva::TestIr::StartIrTestSlave );
#ifndef EVA_REPAIR
    m->Add(" StartIrEchoBack ", uji::eva::TestIr::StartIrEchoBack );
#endif
    m->Open();
    Menu::m_SubWindow->Printf("\f");
    delete m;
}

void uji::eva::TestIr::StartIrTestMaster()
{
    TestIr* ir = new TestIr;
    uji::seq::TestResult result;
    
    ir->TestIrForSC_Master( result );
    
    nn::ir::CTR::Low::PowerOff();
    nn::ir::CTR::Low::Finalize();
    do
    {
        uji::sys::Pad().UpdatePad();
    }while( !uji::sys::Pad().IsButtonPress( uji::sys::Pad::BUTTON_B ));
    
    delete ir;
}

void uji::eva::TestIr::StartIrTestSlave()
{
    TestIr ir;
    uji::seq::TestResult result;
    ir.TestIrForSC_Slave( result );
    
    nn::ir::CTR::Low::PowerOff();
    nn::ir::CTR::Low::Finalize();
    do
    {
        uji::sys::Pad().UpdatePad();
    }while( !uji::sys::Pad().IsButtonPress( uji::sys::Pad::BUTTON_B ));

    // Todo {^͑҂

}

void uji::eva::TestIr::StartIrEchoBack()
{
    TestIr ir;
    ir.TestIrEchoBack();
}

void uji::eva::TestIr::TestIrEchoBack()
{
    char baudRateString[100] = "";
    bool isCreateThread = false;
    nn::os::Thread execRecvThread;
    
    while( true )
    {
        uji::sys::Pad().UpdatePad();
        if( false == m_isReceivingMode )
        {
            if( Pad().IsButtonDown( Pad::BUTTON_DOWN ))
            {
                if( baudRate == nn::ir::CTR::BAUD_RATE_115200 )
                {
                    baudRate = nn::ir::CTR::BAUD_RATE_3000;
                }else
                {
                    baudRate--;
                }
            }
            
            if( Pad().IsButtonDown( Pad::BUTTON_UP ))
            {
                if( baudRate == nn::ir::CTR::BAUD_RATE_3000 )
                {
                    baudRate = nn::ir::CTR::BAUD_RATE_115200;
                }else
                {
                    baudRate++;
                }
            }
            if( Pad().IsButtonDown( Pad::BUTTON_A ))
            {
                m_isReceivingMode = true;
            }
            if( Pad().IsButtonDown( Pad::BUTTON_B ))
            {
                break;
            }
            
            switch ( baudRate )
            {
                case nn::ir::CTR::BAUD_RATE_115200      : std::sprintf( baudRateString, "BAUD_RATE_115200 "); break;
                case nn::ir::CTR::BAUD_RATE_96000       : std::sprintf( baudRateString, "BAUD_RATE_96000  "); break;
                case nn::ir::CTR::BAUD_RATE_72000       : std::sprintf( baudRateString, "BAUD_RATE_72000  "); break;
                case nn::ir::CTR::BAUD_RATE_48000       : std::sprintf( baudRateString, "BAUD_RATE_48000  "); break;
                case nn::ir::CTR::BAUD_RATE_36000       : std::sprintf( baudRateString, "BAUD_RATE_36000  "); break;
                case nn::ir::CTR::BAUD_RATE_24000       : std::sprintf( baudRateString, "BAUD_RATE_24000  "); break;
                case nn::ir::CTR::BAUD_RATE_18000       : std::sprintf( baudRateString, "BAUD_RATE_18000  "); break;
                case nn::ir::CTR::BAUD_RATE_12000       : std::sprintf( baudRateString, "BAUD_RATE_12000  "); break;
                case nn::ir::CTR::BAUD_RATE_9600        : std::sprintf( baudRateString, "BAUD_RATE_9600   "); break;
                case nn::ir::CTR::BAUD_RATE_6000        : std::sprintf( baudRateString, "BAUD_RATE_6000   "); break;
                case nn::ir::CTR::BAUD_RATE_3000        : std::sprintf( baudRateString, "BAUD_RATE_3000   "); break;
            }
            m_UpperWindow.Printf("\f");
            m_UpperWindow.Printf("BaudRate = %s\n", baudRateString);
            m_UpperWindow.Printf("Press A to Start Echoback Mode\n");
            m_UpperWindow.Printf("Press B to Return\n");
            
        }else
        {
            m_UpperWindow.Printf("\f");
            m_UpperWindow.Printf("Start EchoMode!\n");
            m_UpperWindow.Printf("BaudRate = %s\n", baudRateString);
            m_UpperWindow.Printf("Press B to Return\n");
            
            if( !isCreateThread )
            {
                execRecvThread.StartUsingAutoStack( WrappingExecuteEchobackThread, this, 4096, nn::os::DEFAULT_THREAD_PRIORITY - 1 );
                isCreateThread = true;
            }
            
            if( Pad().IsButtonDown( Pad::BUTTON_B ))
            {
                m_isReceivingMode = false;
                m_RecvEvent.Signal();
                isCreateThread = false;
                execRecvThread.Join();
            }
            
        }
        DrawDisplays( NN_GX_DISPLAY_BOTH );
        
    }
    
    
}

//------------------------------------------------------------------------------
// o֐XbhƂċN邽߂̃bp[
//------------------------------------------------------------------------------
void uji::eva::TestIr::WrappingExecuteEchobackThread( void* param )
{
    TestIr* pTI = reinterpret_cast< TestIr* >( param );
    pTI->EchobackThread();
}

void uji::eva::TestIr::EchobackThread()
{
    nn::Result result;
    
    result = nn::ir::CTR::Low::Initialize();
    result = nn::ir::CTR::Low::SetAutoPowerControl( true );
    result = nn::ir::CTR::Low::SetBaudRate( static_cast<nn::ir::CTR::BaudRate>(baudRate) );
    result = nn::ir::CTR::Low::PowerOn();
    result = nn::ir::CTR::Low::GetFinishedReceivingEvent( &m_RecvEvent );
    NN_LOG("CreateThread\n");
    while( true )
    {
        memset( s_RecvBuffer, 0x00, sizeof(s_RecvBuffer) );
        NN_LOG("Receive Start\n");
        result = nn::ir::CTR::Low::StartReceive( s_RecvBuffer, sizeof( s_RecvBuffer ), 4096, true );
        NN_LOG("Wait Start\n");
        //m_RecvEvent.Wait();
        size_t receivedSize_t;
        while(true)
        {
            if( !m_isReceivingMode )
            {
                break;
            }
            nn::ir::CTR::Low::GetReceivedSize( &receivedSize_t );
            if( receivedSize_t < 10 )
            {
                nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10) );
            }else
            {
                break;
            }
        }
        NN_LOG("Receive Done\n");
        if( m_isReceivingMode )
        {
            size_t receivedSize;
            result = nn::ir::CTR::Low::EndReceive( &receivedSize );
            NN_LOG("recv = %s\n", s_RecvBuffer );
            m_LowerWindow.Printf("recv = %s\n", s_RecvBuffer );
            
            nn::os::Event sendEvent(false);
            result = nn::ir::CTR::Low::GetFinishedSendingEvent( &sendEvent );
            result = nn::ir::CTR::Low::Send( s_RecvBuffer, sizeof(&s_RecvBuffer) );
            sendEvent.Wait();  // ł̑҂Ԃ́H
            nn::ir::CTR::Low::ErrorStatus errorStatus = nn::ir::CTR::Low::GetErrorStatus();
            
        }else
        {
            result = nn::ir::CTR::Low::Finalize();
            break;
        }
        
    }
    
}



bool uji::eva::TestIr::TestIrForSC_Slave( uji::seq::TestResult &result )
{
    NN_UNUSED_VAR( result );
    
    m_UpperWindow.Printf("TestIrAccess   = ");
    DrawDisplays( NN_GX_DISPLAY0 );
    
    if( !uji::eva::ir::TestIrAccess( result ))
    {
        m_UpperWindow.Printf("NG %s\n", result.m_String );
        m_UpperWindow.Printf("Press B To Return\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        return result.m_Result;
    }
    
    m_UpperWindow.Printf("OK\n");
    m_UpperWindow.Printf("TestIrSend     = ");
    DrawDisplays( NN_GX_DISPLAY0 );
    
    if( !uji::eva::TestIr::TestIrSendForSC( result ))
    {
        m_UpperWindow.Printf("NG %s\n", result.m_String );
        m_UpperWindow.Printf("Press B To Return\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        return result.m_Result;
    }
    
    
    m_UpperWindow.Printf("OK\n");
    m_UpperWindow.Printf("TestIrRecv     = ");
    DrawDisplays( NN_GX_DISPLAY0 );
    
    if( !uji::eva::TestIr::TestIrRecvForSC( result ))
    {
        m_UpperWindow.Printf("NG %s\n", result.m_String );
        m_UpperWindow.Printf("Press B To Return\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        return result.m_Result;
    }
    
    m_UpperWindow.Printf("OK\n");
    m_UpperWindow.Printf("TestIrTxRc     = ");
    DrawDisplays( NN_GX_DISPLAY0 );
    
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
    
    if( !uji::eva::ir::TestIrTxRc( result ))
    {
        m_UpperWindow.Printf("NG %s\n", result.m_String );
        m_UpperWindow.Printf("Press B To Return\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        return result.m_Result;
    }
    
    m_UpperWindow.Printf("OK\n");
    m_UpperWindow.Printf("TestRxdReceive = ");
    DrawDisplays( NN_GX_DISPLAY0 );
    
    if( !uji::eva::TestIr::TestRxdReceiveForSC( result ))
    {
        m_UpperWindow.Printf("NG %s\n", result.m_String );
        m_UpperWindow.Printf("Press B To Return\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        return result.m_Result;
    }
    
    m_UpperWindow.Printf("OK\n");
    m_UpperWindow.Printf("TestIrTxRc     = ");
    DrawDisplays( NN_GX_DISPLAY0 );
    
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
    
    if( !uji::eva::ir::TestIrTxRc( result ))
    {
        m_UpperWindow.Printf("NG %s\n", result.m_String );
        m_UpperWindow.Printf("Press B To Return\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        return result.m_Result;
    }
    m_UpperWindow.Printf("OK\n\nTotal = OK\n");
    m_UpperWindow.Printf("Press B To Return\n");
    DrawDisplays( NN_GX_DISPLAY0 );
    return true;

}

bool uji::eva::TestIr::TestIrForSC_Master( uji::seq::TestResult& result )
{
    m_UpperWindow.Printf("TestIrAccess   = ");
    DrawDisplays( NN_GX_DISPLAY0 );
    
    if( !uji::eva::ir::TestIrAccess( result ))
    {
        m_UpperWindow.Printf("NG %s\n", result.m_String );
        m_UpperWindow.Printf("Press B To Return\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        return result.m_Result;
    }
    
    m_UpperWindow.Printf("OK\n");
    m_UpperWindow.Printf("TestIrRecv     = ");
    DrawDisplays( NN_GX_DISPLAY0 );
    
    if( !uji::eva::TestIr::TestIrRecvForSC( result ))
    {
        m_UpperWindow.Printf("NG %s\n", result.m_String );
        m_UpperWindow.Printf("Press B To Return\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        return result.m_Result;
    }
    
    m_UpperWindow.Printf("OK\n");
    m_UpperWindow.Printf("TestIrSend     = ");
    DrawDisplays( NN_GX_DISPLAY0 );
    
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
    
    if( !uji::eva::TestIr::TestIrSendForSC( result ))
    {
        m_UpperWindow.Printf("NG %s\n", result.m_String );
        m_UpperWindow.Printf("Press B To Return\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        return result.m_Result;
    }
    
    m_UpperWindow.Printf("OK\n");
    m_UpperWindow.Printf("TestRxdReceive = ");
    DrawDisplays( NN_GX_DISPLAY0 );
    
    if( !uji::eva::TestIr::TestRxdReceiveForSC( result ))
    {
        m_UpperWindow.Printf("NG %s\n", result.m_String );
        m_UpperWindow.Printf("Press B To Return\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        return result.m_Result;
    }
    
    m_UpperWindow.Printf("OK\n");
    m_UpperWindow.Printf("TestIrTxRc     = ");
    DrawDisplays( NN_GX_DISPLAY0 );
    
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
    
    if( !uji::eva::ir::TestIrTxRc( result ))
    {
        m_UpperWindow.Printf("NG %s\n", result.m_String );
        m_UpperWindow.Printf("Press B To Return\n");
        DrawDisplays( NN_GX_DISPLAY0 );
        return result.m_Result;
    }
    
    m_UpperWindow.Printf("OK\n\nTotal = OK\n");
    m_UpperWindow.Printf("Press B To Return\n");
    DrawDisplays( NN_GX_DISPLAY0 );
    return true;

}

bool uji::eva::TestIr::TestIrSendForSC( uji::seq::TestResult& result )
{
    nn::Result nnResult;
    
    u8 sendData[ 32 ];
    
    for( int i = 0x00; i<= 0x1F; i++ )
    {
        sendData[i] = i;
    }
    
    nnResult = nn::ir::CTR::Low::PowerOn();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    nn::os::Event sendEvent( true );
    
    nnResult = nn::ir::CTR::Low::GetFinishedSendingEvent( &sendEvent );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "GetSendEvent Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    nnResult = nn::ir::CTR::Low::Send( sendData, 32 );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "Send Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    sendEvent.Wait();  // ł̑҂Ԃ́H
    
    nn::ir::CTR::Low::ErrorStatus errorStatus = nn::ir::CTR::Low::GetErrorStatus();
    
    if( errorStatus != STATUS_NO_ERROR )
    {
        std::sprintf( result.m_String, "Send Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(50));
    
    nnResult = nn::ir::CTR::Low::PowerOff();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOff Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    
    result.m_Result = true;
    return result.m_Result;

}


bool uji::eva::TestIr::TestIrRecvForSC( uji::seq::TestResult &result )
{
    nn::Result nnResult;
    
    nnResult = nn::ir::CTR::Low::SetAutoPowerControl( true );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "SetAutoPowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    nnResult = nn::ir::CTR::Low::PowerOn();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }

    nn::os::Event recvEvent( true );
    
    nnResult = nn::ir::CTR::Low::GetFinishedReceivingEvent( &recvEvent );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "GetReceiveEvent Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    std::memset( s_RecvBuffer, 0x00, sizeof( s_RecvBuffer ) );
    
    nnResult = nn::ir::CTR::Low::StartReceive( s_RecvBuffer, sizeof( s_RecvBuffer ), 32, false );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "StartReceive Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    if( !recvEvent.Wait( nn::fnd::TimeSpan::FromMilliSeconds(10000)))
    {
        std::sprintf( result.m_String, "ReceiveTimeOut Error");
        size_t receivedSize;
        nn::ir::CTR::Low::EndReceive( &receivedSize );
        result.m_Result = false;
        return result.m_Result;
    }
    
    size_t receivedSize;
    nnResult = nn::ir::CTR::Low::EndReceive( &receivedSize );
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "ReceiveEnd Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    if( receivedSize != 32 )
    {
        std::sprintf( result.m_String, "ReceiveSize Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    for( int i = 0x00; i <= 0x1F; i++ )
    {
        if( s_RecvBuffer[i] != i )
        {
            char DataStr[100] = "";
            char putStr[6] = "";
            
            for( int j = 0x00; j <= 0x1F; j++ )
            {
                sprintf( putStr,"%02X:", s_RecvBuffer[j] );
                strcat( DataStr, putStr );
            }
            std::sprintf( result.m_String, "ReceiveData Error\ndata = %s", DataStr );
            result.m_Result = false;
            return result.m_Result;
        }
    }
    
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(50));
    
    nnResult = nn::ir::CTR::Low::PowerOff();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOff Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    result.m_Result = true;
    return result.m_Result;
}

bool uji::eva::TestIr::TestRxdReceiveForSC( uji::seq::TestResult& result )
{
    nn::Result nnResult;
    
    nnResult = nn::ir::CTR::Low::PowerOn();
    if( nnResult.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    nn::ir::CTR::Low::Status nowStatus = nn::ir::CTR::Low::GetStatus();
    if( nowStatus != STATUS_READY )
    {
        std::sprintf( result.m_String, "Status Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    bit32 level       = 0;
    bit32 lastLevel   = 0;
    
    nnResult = nn::ir::CTR::Low::GetLevel( &level );
    if( nnResult.IsFailure() )
    {
        std::sprintf( result.m_String, "GetLevel Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    lastLevel = level;
    
    uji::eva::TimeCounter counter;
    
    do{
        nnResult = nn::ir::CTR::Low::GetLevel( &level );
        if( nnResult.IsFailure() )
        {
            std::sprintf( result.m_String, "GetLevel Error");
            result.m_Result = false;
            return result.m_Result;
        }
        if( counter.GetTimeSpan().GetMilliSeconds() > 1000 )
        {
            std::sprintf( result.m_String, "TimeOut Error");
            result.m_Result = false;
            return result.m_Result;
        }
        
    }while( level == lastLevel );
    
    u16   changeCount = 0;
    
    counter.InitTime();
    
    while( counter.GetTimeSpan().GetMilliSeconds() < 100 )
    {
        nnResult = nn::ir::CTR::Low::GetLevel( &level );
        if( nnResult.IsFailure() )
        {
            std::sprintf( result.m_String, "GetLevel Error");
            result.m_Result = false;
            return result.m_Result;
        }
        
        if( level != lastLevel )
        {
            changeCount++;
        }
        
        lastLevel = level;
    }

    
    std::sprintf( result.m_String, "Count = %d", changeCount );
    
    if( changeCount > 5 )
    {
        result.m_Result = true;
        return result.m_Result;
    }else
    {
        result.m_Result = false;
        return result.m_Result;
    }

}

//------------------------------------------------------------------------------
// `fBXvCw肵āA`s
//------------------------------------------------------------------------------
void uji::eva::TestIr::DrawDisplays( s32 display )
{
    if( display == NN_GX_DISPLAY0 || display == NN_GX_DISPLAY_BOTH )
    {
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY0 );
        gfx->m_DrawFramework->Clear();
        uji::sys::Menu::m_WindowManager.Update();
        uji::sys::Menu::m_WindowManager.DrawDisplay0();
        gfx->m_DrawFramework->SwapBuffers();
    }
    
    if( display == NN_GX_DISPLAY1 || display == NN_GX_DISPLAY_BOTH )
    {
        gfx->m_DrawFramework->SetRenderTarget( NN_GX_DISPLAY1 );
        gfx->m_DrawFramework->Clear();
        uji::sys::Menu::m_WindowManager.Update();
        uji::sys::Menu::m_WindowManager.DrawDisplay1();
        gfx->m_DrawFramework->SwapBuffers();
        
    }
    gfx->m_DrawFramework->WaitVsync( NN_GX_DISPLAY_BOTH );
    
}


#pragma diag_default 546

} // namespace eva
} // namespace uji



