/*--------------------------------------------------------------------------*
 Project:
 File: TestImport_ErrorCode.h


*--------------------------------------------------------------------------*/
#ifndef TESTIMPORT_ERRORCODE_H_INCLUDED
#define TESTIMPORT_ERRORCODE_H_INCLUDED

namespace uji {
namespace eva {
namespace import {
    
    /*
        f[^ݑŜ̃G[R[h
    */
    typedef enum
    {
        PASS                                    =     0,
        
        // G[R[hl
        ERR_DEFAULT                             =   100,
        
        // InitializeSdmc() ł̃G[R[h
        ERR1_SDCARD_IS_NOT_WRITABLE             =  1000,
        ERR1_CHECK_CAPACITY                     =  1100,
        ERR1_DB_IS_NOT_AVAILABLE                =  1200,
        ERR1_GET_SDMC_SIZE                      =  1310,
        ERR1_INITIALIZE_DB_1                    =  1411,
        ERR1_INITIALIZE_DB_2                    =  1412,
        ERR1_INITIALIZE_DB_3                    =  1413,
        ERR1_QUERY_AVAILABLE_DB_1               =  1511,
        ERR1_QUERY_AVAILABLE_DB_2               =  1512,
        ERR1_QUERY_AVAILABLE_DB_3               =  1513,
        ERR1_MOUNT_SDMC_1                       =  1611,
        ERR1_MOUNT_SDMC_2                       =  1612,
        ERR1_MOUNT_SDMC_3                       =  1613,
        ERR1_MOUNT_SDMC_4                       =  1614,
        ERR1_MOUNT_SDMC_5                       =  1615,
        
        // WriteHomeMenuId() ł̃G[R[h
        ERR1_GET_REGION                         =  1901,
        ERR1_UNKNOWN_REGION                     =  1902,
        ERR1_SET_CONFIG                         =  1903,
        ERR1_FLUSH_CONFIG                       =  1904,
        ERR1_GET_CONFIG                         =  1905,
        
        // ImportCia() ł̃G[R[h
        ERR2_GET_PROGRAM_INFOS_FROM_CIA         =  2000,     // cia t@C ProgramInfos ̎擾Ɏs
        ERR2_UNKNOWN_APPLI                      =  2100,     // Av敪ŕނłȂsȃAv
        ERR2_GET_PROGRAM_INFOS                  =  2200,
        ERR2_GET_PROGRAM_INFOS_1                =  2201,     // nn::am::GetProgramInfos(): ResultInvalidEnumValue
        ERR2_GET_PROGRAM_INFOS_2                =  2202,     // nn::am::GetProgramInfos(): ResultMediaNotSupported
        ERR2_GET_PROGRAM_INFOS_3                =  2203,     // nn::am::GetProgramInfos(): ResultInvalidSize
        ERR2_GET_PROGRAM_INFOS_4                =  2204,     // nn::am::GetProgramInfos(): ResultInternalDataCorrupted
        ERR2_INTERNAL                           =  2300,
        ERR2_INTERNAL_DELETE_TICKET             =  2311,     // nn::am::DeleteTicket(): `Pbg̍폜Ɏs
        ERR2_INTERNAL_BEGIN_IMPORT_PROGRAM_1    =  2321,     // nn::am::BeginImportProgram(): sȃfBAw
        ERR2_INTERNAL_BEGIN_IMPORT_PROGRAM_2    =  2322,     // nn::am::BeginImportProgram(): T|[gÕfBAw
        ERR2_INTERNAL_BEGIN_IMPORT_PROGRAM_3    =  2323,     // nn::am::BeginImportProgram(): C|[gԂs
        ERR2_INTERNAL_BEGIN_IMPORT_PROGRAM_4    =  2324,     // nn::am::BeginImportProgram(): ɕʂ̃pCvJĂ
        ERR2_INTERNAL_BEGIN_IMPORT_PROGRAM_5    =  2325,     // nn::am::BeginImportProgram(): f[^j
        ERR2_INTERNAL_BEGIN_IMPORT_PROGRAM_6    =  2326,     // nn::am::BeginImportProgram(): Temporary ł^Cg
        ERR2_INTERNAL_TRY_WRITE                 =  2331,     // nn::fs::FileOutputStream(): TryWrite G[
        ERR2_INTERNAL_END_IMPORT_PROGRAM_1      =  2341,     // nn::am::EndImportProgram(): C|[gԂs
        ERR2_INTERNAL_END_IMPORT_PROGRAM_2      =  2342,     // nn::am::EndImportProgram(): w肳ꂽpCvs
        ERR2_INTERNAL_END_IMPORT_PROGRAM_3      =  2343,     // nn::am::EndImportProgram(): ݃t@C̐؂Ɏs
        ERR2_INTERNAL_END_IMPORT_PROGRAM_4      =  2344,     // nn::am::EndImportProgram(): ݂ɕKvȗ̈悪mۂłȂ
        ERR2_INTERNAL_END_IMPORT_PROGRAM_5      =  2345,     // nn::am::EndImportProgram(): f[^j
        ERR2_INTERNAL_END_IMPORT_PROGRAM_6      =  2346,     // nn::am::EndImportProgram(): sȃf[^󂯎
        ERR2_COMMIT_IMPORT_PROGRAMS             =  2400,     // cia t@C̏ݍŏIɎs
        ERR2_INTENDED_PREINSTALL                =  2500,     // vCXg[Ӑ}ꂽ̂łȂ
        
        // ImportExtSaveData() ł̃G[R[h
        ERR3_MOUNT_EXT_SAVE_DATA_1              =  3001,
        ERR3_MOUNT_EXT_SAVE_DATA_2              =  3002,
        ERR3_MOUNT_EXT_SAVE_DATA_3              =  3003,
        ERR3_MOUNT_EXT_SAVE_DATA_4              =  3004,
        ERR3_MOUNT_EXT_SAVE_DATA_5              =  3005,
        ERR3_MOUNT_EXT_SAVE_DATA_6              =  3006,
        ERR3_CREATE_EXT_SAVE_DATA_1             =  3101,
        ERR3_CREATE_EXT_SAVE_DATA_2             =  3102,
        ERR3_CREATE_EXT_SAVE_DATA_3             =  3103,
        ERR3_CREATE_EXT_SAVE_DATA_4             =  3104,
        ERR3_REMOUNT_EXT_SAVE_DATA              =  3200,
        ERR3_CREATE_EXT_SAVE_DATA               =  3300,
        ERR3_OPEN_EXT_SAVE_DATA                 =  3400,
        ERR3_WRITE_EXT_SAVE_DATA                =  3500,
        ERR3_UNMOUNT_EXT_SAVE_DATA              =  3600,
        
        // WriteTWLFontTable() ł̃G[R[h
        ERR4_MOUNT_TWLN_ARCHIVE                 =  4000,
        ERR4_OPEN_TWL_FONT_TABLE                =  4100,
        ERR4_SET_SIZE_TWL_FONT_TABLE            =  4200,
        ERR4_WRITE_TWL_FONT_TABLE               =  4300,
        ERR4_FLUSH_TWL_FONT_TABLE               =  4400,
        ERR4_COMPARE_HASH                       =  4500,
        ERR4_UNMOUNT_TWLN_ARCHIVE               =  4600,
        
        // DeleteNandApp() ł̃G[R[h
        ERR4_DELETE_PROGRAM_1                   =  4701,
        ERR4_DELETE_PROGRAM_2                   =  4702,
        ERR4_DELETE_TICKET                      =  4800,
        
        // WasProperlyImported() ł̃G[R[h
        ERR5_GARBAGE_IS_LEFT                    =  5000,
        ERR5_EXIST_ITC                          =  5100,
        ERR5_NEEDS_CLEANUP_1                    =  5201,
        ERR5_NEEDS_CLEANUP_2                    =  5202,
        ERR5_NEEDS_CLEANUP_3                    =  5203,
        ERR5_GET_NUM_ITC_1                      =  5301,
        ERR5_GET_NUM_ITC_2                      =  5302,
        ERR5_GET_NUM_ITC_3                      =  5303,
        
        // GetAppInfo() ł̃G[R[h
        ERR5_GET_NUM_PROGRAMS_1                 =  5501,
        ERR5_GET_NUM_PROGRAMS_2                 =  5502,
        ERR5_GET_NUM_PROGRAMS_3                 =  5503,
        ERR5_GET_PROGRAM_LIST_1                 =  5601,
        ERR5_GET_PROGRAM_LIST_2                 =  5602,
        ERR5_GET_PROGRAM_LIST_3                 =  5603,
        ERR5_GET_PROGRAM_LIST_4                 =  5604,
        ERR5_GET_PROGRAM_LIST_5                 =  5605,
        ERR5_GET_PROGRAM_INFOS_1                =  5701,
        ERR5_GET_PROGRAM_INFOS_2                =  5702,
        ERR5_GET_PROGRAM_INFOS_3                =  5703,
        ERR5_GET_PROGRAM_INFOS_4                =  5704,
        ERR5_GET_PROGRAM_INFOS_5                =  5705,
        
        // CompareProgramInfo() ł̃G[R[h
        ERR6_COMPARE_PROGRAM_INFOS_NUM          =  6000,
        ERR6_COMPARE_PROGRAM_INFOS_ID_AND_VER   =  6100,
        
        // CompareTicketDatabase() ł̃G[R[h
        ERR6_COMPARE_NUM_OF_TICKETS_AND_PROGRAMS=  6500,
        ERR6_COMPARE_ID_OF_TICKETS_AND_PROGRAMS =  6600,
        ERR6_GET_NUM_TICKETS_1                  =  6701,
        ERR6_GET_TICKET_LIST_1                  =  6801,
        ERR6_GET_TICKET_LIST_2                  =  6802,
        ERR6_GET_TICKET_LIST_3                  =  6803,
        
        // CompareTitleList() ł̃G[R[h
        ERR7_OPEN_TITLE_LIST                    =  7000,
        ERR7_GET_SIZE_TITLE_LIST                =  7100,
        ERR7_READ_TITLE_LIST                    =  7200,
        ERR7_COMPARE_TITLE_LIST                 =  7300,
        
        // ComparePreInstallTitleList() ł̃G[R[h
        ERR7_OPEN_PREINSTALL_TITLE_LIST         =  7500,
        ERR7_GET_SIZE_PREINSTALL_TITLE_LIST     =  7600,
        ERR7_READ_PREINSTALL_TITLE_LIST         =  7700,
        ERR7_COMPARE_PREINSTALL_TITLE_LIST      =  7800,
        
        // CompareDefaultTitleList() ł̃G[R[h
        ERR8_OPEN_DEFAULT_TITLE_LIST            =  8000,
        ERR8_GET_SIZE_DEFAULT_TITLE_LIST        =  8100,
        ERR8_READ_DEFAULT_TITLE_LIST            =  8200,
        ERR8_COMPARE_DEFAULT_TITLE_LIST         =  8300,
        
        // CheckRemainingBatteryLv() ł̃G[R[h
        ERR9_GET_REMAINING_BATTERY_LV           =  8500,
        ERR9_TIME_OUT                           =  8600,
        
        // Fatal Error
        ERR_FATAL                               =  9999
    }
    ErrSeq_DataImport;

} // namespace import
} // namespace eva
} // namespace uji

#endif  // TESTIMPORT_ERRORCODE_H_INCLUDED

