/*--------------------------------------------------------------------------*
 Project:
 File: TestImport.h


*--------------------------------------------------------------------------*/
#ifndef TESTIMPORT_H_INCLUDED
#define TESTIMPORT_H_INCLUDED

#include <nn/am/am_Api.h>
#include <nn/CTR/CTR_ProgramId.h>
#include "sys.h"
#include "sys_GetSerialNumber.h"
#include "sys_WriteSerialNumber.h"
#include "../aging/AgingImporter.h"
#include "../seq/TestResult.h"
#include <nn/fs/CTR/fs_ArchiveTypesForSystem.h>
#include <nn/fs/CTR/MPCore/fs_FileSystemBasePrivate.h>
#include <nn/applet/CTR/applet_APIPrivate.h>
#include <string>
#include <deque>
#include "TestImport_ErrorCode.h"
#include <nn/crypto/crypto_Sha1.h>

// CFG ̒lύX
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/cfg/CTR/detail/cfg_DataStructures.h>
#include <nn/cfg/CTR/detail/cfg_Keys.h>

using namespace uji;
using namespace uji::sys;
using namespace std;

namespace uji {
namespace eva {
namespace import {

    /*
        C|[g[W
    */
    typedef enum 
    {
        UNDEFINED   = -1,
        
        JPN         = 0,
        USA         = 1,
        EUR         = 2,
        AUS         = 3,
        KOR         = 4,
        CHN         = 5,
        TWN         = 6,
        UKV         = 7,
        
        RESION_NUM  = 8,
        
        JPN_ARM     = 10,
        USA_ARM     = 11,
        EUR_ARM     = 12,
        
        KMC         = 50,
        UPD         = 51
    }
    Import_Region;
    
    /*
        ݂̃[h
    */
    typedef enum
    {
        CHECK_WIRELESS  = 0,
        START_MENU      = 1,
        DELETE_PROGRAM  = 2,
        IMPORT_CIA      = 3,
        DELETE_NAND_APP = 4,
        COMMIT_IMPORT   = 5,
        COMPARE_PROGRAM_INFO = 6,
        COMPARE_TICKET_DB    = 7,
        COMPARE_TITLE_LIST   = 8,
        GET_APPINFO          = 9,
        WAS_PROPERLY_IMPORTED= 10,
        IMPORT_EXT_SAVEDATA  = 11,
        WRITE_TWL_FONT_TABLE = 12,
        WRITE_HOME_MENU_ID   = 13,
        CHECK_REMAINING_BATTERY_LV = 14,
        EXTRACT_AC_ADAPTER = 15,
        DELETE_PREINSTALL_TICKET = 16,
        
        IMPORT_MODE_NUM
    
    }
    Current_Import_Mode;
    
    /*
        Av^Cv
    */
    typedef enum
    {
        CTR_SYSTEM_APPLI = 0,   // CTR VXeAv
        CTR_USER_N_APPLI = 1,   // CTR [U[Avinand ɕۑj
        CTR_USER_S_APPLI = 2,   // CTR [U[Avisdmc ɕۑj
        TWL_SYSTEM_APPLI = 3,   // TWL VXeAv
        
        APPLI_TYPE_NUM   = 4
    }
    Appli_Type;

class TestImport
{
private:
    /*---------------------------------------------------------------------------
        萔
    ---------------------------------------------------------------------------*/
    static const int FONT_SIZE_L    = 14;
    static const int FONT_SIZE_S    = 12;
    static const u8  MAX_SSID_SIZE  = 32;
    static const int IMPORT_NUM     = 1000;

    // C|[gt@C
    struct ImporteeFileInfo
    {
        nn::fs::MediaType   mediaType;  // C|[g̃foCX
        const wchar_t*      filePath;   // C|[gt@CpX
    }; 

    // C|[gXbḧ
    struct ImportThreadArgs
    {
        TestImport*             ti;
        nn::os::BlockingQueue*  queue;
        
        ImporteeFileInfo        importFile;
    };
    
    // C|[gXbhubLOL[őMC|[gis
    struct ImportProgress
    {
        s64 fileSize;           // t@CTCY
        s32 read;               // [hTCY
        s32 readTotal;          // [hTCY̍v
        s64 msec;               // o߃~b
        nn::Result retBegin;    // nn::am::BeginImportProgram()̌
        nn::Result retWrite;    // nn::fs::FileOutputStream::TryWrite()̌
        nn::Result retEnd;      // nn::am::EndImportProgramWithoutCommit()̌
    };
    
    struct ImportInfo
    {
        uji::eva::ProgressBar*  pb;
        s64                     fileSize;
        s32                     importSize;
        s32                     percentage;
    };
    
    struct ImportMediaAppInfo
    {
        nn::fs::MediaType   media;                  // fBA
        s32                 num;                    // C|[gt@C
        nn::am::ProgramInfo infos[IMPORT_NUM];      // ProgramInfo ւ̃|C^
        nn::ProgramId       programs[IMPORT_NUM];   // vOXg
    };
    
public:

    char m_ssid[ MAX_SSID_SIZE ]; //APSSID

    static TestImport* GetInstance()
    {
        if (m_pInstance == 0)
        {
            m_pInstance = new TestImport;
        }
        return m_pInstance;
    }

    /*---------------------------------------------------------------------------
        o֐
    ---------------------------------------------------------------------------*/
    void ImportThread(ImporteeFileInfo* importeeFile, nn::os::BlockingQueue* pQueue);
    static void s_ImportThread(void* param);
    void CreateProgress(ImportInfo* info, int x, int y, int width, int height);
    void DestroyProgress(ImportInfo* info);
    void LogPrintf(sys::TextWindow *wnd, sys::ATTR_TEXT_COLOR color, const char* format, ...);
    void UpdateLCD(Current_Import_Mode mode);
    void UpdateLCD_Main(Current_Import_Mode mode);
    void UpdateLCD_Sub(Current_Import_Mode mode);
    void UpdateSubject_Main(Current_Import_Mode mode);
    void UpdateSubject_Sub(Current_Import_Mode mode);
    void SetDefaultBackGroundColor();
    void SetBlackBackGroundColor();
    void CreateTextToSdmcByArray( char* buf, const wchar_t* pathName );
    void CreateTitleListTextToSdmcByDeque( deque<nn::am::ProgramInfo> deq, const wchar_t* pathName );
    bool GetCharTypeOfRemainingBatteryLv();
    char* OutputErrorString( ErrSeq_DataImport errCode, nn::Result nnResult=nn::ResultSuccess() );
    bool Initialize();
    bool Finalize();
    bool WriteRegionFromSerial();
    bool OpenStartMenu();
    bool HardwareReset();
    bool CheckRemainingBatteryLv();
    bool ExtractAcAdapter();
    bool InitializeSdmc();
    bool DeleteNandApp(nn::fs::MediaType media, nn::ProgramId id);
    bool DeleteTestProgram();
    bool DeletePreinstallTicket();
    bool DeleteDirectory(const wchar_t* dirPath);
    bool ResetSetting();
    bool WriteHomeMenuId();
    bool ChangeConfigParameters();
    bool ChangeOpeningMenu();
    bool ReadDirectory(nn::fs::DirectoryEntry* dirEntry, s32* entryNum, const wchar_t* dirPath);
    ErrSeq_DataImport InternalImportCia(nn::fs::MediaType media, const wchar_t* filePath, nn::ProgramId id);
    nn::Result CommitImportPrograms( nn::fs::MediaType media, nn::ProgramId* id, int num );
    bool ImportCia();
    bool UpdateFirmware();
    bool ImportExtSaveData();
    void Sha1ContextGetHash( const void* dataBuf, s32 dataSize, char* string );
    bool WriteTWLFontTable();
    bool WasProperlyImported( nn::fs::MediaType media, bool executeCheckNand = false );
    bool GetAppInfo( nn::fs::MediaType media );
    bool CompareProgramInfo( nn::fs::MediaType media );
    bool CompareTicketDatabase();
    bool CompareTitleList();
    bool ComparePreInstallTitleList();
    bool CompareDefaultTitleList();
    bool WriteProductionLog(const char* result);
    bool WriteProductionLog(const char* name, const char* state);
    bool WriteProductionLog(const char* name, const char* state, const char* msg);
    void FormToLogMessage(char *dst, const char *src);
    bool CheckHsmLog();
    
    void CreateTitleListTextToSdmc( const char *str );
    void CreatePreInstallTitleListTextToSdmc( const char *str );
    void ReadNandAndOutputCheckTxt( const wchar_t* path );
    void ReadSdmcAndOutputCheckTxt( const wchar_t* path );
    void ReadSdmcAndOutputCheckTxtEx( const wchar_t* path );
    void ReadNandAndOutputBuffer(  char* buf, const wchar_t* path );
    void ReadSdmcAndOutputBuffer( char* buf, const wchar_t* path );
    void ReadSdmcAndOutputBufferEx( char* buf, const wchar_t* path );
    void UpdateDisplay( const char* Msg );

private:
    TestImport()
    {
        if (m_pInstance != NULL)
        {
            NW_FATAL_ERROR("TestImport instance already exists.");
        }
        m_pInstance = this;

        gfx = GraphicsDrawing::GetInstance();
    }


    /*---------------------------------------------------------------------------
        oϐ
    ---------------------------------------------------------------------------*/
    // VOgIuWFNgւ̃|C^
    static TestImport* m_pInstance;

    // OtBbNX
    GraphicsDrawing *gfx;

    // EBhE
    WindowManager m_WindowManager;
    TextWindow*   m_LogWindow;   // Oo͗p
    
    // 摜\p
    sys::JpegDrawer* m_JpegDrawer;
    
    // [W
    Import_Region m_SysRegion;
    
    // {fBOIvV
    u8     m_BondingOption;
    
    // VXepbP[Wo[W
    string m_SystemPackageVersion;
    
    // vCXg[o[W
    string m_PreInstallPackageVersion;
    
    // A
    string m_Mark;
    
    // drc
    char*  m_RemainingBatteryLv;
    
    // OJE^
    int    m_LogCount;
    
    // f[^ݐi\p
    ImportInfo m_ImportInfoCurrent;
    ImportInfo m_ImportInfoTotal;
    
    s64    m_AlreadyImportedFileSize;
    
    // vCXg[
    bool   m_PreInstall;
    
    // FatalError
    bit32  m_FatalErrorImportProgram;
    
    // ʏo͗p̕
    char*  m_SdSizeString;
    char*  m_HashString;
    char*  m_ImportTitleContextsString;
    char*  m_CompareProgramInfosNumString;
    char*  m_CompareProgramInfosIdAndVerString;
    char*  m_CompareNumOfTicketsAndProgramsString;
    char*  m_CompareIdOfTicketsAndProgramsString;
    char*  m_FatalErrorString;
    
    // fobOp
    bool NON_DELETE_PROGRAM;      // DeleteProgram()sȂ
    bool NON_DELETE_TICKET;       // DeleteTicket() V
    bool NON_IMPORT_CIA;          // ImportCia()    V
    
    u16  THRESHOLD_REMAINING_BATTERY_LV;
    
    s64  m_ProgressMsec;

public:
    uji::seq::TestResult  m_TestResult;
    
    ImportMediaAppInfo   m_RomAppInfo;   // rom
    ImportMediaAppInfo   m_NandAppInfo;  // nand
    ImportMediaAppInfo   m_SdmcAppInfo;  // sdmc
    ImportMediaAppInfo   m_Rom2NandAppInfo;   // rom (Write to nand)
    ImportMediaAppInfo   m_Rom2SdmcAppInfo;   // rom (Write to sdmc)
    
    /*
        ^CgIDivOIDǰ
        j0x000400000F980000 G[WOvO
        
          0004  (16bit): Partner ID
          000   (12bit): Channel ID
          0     ( 4bit): Category ID
          4     ( 4bit): Platform ID
          F9800 (20bit): Unique ID
          00    ( 8bit): Variation ID
    */
    
    static const nn::ProgramId IMPORTEE_TEST_MENU_ID     = 0x0004003000008102L;  // TestMenu
    static const nn::ProgramId IMPORTEE_TWL_KERNEL_ID    = 0x0004013800000102L;  // TWL Kernel
    static const nn::ProgramId IMPORTEE_AGB_KERNEL_ID    = 0x0004013800000202L;  // AGB Kernel
    
    // TWL ݊p^CgiC-ARM̂ݍ폜j
    static const nn::ProgramId IMPORTEE_TWL_WHITELIST_ID  = 0x0004800F484E4841L;  // zCgXg
    static const nn::ProgramId IMPORTEE_TWL_DLPLAY_ID     = 0x00048005484E4441L;  // _E[hvC
    static const nn::ProgramId IMPORTEE_TWL_VERSION_ID    = 0x0004800F484E4C41L;  // o[W
    static const nn::ProgramId IMPORTEE_TWL_INTERNET_ID   = 0x0004800542383841L;  // DSC^[lbgݒ
};

} // namespace import
} // namespace eva
} // namespace uji

#endif  // TESTIMPORT_H_INCLUDED

