/*--------------------------------------------------------------------------*
 Project:
 File: TestImport.h


*--------------------------------------------------------------------------*/
#ifndef TEST_EXECUTE_IMPORT_H_INCLUDED
#define TEST_EXECUTE_IMPORT_H_INCLUDED

#include "sys.h"
#include "../aging/AgingImporter.h"
#include "../seq/TestResult.h"
#include "TestImport.h"
#include "../seq/TesterLog/ProductionLog.h"

namespace uji {
namespace eva {
namespace import {
    
    /*---------------------------------------------------------------------------
        f[^݌p֐
    ---------------------------------------------------------------------------*/
    extern bool TestExecuteInitialize(uji::seq::TestResult &result);
    extern bool TestExecuteStartup(uji::seq::TestResult &result);
    extern bool TestExecuteHardwareReset(uji::seq::TestResult &result);
    extern bool TestExecuteReinitializeAfterReboot(uji::seq::TestResult &result);
    extern bool TestExecuteInitializeSdmc(uji::seq::TestResult &result);
    extern bool TestExecuteDeleteTestProgram(uji::seq::TestResult &result);
    extern bool TestExecuteDeletePreinstallTicket(uji::seq::TestResult &result);
    extern bool TestExecuteResetSetting(uji::seq::TestResult &result);
    extern bool TestExecuteWriteHomeMenuId(uji::seq::TestResult &result);
    extern bool TestExecuteChangeConfigParameters(uji::seq::TestResult &result);
    extern bool TestExecuteChangeOpeningMenu(uji::seq::TestResult &result);
    extern bool TestExecuteImportCia(uji::seq::TestResult &result);
    extern bool TestExecuteUpdateFirmware(uji::seq::TestResult &result);
    extern bool TestExecuteImportExtSaveData(uji::seq::TestResult &result);
    extern bool TestExecuteWriteTWLFontTable(uji::seq::TestResult &result);
    extern bool TestExecuteWasProperlyImported(uji::seq::TestResult &result);
    extern bool TestExecuteNeedsCleanup(uji::seq::TestResult &result);
    extern bool TestExecuteGetAppInfo(uji::seq::TestResult &result);
    extern bool TestExecuteCompareProgramInfo(uji::seq::TestResult &result);
    extern bool TestExecuteCompareTicketDatabase(uji::seq::TestResult &result);
    extern bool TestExecuteCompareTitleList(uji::seq::TestResult &result);
    extern bool TestExecuteComparePreInstallTitleList(uji::seq::TestResult &result);
    extern bool TestExecuteCompareDefaultTitleList(uji::seq::TestResult &result);
    extern bool TestExecuteFinalize(uji::seq::TestResult &result);
    extern bool TestExecuteWriteOkLog(uji::seq::TestResult &result);
    extern bool TestExecuteWriteUpdateOkLog(uji::seq::TestResult &result);
    extern bool TestExecuteCheckRemainingBatteryLv(uji::seq::TestResult &result);
    extern bool TestExecuteSetLcdMinBrightness(uji::seq::TestResult &result);
    extern bool TestExecuteRestoreLcdBrightness(uji::seq::TestResult &result);
    extern bool TestExecuteExtractAcAdapter(uji::seq::TestResult &result);
    extern bool TestExecuteWriteRegionFromSerial(uji::seq::TestResult &result);
    extern bool TestExecuteCheckHsmLog(uji::seq::TestResult &result);
    
    // TitleList o
    void MakeAllTitleListOutputToSdmc();
    void MakeTitleListOutputToSdmc();
    void MakePreInstallTitleListOutputToSdmc();

} // namespace import
} // namespace eva
} // namespace uji

#endif  // TEST_EXECUTE_IMPORT_H_INCLUDED

