/*---------------------------------------------------------------------------*
  Project:  CTR_UJI
  File:     TestImport.cpp

  Copyright (C)2010 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#include <nn/gx/CTR/gx_LcdBacklight.h>
#include "TestExecuteImport.h"

using namespace uji;
using namespace uji::sys;

namespace uji {
namespace eva {
namespace import {

//===========================================================================
//===========================================================================
//                         f[^݌p
//===========================================================================
//===========================================================================
/*---------------------------------------------------------------------------
  Desc: ʂi[
---------------------------------------------------------------------------*/
static void ShiftTestResult( import::TestImport* p, seq::TestResult &result )
{
    result.m_Micro  = p->m_TestResult.m_Micro;
    sprintf(result.m_String, p->m_TestResult.m_String);
    
    // oϐ
    p->m_TestResult.m_Micro  = 0;
    sprintf(p->m_TestResult.m_String, "");
}

/*---------------------------------------------------------------------------
  Desc: CTRf[^݌ iKsĂj
---------------------------------------------------------------------------*/
bool TestExecuteInitialize(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->Initialize();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: X^[gʕ\
---------------------------------------------------------------------------*/
bool TestExecuteStartup(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->OpenStartMenu();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: n[hEFAZbg
---------------------------------------------------------------------------*/
bool TestExecuteHardwareReset(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    
    /*
    // @Q
    char charId[20];
    int  intId = uji::seq::TestSequencer::m_TestResultManager->GetTestResultVectorSize();
    sprintf( charId, "CurrentTest=%d", intId );
    
    result.m_Result = pTi->WriteProductionLog("Reboot", "START", charId);
    */
    // @P
    result.m_Result = pTi->WriteProductionLog("Reboot", "START");
    if( false == result.m_Result )  { goto FINALIZE; }
    
    result.m_Result = pTi->HardwareReset();
    if( false == result.m_Result )  { goto FINALIZE; }
    
    // HardwareResetAċNOɎ̏ɐi܂Ȃ悤ɃX[v
    for(;;)
    {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromDays(1));
    }

FINALIZE:
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: ċN̏
---------------------------------------------------------------------------*/
bool TestExecuteReinitializeAfterReboot(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    
    // Reboot OK O
    result.m_Result = pTi->WriteProductionLog("Reboot", "OK");
    if( false == result.m_Result )  { goto FINALIZE; }
    
    // Reinitialize
    result.m_Result = pTi->Initialize();
    if( false == result.m_Result )  { goto FINALIZE; }
    
FINALIZE:
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: ACA_v^҂
---------------------------------------------------------------------------*/
bool TestExecuteExtractAcAdapter(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->ExtractAcAdapter();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: drcʃ`FbN
---------------------------------------------------------------------------*/
bool TestExecuteCheckRemainingBatteryLv(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->CheckRemainingBatteryLv();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
    Desc: ԏ݂̓drߖ̂߃obNCg̋PxŒɂ
---------------------------------------------------------------------------*/
bool TestExecuteSetLcdMinBrightness(uji::seq::TestResult &result)
{
    nn::gx::CTR::Backlight::SetLuminanceLevel(nn::gx::CTR::LCD_BOTH, 1);

    result.m_Result = true;
    return result.m_Result;

}

/*---------------------------------------------------------------------------
    Desc: obNCg̋Pxɖ߂
---------------------------------------------------------------------------*/
bool TestExecuteRestoreLcdBrightness(uji::seq::TestResult &result)
{
    nn::gx::CTR::Backlight::Restore(nn::gx::CTR::LCD_BOTH);

    result.m_Result = true;
    return result.m_Result;

}

/*---------------------------------------------------------------------------
  Desc: SDJ[hɃf[^x[X쐬ďivCXg[pj
---------------------------------------------------------------------------*/
bool TestExecuteInitializeSdmc(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->InitializeSdmc();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: NAND ɃC|[gĂvO폜
---------------------------------------------------------------------------*/
bool TestExecuteDeleteTestProgram(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->DeleteTestProgram();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: vCXg[^Cg̃`Pbg폜
---------------------------------------------------------------------------*/
bool TestExecuteDeletePreinstallTicket(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->DeletePreinstallTicket();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: CAL  CFG ɃRs[iCFG ̃Zbgj
---------------------------------------------------------------------------*/
bool TestExecuteResetSetting(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->ResetSetting();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: e[W Home j[ ID 
---------------------------------------------------------------------------*/
bool TestExecuteWriteHomeMenuId(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->WriteHomeMenuId();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: CFG ̒lύX
---------------------------------------------------------------------------*/
bool TestExecuteChangeConfigParameters(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->ChangeConfigParameters();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: Ñj[ύX
---------------------------------------------------------------------------*/
bool TestExecuteChangeOpeningMenu(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->ChangeOpeningMenu();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: f[^
---------------------------------------------------------------------------*/
bool TestExecuteImportCia(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->ImportCia();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: t@[EFA̍XV
  
   TestExecuteImportCia() ɐ荞ނEEE
---------------------------------------------------------------------------*/
bool TestExecuteUpdateFirmware(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->UpdateFirmware();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: gZ[uf[^
---------------------------------------------------------------------------*/
bool TestExecuteImportExtSaveData(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->ImportExtSaveData();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: TWLFontTable.dat ̏㏑
---------------------------------------------------------------------------*/
bool TestExecuteWriteTWLFontTable(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->WriteTWLFontTable();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: Nand/Sdmc  C|[gmF
---------------------------------------------------------------------------*/
bool TestExecuteWasProperlyImported(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    
    result.m_Result = pTi->WasProperlyImported( nn::fs::MEDIA_TYPE_NAND );
    if( false == result.m_Result )  { goto FINALIZE; }
    
    result.m_Result = pTi->WasProperlyImported( nn::fs::MEDIA_TYPE_SDMC );
    if( false == result.m_Result )  { goto FINALIZE; }
    
FINALIZE:
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: Nand  C|[gOmF(rdf{̑΍)
---------------------------------------------------------------------------*/
bool TestExecuteNeedsCleanup(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    
    result.m_Result = pTi->WasProperlyImported( nn::fs::MEDIA_TYPE_NAND, true );

    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: Nand/Sdmc ɃC|[gĂAv擾
---------------------------------------------------------------------------*/
bool TestExecuteGetAppInfo(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    
    result.m_Result = pTi->GetAppInfo( nn::fs::MEDIA_TYPE_NAND );
    if( false == result.m_Result )  { goto FINALIZE; }
    
    result.m_Result = pTi->GetAppInfo( nn::fs::MEDIA_TYPE_SDMC );
    if( false == result.m_Result )  { goto FINALIZE; }
    
FINALIZE:
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: Nand/Sdmc  Rom  ProgramInfo( id, size ) ̔r
---------------------------------------------------------------------------*/
bool TestExecuteCompareProgramInfo(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    
    result.m_Result = pTi->CompareProgramInfo( nn::fs::MEDIA_TYPE_NAND );
    if( false == result.m_Result )  { goto FINALIZE; }
    
    result.m_Result = pTi->CompareProgramInfo( nn::fs::MEDIA_TYPE_SDMC );
    if( false == result.m_Result )  { goto FINALIZE; }
    
FINALIZE:
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: `Pbgf[^x[X̊mF
---------------------------------------------------------------------------*/
bool TestExecuteCompareTicketDatabase(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->CompareTicketDatabase();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: vO̊mF
---------------------------------------------------------------------------*/
bool TestExecuteCompareTitleList(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->CompareTitleList();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: vCXg[vO̊mF
---------------------------------------------------------------------------*/
bool TestExecuteComparePreInstallTitleList(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->ComparePreInstallTitleList();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: W̃vO̊mF
---------------------------------------------------------------------------*/
bool TestExecuteCompareDefaultTitleList(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->CompareDefaultTitleList();
    
    // 
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: OK O
---------------------------------------------------------------------------*/
bool TestExecuteWriteOkLog(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    pTi->Finalize();
    result.m_Result = pTi->WriteProductionLog("OK");
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: Update OK O݁iC_pj
---------------------------------------------------------------------------*/
bool TestExecuteWriteUpdateOkLog(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    pTi->Finalize();
    result.m_Result = pTi->WriteProductionLog("Update", "OK");
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: SerialNoRegionݒ(bΉ̂߁A݂͎gp)
---------------------------------------------------------------------------*/
bool TestExecuteWriteRegionFromSerial(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->WriteRegionFromSerial();
    ShiftTestResult( pTi, result );
    return result.m_Result;
}

/*---------------------------------------------------------------------------
  Desc: HSMT[o[̃O`FbN(KHSMT[oƒʐMłmF)
---------------------------------------------------------------------------*/
bool TestExecuteCheckHsmLog(uji::seq::TestResult &result)
{
    import::TestImport* pTi = import::TestImport::GetInstance();
    result.m_Result = pTi->CheckHsmLog();
    ShiftTestResult( pTi, result );
    return result.m_Result;
}
    
/*---------------------------------------------------------------------------
  Desc: NAND ɏ܂ꂽAṽXg SD J[hɏo
---------------------------------------------------------------------------*/
void MakeAllTitleListOutputToSdmc()
{
    char resultMsg[50] = "";
    
    import::TestImport* pTi = import::TestImport::GetInstance();
    
    // SD J[h}Eg
    if( nn::fs::MountSdmc().IsFailure() ) 
    {
        sprintf( resultMsg, " Not found SD card.\n" );
    }
    else
    {
        // TitleList.txt 폜čĐ
        nn::fs::TryDeleteFile( L"sdmc:/uji/TitleList.txt" );
        pTi->ReadNandAndOutputCheckTxt( L"nand:/title/" );
        
        pTi->UpdateDisplay( "\n" );
        pTi->UpdateDisplay( "--------------------\n" );
        
        // PreInstallTitleList.txt 폜čĐ
        nn::fs::TryDeleteFile( L"sdmc:/uji/PreInstallTitleList.txt" );
        pTi->ReadSdmcAndOutputCheckTxtEx( L"sdmc:/Nintendo 3DS/" );
        
        sprintf( resultMsg, " Completed the output to Sdmc.\n" );
    }
    // A}Eg
    nn::fs::Unmount( "sdmc:" );
    
    pTi->UpdateDisplay( "\n" );
    pTi->UpdateDisplay( "\n" );
    pTi->UpdateDisplay( resultMsg );
    pTi->UpdateDisplay( "\n" );
    pTi->UpdateDisplay( " (B : Exit)\n" );
    uji::sys::Pad pad;
    do
    {
        pad.UpdatePad();
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
}
void MakeTitleListOutputToSdmc()
{
    char resultMsg[50] = "";
    
    import::TestImport* pTi = import::TestImport::GetInstance();
    
    // SD J[h}Eg
    if( nn::fs::MountSdmc().IsFailure() ) 
    {
        sprintf( resultMsg, " Not found SD card.\n" );
    }
    else
    {
        // TitleList.txt 폜čĐ
        nn::fs::TryDeleteFile( L"sdmc:/uji/TitleList.txt" );
        pTi->ReadNandAndOutputCheckTxt( L"nand:/title/" );
        sprintf( resultMsg, " Completed the Title List output to Sdmc.\n" );
    }
    // A}Eg
    nn::fs::Unmount( "sdmc:" );
    
    pTi->UpdateDisplay( "\n" );
    pTi->UpdateDisplay( "\n" );
    pTi->UpdateDisplay( resultMsg );
    pTi->UpdateDisplay( "\n" );
    pTi->UpdateDisplay( " (B : Exit)\n" );
    uji::sys::Pad pad;
    do
    {
        pad.UpdatePad();
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
}
void MakePreInstallTitleListOutputToSdmc()
{
    char resultMsg[100] = "";
    
    import::TestImport* pTi = import::TestImport::GetInstance();
    
    // SD J[h}Eg
    if( nn::fs::MountSdmc().IsFailure() ) 
    {
        sprintf( resultMsg, " Not found SD card.\n" );
    }
    else
    {
        // PreInstallTitleList.txt 폜čĐ
        nn::fs::TryDeleteFile( L"sdmc:/uji/PreInstallTitleList.txt" );
        pTi->ReadSdmcAndOutputCheckTxtEx( L"sdmc:/Nintendo 3DS/" );
        sprintf( resultMsg, " Completed the PreInstall Title List output to Sdmc.\n" );
    }
    // A}Eg
    nn::fs::Unmount( "sdmc:" );
    
    pTi->UpdateDisplay( "\n" );
    pTi->UpdateDisplay( "\n" );
    pTi->UpdateDisplay( resultMsg );
    pTi->UpdateDisplay( "\n" );
    pTi->UpdateDisplay( " (B : Exit)\n" );
    uji::sys::Pad pad;
    do
    {
        pad.UpdatePad();
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }
    while(!pad.IsButtonDown(Pad::BUTTON_B));
}

} // namespace import
} // namespace eva
} // namespac

