#include "TcpComm.h"

#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/ac.h>

using namespace uji::sys;
using namespace nn::cfg::CTR;
using namespace nn::cfg::CTR::init;
using namespace nn::cfg::CTR::detail;
using namespace std;

namespace uji{
namespace eva{
namespace import{

// IuWFNgTCY_v
void TcpComm::TestFunc_DumpObjectSize()
{
   NN_LOG("u8:%d\n",sizeof(u8));
   NN_LOG("u16:%d\n",sizeof(u16));
   NN_LOG("u32:%d\n",sizeof(u32));
   NN_LOG("s32:%d\n",sizeof(s32));
   NN_LOG("uptr:%d\n",sizeof(uptr));
   NN_LOG("uptr *:%d\n", sizeof(uptr *));
   NN_LOG("string:%d\n",sizeof(string));
   NN_LOG("string *:%d\n",sizeof(string *));

   NN_LOG("sys::WindowManager :%d\n", sizeof(sys::WindowManager));
   NN_LOG("sys::TextWindow :%d\n", sizeof(sys::TextWindow));

   //
   NN_LOG("SockAddrIn :%d\n", sizeof(nn::socket::SockAddrIn));
   NN_LOG("nn::socket::InAddr :%d\n", sizeof(nn::socket::InAddr));

   NN_LOG("CommPack:%d\n",sizeof(CommPack));
   NN_LOG("CommPack *:%d\n",sizeof(CommPack *));
   NN_LOG("CommandUtil :%d\n", sizeof(CommandUtil));

   NN_LOG("SecureInfoBody:%d\n",sizeof(SecureInfoBody));
   NN_LOG(" CfgRegionCode:%d\n",sizeof(CfgRegionCode));
   NN_LOG("LocalFriendCodeSeedBody:%d\n",sizeof(LocalFriendCodeSeedBody));

   NN_LOG("EvaImport:%d\n",sizeof(TcpComm));
}

#pragma diag_suppress 1446
// |C^  string -> utr  -> string
void TcpComm::TestFunc_PointerRestore()
{
   string str1;
   str1 = "SAMPLE STRING";

   string * s;
   s = &str1;

   uptr u1;
   u1 = 12345;

   NN_LOG("str1 addr:%p\n", &str1);
   NN_LOG("s        :%p\n", s);
   NN_LOG("s    addr:%p\n", &s);
   NN_LOG("u1       :%p\n", u1);
   NN_LOG("u1   addr:%p\n", &u1);

   // stringւ̃|C^ u1ɃRs[(memmove)
//   std::memmove(reinterpret_cast<void *>(u1), s, 4); // ꂾ 12345Ԓn str1̃AhXRs[悤ƂāAƂ܂B
   std::memmove(reinterpret_cast<void *>(&u1), s, 4); //삷

   NN_LOG("\n\n");
   NN_LOG("u1       :%p\n",  u1);
   NN_LOG("u1   addr:%p\n", &u1);

// u1  string𕜌
   uptr * up;
   up = &u1;
   string * sp;

   sp = reinterpret_cast<string *>(up);
   NN_LOG("restore[%s]\n",*sp); //#1446-D
}

// |C^ϊ uptr <-> string
void TcpComm::TestFunc_PointerConv()
{
   string str1;
   NN_LOG("string:%d\n",sizeof(str1));
   str1 = "HELLO STRING";
   NN_LOG("str1:%d\n",sizeof(str1));

   uptr u;
   uptr * p1;
   p1 = &u;
   string * p2;
   p2 = &str1;


   // |C^m̃LXg reinterpret_castB
   p1= reinterpret_cast<uptr *>(p2);
   NN_LOG("p1:%s\n", *p1); //#1446-D

   p2= reinterpret_cast<string *>(p1);
   NN_LOG("p2:%s\n", *p2); //#1446-D

}
#pragma diag_default 1446

// Ǒ݂
void TcpComm::TestFunc_WriteLog()
{
    uji::seq::ProductionLog  *pl = new uji::seq::ProductionLog;
    uji::seq::LogResult lr;

    lr  = pl->Initialize();
    if ( lr == uji::seq::LogResultCode::SUCCESS)
    {
        pl->Add_1Line(0,"IMPORT","START",  "9.99", "2010/4/8",  "23:59","012345", "free message");
    }

    delete pl;
}


// VANO
void TcpComm::TestFunc_WriteSerNo()
{
/*
    nn::cfg::CTR::detail::SecureInfoBody sib;
    nn::cfg::CTR::detail::SecureInfoBody * p;

    u8 sigDummy[256+1]; //_~[f[^
    std::memset(sigDummy, 0x00, sizeof(sigDummy));
    std::memcpy(sigDummy, "AAAAAAAAAA111111111122222222223333333333444444444455555555556666666666777777777788888888889999999999AAAAAAAAAA111111111122222222223333333333444444444455555555556666666666777777777788888888889999999999AAAAAAAAAA1111111111222222222233333333334444444444555555", 256);

    sib.region = CFG_REGION_JAPAN;

    std::memcpy(sib.serialNo, "ABC00000001", 11);

    p = &sib;

    NN_LOG("SetSecureInfo call.\n");
    SetSecureInfo(p,sigDummy); // sigDummyNULL̏ꍇ́Aԉ
    NN_LOG("done.");

    //f[^flush
    FlushSecureInfo();
*/
}

//VANOǂݏo
void TcpComm::TestFunc_ReadSerNo()
{
/*
    u8 serialNo[48];
    u8 * p = serialNo;

    std::memset(serialNo, 0x00, sizeof(serialNo));

    nn::cfg::CTR::init::GetSerialNo(p);

    NN_LOG("serialNo:[%s]\n", serialNo);

    //[Wǂݏo
    NN_LOG("region:[%d]\n", nn::cfg::CTR::init::GetRegion());
*/
}

/*
//
bool TcpComm::TestFunc_ValidateSignature(sys::GraphicsDrawing* gfx)
{
    nn::Result r;

    ULCDPrintf("ValidateLocalFriendCodeSeed ...");
    DrawUpperLCD(gfx);


//TODO IɏC
    if ( 0 == m_bondingOption )
    {
//      r = Prod_Self_ValidateLocalFriendCodeSeed(); // ʎY@
    }
    else
    {
        r = nn::cfg::CTR::init::ValidateLocalFriendCodeSeed();//J@
    }

    if ( r.IsFailure())
    {
        ULCDPrintfWarn("Failed.\n");
        nn::dbg::PrintResult(r);
        return false;
    }
    else
    {
        ULCDPrintf("Succeeded.\n");
    }
    DrawUpperLCD(gfx);

    ULCDPrintf("ValidateSecureInfo ...");
    DrawUpperLCD(gfx);

//TODO IɏC
    if ( 0 == m_bondingOption )
    {
//      r = Prod_Self_ValidateSecureInfo(); // ʎY@
    }
    else
    {
        r = nn::cfg::CTR::init::ValidateSecureInfo();
    }

    if ( r.IsFailure())
    {
        ULCDPrintfWarn("Failed.\n");
        nn::dbg::PrintResult(r);
        return false;
    }
    else
    {
        ULCDPrintf("Succeeded.\n");
    }
    DrawUpperLCD(gfx);

    u8 serialNo[48];
    u8 * p = serialNo;

    //VAԍǂݏo
    std::memset(serialNo, 0x00, sizeof(serialNo));
    nn::cfg::CTR::init::GetSerialNo(p);
    NN_LOG("serialNo:[%s]\n",serialNo);

    return true;
}
*/


// LocalFriendCodeSeedBody̓ǂݏo
void TcpComm::TestFunc_ReadLocalFriendCode()
{
    nn::cfg::CTR::detail::LocalFriendCodeSeedBody lfcsb;
    nn::cfg::CTR::detail::LocalFriendCodeSeedBody * p;
    p = &lfcsb;

    // ZbgtrueɂƁAn[hEFAlǂށB
    // A SDK 0.10.2ł́A5ǂނƉFʂɂȂĎSB
    nn::cfg::CTR::init::GetLocalFriendCodeSeedBody(p, true);

    NN_LOG(" sizeof lfcsb:%d\n",sizeof(lfcsb));
    NN_LOG(" version:%d\n"            ,lfcsb.version);
    NN_LOG(" bondingOption:%d\n"      ,lfcsb.bondingOption);
    NN_LOG(" localFriendCodeSeed:%x\n",lfcsb.localFriendCodeSeed);
    NN_LOG(" localFriendCodeSeed:%lx\n",lfcsb.localFriendCodeSeed);
    NN_LOG(" localFriendCodeSeed:%llx\n",lfcsb.localFriendCodeSeed);

}
/*
bool TcpComm::TestFunc_GetACStatus(string * str_ptr)
{
    nn::Result r;
    nn::ac::CTR::Status s;

    string  str;


    // Xe[^X𒲂ׂāATcpڑATcpDisconnectĂ
//    r = nn::ac::GetStatus(&s);            // EVA_SDK_0_14_1
//    if ( r.IsFailure()) return false;     // EVA_SDK_0_14_1

    switch (s)
    {
        case  nn::ac::CTR::STATUS_NONE         : str ="NONE"; break;
        case  nn::ac::CTR::STATUS_IDLE         : str ="IDLE"; break;
        case  nn::ac::CTR::STATUS_LAN_CONNECTED: str ="LAN_CONNECTED"; break;
        case  nn::ac::CTR::STATUS_WAN_CONNECTED: str ="WAN_CONNECTED"; break;
        case  nn::ac::CTR::STATUS_ACTIVE_SCAN  : str ="ACTIVE_SCAN"; break;
        case  nn::ac::CTR::STATUS_PASSIVE_SCAN : str ="PASSIVE_SCAN"; break;
        case  nn::ac::CTR::STATUS_CONNECT_AP   : str ="CONNECT_AP"; break;
        case  nn::ac::CTR::STATUS_GET_IP_ADDRESS : str = "GET_IP_ADDRESS"; break;
        case  nn::ac::CTR::STATUS_CONNTEST     : str ="CONNTEST"; break;
        case  nn::ac::CTR::STATUS_AUTH_HOTSPOT: str ="AUTH_HOTSPOT"; break;
        case  nn::ac::CTR::STATUS_DISCONNECT_AP: str = "DISCONNECT_AP"; break;
    }
#if 0
    NN_LOG(" ac::GetStatus:%s(%d)\n", str.c_str(),s);
#endif

    *str_ptr = str;
    return true;
}
*/

//  ۗ֐
// R}hM[h
void TcpComm::CommandReceiver(sys::GraphicsDrawing* gfx)
{
     NN_UNUSED_VAR(gfx);
}


} // namespace import
} // namespace eva
} // namespace uji
