/*---------------------------------------------------------------------------*
  Project:  CTR_UJI
  File:     TcpComm_SystemMenuDesc.cpp

  Copyright (C)2010 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#include "TcpComm.h"
#include <nn/am.h>
#include <nn/CTR/CTR_ProgramId.h>

using namespace uji::sys;

namespace uji{
namespace eva{
namespace import{

    // CIA fBNg̃pX
//    const wchar_t * CIA_DIR_PATH = L"rom:/sys";
//    const std::wstring  CIADIR_PATH = L"rom:/sys/dev/";
    const std::wstring  CIADIR_PATH = L"rom:/import/";


// NUP̉1
bool TcpComm::GetSystemMenuRegion(const CommPack &cp)
{
    return SendResponse(m_systemMenuRegion,cp); //1
}

// p~
//bool TcpComm::GetSystemMenuVersion(const CommPack &cp)
//{
//    return SendResponse("0.00",cp);
//}

// NUP
bool TcpComm::GetSystemMenuNupVersion(const CommPack &cp)
{
    return SendResponse(m_nupVersion,cp);
}

// CUP
bool TcpComm::GetSystemMenuCupVersion(const CommPack &cp)
{
    return SendResponse(m_cupVersion,cp);
}

// PreInstall
bool TcpComm::GetSystemMenuPreInstallVersion(const CommPack &cp)
{
    return SendResponse(m_preInstallVersion,cp);
}


// ֐
bool TcpComm::EntryPreInstallApp( const wchar_t* cia_path , int entry_id)
{
    nn::am::ProgramInfo pi;
    nn::ProductCode pc;
    nn::Result      nnr;

#if 0
    NN_LOG("[%ls],", cia_path);
#endif

//    nnr = nn::am::GetProgramInfoFromCia(&pi, cia_path, nn::fs::MEDIA_TYPE_NAND);
    nnr = nn::am::GetProgramInfoFromCia(&pi, cia_path);
    if ( nnr.IsSuccess())
    {
//        NN_LOG("id=0x%016llx,",   pi.id);     // bit64
//        NN_LOG("version=0x%04x,", pi.version);// u16
//        NN_LOG("size=%lld,",      pi.size);   // s64

        if (    nn::CTR::IsCtr(pi.id)         &&   // CTRAvł
               !nn::CTR::IsSystem(pi.id)      &&   // VXeAvłȂ
             2!=nn::CTR::GetVariationOf(pi.id)     // NANDAvłȂ(!=2)
           )
        {
            m_ApplicationDescTable[entry_id].titleId     = pi.id;
            m_ApplicationDescTable[entry_id].ciaVersion  = pi.version;

//            // productCode
//            nnr = nn::am::GetProductCode(&pc ,nn::fs::MEDIA_TYPE_NAND, pi.id);
//            if ( nnr.IsSuccess())
//            {
//    //             NN_LOG("productCode=[%s]", pc.code);
//                 strncpy (m_ApplicationDescTable[entry_id].productCode, pc.code, strlen(pc.code));
//            }
            return true;
        }

    }

    return false;
}

// InstallApplicationNum
bool TcpComm::GetInstallApplicationNum(const CommPack &cp)
{
    nn::Result nnr;
    void * buf;
    int  fileCount= 0;
    int  ciaCount = 0;

    // ApplicationDescTablȇSNA
    std::memset(m_ApplicationDescTable, 0x00, sizeof(m_ApplicationDescTable));

// ʎYJn zp̃^Cg𑗂KvȂ߁AciaCount0ŌŒ (2011/1/10)
#if 1

    // ROM̎wtH_̓eSēo^B
    nn::fs::Directory dir;
    nnr = dir.TryInitialize(CIADIR_PATH.c_str());
    if ( nnr.IsSuccess())
    {
        nn::fs::DirectoryEntry de[10];
        s32  entryNum = 1;

        while ( entryNum > 0)
        {
            nnr = dir.TryRead ( &entryNum, de,  10);
            if ( nnr.IsFailure())
            {
                break;
            }
            else
            {
                NN_LOG("entryNum :%d\n", entryNum);
                int i;
                for ( i=0; i < entryNum; i++)
                {
//                    NN_LOG("%d,%ls,",fileCount++,de[i].entryName);
//                    NN_LOG("[%d] %ls\n",i, de[i].entryName);
                    std::wstring filename(de[i].entryName);
                    std::wstring path ;
                    path = CIADIR_PATH + filename;

                    // .cia܂ރt@C̏
                    std::wstring::size_type index = path.find(L".cia");
                    if ( index == std::string::npos)
                    {
                        NN_LOG("[NOT_CIA]\n");
                    }
                    else
                    {
                        if ( true == EntryPreInstallApp(path.c_str(),ciaCount))
                        {
                            ciaCount++;
                        }
                    }
                }
            }
        }//while
    }

#endif

    //ciaCount Ԃ
    char resultBuf[2+1];
    std::memset(resultBuf, 0x00, sizeof(resultBuf));
    std::sprintf(resultBuf, "%02x",ciaCount);
    return SendResponse(resultBuf,cp);   //16i2z
}

// AvP[V̌ʂ̏擾
bool TcpComm::GetInstallApplicationDesc(const CommPack &cp)
{
    char argStr[2];
    std::memset(argStr, 0x00, sizeof(argStr));
    std::memcpy(argStr, cp.Arg, 2);

    int index = 0;
    index = (argStr[0] - 0x30)*16 + (argStr[1] - 0x30);

    if (( index >= 0 ) && ( index < 256))
    {
        NN_LOG("titleId=0x%016llX \n",m_ApplicationDescTable[index].titleId);
        NN_LOG("productCode=%s\n",    m_ApplicationDescTable[index].productCode);
        NN_LOG("version=%d\n",        m_ApplicationDescTable[index].ciaVersion);

        u8 majorVer = 0;
        u8 minorVer = 0;
        u8 microVer = 0;

        majorVer = (0xFC00 & m_ApplicationDescTable[index].ciaVersion) >> 10;
        minorVer = (0x3F0  & m_ApplicationDescTable[index].ciaVersion) >> 4;
        microVer = (0xF    & m_ApplicationDescTable[index].ciaVersion);

        char ciaVersionStr[20+1];
        std::memset(ciaVersionStr, 0x00, sizeof(ciaVersionStr));
        std::sprintf(ciaVersionStr, "%d.%d.%d", majorVer,minorVer,microVer);

        char resultBuf[40+1];
        std::memset(resultBuf, 0x00, sizeof(resultBuf));
        std::sprintf(resultBuf, "%016llX#%d#%s",m_ApplicationDescTable[index].titleId,
                                                0,//productCode͌ 0 (2011/1/8 c񃁁[QƁj
                                                ciaVersionStr);

        return SendResponse(resultBuf,cp);   //16i2z
    }
    else
    {
        return SendResponse("UNDEFINED",cp);

    }
}

// CommunicationMouduleNum
bool TcpComm::GetCommunicationModuleNum(const CommPack &cp)
{
    // 2010/12/21 ʐMW[RFÛ
    return SendResponse("01",cp);   //16i2
}

// CommunicationMoudlěʂ̏擾
bool TcpComm::GetCommunicationModuleDesc(const CommPack &cp)
{
    char argStr[2];
    std::memset(argStr, 0x00, sizeof(argStr));
    std::memcpy(argStr, cp.Arg, 2);

    int index = 0;
    index = (argStr[0] - 0x30)*16 + (argStr[1] - 0x30);

    if ( 0 == index )
    {
        char resultBuf[20];
        std::memset(resultBuf, 0x00, sizeof(resultBuf));
        std::sprintf(resultBuf, "RFU#%s",m_macAddressChar);
        return SendResponse(resultBuf,cp);
    }
    else
    {
        return SendResponse("UNDEFINED",cp);
    }

//    return false;
}

} // namespace import
} // namespace eva
} // namespace uji
