#include "TcpComm.h"

//#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/cfg/CTR/detail/cfg_LocalFriendCodeSeed.h>
#include <nn/cfg/CTR/detail/cfg_SecureInfo.h>
//#include <nn/ps.h>
#include <nn/ps/CTR/ps_API.h>
#include <nn/ps/CTR/ps_Parameters.h>
//#include <nn/crypto/crypto_RsaKey.h>

#include <nn/fs/CTR/MPCore/fs_FileSystemBasePrivate.h>

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji::sys;
using namespace nn::cfg::CTR;
using namespace nn::cfg::CTR::init;
using namespace nn::cfg::CTR::detail;
using nn::Handle;

// SecureInfoĝ͂

namespace uji{
namespace eva{
namespace import{

const u8 DEVICE_ID_LEN = 8;

// foCXID̎擾
// [JthR[hV[hƂ͕ʂ̂̂Ăق(NBD)
bool TcpComm::GetDeviceID(const CommPack &cp)
{
    nn::Result r;
    u8 rsc = m_cu.FAILURE;

    bit32 deviceId = 0;

    // PSZbV
    r = nn::ps::CTR::Initialize();
    if ( r.IsFailure())
    {
        NN_LOG("Initialize failed.\n");
        nn::dbg::PrintResult(r);
        rsc = m_cu.FAILURE;
    }
    else
    {
        rsc = m_cu.SUCCESS;
    }

    // foCXID擾
    r = nn::ps::CTR::GetDeviceId(&deviceId);
    if ( r.IsFailure())
    {
        NN_LOG("GetDeviceId failed.\n");
        nn::dbg::PrintResult(r);
        rsc = m_cu.FAILURE;
    }
    else
    {
        rsc = m_cu.SUCCESS;
    }

    // argɊi[
    char  arg[DEVICE_ID_LEN +1];
    std::memset(arg, 0x00, sizeof(arg));
    sprintf(arg, "%08X", deviceId);
    NN_LOG("arg: [%s]\n",arg);

    //response𐶐
    char response [4+4+2+2+DEVICE_ID_LEN+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(rsc, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");

    // psZbVj
    r = nn::ps::CTR::Finalize();
    if ( r.IsFailure())
    {
        NN_LOG("GetDeviceId failed.\n");
        nn::dbg::PrintResult(r);
    }

    return true;
}

//VANOǂݍ
bool TcpComm::GetSerialNumber(const CommPack &cp)
{
    u8 rsc = m_cu.FAILURE;
    nn::Result r;
    nn::cfg::CTR::detail::SecureInfoBody   sib;
    nn::cfg::CTR::detail::SecureInfoBody* pSib;
    pSib = &sib;

    // SecureInfoBody擾
    r = GetSecureInfoBody(pSib);
    if ( r.IsFailure())
    {
        NN_LOG("GetSecureInfoBody failed.\n");
        nn::dbg::PrintResult(r);
        rsc = m_cu.FAILURE;
    }
    else
    {
        rsc = m_cu.SUCCESS;
    }

    // SecureInfoBodyserialNo擾
    //u8 serialNo[CFG_SECURE_INFO_SERIAL_NO_LEN +1];
    std::memset(m_serialNo, 0x00, sizeof(m_serialNo));
    std::memcpy(m_serialNo, pSib->serialNo, CFG_SECURE_INFO_SERIAL_NO_LEN);
    NN_LOG("m_serialNo:[%s]\n", m_serialNo);

    // argɊi[
    char  arg[CFG_SECURE_INFO_SERIAL_NO_LEN +1];
    std::memset(arg, 0x00, sizeof(arg));
    std::memcpy(arg, m_serialNo, CFG_SECURE_INFO_SERIAL_NO_LEN);
    NN_LOG("arg: [%s]\n",arg);

    //response𐶐
    char response [4+4+2+2+CFG_SECURE_INFO_SERIAL_NO_LEN+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(rsc, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}

// VANO
bool TcpComm::SetSerialNumber(const CommPack &cp)
{
    u8 rsc = m_cu.FAILURE;
    nn::Result r;

    // VANO
    u8 serialNo[CFG_SECURE_INFO_SERIAL_NO_LEN + 1];
    std::memset(serialNo, 0x00, sizeof(serialNo));
    std::memcpy(serialNo, cp.Arg, CFG_SECURE_INFO_SERIAL_NO_LEN);
    NN_LOG("serialNo:[%s]\n",serialNo);


    // _~[f[^
    u8 sigDummy[256+1];
    std::memset(sigDummy, 0x00, sizeof(sigDummy));
    std::memcpy(sigDummy, "AAAAAAAAAA111111111122222222223333333333444444444455555555556666666666777777777788888888889999999999AAAAAAAAAA111111111122222222223333333333444444444455555555556666666666777777777788888888889999999999AAAAAAAAAA1111111111222222222233333333334444444444555555", 256);

    nn::cfg::CTR::detail::SecureInfoBody sib;
    nn::cfg::CTR::detail::SecureInfoBody * pSib;
    pSib = &sib;

    // SecureInfoBody擾
    r = GetSecureInfoBody(pSib);
    if ( r.IsFailure())
    {
        NN_LOG("GetSecureInfo failed.\n");
        nn::dbg::PrintResult(r);
    }

    // SecureInfoBody̒lXV
    std::memcpy(sib.serialNo, serialNo, CFG_SECURE_INFO_SERIAL_NO_LEN);//VANO
    sib.region = SerialNumberToRegionCode(serialNo[1]);

/*
    switch( serialNo[1] ) // VA2
    {
        case 'A' : sib.region = nn::cfg::CFG_REGION_EUROPE;     break;
        case 'B' : sib.region = nn::cfg::CFG_REGION_AMERICA;    break;
        case 'C' : sib.region = nn::cfg::CFG_REGION_CHINA;      break;
        case 'E' : sib.region = nn::cfg::CFG_REGION_EUROPE;     break;
        case 'J' : sib.region = nn::cfg::CFG_REGION_JAPAN;      break;
        case 'K' : sib.region = nn::cfg::CFG_REGION_KOREA;      break;
        case 'S' : sib.region = nn::cfg::CFG_REGION_AMERICA;    break;
        case 'T' : sib.region = nn::cfg::CFG_REGION_TAIWAN;     break;
        case 'W' : sib.region = nn::cfg::CFG_REGION_AMERICA;    break;
        default  : sib.region = nn::cfg::CFG_REGION_JAPAN;
    }
*/

    // SecureInfoBodyDumps
    u8 * u8DispPtr = NULL;
    u8DispPtr =  reinterpret_cast<u8 *>(pSib);
    NN_LOG(" SecureInfoBody:\n  ");
    for(int i=0; i < 17; i++)
    {
        if ( i == 16 ) NN_LOG("\n  ");

        NN_LOG("%02X ", *u8DispPtr);
        u8DispPtr++;
    }
    NN_LOG("\n");

    //SecureInfoɃf[^ݒ肷
    r = SetSecureInfo(pSib,sigDummy);
    if ( r.IsFailure())
    {
        NN_LOG("SetSecureInfo failed.\n");
        nn::dbg::PrintResult(r);
        rsc = m_cu.FAILURE;
        goto FIN;
    }

    //f[^flush
    r = FlushSecureInfo();
    if ( r.IsFailure())
    {
        NN_LOG("FlushSecureInfo failed.\n");
        nn::dbg::PrintResult(r);
        rsc = m_cu.FAILURE;
        goto FIN;
    }

    //܂łΐ
    rsc = m_cu.SUCCESS;

FIN:
    //response𐶐
    char response [4+4+2+2+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(rsc, ""));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}

// m_recvBuffer  LocalFriendCodep̏Ƃ݂ȂALocalFriendCodeSeed
u32 TcpComm::RecvBuffer_WriteAsLocalFriendCodeSeed(void)
{
    nn::Result r;

    // LocalFriendCodeSeedp̏ƂāAm_recvBufferݒ肷
    r = SetLocalFriendCodeSeedSignature(m_recvBuffer);
    if ( r.IsFailure())
    {
        nn::dbg::PrintResult(r);
        return 1;
    }

    // f[^NANDɏ
    r = FlushLocalFriendCodeSeed();
    if ( r.IsFailure())
    {
        nn::dbg::PrintResult(r);
        return 2;
    }

// SDK 0.14.9ȍ~łȂƃRpCł܂
#if 1
    // /private/movable.sed ̍쐬
    r = nn::fs::CreateSeed();
    if ( r.IsFailure())
    {
        nn::dbg::PrintResult(r);
        return 3;
    }
#endif

    return 0;
}


// m_recvBuffer  SecureInfop̏Ƃ݂ȂASecureInfo
// VAio[́Aŝ̂擾AēxށB
void TcpComm::RecvBuffer_WriteAsSecureInfo(void)
{
    nn::Result r;
    nn::cfg::CTR::detail::SecureInfoBody  sib;
    nn::cfg::CTR::detail::SecureInfoBody* pSib;
    pSib = &sib;

    // SecureInfoBody擾iVANO擾j
    r = GetSecureInfoBody(pSib);
    if ( r.IsFailure())
    {
        NN_LOG("GetSecureInfo failed.\n");
        nn::dbg::PrintResult(r);
    }

    // SecureInfo  SecureInfoBodyƏZbgB
    r = SetSecureInfo(pSib, m_recvBuffer);
    if ( r.IsFailure())
    {
        NN_LOG("SetSecureInfo failed.\n");
        nn::dbg::PrintResult(r);
    }

    // f[^NANDɏ
    r = FlushSecureInfo();
    if ( r.IsFailure())
    {
        NN_LOG("FlushSecureInfo failed.");
        nn::dbg::PrintResult(r);
    }
}

//------------------------------------------------------------------
// pR}h
//------------------------------------------------------------------

//
// Ώۃf[^P(LocalFriendCodeSeedBody)擾
//
bool TcpComm::GetBody1(const CommPack &cp)
// sha256
#if 0
{
    u8 sha256[32];
    u8 * u8Ptr = sha256;
    u8 * u8DispPtr;

    nn::cfg::CTR::detail::LocalFriendCodeSeedBody lfcsb;
    nn::cfg::CTR::detail::LocalFriendCodeSeedBody * lfcsbPtr;
    lfcsbPtr = &lfcsb;

    // LocalFriendCodeSeedBody擾
    nn::cfg::CTR::init::GetLocalFriendCodeSeedBody(lfcsbPtr, true); //hardware resettrue
    u8DispPtr =  reinterpret_cast<u8 *>(lfcsbPtr);
    NN_LOG(" LocalFriendCodeSeedBody:\n  ");
    for(int i=0; i < 16; i++)
    {
        if ( i == 8 ) NN_LOG("\n  ");

        NN_LOG("%02X ", *u8DispPtr);
        u8DispPtr++;
    }
    NN_LOG("\n");

    //SHA256l=32oCgvZ
    NN_LOG("sizeof LocalFriendCodeSeedBody:%d\n",  sizeof(lfcsb));
    nn::crypto::CalculateSha256(u8Ptr,lfcsbPtr,sizeof(lfcsb));

    //arg𐶐
    char arg[64];
    std::memset(arg,      0x00, sizeof(arg));
    u8DispPtr = u8Ptr;
    NN_LOG(" SHA256bit:\n  ");
    for(int i=0; i < 32; i++)
    {
        if ( i == 16 ) NN_LOG("\n  ");

        NN_LOG("%02X ", *u8DispPtr);
        sprintf(arg+i*2, "%02X", *u8DispPtr);
        u8DispPtr++;
    }
    NN_LOG("\n");
    NN_LOG("arg: [%s]\n",arg);

    //response𐶐
    char response [4+4+2+2+32];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}
#else
// sha256gpȂ
{
    u8 * u8DispPtr;

    nn::cfg::CTR::detail::LocalFriendCodeSeedBody lfcsb;
    nn::cfg::CTR::detail::LocalFriendCodeSeedBody * lfcsbPtr;
    lfcsbPtr = &lfcsb;

    // LocalFriendCodeSeedBody擾
    nn::cfg::CTR::init::GetLocalFriendCodeSeedBody(lfcsbPtr, true); //hardware resettrue
    u8DispPtr =  reinterpret_cast<u8 *>(lfcsbPtr);
    NN_LOG(" LocalFriendCodeSeedBody:\n  ");
    for(int i=0; i < 16; i++)
    {
        if ( i == 8 ) NN_LOG("\n  ");

        NN_LOG("%02X ", *u8DispPtr);
        u8DispPtr++;
    }
    NN_LOG("\n");

    //LocalFriendCodeSeedBody=16oCg
    NN_LOG("sizeof LocalFriendCodeSeedBody:%d\n",  sizeof(lfcsb));

    //arg𐶐
    char arg[32];
    std::memset(arg,      0x00, sizeof(arg));
    u8DispPtr =  reinterpret_cast<u8 *>(lfcsbPtr);
    for(int i=0; i < 16; i++)
    {

        NN_LOG("%02X ", *u8DispPtr);
        sprintf(arg+i*2, "%02X", *u8DispPtr);
        u8DispPtr++;
    }
    NN_LOG("\n");
    NN_LOG("arg: [%s]\n",arg);

    //response𐶐
    char response [4+4+2+2+32+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}
#endif


//
//  Ώۃf[^2 (SecureInfo)擾
//
//  SecureInfo:17oCg -> ResponseƂĂ34ԓB
//  A0.10.2ł́ASecureInfo:32oCgƂȂB
bool TcpComm::GetBody2(const CommPack &cp)
#if 0
{
    u8 sha256[32];
    u8 * u8Ptr = sha256;
    u8 * u8DispPtr;

    nn::cfg::CTR::detail::SecureInfoBody   sib;
    nn::cfg::CTR::detail::SecureInfoBody * sibPtr;
    sibPtr = &sib;

    // TODO SecureInfoBody擾 (SDK0.11.x)
    nn::cfg::CTR::init::GetSecureInfoBody(sibPtr);

    u8DispPtr =  reinterpret_cast<u8 *>(sibPtr);
    NN_LOG(" SecureInfoBody:\n  ");
    for(int i=0; i < 17; i++)
    {
        if ( i == 16 ) NN_LOG("\n  ");

        NN_LOG("%02X ", *u8DispPtr);
        u8DispPtr++;
    }
    NN_LOG("\n");

    //SHA256l=32oCgvZ
    NN_LOG("sizeof SecureInfoBody:%d\n",  sizeof(sib));
    nn::crypto::CalculateSha256(u8Ptr,sibPtr,sizeof(sib));

    //arg𐶐
    char arg[64];
    std::memset(arg,      0x00, sizeof(arg));
    u8DispPtr = u8Ptr;
    NN_LOG(" SHA256bit:\n  ");
    for(int i=0; i < 32; i++)
    {
        if ( i == 16 ) NN_LOG("\n  ");

        NN_LOG("%02X ", *u8DispPtr);
        sprintf(arg+i*2, "%02X", *u8DispPtr);
        u8DispPtr++;
    }
    NN_LOG("\n");
    NN_LOG("arg: [%s]\n",arg);

    //response𐶐
    char response [4+4+2+2+32];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}
#else
{
    u8 * u8DispPtr;

    nn::cfg::CTR::detail::SecureInfoBody   sib;
    nn::cfg::CTR::detail::SecureInfoBody * sibPtr;
    sibPtr = &sib;

    NN_LOG("sizeof SecureInfoBody:%d\n",  sizeof(sib));

    // SecureInfoBody擾 (SDK0.11.x)
    nn::cfg::CTR::init::GetSecureInfoBody(sibPtr);

    u8DispPtr = reinterpret_cast<u8 *>(sibPtr);
    NN_LOG(" SecureInfoBody:\n  ");
    for(int i=0; i < 17; i++)
    {
        if ( i == 16 ) NN_LOG("\n  ");

        NN_LOG("%02X ", *u8DispPtr);
        u8DispPtr++;
    }
    NN_LOG("\n");

    //arg𐶐
    char arg[34];
    std::memset(arg,      0x00, sizeof(arg));
    u8DispPtr = reinterpret_cast<u8 *>(sibPtr);
    for(int i=0; i < 17; i++)
    {
        if ( i == 16 ) NN_LOG("\n  ");

        NN_LOG("%02X ", *u8DispPtr);
        sprintf(arg+i*2, "%02X", *u8DispPtr);
        u8DispPtr++;
    }
    NN_LOG("\n");
    NN_LOG("arg: [%s]\n",arg);

    //response𐶐
    char response [4+4+2+2+34+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}
#endif


//ς݃f[^1CTRɏ݁B
bool TcpComm::WriteSign1(const CommPack &cp)
{
    // CNgf[^̍쐬i؂̗pr˂j
    u8  buffer[256];
    for(int i = 0; i < 256; i++)
    {
        buffer[i] = i;
    }

    // cp.arg擪5ĔfB
    char argStr[4];
    std::memset(argStr, 0x00, sizeof(argStr));
    std::memcpy(argStr, cp.Arg, 4);
    //c = cp.Arg[3]; // cp.Arg ́A 16i4ĂB
    int index;
    index = argStr[3] - 0x30;

    char arg[] = "WRITESIGN1(X)";
    u8 rsc = m_cu.SUCCESS;
    s32 result = -1;
    switch(index)
    {
        case 1:
            RecvBuffer_Init();              // Mobt@NA
            AsciiArrayToByteArray(buffer, &cp.Arg[5], 125);
            RecvBuffer_Set(buffer, 0, 125); // ItZbg0125oCg̃f[^Zbg
            arg[11] = '1';
            break;
        case 2:
            AsciiArrayToByteArray(buffer, &cp.Arg[5], 125);
            RecvBuffer_Set(buffer,125, 125);// ItZbg125125oCg̃f[^Zbg
            arg[11] = '2';
            break;
        case 3:
            AsciiArrayToByteArray(buffer, &cp.Arg[5], 6);
            RecvBuffer_Set(buffer,250, 6);  // ItZbg2506oCg̃f[^Zbg
            RecvBuffer_Dump();
            result = RecvBuffer_WriteAsLocalFriendCodeSeed(); //LocalFriendCodeSeed̏ƂăCg
            arg[11] = '3';
            if ( result > 0 )
            {
                arg[10] = 'E';
                rsc = m_cu.FAILURE;
                arg[12] = (result + 0x30);
            }
            break;
        default:
            ULCDPrintfWarn("Argument invalid.\n"); // 1`3łȂƈsƔfB
            rsc = m_cu.FAILURE;
    };//swicth

    //response𐶐
    char response [4+4+2+2+13];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(rsc, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}

bool TcpComm::WriteSign2(const CommPack &cp)
{
    // CNgf[^̍쐬i؂̗pr˂j
    u8  buffer[256];
    for(int i = 0; i < 256; i++)
    {
        buffer[i] = i;
    }

    // cp.arg擪5ĔfB
    char argStr[4];
    std::memset(argStr, 0x00, sizeof(argStr));
    std::memcpy(argStr, cp.Arg, 4);
    //c = cp.Arg[3]; // cp.Arg ́A 16i4ĂB
    int index;
    index = argStr[3] - 0x30;

    char arg[] = "WRITESIGN2(X)";
    u8 rsc = m_cu.SUCCESS;
    switch(index)
    {
        case 1:
            RecvBuffer_Init();              // Mobt@NA
            AsciiArrayToByteArray(buffer, &cp.Arg[5], 125);
            RecvBuffer_Set(buffer, 0, 125); // ItZbg0125oCg̃f[^Zbg
            arg[11] = '1';
            break;
        case 2:
            AsciiArrayToByteArray(buffer, &cp.Arg[5], 125);
            RecvBuffer_Set(buffer,125, 125);// ItZbg125125oCg̃f[^Zbg
            arg[11] = '2';
            break;
        case 3:
            AsciiArrayToByteArray(buffer, &cp.Arg[5], 6);
            RecvBuffer_Set(buffer,250, 6);  // ItZbg2506oCg̃f[^Zbg
            RecvBuffer_Dump();
            RecvBuffer_WriteAsSecureInfo(); // SecureInfoCg
            arg[11] = '3';
            break;
        default:
            ULCDPrintfWarn("Argument invalid.\n"); // 1`3łȂƈsƔfB
            rsc = m_cu.FAILURE;
    };//swicth

    /*Sign1,Sign2ɏmFAOKȂHSMOc
      HSMT[o[ʐMɍsꂽA팟ŊmF邽*/
    if ( HSM_RESTRICT && index == 3)
    {
        nn::Result nnResult1;        
        nn::Result nnResult2;
        
        nnResult1 = ValidateLocalFriendCodeSeed();
        nnResult2 = ValidateSecureInfo();
        if ( nnResult1.IsFailure() || nnResult2.IsFailure() )
        {
            //mFNG
            NN_LOG("Validate Sign Failure.\n");
            rsc = m_cu.FAILURE;
        }
        else
        {
            //mFOK
            uji::seq::ProductionLog *pl = new uji::seq::ProductionLog;
            pl->Initialize();
            uji::seq::Config  *config = new uji::seq::Config;
            uji::seq::LogResult lr;
            lr = pl->Add_1Line(config->Get().TestMode, "Hsm", "OK",  VERSION_STRING, "", "", "", "");
            if (lr != uji::seq::LogResultCode::SUCCESS)
            {
                NN_LOG("Write Hsm Log Failure.\n");
                rsc = m_cu.FAILURE;
            }
            pl->Finalize();
            delete(pl);
            delete(config);
        }
    }
    
    //response𐶐
    char response [4+4+2+2+13];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(rsc, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}


//
bool TcpComm::VerifySignature1(const CommPack &cp)
{
    u8 rsc = m_cu.FAILURE;
    nn::Result r;

    NN_LOG("ValidateLocalFriendCodeSeed ");
    r = ValidateLocalFriendCodeSeed();
    if ( r.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(r);
        rsc = m_cu.FAILURE;
    }
    else
    {
        NN_LOG("succeeded.\n");
        rsc = m_cu.SUCCESS;
    }

    char arg[] = "VALIDATE_SIGN1";
    char response [4+4+2+2+14+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(rsc, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}

bool TcpComm::VerifySignature2(const CommPack &cp)
{
    u8 rsc = m_cu.FAILURE;
    nn::Result r;

    NN_LOG("ValidateSecureInfo ");
    r = ValidateSecureInfo();
    if ( r.IsFailure())
    {
        NN_LOG("failed.\n");
        nn::dbg::PrintResult(r);
        rsc = m_cu.FAILURE;
    }
    else
    {
        NN_LOG("succeeded.\n");
        rsc = m_cu.SUCCESS;
    }

    char arg[] = "VALIDATE_SIGN2";
    char response [4+4+2+2+14+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(rsc, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}

} // namespace import
} // namespace eva
} // namespace uji
