#include "TcpComm.h"

using namespace std;

namespace uji{
namespace eva{
namespace import{

// `: xAs
void TcpComm::ULCDPrintf(char * msg)
{
   NN_LOG(msg);
   m_UpperWindow.Printf(msg);
}

// `: xAs
void TcpComm::ULCDPrintfWarn(char * msg)
{
    m_UpperWindow.SetTextColor(sys::ATTR_COLOR_RED);
    ULCDPrintf(msg);
    m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);
}

// `: 
void TcpComm::ULCDPrintfGood(char * msg)
{
    m_UpperWindow.SetTextColor(sys::ATTR_COLOR_YELLOW);
    ULCDPrintf(msg);
    m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);
}

// `: Mf[^
void TcpComm::ReceiveDataPrint(const string &str)
{
     ULCDPrintfVarg(0,"%s%r%s", " ",str.c_str(),"\n");
}

// `: Mf[^
void TcpComm::SendDataPrint(const string &str)
{
    ULCDPrintfVarg(0,"%s%t%s", ">",str.c_str(),"\n");
}

//------------------------------------------------------------------
// `JX^
//------------------------------------------------------------------
// `: Ȉ ψ
void TcpComm::ULCDPrintfVarg(int type, char * fmt, ...)
{

      if (type == 1)
      {
          m_UpperWindow.SetTextColor(sys::ATTR_COLOR_YELLOW);
      }
      else if ( type == 2)
      {
          m_UpperWindow.SetTextColor(sys::ATTR_COLOR_RED);
      }

      va_list ap;

      int d;
      char c;
      char *s;
      bool isReceive = false;

      va_start(ap, fmt);

      while(*fmt)
      {
        switch (*fmt++)
        {
            case 's':
                s = va_arg(ap, char *);
                NN_LOG("%s",s);
                m_UpperWindow.Printf("%s",s);
                break;
            case 'd':
                d = va_arg(ap, int);
                NN_LOG("%d",d);
                m_UpperWindow.Printf("%d",d);
                break;
            case 'c':
                c = (char) va_arg(ap, int);
                NN_LOG("%c",c);
                m_UpperWindow.Printf("%c",c);
                break;

            case 'r': //MR}hg
                isReceive = true;
            case 't': //MR}hg (R}h̐FႤj
                s = va_arg(ap, char *);
                NN_LOG("%s",s);

                if ( std::strlen(s) >= 10)
                {
                    char * p = NULL;
                    char checkSum[4+1] = "";
                    char commandId[4+1] = "";
                    char argNum[2+1] = "";
                    char resultCode[2+1] = "";

                    std::memset(checkSum,  0x00, sizeof(checkSum));
                    std::memset(commandId, 0x00, sizeof(commandId));
                    std::memset(argNum,    0x00, sizeof(argNum));
                    std::memset(resultCode, 0x00, sizeof(resultCode));

                    p = s;
                    std::memcpy(checkSum, p, 4);
                    p = p+4;
                    std::memcpy(commandId, p, 4);
                    p = p+4;
                    std::memcpy(argNum, p, 2);
                    p = p+2;
                    if ( !isReceive )
                    {
                        std::memcpy(resultCode, p, 2);
                        p = p+2;
                    }

                    m_UpperWindow.SetTextColor(sys::ATTR_COLOR_BLUE);
                    m_UpperWindow.Printf("%s",checkSum);
//                    NN_LOG("checkSum:%s\n",checkSum);

                    if ( isReceive)
                    {
                        m_UpperWindow.SetTextColor(sys::ATTR_COLOR_GREEN);
                    }
                    else
                    {
                        m_UpperWindow.SetTextColor(sys::ATTR_COLOR_MAGENTA);
                    }
                    m_UpperWindow.Printf("%s",commandId);
//                    NN_LOG("commandId:%s\n",commandId);

                    m_UpperWindow.SetTextColor(sys::ATTR_COLOR_CYAN);
                    m_UpperWindow.Printf("%s",argNum);
//                    NN_LOG("argNum:%s\n",argNum);

                    if ( isReceive )
                    {
                        m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);
                        if ( std::strlen(s) > 10)
                        {
                            m_UpperWindow.Printf("%s",p);
//                            NN_LOG("arg:[%s]\n",p);
                        }
                    }
                    else
                    {
                        if (( 0x30 == resultCode[0]) && (0x30 == resultCode[1]))
                        {
                            m_UpperWindow.SetTextColor(sys::ATTR_COLOR_YELLOW);
                        }
                        else
                        {
                            m_UpperWindow.SetTextColor(sys::ATTR_COLOR_RED);// RSC 00ȊO͐
                        }

                        m_UpperWindow.Printf("%s",resultCode);
//                        NN_LOG("resultCode:%s\n",resultCode);

                        m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);
                        if ( std::strlen(s) > 12)
                        {
                            m_UpperWindow.Printf("%s",p);
//                           NN_LOG("arg:[%s]\n",p);
                        }
                    }
                }
                else
                {
                    m_UpperWindow.Printf("%s",s);
                }

                break;
        }
      }

      va_end(ap);

      // F߂
      m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);
}

} // namespace import
} // namespace eva
} // namespace uji
