/*---------------------------------------------------------------------------*
  Project:  Horizon
  File:     main.cpp

  Copyright (C)2009 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

  $Rev: 25559 $
 *---------------------------------------------------------------------------*/

#include <nn/init.h>
#include <nn/os.h>
#include <nn/socket.h>
#include <nn/ac.h>
#include <nn/math.h>
#include "TcpComm.h"

namespace uji{
namespace eva{

void TcpComm::SDKDemo( void )
{
    nn::Result result;
    
    do
    {

        {
            NN_LOG("Initializing socket..\n");
            
            // ̃Xbh\Pbg API 𗘗p
            const s32    sessionCount           = 1;
            // \Pbg̑Mobt@Ƃ 64 KB 蓖
            const size_t bufferSizeForSockets   = 65536;
            // \PbgCuɕKvȃ[NTCY߂
            const size_t workSizeForLibrary     = nn::socket::GetRequiredMemorySize(bufferSizeForSockets, sessionCount);

            // [Nmۂ 4KB ɃACɂ
            u8* pWorkMemory = new u8[workSizeForLibrary + 4096];
            uptr workMemoryAddress = nn::math::RoundUp<uptr>(reinterpret_cast<uptr>(pWorkMemory), 4096);

            // \PbgCȕ
            result = nn::socket::Initialize(workMemoryAddress, workSizeForLibrary, bufferSizeForSockets, sessionCount);
            NN_UTIL_PANIC_IF_FAILED(result);
            
            {
                s32 ret;
                nn::socket::InAddr addr, netmask;
                ret = nn::socket::GetPrimaryAddress(reinterpret_cast<u8*>(&addr), reinterpret_cast<u8*>(&netmask));
                NN_ASSERT(ret == 0);
                NN_LOG("host       : %s\n", nn::socket::InetNtoA(addr));
                NN_LOG("netmask    : %s\n", nn::socket::InetNtoA(netmask));

                nn::socket::InAddr dns1, dns2;
                ret = nn::socket::GetResolver(reinterpret_cast<u8*>(&dns1), reinterpret_cast<u8*>(&dns2));
                if (ret == 0)
                {
                    NN_LOG("dns1       : %s\n", nn::socket::InetNtoA(dns1));
                    NN_LOG("dns2       : %s\n", nn::socket::InetNtoA(dns2));
                }

                nn::socket::InAddr gateway;
                ret = nn::socket::GetDefaultGateway(reinterpret_cast<u8*>(&gateway));
                if (ret == 0)
                {
                    NN_LOG("gateway    : %s\n", nn::socket::InetNtoA(gateway));
                }

                NN_LOG("\n");
#ifndef NN_SWITCH_DISABLE_DEBUG_PRINT
                nn::socket::DumpRoutingTable();
#endif
                NN_UNUSED_VAR(ret);
            }

            {
                s32 socket = nn::socket::Socket(nn::socket::PF_INET, nn::socket::SOCK_STREAM, 0);
                NN_LOG("socket = %d\n", socket);

                nn::socket::SockAddrIn server_addr;
                server_addr.len = sizeof(nn::socket::SockAddrIn);
                server_addr.family = nn::socket::AF_INET;
                server_addr.addr.addr = 0;
                server_addr.port = nn::socket::HtoNs(100);

                s32 ret = nn::socket::Bind(socket, &server_addr);
                NN_LOG("bind = %d\n", ret);

                ret = nn::socket::Listen(socket, 1);
                NN_LOG("listen = %d\n", ret);

                nn::socket::Close(socket);
                NN_UNUSED_VAR(ret);
            }

            NN_LOG("Finalizing socket..\n");
            // \PbgCȕI
            result = nn::socket::Finalize();
            NN_UTIL_PANIC_IF_FAILED(result);

            // \PbgCu Finalize ΃[N̈ėpł܂B
            delete [] pWorkMemory;
        }
        

    } while(false);
}

} // namespace eva
} // namespace uji
