#include "TcpComm.h"
#include <nn/socket/socket_DummyUtil.h>
#include <nn/os.h>
#include <nn/ac.h>
#include <nn/ac/CTR/private/ac_InternalApi.h>
#include <nn/ac/CTR/private/ac_PrivateApi.h>

using namespace nn::socket;

namespace uji{
namespace eva{

namespace import{

// -- lbg[Nڑ̗ --
//
// 1. acCȕ       AcInit
// 2. acł̃RlNg             AcConnect

// 3. socketCȕ   SocketInit
// 4. socket̐Bind         SocketCreate
// 5. pctcp|[g֐ڑ        SocketConnect
//
// 6. socket̃N[Y           SocketClose

// 7. ac̃N[Y               AcClose
// 8. ac̃t@CiCY         AcFinalize

//------------------------------------------------------------------------------
// ACCȕAAPڑpConfig(pX[h)ݒ
//------------------------------------------------------------------------------
//    SSID      : "N-WAP" WAP̃VAio[̉4
//    PASS      : "N-WAP0000"
//    Fؕ  : WPA2_AES
bool TcpComm::AcInit(sys::GraphicsDrawing* gfx)
{
    nn::Result r;

    static bool initDone = false;
    if ( initDone )
    {
        return true;  //ɎsĂ΁Aɖ߂B
    }

    nn::fs::Initialize();

    ULCDPrintf("ac::CTR::InitializeInternal ... ");
    DRAW_LCD(gfx);
    r = nn::ac::CTR::InitializeInternal();
    if ( r.IsFailure())
    {
        ULCDPrintfWarn("failed.\n");
        nn::dbg::PrintResult(r);
        return false;
    }
    ULCDPrintf("done.\n");
    DRAW_LCD(gfx);

    u8 key[64];
    // WAP̃pX[h (TODO IɃwb_)
    key[0] = 'N';
    key[1] = '-';
    key[2] = 'W';
    key[3] = 'A';
    key[4] = 'P';

    key[5] = '0';
    key[6] = '0';
    key[7] = '0';
    key[8] = '0';

    NN_UNUSED_VAR( key )

#if 0
    r = nn::ac::DebugSetNetworkSetting1( reinterpret_cast<const u8*>(m_SSID),
                                                       std::strlen(m_SSID),
                                                       nn::ac::WPA2_AES, key, 9 );

    if ( r.IsFailure())
    {
        ULCDPrintfWarn("ac::DebugSetNetworkSetting1 failed.\n");
        nn::dbg::PrintResult(r);
        return false;
    }

#else

//    nn::ac::NetworkSetting  ns;
    m_ns.wireless.enable = true;
    m_ns.wireless.editableEssidSecurity = true;
    memcpy( m_ns.wireless.essidSecurity.ssid, m_SSID, std::strlen(m_SSID));
    m_ns.wireless.essidSecurity.ssidLength = std::strlen(m_SSID);
    m_ns.wireless.essidSecurity.securityMode = nn::ac::WPA2_AES;

    memcpy( m_ns.wireless.essidSecurity.passphrase, key, 9 );
    r = nn::ac::ConvertPassphraseToPsk(
            key,
            9,
            m_ns.wireless.essidSecurity.ssid,
            m_ns.wireless.essidSecurity.ssidLength,
            m_ns.wireless.essidSecurity.key,
            nn::nwm::WPA_PSK_SIZE );

    if ( r.IsFailure())
    {
        ULCDPrintfWarn("ac::ConvertPassphraseToPsk failed.\n");
        nn::dbg::PrintResult(r);
        return false;
    }


    // UpdateNetworkSetting
    m_ns.ip.enableDHCP = true;
    m_ns.ip.autoDNSSetting = true;
    m_ns.scanlessConnect.hasConnected = false;

    r = nn::ac::UpdateNetworkSetting(0, m_ns);
    if ( r.IsFailure())
    {
        ULCDPrintfWarn("ac::UpdateNetworkSetting failed.\n");
        nn::dbg::PrintResult(r);
        return false;
    }

    // FlushNetworkSetting
    r = nn::ac::FlushNetworkSetting();
    if ( r.IsFailure())
    {
        ULCDPrintfWarn("ac::FlushNetworkSetting failed.\n");
        nn::dbg::PrintResult(r);
        return false;
    }

#endif


    r = nn::ac::CreateDefaultConfig( &m_config );
    if ( r.IsFailure())
    {
        ULCDPrintfWarn("ac::CreateDefaultConfig failed.\n");
        nn::dbg::PrintResult(r);
        return false;
    }

//    r = nn::ac::DebugSetNetworkArea( &m_config, nn::ac::NETWORK_AREA_LAN );
    r = nn::ac::SetNetworkArea( &m_config, nn::ac::NETWORK_AREA_LAN );
    if ( r.IsFailure())
    {
        ULCDPrintfWarn("ac::SetNetworkArea failed.\n");
        nn::dbg::PrintResult(r);
        return false;
    }

    initDone = true;

    DRAW_LCD(gfx);
    return true;
}

//------------------------------------------------------------------------------
// APւ̐ڑ݂
//------------------------------------------------------------------------------
//static nn::os::Event m_DisconnectEvent(false);

void TcpComm::DisconnectWaitThread()
{
//    NN_LOG( "Start disconnect event wait.\n" );
    m_DisconnectEvent.Wait();
//    NN_LOG( "Signal disconnect event!\n" );
}


bool TcpComm::AcConnect(sys::GraphicsDrawing* gfx)
{
    nn::Result nnr;

    m_DisconnectEvent.Initialize(false);
    nn::ac::RegisterDisconnectEvent( &m_DisconnectEvent );

    ULCDPrintfVarg(0,"%s%s%s","ac::Connect AccessPoint(ssid=",m_SSID, ") ... ");
    DRAW_LCD(gfx);

//    nnr = nn::ac::Connect( m_config );
    nnr = nn::ac::ConnectWithoutEula( m_config );
    if( nnr.IsFailure())
    {
        ULCDPrintfWarn("failed.\n");
        nn::dbg::PrintResult(nnr);
        return false;
    }

    ULCDPrintfGood("succeeded!\n");
    DRAW_LCD(gfx);
    return true;
}

//------------------------------------------------------------------------------
// SocketgpāATCPT[oiPC)֐ڑ݂
//------------------------------------------------------------------------------
bool TcpComm::SocketConnect(sys::GraphicsDrawing* gfx)
{
    s32 ret;
    // ServerpSockAddrIn̐ݒ
    m_TcpServer.len       = sizeof(nn::socket::SockAddrIn);
    m_TcpServer.port      = nn::socket::HtoNs( m_targetPortNum );
    m_TcpServer.family    = PF_INET;
    nn::socket::InAddr TargetIpAddr;
    nn::socket::InetAtoN("192.168.11.2", &TargetIpAddr);
    m_TcpServer.addr      = TargetIpAddr;

    ULCDPrintfVarg(0,"%s%s%s","socket::Connect TcpServer ",nn::socket::InetNtoA(TargetIpAddr)," ... ");
    DRAW_LCD(gfx);
    ret = nn::socket::Connect(m_sock, &m_TcpServer);
    if ( ret != 0)
    {
        ULCDPrintfWarn("failed.\n");
        return false;
    }

    ULCDPrintfGood("succeeded!\n");
    DRAW_LCD(gfx);
    return true;
}

//------------------------------------------------------------------------------
// ac::close
//------------------------------------------------------------------------------
bool TcpComm::AcClose(sys::GraphicsDrawing * gfx)
{
    nn::Result r;

    // ac::close
    ULCDPrintf("ac::Close ... ");
    DRAW_LCD(gfx);
    r = nn::ac::Close();
    if ( r.IsFailure())
    {
       ULCDPrintf("failed.\n");DrawUpperLCD(gfx);
       return false;
    }
    else
    {
       ULCDPrintf("done.\n");DrawUpperLCD(gfx);
    }
    DRAW_LCD(gfx);
    return true;
}

//------------------------------------------------------------------------------
// AC̏Iiacfinalize)
//------------------------------------------------------------------------------
bool TcpComm::AcFinalize(sys::GraphicsDrawing * gfx)
{
    DRAW_LCD(gfx);
#if 0
    nn::Result r;

    // ac::Finalize
    ULCDPrintf("ac::FinalizeInternal ... ");
    DRAW_LCD(gfx);
    r = nn::ac::FinalizeInternal();     // ڑI
    if ( r.IsFailure())
    {
        ULCDPrintf("failed.\n");
        DRAW_LCD(gfx);
        return false;
    }
    ULCDPrintf("done.\n");
    DRAW_LCD(gfx);
#endif
    return true;
}

//------------------------------------------------------------------------------
// SocketCu
//------------------------------------------------------------------------------
bool TcpComm::SocketInit(sys::GraphicsDrawing* gfx)
{
    nn::Result nnr;

    static bool initDone = false;
    if ( initDone )
    {
        return true;  //ɎsĂ΁Aɖ߂B
    }

    ULCDPrintf("socket::Initialize ... ");
    DRAW_LCD(gfx);

    nnr = nn::socket::Initialize();
    if( nnr.IsFailure())
    {
        ULCDPrintfWarn("failed.\n");
        nn::dbg::PrintResult(nnr);
    }
    else
    {
        ULCDPrintf("done.\n");
    }

    initDone = true;
    DRAW_LCD(gfx);
    return true;
}

//------------------------------------------------------------------------------
// Socket𐶐ABind
//------------------------------------------------------------------------------
bool TcpComm::SocketCreate(sys::GraphicsDrawing* gfx)
{
    nn::Result r;

    //IP\
    nn::socket::InAddr myAddr;
    myAddr.addr = nn::socket::GetHostId();
    ULCDPrintfVarg(TCPCOMM_COLOR_WHITE, "%s%s%s", " CTR IP=",nn::socket::InetNtoA(myAddr),"\n");
    DRAW_LCD(gfx);

    //Socket𐶐
    m_sock = Socket(PF_INET, SOCK_STREAM, 0);
    if (m_sock < 1)
    {
        ULCDPrintfVarg(TCPCOMM_COLOR_RED,"%s%d%s","socket create failed(",m_sock,").\n");
        DRAW_LCD(gfx);
        return false;
    }
    ULCDPrintfVarg(TCPCOMM_COLOR_WHITE,"%s%d%s","socket create done(",m_sock,").\n");
    DRAW_LCD(gfx);

    //pSockAddrInݒ
    m_TcpClient.len       = sizeof(nn::socket::SockAddrIn);
    m_TcpClient.port      = nn::socket::HtoNs(m_myPortNum);//CTR̃|[g͂ԂȂł悢͂B
    m_TcpClient.family    = PF_INET;
    m_TcpClient.addr      = myAddr;

    //Bind (̏ꍇA߂l0)
    s32 ret;
    ret = Bind(m_sock, &m_TcpClient);
    if( 0 != ret )
    {
        ULCDPrintfVarg(TCPCOMM_COLOR_RED,"%s%d%s","socket::Bind failed(",ret,").\n");
        DrawUpperLCD(gfx);
        return false;
    }
    ULCDPrintfVarg(TCPCOMM_COLOR_WHITE,"%s%d%s","socket::Bind done(",m_sock,").\n");
    DRAW_LCD(gfx);

    return true;
}

//------------------------------------------------------------------------------
// SocketClose
//------------------------------------------------------------------------------
bool TcpComm::SocketClose(sys::GraphicsDrawing * gfx)
{
    NN_LOG("m_sock :%d\n", m_sock);
    if ( m_sock > 0 )
    {
        ULCDPrintfVarg(TCPCOMM_COLOR_WHITE,"%s%d%s","socket::Close (",m_sock,") ...");
        nn::socket::Close(m_sock);
        ULCDPrintf("done.\n");
        m_sock = -1;
        DRAW_LCD(gfx);
        return false;
    }
    m_sock = -1;
    DRAW_LCD(gfx);
    return true;
}

//------------------------------------------------------------------------------
// SocketFinalize 
//------------------------------------------------------------------------------
bool TcpComm::SocketFinalize(sys::GraphicsDrawing * gfx)
{
    DRAW_LCD(gfx);
#if 0
    nn::socket::Finalize();
    ULCDPrintf("socket::Finalize done.\n");
    DRAW_LCD(gfx);
#endif
    return true;
}


//------------------------------------------------------------------------------
// ڑ
//------------------------------------------------------------------------------
bool TcpComm::Connect(sys::GraphicsDrawing * gfx)
{
//   nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(500));

    if (false == AcInit(gfx))         return false;

    if (false == AcConnect(gfx))      goto FIN3;

    if (false == SocketInit(gfx))     goto FIN2;

    if (false == SocketCreate(gfx))   goto FIN1;

    if (false == SocketConnect(gfx))  goto FIN1;

    return true;

FIN1:
    SocketFinalize(gfx);
FIN2:
    AcClose(gfx);
FIN3:
    AcFinalize(gfx);

    NN_LOG("connect failed. return false.\n");
    return false;
}

//------------------------------------------------------------------------------
// ؒf
//------------------------------------------------------------------------------
bool TcpComm::Disconnect(sys::GraphicsDrawing * gfx)
{
//   nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(500));

    SocketClose(gfx);

    if (false == SocketFinalize(gfx)) goto FIN2;

    if (false == AcClose(gfx))        goto FIN3;

    if (false == AcFinalize(gfx))     return false;

    return true;

FIN2:
    AcClose(gfx);
FIN3:
    AcFinalize(gfx);

    NN_LOG("disconnect failed. return false.\n");
    return false;
}


//------------------------------------------------------------------------------
// ڑؒf܂
//------------------------------------------------------------------------------
bool TcpComm::ConnectBatch(sys::GraphicsDrawing * gfx)
{
//   nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(500));

    if (false == AcInit(gfx))         return false;

    if (false == AcConnect(gfx))      goto FIN3;

    if (false == SocketInit(gfx))     goto FIN2;

    if (false == SocketCreate(gfx))   goto FIN1;

    if (false == SocketConnect(gfx))  goto FIN1;

    if (false == SocketClose(gfx))    goto FIN1;

    if (false == SocketFinalize(gfx)) goto FIN2;

    if (false == AcClose(gfx))        goto FIN3;

    if (false == AcFinalize(gfx))     return false;

    return true;

FIN1:
    SocketFinalize(gfx);

FIN2:
    AcClose(gfx);

FIN3:
    AcFinalize(gfx);

    return false;
}

//------------------------------------------------------------------------------
// AI͍sȂ
//------------------------------------------------------------------------------
bool TcpComm::ConnectBatch_NoAcInit(sys::GraphicsDrawing * gfx)
{
    if (false == AcConnect(gfx))      return false;

    if (false == SocketInit(gfx))     goto FIN2;

    if (false == SocketCreate(gfx))   goto FIN1;

    if (false == SocketConnect(gfx))  goto FIN1;

    if (false == SocketClose(gfx))    goto FIN1;

    if (false == SocketFinalize(gfx)) goto FIN2;

    if (false == AcClose(gfx))        return false;

    return true;

FIN1:
    SocketFinalize(gfx);

FIN2:
    AcClose(gfx);

    return false;
}



} // namespace import
} // namespace eva
} // namespace uji
