#include "TcpComm.h"
#include "../../seq/TesterLog/InspectLog.h"
#include "../seq/TestListManager.h"
#include "../procchk/ProcessCheck.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji::sys;
using namespace uji::seq;

namespace uji{
namespace eva{

namespace import{

//------------------------------------------------------------------------------
// R}hs
//------------------------------------------------------------------------------
void TcpComm::ExecuteCommand(CommPack & cp)
{
#if 1
    NN_LOG("cp:CheckSum:%d\n", cp.CheckSum);
    NN_LOG("cp:CommID:%d\n",   cp.CommID);
    NN_LOG("cp:ArgNum:%d\n",   cp.ArgNum);
    NN_LOG("cp:Arg:[%s]\n",    cp.Arg);
#endif

    switch(cp.CommID)
    {
        // f[^P
        case 0x0611:
             GetBody1(cp);break;
        case 0x0613:
             WriteSign1(cp);break;
        case 0x0617:
             VerifySignature1(cp);break;

        // f[^Q
        case 0x0621:
             GetBody2(cp);break;
        case 0x0623:
             WriteSign2(cp);break;
        case 0x0627:
             VerifySignature2(cp);break;

        // f[^XgpR}h
        case 0x0631:
             GetSystemMenuRegion(cp);break;
//        case 0x0632:
//             GetSystemMenuVersion(cp);break;
        case 0x0633:
             GetSystemMenuNupVersion(cp);break;
        case 0x0634:
             GetSystemMenuCupVersion(cp);break;
        case 0x0635:
             GetSystemMenuPreInstallVersion(cp);break;
        case 0x0641:
             GetInstallApplicationNum(cp);break;
        case 0x0642:
             GetInstallApplicationDesc(cp);break;
        case 0x0651:
             GetCommunicationModuleNum(cp);break;
        case 0x0652:
             GetCommunicationModuleDesc(cp);break;
        case 0x0680:
             NotifyDataListStatus(cp);break; // f[^Xg MXe[^Xʒm


        // CTR{̂̏擾R}h (̃vOƋpj
        case 0x0801:
             GetMacAddress(cp);break;
             
        case 0x0806:
             GetSerialNumber(cp);break;

        case 0x0807:
             SetSerialNumber(cp);break;

        case 0x0808:
             GetDeviceID(cp);break;

        case 0x0809:
             GetEmsLabel(cp);break;

        case 0x0820:
             GetPlatform(cp);break;

        //HGpRgt@C
        case 0x0821:
             GetComment(cp);break;

        case 0x0822:
             WriteComment(cp);break;

        //[W`FbNR}hidBS_W)
        case 0x0823:
             CheckRegion(cp);break;

        case 0x0824:
             CheckSerialNo(cp);break;

        // eX^[R}h
        case 0x0901:
             GetProgramVersion(cp);break;

        case 0x0902:
             GetBuildDate(cp);break;
    }//switch
}

//------------------------------------------------------------------------------
// vOo[W擾
//------------------------------------------------------------------------------
bool TcpComm::GetProgramVersion(const CommPack &cp)
{
    char arg[4+1];
    std::memset(arg, 0x00, sizeof(arg));
    std::memmove(arg, VERSION_STRING, sizeof(arg));

    //response𐶐
    char response [4+4+2+2+4+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}

//------------------------------------------------------------------------------
// rh擾
//------------------------------------------------------------------------------
bool TcpComm::GetBuildDate(const CommPack &cp)
{
    char arg[40+1];
    std::memset(arg, 0x00, sizeof(arg));
    std::memmove(arg, m_versionDate, sizeof(arg));

    //response𐶐
    char response [4+4+2+2+40+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}

//------------------------------------------------------------------------------
// MACAhX擾
//------------------------------------------------------------------------------
bool TcpComm::GetMacAddress(const CommPack &cp)
{
    char arg[12+1];
    std::memset(arg,  0x00, sizeof(arg));

    std::sprintf(arg, "%02X%02X%02X%02X%02X%02X", m_macAddress[0],
                                                  m_macAddress[1],
                                                  m_macAddress[2],
                                                  m_macAddress[3],
                                                  m_macAddress[4],
                                                  m_macAddress[5]);

    //response𐶐
    char response [4+4+2+2+12+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}

//------------------------------------------------------------------------------
// vbgtH[擾
//------------------------------------------------------------------------------
bool TcpComm::GetPlatform(const CommPack &cp)
{
    char arg[2+1];
    std::memset(arg, 0x00, sizeof(arg));
    
    
    if ( uji::sys::PLATFORM_CTR == uji::sys::GetPlatformType())
    {
		std::sprintf(arg, "%02d", TCPCOMM_PLATFORM_CTR);
	}
	else if ( uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType())
	{
		std::sprintf(arg, "%02d", TCPCOMM_PLATFORM_SPFL);
	}
    else if ( uji::sys::PLATFORM_KTR == uji::sys::GetPlatformType())
    {
		std::sprintf(arg, "%02d", TCPCOMM_PLATFORM_SNAKE);
	}
    else if ( uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType())
	{
		std::sprintf(arg, "%02d", TCPCOMM_PLATFORM_FLOWER);
	}


    //response𐶐
    char response [4+4+2+2+2+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}

//------------------------------------------------------------------------------
// Rg擾
//------------------------------------------------------------------------------
bool TcpComm::GetComment(const CommPack &cp)
{
    char arg[40+1];
    std::memset(arg, 0x00, sizeof(arg));

    LogResult lr;
    InspectLog * il = new InspectLog();
    lr = il->Initialize();
    NN_LOG("GC lr=[%d]\n",lr);
    if ( LogResultCode::SUCCESS == lr )
    {
        std::memmove(arg, il->Get_Comment().c_str(), sizeof(arg));
    }
    delete il;

    NN_LOG("arg=[%s]\n",arg);

    //response𐶐
    char response [4+4+2+2+40+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));

    if ( LogResultCode::SUCCESS == lr )
    {
        p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    }
    else
    {
        p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.FAILURE, arg));
    }

    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}

//------------------------------------------------------------------------------
// Rgݒ肷
//------------------------------------------------------------------------------
bool TcpComm::WriteComment(const CommPack &cp)
{
#if 0
    NN_LOG("WC cp:CheckSum:%d\n", cp.CheckSum);
    NN_LOG("WC cp:CommID:%d\n",   cp.CommID);
    NN_LOG("WC cp:ArgNum:%d\n",   cp.ArgNum);
    NN_LOG("WC cp:Arg:[%s]\n",    cp.Arg);
#endif

    char arg[40+1];
    int argLength = 0;

    argLength = strlen(cp.Arg);
    std::memset(arg, 0x00,   sizeof(arg));
    std::memcpy(arg, cp.Arg, argLength);

    //
    // comment, commentDate ̐ݒ
    //
    char comment     [20+1];
    char commentDate [10+1];// 2010/12/18

    // # 
    int commentLength = 0;
    char * ptr;
    ptr = arg;
    for(int i=0; i < sizeof(arg) ;i++)
    {
        if ( '#' == *ptr) { commentLength = i; break;}
        ptr++;
    }
    NN_LOG("commentLength :%d\n",commentLength);

    // commentݒ
    std::memset(comment, 0x00, sizeof(comment));
    std::memcpy(comment, arg,  commentLength);

    // commentDateݒ
    int commentDateLength = 0;
    ptr++;  //'#'skip
    std::memset(commentDate, 0x00, sizeof(commentDate));
    commentDateLength = argLength - commentLength -1;
    std::memcpy(commentDate, ptr,  commentDateLength);

#if 0
    NN_LOG("comment      [%s]\n",comment);
    NN_LOG("commentLength[%d]\n",commentLength);
    NN_LOG("commentDate      [%s]\n",commentDate);
    NN_LOG("commentDateLength[%d]\n",commentDateLength);
#endif


    LogResult lr;
    InspectLog * il = new InspectLog();
    lr = il->Initialize();


    il->Clear_DataStructure();
    lr = il->Set_Comment(comment,commentDate);
    lr = il->Create_DataStructure();
    lr = il->Calc_DataHash();
    lr = il->WriteProc();
    delete il;

    //response𐶐
    char response [4+4+2+2+40+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));

    if ( LogResultCode::SUCCESS == lr )
    {
        p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    }
    else
    {
        p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.FAILURE, arg));
    }

    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}


//------------------------------------------------------------------------------
// [W`FbNs
//------------------------------------------------------------------------------
bool TcpComm::CheckRegion(const CommPack &cp)
{
    char arg[40+1];
    std::memset(arg, 0x00, sizeof(arg));
    bool result;

    uji::seq::TestResult tr;
    if ( true == uji::eva::procchk::Invoke_CheckRegion(tr))
    {
       std::memmove(arg, "1", sizeof(arg));
    }
    else
    {
       std::memmove(arg, "0", sizeof(arg));
    }
    NN_LOG("arg=[%s]\n",arg);

   //response𐶐
    char response [4+4+2+2+40+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));

    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}


//------------------------------------------------------------------------------
// VAio[`FbNs
//------------------------------------------------------------------------------
bool TcpComm::CheckSerialNo(const CommPack &cp)
{
    char arg[40+1];
    std::memset(arg, 0x00, sizeof(arg));
    bool result;

    uji::seq::TestResult tr;
    if ( true == uji::eva::procchk::Invoke_CheckSerialNo(tr))
    {
       std::memmove(arg, "1", sizeof(arg));
    }
    else
    {
       std::memmove(arg, "0", sizeof(arg));
    }
    NN_LOG("arg=[%s]\n",arg);

   //response𐶐
    char response [4+4+2+2+40+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));

    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}


//------------------------------------------------------------------------------
// EMSx̎擾s(ʏo͗p)
//------------------------------------------------------------------------------
bool TcpComm::GetEmsLabel(const CommPack &cp)
{
    char arg[40+1];
    std::memset(arg, 0x00, sizeof(arg));

    uji::seq::ProductionLog * productionLog = new uji::seq::ProductionLog;
    productionLog->Initialize();

    int id = -1;
    id = productionLog->Get_LatestLogEntryIndex("EmsLabel"); // EMSx̍ŐVO
    if ( id == -1 )
    {
        std::memmove(arg, "", sizeof(arg));
    }
    else
    {
        LogEntry logEntry;
        logEntry = productionLog->Get_LogEntry(id);
        std::memmove(arg, logEntry.message, sizeof(arg));
    }
    delete productionLog;
    
    //response𐶐
    char response [4+4+2+2+40+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));

    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");

    return true;
}


//------------------------------------------------------------------------------
// f[^XgpR}h
//------------------------------------------------------------------------------
bool TcpComm::NotifyDataListStatus(const CommPack &cp)
{

    // cp.Arg𔻒肷
    if (( '0' == cp.Arg[0] ) && ('0' == cp.Arg[1]))
    {
        m_ListenerMode_Result = true;
    }
    else
    {
        m_ListenerMode_Result = false;
    }

    // O܂B

    // Config̃`FbNR[h擾
    uji::seq::Config  *c = new uji::seq::Config;

    // ObZ[W̍쐬
    char message[80+1];
    std::memset(message, 0x00, sizeof(message));

    // vCXg[o[W擾ł preInstallOɎc
    if (( strlen(m_preInstallVersion) > 0 ))
    {
        sprintf(message, "nup:%s cup:%s preInstall:%s", m_nupVersion, m_cupVersion, m_preInstallVersion);
    }
    else
    {
        sprintf(message, "nup:%s cup:%s", m_nupVersion, m_cupVersion);
    }

    // OpIuWFNg
    uji::seq::LogResult  lr;
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->Initialize();

    if (true == m_ListenerMode_Result )
    {
        lr = pl->Add_1Line(c->Get().TestMode,"DataList", "OK",  VERSION_STRING, "","","",message);
    }

    pl->Finalize();

    delete pl;
    delete c;

   //response𐶐
    char arg[40+1];
    std::memset(arg, 0x00, sizeof(arg));

    if ((true == m_ListenerMode_Result ) && ( LogResultCode::SUCCESS == lr ))
    {
        sprintf(arg, "NOTIFY SUCCESS");
    }
    else
    {
        sprintf(arg, "NOTIFY FAILURE RECEIVED");
    }

    char response [4+4+2+2+40+1];
    const char * p = response;
    std::memset(response, 0x00, sizeof(response));

    if ( m_ListenerMode_Result )
    {
        p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    }
    else
    {
        p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.FAILURE, arg));
    }

    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]\n",p);
        MySendToSimple(p, std::strlen(p));
    }
    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;

//    return SendResponse("NOTIFY RECEIVED",cp);
}

} // namespace import
} // namespace eva
} // namespace uji
