/*---------------------------------------------------------------------------*
  Project:  CTR_UJI
  File:     TcpComm.h

  Copyright (C)2010 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#ifndef IMPORT_TCP_COMM_H_
#define IMPORT_TCP_COMM_H_

#include "sys.h"
#include <nn/socket.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include "../eva/wireless/CommandUtil.h"
#include "../../seq/TesterLog/ProductionLog.h"
#include "../../seq/Config.h"
#include <nn/ac.h>
#include <nn/ac/CTR/private/ac_InternalApi.h>
#include <nn/ac/CTR/private/ac_PrivateApi.h>

//#pragma diag_suppress 1301

namespace
{
//  AC Config
    static nn::ac::Config m_config;
//    static nn::ac::Config m_configMirror;
}


namespace uji{
namespace eva{

void OpenImportMenu();

    static       u16   m_ListenerEndCommandId;  //Listener[hIƂ̃R}h

//
// }N`
//
#define DRAW_LCD(arg) { DrawUpperLCD(arg); DrawLowerLCD(arg);arg->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);}
// F
#define TCPCOMM_COLOR_WHITE   0
#define TCPCOMM_COLOR_YELLOW  1
#define TCPCOMM_COLOR_RED     2

#define TCPCOMM_PLATFORM_CTR    1
#define TCPCOMM_PLATFORM_SPFL   2
#define TCPCOMM_PLATFORM_FLOWER 3
#define TCPCOMM_PLATFORM_CLOSER 4
#define TCPCOMM_PLATFORM_SNAKE  5

//============================================================================
//
//  ApplicationDesc NX(\́j
//
//============================================================================
#define PRODUCT_CODE_LEN  20
class ApplicationDesc
{
public:
    s64  titleId;
    s32  ciaVersion;
    char productCode [ PRODUCT_CODE_LEN +1];
};


//============================================================================
//
//  CommunicationModule NX(\́j
//
//============================================================================
class CommunicationModule
{
    char name       [20 +1];//W[
    char macAddress [12 +1];//}bNAhX(6oCg)
};


//==============================================================================
//
// TcpCommNX
//
//==============================================================================
class TcpComm
{
protected:
                 u8   m_serialNo[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN +1];//VANO
                 bit8 m_macAddress[6];         //MACAhX
                 char m_macAddressHyphenStr[12+5+1]; //MACAhX(ʕ\p)
                 char m_macAddressChar     [12+1];   //MACAhX(f[^Xgp)
                 char m_versionDate[40+1];     //ʏ20
                 char m_programVersion[4+1];   //ʏ4
                 NN_PADDING1;

                 char m_rspVersion[20+1];      //RSPo[W
                 char m_cupVersion[11+1];      //CUPo[W (255.255.255 => 3+1+3+1+3=11)
                 char m_nupVersion[4+1];       //NUPo[W
                 char m_preInstallVersion[3+1];//PreInstallo[W(At@xbg3)
                 char m_systemMenuRegion[1+1]; //SystemMenuRegion

                 bool m_ListenerEndCommandAsTrue; //Xi[[h̑UgendcommadMtrueƂ邩ǂ
                 bool m_ListenerMode_Result;      //Xi[[h̑Ug

     ApplicationDesc  m_ApplicationDescTable[256]; //ApplicationDesc̃e[u

                 u8   m_recvBuffer[256];     //Mobt@

      nn::os::Event m_DisconnectEvent;  //fBXRlNgCxg

                 u32  m_targetPortNum;    //ڑ|[gԍ
    static const u32  m_myPortNum = 1000; //CTR|[gԍ
    static const u8   MAX_SSID_SIZE  = 32;
    static const u8   padding1[3];
                 char m_SSID[ MAX_SSID_SIZE ]; //APSSID


    nn::socket::SockAddrIn m_TcpClient;        //CTR
    nn::socket::InAddr     m_MyIpAddress;

                 u32   m_frameLoop     ;//t[JE^Ɏgp

    sys::WindowManager m_WindowManager; //EBhE}l[W
    sys::TextWindow    m_UpperWindow;   //EBhE
    sys::TextWindow    m_LowerWindow;   //EBhE

    static const int FONT_SIZE         =14;//tHgTCY

    static const u16 MAX_RECEIVE_LOOP = 1000;  //M[vől
    static const u16 padding3;

    nn::ac::NetworkSetting  m_ns;

    // XbhƋpϐ
    std::string m_strMessage ;
    CommandUtil m_cu;                    //CommandUtil
    NN_PADDING3;
    CommPack    m_cp;                    //CommPack
    NN_PADDING2;
    s32         m_sock;                  //\PbgLqq
    nn::socket::SockAddrIn  m_TcpServer; //PC

    // Xbhp[^
    struct ThreadParam
    {
        int threadNum;               // Xbhԍ(svH)
        nn::os::BlockingQueue * pBq; // ubLOL[
        std::string  * pSm;          // MbZ[W
        CommPack     * pCp;          // R}hpPbg
        s32         sock;
        nn::socket::SockAddrIn sai;
        bool       reqJoin;          // Join Request
        u16        endCommId;        // threadEnd CommId  (m_ListenerEndCommandId Ɠj
        NN_PADDING1;
    };

private:
    // Rs[RXgN^EZq̎gp֎~
    TcpComm(const TcpComm& ei);
    const TcpComm& operator=(const TcpComm& ei);

public:

    // RXgN^
    TcpComm():
//                 m_DisconnectEvent(false),
                 m_targetPortNum(1234),
                 m_frameLoop(0),
                 m_UpperWindow(56, 16, FONT_SIZE), //EChE (1 56~c16BtHgTCY14)
                 m_LowerWindow(280, 240, 12),
                 m_sock(-1)
    {
        std::memset(&m_ns, 0x00, sizeof(m_ns));
    }

    // fXgN^
    virtual ~TcpComm()
    {};

    // j[
    void MenuItem1(); // Listener[h
    void MenuItem2(); //


    // Xbhp֐
    static void TestFunc(ThreadParam* param); //XbhŎs邽߂̊֐BstaticB

    void DrawUpperLCD(sys::GraphicsDrawing* gfx);
    void DrawLowerLCD(sys::GraphicsDrawing* gfx);

    void Initialize(); //
    void Finalize();   //I

    static void MySendTo(s32 sock, nn::socket::SockAddrIn * sai_server, const char * buf, int length);
//           void MySendToSimple                             (const char * buf, int length);
    virtual void MySendToSimple                             (const char * buf, int length);

    // `pAPI


    void ULCDPrintfVarg(int type, char *fmt, ...);//ȈՉψ
    void ULCDPrintf    (char *msg);//ʏp
    void ULCDPrintfWarn(char *msg);//xp
    void ULCDPrintfGood(char *msg);//܂ꍇ

    // HpH
//    nn::cfg::CTR::CfgRegionCode SerialNumberToRegion(u8 * serial_number ); //VAio[烊[W擾

    //
    u8   AsciiToByte(char ascii_char );
    void AsciiArrayToByteArray(u8 * u8_array, const char * ascii_array, int length);
    void RecvBuffer_Set(const u8 * u8_src, int offset, int length);
    void RecvBuffer_Dump(void);
    void RecvBuffer_Init(void);
    u32  RecvBuffer_WriteAsLocalFriendCodeSeed(void);
    void RecvBuffer_WriteAsSecureInfo(void);

    // eXg֐
    void TestFunc_DumpObjectSize();
    void TestFunc_PointerConv();
    void TestFunc_PointerRestore();

    void TestFunc_ReadLocalFriendCode(); //[JthR[h(Seedł͂Ȃj
    void TestFunc_ReadSerNo();
    void TestFunc_WriteSerNo();
    void TestFunc_WriteLog();
//    bool TestFunc_GetACStatus(std::string * str_ptr);

    // ʐM
    bool Connect     (sys::GraphicsDrawing * gfx); // ڑ
    bool Disconnect  (sys::GraphicsDrawing * gfx); // ؒf

    bool ConnectBatch         (sys::GraphicsDrawing * gfx);
    bool ConnectBatch_NoAcInit(sys::GraphicsDrawing * gfx);
    void ConnectTest (int test_type, int trial_num);        //ڑ-ؒfeXg

    bool AcInit     (sys::GraphicsDrawing* gfx);

    void DisconnectWaitThread();
    bool AcConnect  (sys::GraphicsDrawing* gfx);
    bool AcClose    (sys::GraphicsDrawing* gfx);
    bool AcFinalize (sys::GraphicsDrawing* gfx);

    bool SocketInit     (sys::GraphicsDrawing* gfx);
    bool SocketCreate   (sys::GraphicsDrawing* gfx);
    bool SocketConnect  (sys::GraphicsDrawing* gfx);
    bool SocketClose    (sys::GraphicsDrawing* gfx);
    bool SocketFinalize (sys::GraphicsDrawing* gfx);

    bool ListenerMode ();                            //҂󂯃[h (ėp)
           void CommandReceiver(sys::GraphicsDrawing* gfx); //R}hM[h(R}h󂯁AX|XԂj
//    static void CommandReceiverFunc(std::string * str_ptr, CommPack * cp ,s32 sock, nn::socket::SockAddrIn *tcp_server, nn::os::BlockingQueue *bq);
    static void CommandReceiverFunc(std::string * str_ptr, CommPack * cp ,s32 sock, nn::socket::SockAddrIn *tcp_server, nn::os::BlockingQueue *bq, u16 end_CommId);



    void ExecuteCommand (CommPack & cp);     //R}hs
    void ReceiveDataPrint(const std::string &str);//M̕\
    void SendDataPrint   (const std::string &str);//M̕\

    // 
    bool GetBody1        (const CommPack &cp); //Ώۃf[^P(LocalFriendCode)
    bool GetBody2        (const CommPack &cp); //Ώۃf[^Q(SecureInfo)

    bool WriteSign1      (const CommPack &cp); //f[^P
    bool WriteSign2      (const CommPack &cp); //f[^Q

    bool SendResponseWithArg(const char * msg, const CommPack & cp); // WriteSign1,2,SetPublicKey1,2̃_~[
    bool SendResponse       (const char * msg, const CommPack & cp); // Verify1,Verify2̃_~[

    bool VerifySignature1(const CommPack &cp); //CTR{̓̏f[^P̌؂s
    bool VerifySignature2(const CommPack &cp); //CTR{̓̏f[^Q̌؂s

    // eX^[R}h
    bool GetProgramVersion        (const CommPack &cp);
    bool GetBuildDate             (const CommPack &cp);
    bool GetMacAddress            (const CommPack &cp);
    bool GetPlatform              (const CommPack &cp);

    // f[^Xg쐬R}h
    bool GetDeviceID              (const CommPack &cp);
    bool SetSerialNumber          (const CommPack &cp);// VANO̐ݒi[WIɐݒ肵܂j

    bool GetSerialNumber          (const CommPack &cp);
    bool GetSystemMenuRegion      (const CommPack &cp);
    bool GetEmsLabel              (const CommPack &cp);
    
//    bool GetSystemMenuVersion     (const CommPack &cp);
    bool GetSystemMenuNupVersion        (const CommPack &cp);
    bool GetSystemMenuCupVersion        (const CommPack &cp);
    bool GetSystemMenuPreInstallVersion (const CommPack &cp);

    bool GetInstallApplicationNum  (const CommPack &cp);
    bool GetInstallApplicationDesc (const CommPack &cp);

    // vCXg[Av̓o^
    bool EntryPreInstallApp ( const wchar_t* cia_path , int entry_id);

    bool GetCommunicationModuleNum  (const CommPack &cp);
    bool GetCommunicationModuleDesc (const CommPack &cp);

    bool NotifyDataListStatus     (const CommPack &cp);


    // HGpRgݒ
    bool GetComment(const CommPack &cp);
    bool WriteComment(const CommPack &cp);

    // [W`FbN
    bool CheckRegion(const CommPack &cp);
    bool CheckSerialNo(const CommPack &cp);


    // SDK Demo
    void SDKDemo();

};

} // namespace eva
} // namespace uji
#endif
