/*---------------------------------------------------------------------------*
  Project:  CTR_UJI
  File:     TcpComm.cpp

  Copyright (C)2010 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#include "TcpComm.h"
#include "TestImport.h"
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include <nn/dbg.h>
#include <nn/socket/socket_DummyUtil.h>
#include <nn/ac.h>
#include <nn/cfg.h>
#include "../seq/TestListManager.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji::sys;
using namespace nn::cfg::CTR;
using namespace nn::cfg::CTR::init;
using namespace nn::cfg::CTR::detail;
using namespace nn::socket;
using namespace std;

namespace uji{
namespace eva{

//------------------------------------------------------------------
// j[ (MenuItem)
//------------------------------------------------------------------
#define TCPCOMM_TEST_AC      0
#define TCPCOMM_TEST_SOCKET  1

void TcpComm::ConnectTest(int test_type, int trial_num)
{
    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    s64 tick_start;
    s64 tick_ac_connect;
    s64 tick_sock_connect;
    s64 tick_ac_close;

    s64 usec1=-1;
    s64 usec2=-1;
    s64 usec3=-1;
    s64 usec4=-1;

    static bool initializeDone = false;

    bool acConnectSuccess;
    bool socConnectSuccess;

    for(int i= 0; i < trial_num; i++)
    {
        NN_LOG("Trial :%d/%d\n", (i+1), trial_num);

        acConnectSuccess = false;
        socConnectSuccess = false;

        tick_start = nn::svc::GetSystemTick();

        Initialize();

        if ( false == initializeDone )
        {
            AcInit(gfx);
        }

        acConnectSuccess = AcConnect(gfx);
        tick_ac_connect = nn::svc::GetSystemTick();

        // Socket̏s
        if (TCPCOMM_TEST_SOCKET == test_type )
        {
            if ( false == initializeDone )
            {
               SocketInit(gfx);
               initializeDone = true;
            }

            SocketCreate(gfx);

            socConnectSuccess = SocketConnect(gfx);
            tick_sock_connect = nn::svc::GetSystemTick();

            SocketClose(gfx);

            if  ( false == initializeDone )
            {
        //       SocketFinalize(gfx);
            }
        }

        AcClose(gfx);
        tick_ac_close = nn::svc::GetSystemTick();

        //  AcFinalize(gfx);

        // sԂ̌v
        usec1 = nnosTickConvertToMilliSeconds(tick_ac_connect          - tick_start);
        if ( TCPCOMM_TEST_SOCKET == test_type)
        {
            usec2 = nnosTickConvertToMilliSeconds(tick_sock_connect        - tick_start);
        }
        usec3 = nnosTickConvertToMilliSeconds(tick_ac_close            - tick_start);
        usec4 = nnosTickConvertToMilliSeconds(nn::svc::GetSystemTick() - tick_start);

        nn::dbg::detail::Printf(" ac connect %lld (msec)\n",  usec1);
        if ( TCPCOMM_TEST_SOCKET == test_type)
        {
            nn::dbg::detail::Printf(" soc connect %lld (msec)\n", usec2);
        }
        nn::dbg::detail::Printf(" ac close  %lld (msec)\n",   usec3);
        nn::dbg::detail::Printf("Total    %lld (msec)\n",     usec4);


        // 茋ʂOɏ
        {
            uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
            pl->Initialize();

            char message[80+1];
            std::memset(message, 0x00, sizeof(message));

            sprintf(message, "%lld$%lld$%lld$Total %lld(msec)",usec1,usec2,usec3,usec4);

            if ( TCPCOMM_TEST_SOCKET == test_type )
            {
                if ( socConnectSuccess)
                {
                    NN_LOG("Result :OK\n");
                    pl->Add_1Line(uji::seq::pl::DEBUG,"SocTest", "OK",  VERSION_STRING, "","","",message);
                }
                else
                {
                    NN_LOG("Result :NG\n");
                    pl->Add_1Line(uji::seq::pl::DEBUG,"SocTest", "NG",  VERSION_STRING, "","","",message);
                }
            }
            else
            {
                if ( acConnectSuccess)
                {
                    NN_LOG("Result :OK\n");
                    pl->Add_1Line(uji::seq::pl::DEBUG,"AcTest", "OK",  VERSION_STRING, "","","",message);
                }
                else
                {
                    NN_LOG("Result :NG\n");
                    pl->Add_1Line(uji::seq::pl::DEBUG,"AcTest", "NG",  VERSION_STRING, "","","",message);
                }
            }

            pl->Finalize();
            delete pl;
        }



        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromSeconds(3));

        Finalize();

    }//for

}

// acCugpAWAPւ̐ڑAؒfJԂB
// Socketɂ͐ڑȂB
void TcpComm::MenuItem1()
{
    uji::seq::Config  *c = new uji::seq::Config;
    u32 trialNum = c->GetAlternative().NumOfTrials;
    delete c;

    ConnectTest(TCPCOMM_TEST_AC, trialNum);
}

// acCugpAWAPւ̐ڑAؒfJԂB
// Socketɂ͐ڑȂB
void TcpComm::MenuItem2()
{
    uji::seq::Config  *c = new uji::seq::Config;
    u32 trialNum = c->GetAlternative().NumOfTrials;
    delete c;

    ConnectTest(TCPCOMM_TEST_SOCKET, trialNum);
}

namespace import{

//------------------------------------------------------------------
// 
//------------------------------------------------------------------
void TcpComm::Initialize()
{

    nn::cfg::CTR::init::Initialize();

    // MacAddress
    uji::sys::GetMacAddress(m_macAddress);
    std::memset(m_macAddressHyphenStr, 0x00, sizeof(m_macAddressHyphenStr));
    sprintf(m_macAddressHyphenStr, "%02X-%02X-%02X-%02X-%02X-%02X", m_macAddress[0],
                                                              m_macAddress[1],
                                                              m_macAddress[2],
                                                              m_macAddress[3],
                                                              m_macAddress[4],
                                                              m_macAddress[5]);
    std::memset(m_macAddressChar, 0x00, sizeof(m_macAddressChar));
    sprintf(m_macAddressChar, "%02X%02X%02X%02X%02X%02X", m_macAddress[0],
                                                              m_macAddress[1],
                                                              m_macAddress[2],
                                                              m_macAddress[3],
                                                              m_macAddress[4],
                                                              m_macAddress[5]);

    std::memset(m_versionDate, 0x00, sizeof(m_versionDate));
    std::memmove(m_versionDate, VERSION_DATE, sizeof(VERSION_DATE));

    // SerialNumber̎擾
    {
        nn::Result r;
        nn::cfg::CTR::detail::SecureInfoBody sib;
        // SecureInfoBody擾
        r = GetSecureInfoBody(&sib);
        if ( r.IsFailure())
        {
            NN_LOG("GetSecureInfoBody failed.\n");
            nn::dbg::PrintResult(r);
            return;
        }

        // SecureInfoBodyserialNo擾
        std::memset(m_serialNo, 0x00, sizeof(m_serialNo));
        std::memcpy(m_serialNo, sib.serialNo, CFG_SECURE_INFO_SERIAL_NO_LEN);
    }

    //Configݒǂ
    uji::seq::Config  *c = new uji::seq::Config;
        m_ListenerEndCommandId     = c->Get().ListenerEndCommandId;     // ListerEndCommand̐ݒ
        m_ListenerEndCommandAsTrue = c->Get().ListenerEndCommandAsTrue; //

        std::memset( m_SSID, 0x00, sizeof(m_SSID));
        u16 ssidU16 = c->GetAlternative().WapSsid;
        ssidU16 = ssidU16 % 10000;                 //4
        sprintf(m_SSID, "N-WAP%04d", ssidU16);
    delete c;


//--------------------------- ̕ӂ胊t@N^OK{ ------

    //rom:/misc/PackageVersion.dat ǎARSPo[W,PreInstallo[W͂B
    nn::fs::FileInputStream fis;
    fis.TryInitialize(L"rom:/misc/PackageVersion.dat");
    s64 fileSize = 0;
    fis.TryGetSize(&fileSize);
    NN_LOG("fileSize %ld\n", fileSize);

    s64 readBufSize = 0;
    readBufSize = fileSize * 2;
    void * readBuf = uji::sys::Alloc(readBufSize);
    if ( NULL == readBuf)
    {
        NN_LOG("allocate error!!\n");
        return;
    }
    std::memset(readBuf, 0x00, readBufSize);

    s32 readBytes;
    fis.TryRead(&readBytes, readBuf,fileSize);

    // Af[^o^B
    char * dataPtr = NULL;       //f[^obt@ւ̃|C^
    dataPtr = static_cast<char *>(readBuf);
    NN_LOG("readBuf [%s]\n", dataPtr);

    // 2.1.0-3J Ƃꂽ̂ŁA
    std::memset(m_rspVersion, 0x00, sizeof(m_rspVersion));
    std::sprintf(m_rspVersion, "%s", dataPtr);

    // CupVersion, NupVersion̎擾
    std::memset(m_cupVersion, 0x00, sizeof(m_cupVersion));
    std::memset(m_nupVersion, 0x00, sizeof(m_nupVersion));
    std::memset(m_preInstallVersion, 0x00, sizeof(m_preInstallVersion));
    
    char workbuf[30+1];
    std::memset(workbuf, 0x00, sizeof(workbuf));

    s32 pos = 0;
    char * ptr = NULL;
    ptr = m_rspVersion;
    while(1)
    {
        if ( pos > fileSize)
        {
            NN_LOG("SystemMenuVersion.dat file data is illegal!!\n");
            break;
        }

        if ( *ptr == '-')
        {
            strncpy(m_cupVersion, dataPtr,pos);
            ptr++;
            strncpy(workbuf, ptr, fileSize-pos-1);
            break;
        }
        ptr++;
        pos++;
    }

    //(@햼)܂܂ꍇ̏
    //ToDo.ʏ펞̍\͂Ə@قȂ̂ō킹
    char* ptrHyphen   = strstr ( workbuf, "-" );
    char* ptrLeftParen  = strstr ( workbuf, "(");
    char* ptrRightParen = strstr ( workbuf, ")");
    if ( ptrLeftParen != NULL && ptrRightParen != NULL )
    {
        int indexLeftParen  = ptrLeftParen - workbuf;
        strncat( m_nupVersion, workbuf, indexLeftParen );
        if( ptrHyphen != NULL )
        {
            int indexHyphen = ptrHyphen - workbuf;
            // PackageVersion.dat ɃvCXg[o[W܂܂Ăꍇ
            strcpy ( m_preInstallVersion, workbuf + 1 + indexHyphen );
        }
    }
    // workbuf̒4ȏ̏ꍇ́ApreInstallVer܂Ŋ܂ނƂ݂ȂB
    else if ( strlen(workbuf) > 3 )
    {
        ptr = workbuf;
        pos = 0;
        while(1)
        {
            if ( *ptr == '-')
            {
                strncpy(m_nupVersion,        workbuf, pos);
                ptr++;
                strncpy(m_preInstallVersion, ptr,     strlen(workbuf)-pos-1);	// preInstallVersion̎擾
                break;
            }
            ptr++;
            pos++;
        }
	}
	else
	{
        strncpy(m_nupVersion, workbuf, strlen(workbuf));
	}

    // systemMenuRegion̎擾    
    ptr = m_nupVersion;
    int nupStrlen = 0;
    nupStrlen = strlen(m_nupVersion);
    while ( nupStrlen > 1 ) { ptr++; nupStrlen--;}

    std::memset(m_systemMenuRegion, 0x00, sizeof(m_systemMenuRegion));
    m_systemMenuRegion[0] = *ptr;

    NN_LOG("m_rspVersion       [%s]\n",m_rspVersion);
    NN_LOG("m_cupVersion       [%s]\n",m_cupVersion);
    NN_LOG("m_nupVersion       [%s]\n",m_nupVersion);
    NN_LOG("m_preInstallVersion[%s]\n",m_preInstallVersion);
    NN_LOG("m_systemMenuRegion [%s]\n",m_systemMenuRegion);

    // f[^J
    uji::sys::Free(readBuf);


//--------------------------- ̕ӂ ܂ ------------------------------


    // EChE
    (void)m_WindowManager.CreateWindow(&m_UpperWindow,       NN_GX_DISPLAY0, 0, 0);
    m_UpperWindow.SetTitle("* Listener Mode *");

    (void)m_WindowManager.CreateWindow(&m_LowerWindow,       NN_GX_DISPLAY1, 0, 0);
    m_LowerWindow.SetTitle(" Infomation ");

}

//------------------------------------------------------------------
// I
//------------------------------------------------------------------
void TcpComm::Finalize()
{
    // EBhEj
    m_WindowManager.DestroyWindow(&m_UpperWindow);
    m_WindowManager.DestroyWindow(&m_LowerWindow);
}


//------------------------------------------------------------------
// ҂󂯃[h
//------------------------------------------------------------------
bool TcpComm::ListenerMode ()
{
    m_ListenerMode_Result = false;

    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    Initialize();

//TODO ̉̂̂́AInitializeThread ł쐬āA܂Ƃ߂Ă
    nn::os::Thread * pThread;
    ThreadParam threadParam1;
    nn::os::StackMemoryBlock stack1(8192);

    // Xbh쐬
    threadParam1.threadNum = 1;
    threadParam1.reqJoin = false;
    threadParam1.endCommId = m_ListenerEndCommandId;

    // ubLOL[쐬
    nn::os::BlockingQueue bq;
    const size_t SIZE = 100;
    uptr buffer[SIZE];
    bq.Initialize(buffer,SIZE);
    threadParam1.pBq = &bq; //Xbhp[^ɓo^

    // obt@
    uptr recvBuffer[100];
    uptr * uPtr;
    uPtr = recvBuffer;
    std::memset(recvBuffer, 0x00,sizeof(recvBuffer));

    // ڑOɂʕ`
    DRAW_LCD(gfx);

    //
    // ڑs
    //
    bool flag_tcp_connect = false;
    bool flagCommandReceiver = false;
    flag_tcp_connect = Connect(gfx);
    if ( false == flag_tcp_connect )
    {
        DRAW_LCD(gfx);
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromSeconds(3)); // ڑłȂꍇ̒~(config)
        goto FIN; //ڑłȂΏIB
    }

    // C[v
    do
    {
        sys::Pad().UpdatePad();
        m_WindowManager.UpdatePad(sys::Pad());  // pbh
        m_WindowManager.Update();               // XV

        // TCP RlNgԂł΁A
        if ( true == flag_tcp_connect )
        {
            if (( false == threadParam1.reqJoin ) && ( false == flagCommandReceiver))
            {
                pThread  = new nn::os::Thread;
                threadParam1.pSm          = &m_strMessage;
                threadParam1.pCp          = &m_cp;
                threadParam1.sock         = m_sock;
                threadParam1.sai          = m_TcpServer;
                threadParam1.reqJoin      = false;
                pThread->Start(this->TestFunc, &threadParam1, stack1);
                NN_LOG("Thread Start.\n");
                ULCDPrintfGood("Command Receiver Started.\n");
                flagCommandReceiver = true;
            }
        }

        // L[`ʕ\
        if ( bq.TryDequeue(uPtr))
        {
            ReceiveDataPrint(m_strMessage);
            uptr u;
            u = *uPtr;
            switch (u)
            {
                case 'f' : ULCDPrintf("\f");
                           break;
                case 'e' : break;               // ENDM

                case 'x' : ExecuteCommand(m_cp);// R}hs
                           break;

                case 't' : ULCDPrintf("tcp connection TIMEOUT.\n");
                           flag_tcp_connect = false;
                           break;

                case 'c' : ULCDPrintf("tcp connection closed.\n"); // ListenerEndCommandMꍇ

                           //m_ListenerEndCommandAsTrueLł΁AR}hM疳Ŗ߂ltrue
                           if ( m_ListenerEndCommandAsTrue ) { m_ListenerMode_Result = true ;}

                           flag_tcp_connect = false;
                           break;
            }
            m_strMessage = "";
        }

        // Xbh̏I
        if (( threadParam1.reqJoin == true) && (false == flag_tcp_connect))
        {
            ULCDPrintfGood("Command Receiver End.\n");
            flagCommandReceiver = false;

            // Xbhj
            pThread->Join();
            NN_LOG("thread1 Join called.\n");
            threadParam1.reqJoin = false;
            delete pThread;

            // ACƂ̐ڑ
            Disconnect(gfx);
            goto FIN;
        }

        m_frameLoop++;

        DRAW_LCD(gfx);

    } while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_START));

FIN:
    Finalize();

    if ( false == m_ListenerMode_Result)
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromSeconds(5)); // G[bZ[WmF
    }
    else
    {
        nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromSeconds(1));
    }

    return m_ListenerMode_Result;
}


//------------------------------------------------------------------------------
// LCD̕`
//------------------------------------------------------------------------------
// LCD
void TcpComm::DrawUpperLCD(sys::GraphicsDrawing* gfx)
{
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->Clear();
    m_WindowManager.DrawDisplay0();

    // R}hGg`
    // Draw_CommandEntry();

    m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);
//  m_UpperWindow.Gotoxy(0, 12);
//  m_UpperWindow.Printf(" Clipboard [%s]", "test ULCD");

    // ΏۃGg̉`
    gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->SetColor(0.5f, 0.5f, 1.0f, 0.5f);
    gfx->m_DrawFramework->SetPointSize( 2.0f);

    gfx->m_DrawFramework->SwapBuffers();

    return;
}

// LCD
void TcpComm::DrawLowerLCD(sys::GraphicsDrawing* gfx)
{
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    m_WindowManager.DrawDisplay1();

    // Œ `
    m_LowerWindow.SetTextColor(sys::ATTR_COLOR_WHITE);

    // Œ
    m_LowerWindow.Gotoxy(0, 0);
    m_LowerWindow.Printf(" program version: %s",  VERSION_STRING);
    m_LowerWindow.Gotoxy(0, 1);
    m_LowerWindow.Printf(" build date: %s",       m_versionDate);
    m_LowerWindow.Gotoxy(0, 2);
    m_LowerWindow.Printf(" mac address: %s",      m_macAddressHyphenStr);
    m_LowerWindow.Gotoxy(0, 3);
    m_LowerWindow.Printf(" serial number: %s",     m_serialNo);



    m_LowerWindow.Gotoxy(0, 5);
    m_LowerWindow.Printf("-- Network Status --");
    m_LowerWindow.Gotoxy(0, 6);
    m_LowerWindow.Printf(" ssid: %s",  m_SSID);
    m_LowerWindow.Gotoxy(0, 7);
    m_LowerWindow.Printf("  PC  IP:%s Port:%d", nn::socket::InetNtoA(m_TcpServer.addr), m_targetPortNum);
    m_LowerWindow.Gotoxy(0, 8);
    m_LowerWindow.Printf("  CTR IP:%s Port:%d", nn::socket::InetNtoA(m_TcpClient.addr), m_myPortNum);
    m_LowerWindow.Gotoxy(0, 9);
    m_LowerWindow.Printf(" sock: %d",  m_sock);

    // ڑXe[^X
    m_LowerWindow.Gotoxy(0, 10);
    m_LowerWindow.Printf(" status:                             ");
    string strStatus;
    strStatus = "                     "; //󕶎
/*    if (TestFunc_GetACStatus(&strStatus))
    {
        m_LowerWindow.Gotoxy(0, 10);
        m_LowerWindow.Printf(" status: %s",  strStatus.c_str());
    }
*/
    // fobO
    m_LowerWindow.Gotoxy(0, 16);
    m_LowerWindow.Printf(" ListenerEndCommandId: 0x%04x", m_ListenerEndCommandId);
    // t[JE^
    m_LowerWindow.Gotoxy(0, 17);
    m_LowerWindow.Printf(" Frame: %010d", m_frameLoop);
    gfx->m_DrawFramework->SwapBuffers();
    return;
}

//------------------------------------------------------------------------------
// M
//------------------------------------------------------------------------------
void TcpComm::MySendTo(s32 sock, SockAddrIn * sai_server, const char * buf, int length)
{
    s32 ret;
//    ret = nn::socket::SendTo(sock, buf, length, SOCK_STREAM, sai_server); //URGrbg
    ret = nn::socket::SendTo(sock, buf, length, 0, sai_server);
    if ( ret != 0)
    {
        NN_LOG(" SendTo succeded(%d).\n",ret);
        return;
    }
    NN_LOG(" SendTo failed.\n"); //0oCgȂB
}

// bgp
void TcpComm::MySendToSimple(const char * buf, int length)
{
    MySendTo(m_sock, &m_TcpServer, buf, length);
}



//------------------------------------------------------------------------------
// Send֐
//------------------------------------------------------------------------------
bool TcpComm::SendResponseWithArg(const char * msg, const CommPack & cp)
{
    const char * p = NULL;

    char arg[256];
    std::memset(arg, 0x0, sizeof(arg));
    u8   rsc = m_cu.SUCCESS;
    int  index;
    char argStr[4];

    std::memset(argStr, 0x00, sizeof(argStr));
    std::memcpy(argStr, cp.Arg, 4);
    //c = cp.Arg[3]; // cp.Arg ́A 16i4ĂB
    index = argStr[3] - 0x30;


    // cp.Arg(1-3)ɂāAԂf[^߂B
    // őf[^255(1oCgŕ\Ă̂ 0-255܂)Ȃ̂ŁA
    // 512oCgɂ́A512 = 255 + 255 + 2 3;
    switch(index)
    {
        case 1:
            std::memcpy(arg, msg, std::strlen(msg));
            arg[11]='1';
            break;
        case 2:
            std::memcpy(arg, msg, std::strlen(msg));
            arg[11]='2';
            break;
        case 3:
            std::memcpy(arg, msg, std::strlen(msg));
            arg[11]='3';
            break;
        case 4:
            std::memcpy(arg, msg, std::strlen(msg));
            arg[11]='4';
            break;
        case 5:
            std::memcpy(arg, msg, std::strlen(msg));
            arg[11]='5';
            break;
        default:
            ULCDPrintfWarn("Argument invalid.\n"); // 1`5łȂƈsƔfB
            rsc = m_cu.FAILURE;
    };//swicth

  NN_LOG("arg: [%s]\n",arg);
  p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(rsc, arg));
  if ( p != NULL)
  {
        NN_LOG("CreateResponseString:[%s]",p);
        MySendToSimple(p, std::strlen(p)); //
  }

  SendDataPrint(p);
  NN_LOG("done.\n");
  return true;
}

// SendResponse֐
bool TcpComm::SendResponse(const char * msg, const CommPack & cp)
{
    const char * p = NULL;

    char arg[256];
    std::memset(arg, 0x0, sizeof(arg));
    std::memcpy(arg, msg, std::strlen(msg));

    NN_LOG("arg: [%s]\n",arg);
    p =m_cu.CreateResponseString(cp, m_cu.CreateRSCAndResponseArgString(m_cu.SUCCESS, arg));
    if ( p != NULL)
    {
        NN_LOG("CreateResponseString:[%s]",p);
        MySendToSimple(p, std::strlen(p));
    }

    SendDataPrint(p);
    NN_LOG("done.\n");
    return true;
}

// V[uobt@փf[^ZbgB
void TcpComm::RecvBuffer_Set(const u8 * u8_src, int offset,int length)
{
    // `FbN
    int localOffset = 0;
    if ( offset < 256 )
    {
         localOffset = offset;
    }

    int  copyLength;
    if ( length > 250 )
    {
        copyLength = 250;
    }
    else
    {
        copyLength = length;
    }


    u8 * destPtr = m_recvBuffer;
    destPtr = destPtr + localOffset;

    //
    std::memcpy(destPtr, u8_src, copyLength);
}

// V[uobt@̃_v
void TcpComm::RecvBuffer_Dump(void)
{
    NN_LOG("-- m_recvBuffer --\n");
    for(int i = 0; i < 256; i=i+8)
    {
        NN_LOG("%02X %02X %02X %02X %02X %02X %02X %02X\n", m_recvBuffer[i],
                                                            m_recvBuffer[i+1],
                                                            m_recvBuffer[i+2],
                                                            m_recvBuffer[i+3],
                                                            m_recvBuffer[i+4],
                                                            m_recvBuffer[i+5],
                                                            m_recvBuffer[i+6],
                                                            m_recvBuffer[i+7]
                                                          );
    }
}

// V[uobt@̏
void TcpComm::RecvBuffer_Init(void)
{
    std:memset(m_recvBuffer, 0x00, sizeof(m_recvBuffer));
}

} // namespace import
} // namespace eva
} // namespace uji
