#include "IrComm.h"
#include "../seq/TestListManager.h"

using namespace std;

namespace uji{
namespace eva{
namespace import{

const int RECV_SIZE = 280;

//------------------------------------------------------------------
// Xbhp֐
//------------------------------------------------------------------
void IrComm::TestFunc(ThreadParam* param)
{
    CommandReceiverFunc( param->pSm,        //bZ[W
                         param->pCp,        //CommPack
                         param->pBq,        //ubLOL[
                         param->endCommId); //XbhEnd R}hID

    NN_LOG("IrComm::TestFunc finished.\n");
}

//------------------------------------------------------------------
// R}hM֐
//------------------------------------------------------------------
//  IR當MB
//  MR}h̎sAʕ\́AL[當擾AListermodeōsB
//
void IrComm::CommandReceiverFunc(string * str_ptr,  
                                 CommPack * cp, 
                                 nn::os::BlockingQueue *bq, 
                                 u16 end_CommId)
{
    string str;
    string str2;
    
    NN_LOG("Thread End CommandId : 0x%04X \n",end_CommId);
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(100));

    // config  ^CAEgl擾
    uji::seq::Config  *c = new uji::seq::Config;
    u32 timeoutSec = c->GetAlternative().InstallStateTimeout;
    delete c;

    // MCxg
    nn::os::Event s_ReceiveEvent;
    nn::ir::Communicator::GetReceiveEvent(&s_ReceiveEvent);         // MCxg

    // Mobt@
    bit8  recvBuffer[RECV_SIZE] NN_ATTRIBUTE_ALIGN(4);
    char  recvBuffChar[RECV_SIZE];

    // M
    while(1)
    {
        s32 usedSize = -1;
        size_t receiveSize = 0;
        nn::Result r;

TOP:
        // XbhItO̊mF
        if ( true == m_rqThreadExit ) return;

        // f[^MĂ邩mF
        if(!s_ReceiveEvent.Wait(0))
        {
            nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(50));
            m_receiveLoop++;
            goto TOP; 
        }

        // obt@
        ::memset(recvBuffer,0,sizeof(recvBuffer));
        ::memset(recvBuffChar,0,sizeof(recvBuffChar));

        // Mf[^
        do
        {
            s_ReceiveEvent.ClearSignal();

            r = nn::ir::Receive(recvBuffer,sizeof(recvBuffer), &receiveSize, &usedSize, true);
            NN_LOG("receiveSize :%d  usedSize : %d\n",receiveSize,usedSize);
            if(r.IsFailure())
            {
                receiveSize = 0; 
                if(r == nn::ir::ResultInvalidData())
                { 
                    NN_LOG("nn::ir::ResultInvalidData\n");
                    goto TOP;
                }
                else if(r == nn::ir::ResultBufferInsufficient())
                {
                    NN_LOG("nn::ir::ResultBufferInsufficient\n");
                    nn::ir::Communicator::DropNextReceiveData(&usedSize);
                    goto TOP;
                }
            }

        }while(usedSize > 0);

        //f[^MĂÃf[^\
        NN_LOG("receiveSize :%d\n",receiveSize);
        NN_LOG("recvBuffer  :%s\n",recvBuffer);

        if ( receiveSize > 0)
        {
            ::memcpy(recvBuffChar, recvBuffer, sizeof(recvBuffer));
            str2 = string(recvBuffChar);
            str = str2.substr(0,receiveSize);
            NN_LOG("str Size:%d\n",str.size());
            NN_LOG("str:[%s]\n",str.c_str());
            *str_ptr = str;

            // 񒷂10ȏ
            if (str.size() < 10)
            {
                NN_LOG("string length is invalid.\n");
            }
            else
            {
                //`FbNTmFB
                if ( false == CommandUtil::isCorrectCheckSum(str.c_str(), str.size()))
                {
                    NN_LOG("checksum is invalid.\n");
                }
                else
                {
                    NN_LOG("checksum is ok.\n");
                    CommPack l_cp;
                    l_cp = CommandUtil::AnalysisCommand(str.c_str());
                    NN_LOG("%s\n",l_cp.Arg);

                    *cp = l_cp;
                    {
                        bq->Enqueue('x'); // socketR}hMAL['x'
                    }

                    // Ip̃R}hIDł΁AIB
                    if ( end_CommId == l_cp.CommID )
                    {
                        bq->Enqueue('c');
                        NN_LOG("Listener end command received. return.\n");
                        return;
                    }

                    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(10));
                }
            }

            NN_LOG("clear m_receiveLoop.\n");
            m_receiveLoop = 0; //Mɐꍇ́Am_receiveLoopZbgB
        }
    }
}

} // namespace import
} // namespace eva
} // namespace uji
