/*---------------------------------------------------------------------------*
  Project:  CTR_UJI
  File:     IrComm.h

  Copyright (C)2010 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.

 *---------------------------------------------------------------------------*/
#ifndef IMPORT_IR_COMM_H_
#define IMPORT_IR_COMM_H_

#include "TcpComm.h"

#include <nn/ir/CTR/ir_API.h>
#include <nn/ir/CTR/ir_Types.h>
#include <nn/ir/CTR/ir_Communicator.h>
#include <nn/ir/CTR/ir_IrnopApi.h>
#include <nn/ir/CTR/ir_Irnop.h>

#include <nn/ir.h>

using namespace nn::ir::CTR;
using namespace nn::ir::CTR::Low;

namespace uji{
namespace eva{
namespace import {

//==============================================================================
//
// IrCommNX
//
//==============================================================================
class IrComm : public TcpComm
{

private:

    char           m_baudRate[8] ; // {[[g
    char           m_status [40] ; // ڑXe[^X
    char           m_role   [20] ; // ڑXe[^X
    bit32               m_commId ; // communication ID
    int                m_sendNum ; // sendNum
    char         m_recvData[100] ; // Mf[^ 265ȏ =4+4+2+255 SUM+CMD+ARGLEN+ARG
    char        m_recvData2[100] ; // Mf[^ 265ȏ =4+4+2+255 SUM+CMD+ARGLEN+ARG
    char        m_recvData3[100] ; // Mf[^ 265ȏ =4+4+2+255 SUM+CMD+ARGLEN+ARG
    int                m_recvNum ; // recvNum
    static s32    m_receiveLoop  ; // M[vJE^iMƁA0ɖ߂j
    static bool   m_rqThreadExit ; // XbhItO


    // Xbhp[^\
    struct ThreadParam
    {
        nn::os::BlockingQueue * pBq ; // ubLOL[
        std::string  *          pSm ; // MbZ[W
        CommPack     *          pCp ; // R}hpPbg
        u16               endCommId ; // threadEnd CommId  (m_ListenerEndCommandId Ɠj
        NN_PADDING1;
    };

    // Xbhs̃p[^
    nn::os::Thread   *    m_pThread ; //Xbh|C^
    ThreadParam       m_threadParam ; //Xbhp[^

    nn::os::BlockingQueue      m_bq ; //Xbhp̃ubLOL[
    uptr            m_bqBuffer[100] ; //ubLOL[pobt@


    // Rs[RXgN^EZq̎gp֎~
    IrComm(const IrComm& ei);
    const IrComm& operator=(const IrComm& ei);


public:

    // RXgN^
    IrComm():
        m_baudRate("115200"),
        m_status("uninitialize"),
        m_role("None"),
        m_commId(0),
        m_sendNum(0),
        m_recvData("nothing"),
        m_recvNum(0),
        m_pThread(NULL)
    {}

    // fXgN^
    virtual ~IrComm()
    {};

    // EI
    void Initialize();
    void Finalize();

    // 샂[h
    bool ListenerMode (); //Ҏ󂯃[h
    bool ManualMode ();   //蓮[h(pj

    // GUI`p
    void DrawUpperLCD(sys::GraphicsDrawing* gfx);
    void DrawLowerLCD(sys::GraphicsDrawing* gfx);
    void SetStatus(sys::GraphicsDrawing* gfx, const char * msg);
    void UpdateRole(void);

    // Xbh
    static void CommandReceiverFunc(std::string * str_ptr,  CommPack * cp , nn::os::BlockingQueue *bq, u16 end_CommId);
    static void TestFunc(ThreadParam* param); //XbhŎs֐BstaticK{B

    // f[^Mp
    static  void MySendTo       (const char * buf, int length);
    virtual void MySendToSimple (const char * buf, int length);
    void ClearRecvData(sys::GraphicsDrawing* gfx);

private:
    // Ɏgp֐
    void CollectDutInfo();
    void CollectSystemMenuInfo();
    void CollectConfigSetting();
    void CollectRomInfo();

    // Xbh֘A
    void CreateThread(nn::os::StackMemoryBlock * smbp );
    void DestroyThread();

};

} // namespace import
} // namespace eva
} // namespace uji
#endif
