#include "Import.h"
#include "IrComm.h"
#include <nn/cfg/CTR/cfg_ApiInit.h>
#include "TestImport.h"
#include "../seq/TestListManager.h"

using namespace uji::seq::pl;
using namespace nn::ir;
using namespace nn::cfg::CTR::init;
using namespace nn::cfg::CTR::detail;

namespace 
{
    //AvP[Ṽj[NID
    const bit32 UNIQUE_ID = 0xFF000;

    // eCxg
    nn::os::Event s_ReceiveEvent;
    nn::os::Event s_SendEvent;
    nn::os::Event s_ConnectEvent;

    char* s_ConnectionRoleText[] =
    {
        "None",
        "Require",
        "Wait"
    };
}

namespace uji{
namespace eva{
namespace import {


//ÓIoϐ

// XbhƋp
bool IrComm::m_rqThreadExit = false; //XbhItO
 s32 IrComm::m_receiveLoop  = 0;     //M[vJE^


//팟ǂݎAoϐ
void IrComm::CollectDutInfo()
{
    nn::cfg::CTR::init::Initialize();

    // MacAddress
    uji::sys::GetMacAddress(m_macAddress);
    std::memset(m_macAddressHyphenStr, 0x00, sizeof(m_macAddressHyphenStr));
    sprintf(m_macAddressHyphenStr, "%02X-%02X-%02X-%02X-%02X-%02X", m_macAddress[0],
                                                              m_macAddress[1],
                                                              m_macAddress[2],
                                                              m_macAddress[3],
                                                              m_macAddress[4],
                                                              m_macAddress[5]);
    std::memset(m_macAddressChar, 0x00, sizeof(m_macAddressChar));
    sprintf(m_macAddressChar, "%02X%02X%02X%02X%02X%02X", m_macAddress[0],
                                                              m_macAddress[1],
                                                              m_macAddress[2],
                                                              m_macAddress[3],
                                                              m_macAddress[4],
                                                              m_macAddress[5]);

    std::memset(m_versionDate, 0x00, sizeof(m_versionDate));
///zantei    std::memmove(m_versionDate, VERSION_DATE, sizeof(VERSION_DATE));

    // SerialNumber̎擾
    {
        nn::Result r;
        nn::cfg::CTR::detail::SecureInfoBody sib;
        // SecureInfoBody擾
        r = GetSecureInfoBody(&sib);
        if ( r.IsFailure())
        {
            NN_LOG("GetSecureInfoBody failed.\n");
///            nn::dbg::detail::PrintResult(r);
            return;
        }

        // SecureInfoBodyserialNo擾
        std::memset(m_serialNo, 0x00, sizeof(m_serialNo));
        std::memcpy(m_serialNo, sib.serialNo, CFG_SECURE_INFO_SERIAL_NO_LEN);
    }

}

//ROMC[WVXej[n̏ǂݎAoϐ
void IrComm::CollectSystemMenuInfo()
{

   //rom:/misc/PackageVersion.dat ǎARSPo[W,PreInstallo[W͂B
    nn::fs::FileInputStream fis;
    fis.TryInitialize(L"rom:/misc/PackageVersion.dat");
    s64 fileSize = 0;
    fis.TryGetSize(&fileSize);
    NN_LOG("fileSize %ld\n", fileSize);

    s64 readBufSize = 0;
    readBufSize = fileSize * 2;
    void * readBuf = uji::sys::Alloc(readBufSize);
    if ( NULL == readBuf)
    {
        NN_LOG("allocate error!!\n");
        return;
    }
    std::memset(readBuf, 0x00, readBufSize);

    s32 readBytes;
    fis.TryRead(&readBytes, readBuf,fileSize);

    // Af[^o^B
    char * dataPtr = NULL;       //f[^obt@ւ̃|C^
    dataPtr = static_cast<char *>(readBuf);
    NN_LOG("readBuf [%s]\n", dataPtr);

    // 2.1.0-3J Ƃꂽ̂ŁA
    std::memset(m_rspVersion, 0x00, sizeof(m_rspVersion));
    std::sprintf(m_rspVersion, "%s", dataPtr);

    // CupVersion, NupVersion̎擾
    std::memset(m_cupVersion, 0x00, sizeof(m_cupVersion));
    std::memset(m_nupVersion, 0x00, sizeof(m_nupVersion));
    std::memset(m_preInstallVersion, 0x00, sizeof(m_preInstallVersion));
    
    char workbuf[30+1];
    std::memset(workbuf, 0x00, sizeof(workbuf));

    s32 pos = 0;
    char * ptr = NULL;
    ptr = m_rspVersion;
    while(1)
    {
        if ( pos > fileSize)
        {
            NN_LOG("SystemMenuVersion.dat file data is illegal!!\n");
            break;
        }

        if ( *ptr == '-')
        {
            strncpy(m_cupVersion, dataPtr,pos);
            ptr++;
            strncpy(workbuf, ptr, fileSize-pos-1);
            break;
        }
        ptr++;
        pos++;
    }

    //(@햼)܂܂ꍇ̏
    //ToDo.ʏ펞̍\͂Ə@قȂ̂ō킹
    char* ptrHyphen   = strstr ( workbuf, "-" );
    char* ptrLeftParen  = strstr ( workbuf, "(");
    char* ptrRightParen = strstr ( workbuf, ")");
    if ( ptrLeftParen != NULL && ptrRightParen != NULL )
    {
        int indexLeftParen  = ptrLeftParen - workbuf;
        strncat( m_nupVersion, workbuf, indexLeftParen );
        if( ptrHyphen != NULL )
        {
            int indexHyphen = ptrHyphen - workbuf;
            // PackageVersion.dat ɃvCXg[o[W܂܂Ăꍇ
            strcpy ( m_preInstallVersion, workbuf + 1 + indexHyphen );
        }
    }
    // workbuf̒4ȏ̏ꍇ́ApreInstallVer܂Ŋ܂ނƂ݂ȂB
    else if ( strlen(workbuf) > 3 )
    {
        ptr = workbuf;
        pos = 0;
        while(1)
        {
            if ( *ptr == '-')
            {
                strncpy(m_nupVersion,        workbuf, pos);
                ptr++;
                strncpy(m_preInstallVersion, ptr,     strlen(workbuf)-pos-1);	// preInstallVersion̎擾
                break;
            }
            ptr++;
            pos++;
        }
	}
	else
	{
        strncpy(m_nupVersion, workbuf, strlen(workbuf));
	}
    
    // systemMenuRegion̎擾    
    ptr = m_nupVersion;
    int nupStrlen = 0;
    nupStrlen = strlen(m_nupVersion);
    while ( nupStrlen > 1 ) { ptr++; nupStrlen--;}

    std::memset(m_systemMenuRegion, 0x00, sizeof(m_systemMenuRegion));
    m_systemMenuRegion[0] = *ptr;

    NN_LOG("m_rspVersion       [%s]\n",m_rspVersion);
    NN_LOG("m_cupVersion       [%s]\n",m_cupVersion);
    NN_LOG("m_nupVersion       [%s]\n",m_nupVersion);
    NN_LOG("m_preInstallVersion[%s]\n",m_preInstallVersion);
    NN_LOG("m_systemMenuRegion [%s]\n",m_systemMenuRegion);

    // f[^J
    uji::sys::Free(readBuf);
}

// ROMC[WConfig̐ݒǂݎAoϐ
void IrComm::CollectConfigSetting()
{
    //Configݒǂ
    uji::seq::Config  *c = new uji::seq::Config;
        m_ListenerEndCommandId     = c->Get().ListenerEndCommandId;     // ListerEndCommand̐ݒ
        m_ListenerEndCommandAsTrue = c->Get().ListenerEndCommandAsTrue; //
    delete c;
}

// ROMC[Wǎ
void IrComm::CollectRomInfo()
{
    CollectSystemMenuInfo();
    CollectConfigSetting();
}

//
// 
//   NXϐ̏
void IrComm::Initialize()
{
    //팟̏擾
    CollectDutInfo();

    //ROM擾
    CollectRomInfo();

    // m_recvData 
    ::memset(m_recvData, 0,sizeof(m_recvData));
    ::memset(m_recvData2,0,sizeof(m_recvData2));
    ::memset(m_recvData3,0,sizeof(m_recvData3));

    // EChE
    (void)m_WindowManager.CreateWindow(&m_UpperWindow,       NN_GX_DISPLAY0, 0, 0);
    m_UpperWindow.SetTitle("* Listener Mode *");

    (void)m_WindowManager.CreateWindow(&m_LowerWindow,       NN_GX_DISPLAY1, 0, 0);
    m_LowerWindow.SetTitle(" Infomation ");

    // XbhtO
    m_rqThreadExit = false;
}

//
// I
//
void IrComm::Finalize()
{
    // EBhEj
    m_WindowManager.DestroyWindow(&m_UpperWindow);
    m_WindowManager.DestroyWindow(&m_LowerWindow);

    // IRʐMIB
    nn::ir::Communicator::Finalize();
}

//------------------------------------------------------------------------------
// LCD̕`
//------------------------------------------------------------------------------
// LCD
void IrComm::DrawUpperLCD(sys::GraphicsDrawing* gfx)
{
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->Clear();
    m_WindowManager.DrawDisplay0();

    // R}hGg`
    // Draw_CommandEntry();

    m_UpperWindow.SetTextColor(sys::ATTR_COLOR_WHITE);
//  m_UpperWindow.Gotoxy(0, 12);
//  m_UpperWindow.Printf(" Clipboard [%s]", "test ULCD");

    // ΏۃGg̉`
    gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->SetColor(0.5f, 0.5f, 1.0f, 0.5f);
    gfx->m_DrawFramework->SetPointSize( 2.0f);

    gfx->m_DrawFramework->SwapBuffers();

    return;
}

// LCD
void IrComm::DrawLowerLCD(sys::GraphicsDrawing* gfx)
{
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    m_WindowManager.DrawDisplay1();

    // Œ `
    m_LowerWindow.SetTextColor(sys::ATTR_COLOR_WHITE);

    // Œ
    m_LowerWindow.Gotoxy(0, 0);
    m_LowerWindow.Printf(" program version: %s",  UJI_APPVER);
    m_LowerWindow.Gotoxy(0, 1);
    m_LowerWindow.Printf(" build date: %s",       m_versionDate);
    m_LowerWindow.Gotoxy(0, 2);
    m_LowerWindow.Printf(" mac address: %s",      m_macAddressHyphenStr);
    m_LowerWindow.Gotoxy(0, 3);
    m_LowerWindow.Printf(" serial number: %s",    m_serialNo);

    // IRXe[^X
    m_LowerWindow.Gotoxy(0, 5);
    m_LowerWindow.Printf(" baudrate: %s",       m_baudRate);
    m_LowerWindow.Gotoxy(0, 6);
    m_LowerWindow.Printf(" status: %s",         m_status);
    m_LowerWindow.Gotoxy(0, 7);
    m_LowerWindow.Printf(" com id: %d",         m_commId);
    m_LowerWindow.Gotoxy(0, 8);
    m_LowerWindow.Printf(" role: %s",           m_role);
    m_LowerWindow.Gotoxy(0, 9);
    m_LowerWindow.Printf(" sendNum: %d",        m_sendNum);
    m_LowerWindow.Gotoxy(0, 10);
    m_LowerWindow.Printf(" recvData:%s",        m_recvData);
    m_LowerWindow.Gotoxy(0, 11);
    m_LowerWindow.Printf(" %s",                 m_recvData2);
    m_LowerWindow.Gotoxy(0, 12);
    m_LowerWindow.Printf(" %s",                 m_recvData3);
    m_LowerWindow.Gotoxy(0, 13);
    m_LowerWindow.Printf(" recvNum: %d",        m_recvNum);
    m_LowerWindow.Gotoxy(0, 14);
    m_LowerWindow.Printf(" receiveLoop: %d",    m_receiveLoop);
    m_LowerWindow.Gotoxy(0, 16);
    m_LowerWindow.Printf(" ListenerEndCommandId: 0x%04x", m_ListenerEndCommandId);

    // t[JE^
    m_LowerWindow.Gotoxy(0, 17);
    m_LowerWindow.Printf(" Frame: %010d", m_frameLoop);
    gfx->m_DrawFramework->SwapBuffers();

    return;
}

//---------------------------------------------------------------------
// IRʐM̃eXg (skel)
//---------------------------------------------------------------------
//#define DEBUG_WRITE( ... )  (void)nn::dbg::detail::Printf(__VA_ARGS__)
#define NN_ATTRIBUTE_ALIGN(n)   __attribute__ ((aligned(n)))


// Xbh֘Ãp[^̏
void IrComm::CreateThread(nn::os::StackMemoryBlock  * smbp )
{
//    m_pThread = NULL;
    m_bq.Initialize(m_bqBuffer, 100);
    m_threadParam.pBq = &m_bq; //Xbhp[^ɓo^
    m_threadParam.pSm = &m_strMessage;
    m_threadParam.pCp = &m_cp;
    m_threadParam.endCommId = m_ListenerEndCommandId;

    // Xbh쐬ATestFuncs
    m_pThread  = new nn::os::Thread;
    m_pThread->Start(this->TestFunc, &m_threadParam, *smbp);
    NN_LOG("Thread Start.\n");
}

// Xbh̏IAp[^̏I
void IrComm::DestroyThread()
{
    // XbhI
    m_rqThreadExit = true;
    NN_LOG("Thread Join called.\n");
    m_pThread->Join();

    // Xbh|C^I
    delete m_pThread;
    m_pThread = NULL;
}

// Ҏ󃂁[h
bool IrComm::ListenerMode ( )
{
    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    Initialize();

    nn::Result r;
    bool requireConnect  = false;     //ڑv
    bool isConnected     = false;     //ڑXe[^X

    NN_LOG("-- Invoke_TestIR --\n");

    // obt@
    uptr recvBuffer[100];
    uptr * uPtr;
    uPtr = recvBuffer;
    std::memset(recvBuffer, 0x00,sizeof(recvBuffer));

    //
    static u8 buffer[4096] NN_ATTRIBUTE_ALIGN(4096);
    size_t sendDataSize  = 280;
    size_t sendPacketNum =   5;
    size_t recvDataSize  = 280;
    size_t recvPacketNum =   5;


RETRY:
    // KvȃTCYvZ
    size_t sendBufferSize     = CTR::Communicator::GetPacketSize(sendDataSize) * sendPacketNum;
    size_t sendManagementSize = CTR::Communicator::GetManagementSize(sendPacketNum);
    size_t recvBufferSize     = CTR::Communicator::GetPacketSize(recvDataSize) * recvPacketNum;
    size_t recvManagementSize = CTR::Communicator::GetManagementSize(recvPacketNum);
    size_t reservedSize       = CTR::Communicator::GetReservedSize();

    DEBUG_WRITE("sendBufferSize:%d\n",    sendBufferSize);
    DEBUG_WRITE("sendManagementSize:%d\n",sendManagementSize);
    DEBUG_WRITE("recvBufferSize:%d\n",    recvBufferSize);
    DEBUG_WRITE("recvManagementSize:%d\n",recvManagementSize);
    DEBUG_WRITE("reservedSize:%d\n",      reservedSize);

    DRAW_LCD(gfx);

    // TCY̑abuffer̃TCYȉł邱Ƃ`FbN
    NN_ASSERT((sendBufferSize + sendManagementSize +
               recvBufferSize + recvManagementSize +
               reservedSize )  <= sizeof(buffer)); 

    //MpPbgۑ̈̃TCYɉZ
    recvBufferSize = sizeof(buffer) - (sendManagementSize + sendBufferSize +
                                       recvManagementSize + 
                                       reservedSize );


    r = CTR::Communicator::Initialize(buffer,sizeof(buffer),
                                      recvBufferSize,recvManagementSize,
                                      sendBufferSize,sendManagementSize,
                                      CTR::BAUD_RATE_115200);

    if( r.IsFailure())
    {
        SetStatus(gfx,"Initialize failed.");
        goto ERROR;
    }

    SetStatus(gfx,"connecting ...");
    DRAW_LCD(gfx);
    m_frameLoop++;

    // eCxg̎擾
    Communicator::GetSendEvent(&s_SendEvent);               // MCxg
    Communicator::GetReceiveEvent(&s_ReceiveEvent);         // MCxg
    Communicator::GetConnectionStatusEvent(&s_ConnectEvent);// ڑԃCxg

    // ڑv
    requireConnect = true;
    do{
        sys::Pad().UpdatePad();
        m_WindowManager.UpdatePad(sys::Pad());  // pbh
        m_WindowManager.Update();               // XV

        if ( true == requireConnect )
        {
            r = Communicator::RequireConnection(); //F؂
            if( r.IsFailure())
            {
                SetStatus(gfx,"RequireConnection failed.");
                nn::ir::Communicator::Finalize();
                goto RETRY;
            }
            requireConnect = false;
        }


        if(s_ConnectEvent.Wait(0))
        {
            switch(Communicator::GetConnectionStatus())
            {
                case CONNECTION_STATUS_CONNECTED:
                    {
                        SetStatus(gfx,"Connected\n");
                        isConnected = true;
                    }
                    break;
                case CONNECTION_STATUS_STOPPED:
                    {
                        SetStatus(gfx,"Disconnected\n");
                        goto ERROR;
                    }
                case CONNECTION_STATUS_FATAL_ERROR:
                    {
                        // IR ̏Ⴕ\܂B{̓d؂܂ŁȀԂ͌p܂B
                        // IR CuIA[UɌ̏̉\ʒm邱Ƃ𐄏܂
                        Communicator::Finalize();
                        NN_PANIC("IR Fatal Error occurred.\n");
                    }
            }
        }

        // ^CAEgs
        if ( m_frameLoop >  180*60 ) //bl 60*60t[
        {
            SetStatus(gfx, "Timeout!\n"); //TODO ConfigŒlݒoقǂB
            goto ERROR;
        }

        // Ďs݂@60t[
        if ( 0 == (m_frameLoop % 60) && (false == requireConnect))
        {
            requireConnect = true;
        }

        UpdateRole();
        DRAW_LCD(gfx);
        m_frameLoop++;

    } while (false == isConnected);


    //------------------------------------------------------------------------
    // C[v
    //------------------------------------------------------------------------
    do{
        sys::Pad().UpdatePad();
        m_WindowManager.UpdatePad(sys::Pad());  // pbh
        m_WindowManager.Update();               // XV

        // RlNgԂł΁A
        if ( true == isConnected )
        {
            if (NULL == m_pThread)
            {
                // Xbh쐬ACommandReceiversB
                nn::os::StackMemoryBlock threadStack(8192);
                CreateThread(&threadStack);
                ULCDPrintfGood("Command Receiver Started.\n");
            }
        }

        // L[`ʕ\
        if ( m_bq.TryDequeue(uPtr))
        {
            ReceiveDataPrint(m_strMessage);
            uptr u;
            u = *uPtr;
            switch (u)
            {
                case 'f' : ULCDPrintf("\f");
                           break;

                case 'e' : break;               // ENDM

                case 'x' : ExecuteCommand(m_cp);// R}hs
                           break;

                case 'c' : ULCDPrintf("ir connection closed.\n"); // ListenerEndCommandMꍇ
                           //m_ListenerEndCommandAsTrueLł΁AR}hM疳Ŗ߂ltrue
                           if ( m_ListenerEndCommandAsTrue ) { m_ListenerMode_Result = true ;}
                           isConnected = false;
                           break;
            }
            m_strMessage = "";
        }

        UpdateRole();
        DRAW_LCD(gfx);
        m_frameLoop++;

    } while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_START));

    goto FIN;

ERROR:
    do
    {
        sys::Pad().UpdatePad();
        m_WindowManager.UpdatePad(sys::Pad());  // pbh
        m_WindowManager.Update();               // XV

        UpdateRole();
        DRAW_LCD(gfx);
        m_frameLoop++;

    }while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_START));


FIN:
    // Xbhj
    DestroyThread();
    ULCDPrintfGood("Command Receiver End.\n");

    // I
    Finalize();

    return true;
}

//------------------------------------------------------------------------------
// M
//------------------------------------------------------------------------------
void IrComm::MySendTo(const char * buf, int length)
{

    nn::os::Event s_SendEvent;
    nn::ir::Communicator::GetSendEvent(&s_SendEvent);               // MCxg

    nn::Result r;

   //MŎgpf[^`
    u8 sendData[280] NN_ATTRIBUTE_ALIGN(4);

    s32 usedSize = -1;

    //4byteACgKv
    bit8  sendBuffer[280] NN_ATTRIBUTE_ALIGN(4);
    ::memset(sendBuffer,0x00,sizeof(sendBuffer));

    //Mf[^cʂmFAcĂȂΑM
    nn::ir::Communicator::GetSendSizeFreeAndUsed(NULL,NULL,NULL,&usedSize);
    if(usedSize == 0)
    {

        ::memcpy(sendData, buf, length);

        ::memcpy(sendBuffer,reinterpret_cast<void*>(&sendData),sizeof(sendData));


        s_SendEvent.ClearSignal();

        r = nn::ir::Send(sendBuffer,length);

        NN_LOG("sizeof(sendData):%d\n",sizeof(sendData));

        if(r.IsFailure())
        {
            NN_LOG("IrSend Failed.");
        }
        else
        {
            NN_LOG("IrSend Succeeded.");
        }
        // M͔񓯊ɍs܂BMmKvꍇɂ́A
        // MCxg𗘗pĂB
    }
}

//
void IrComm::MySendToSimple(const char * buf, int length)
{
    MySendTo(buf, length);
}

//
bool IrComm::ManualMode ( )
{
    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();

    Initialize();


    nn::Result r;

    bool requireSend = false;
    bool requireRecv = false;


    DEBUG_WRITE("-- Invoke_TestIR --\n");

    //
    static u8 buffer[4096] NN_ATTRIBUTE_ALIGN(4096);

    size_t sendDataSize  = 100;
    size_t sendPacketNum =   5;
    size_t recvDataSize  = 100;
    size_t recvPacketNum =   5;

    // KvȃTCYvZ
    size_t sendBufferSize     = nn::ir::CTR::Communicator::GetPacketSize(sendDataSize) * sendPacketNum;
    size_t sendManagementSize = nn::ir::CTR::Communicator::GetManagementSize(sendPacketNum);

    size_t recvBufferSize     = nn::ir::CTR::Communicator::GetPacketSize(recvDataSize) * recvPacketNum;
    size_t recvManagementSize = nn::ir::CTR::Communicator::GetManagementSize(recvPacketNum);

    size_t reservedSize       = nn::ir::CTR::Communicator::GetReservedSize();


    DEBUG_WRITE("sendBufferSize:%d\n",sendBufferSize);
    DEBUG_WRITE("sendManagementSize:%d\n",sendManagementSize);
    DEBUG_WRITE("recvBufferSize:%d\n",recvBufferSize);
    DEBUG_WRITE("recvManagementSize:%d\n",recvManagementSize);
    DEBUG_WRITE("reservedSize:%d\n",reservedSize);

    DRAW_LCD(gfx);


    // TCY̑abuffer̃TCYȉł邱Ƃ`FbN
    NN_ASSERT((sendBufferSize + sendManagementSize +
               recvBufferSize + recvManagementSize +
               reservedSize )  <= sizeof(buffer)); 

    //MpPbgۑ̈̃TCYɉZ
    recvBufferSize = sizeof(buffer) - (sendManagementSize + sendBufferSize +
                                       recvManagementSize + 
                                       reservedSize );

    r = nn::ir::CTR::Communicator::Initialize(buffer,sizeof(buffer),
                                              recvBufferSize,recvManagementSize,
                                              sendBufferSize,sendManagementSize,
                                              nn::ir::CTR::BAUD_RATE_115200);

    if( r.IsFailure())
    {
        SetStatus(gfx,"Initialize failed.");
        goto ERROR;
    }


    SetStatus(gfx,"initialized");
    DRAW_LCD(gfx);
    m_frameLoop++;


    // eCxg̎擾
    // MCxg
    nn::ir::Communicator::GetSendEvent(&s_SendEvent);
    // MCxg
    nn::ir::Communicator::GetReceiveEvent(&s_ReceiveEvent);
    // ڑԃCxg
    nn::ir::Communicator::GetConnectionStatusEvent(&s_ConnectEvent);


    // ڑv
#if 1
    r = nn::ir::Communicator::RequireConnection();  //F؂
    if( r.IsFailure())
    {
        SetStatus(gfx,"RequireConnection failed.");
        goto ERROR;
    }

#else
    r = nn::ir::AnyConnection();      //F؂Ȃ
    if( r.IsFailure())
    {
        SetStatus("AnyConnection failed.");
        goto ERROR;
    }
#endif

    // C[v
    do{

TOP:
        sys::Pad().UpdatePad();
        m_WindowManager.UpdatePad(sys::Pad());  // pbh
        m_WindowManager.Update();               // XV


        if(s_ConnectEvent.Wait(0))
        {
            switch(nn::ir::Communicator::GetConnectionStatus())
            {
                case nn::ir::CONNECTION_STATUS_CONNECTED:
                    {
                        SetStatus(gfx,"Connected\n");
                        ULCDPrintfGood("Command Receiver Started.\n"); //eXg
                    }
                    break;
                case nn::ir::CONNECTION_STATUS_STOPPED:
                    {
                        SetStatus(gfx,"Disconnected\n");
                    }
                    break;
                case nn::ir::CONNECTION_STATUS_FATAL_ERROR:
                    {
                        // IR ̏Ⴕ\܂B{̓d؂܂ŁȀԂ͌p܂B
                        // IR CuIA[UɌ̏̉\ʒm邱Ƃ𐄏܂
                        nn::ir::Communicator::Finalize();

                        NN_PANIC("IR Fatal Error occurred.\n");
                    }
                    break;
            }
        }


        // M
        if (( nn::ir::Communicator::GetConnectionStatus() == nn::ir::CONNECTION_STATUS_CONNECTED)
          && ( true == requireRecv))
        {
                m_recvNum++;

                SetStatus(gfx,"waiting incoming data ...");

                ClearRecvData(gfx);
                DRAW_LCD(gfx);


                // ܂f[^MĂ邩ׂ܂
                if(!s_ReceiveEvent.Wait(0)){ goto TOP; }

                s32 usedSize = -1;
                size_t receiveSize = 0;

                bit8  recvBuffer[280] NN_ATTRIBUTE_ALIGN(4);
                ::memset(recvBuffer,0,sizeof(recvBuffer));

                // Mꂽf[^܂
                do
                {
                    s_ReceiveEvent.ClearSignal();

                #if 0
                    r = nn::ir::Communicator::Receive(buffer,bufferSize,&receiveSize,&usedSize);
                #else
                    r = nn::ir::Receive(recvBuffer,sizeof(recvBuffer), &receiveSize, &usedSize, true);
                #endif
                    if(r.IsFailure())
                    {
                        receiveSize = 0; 

                        if(r == nn::ir::ResultInvalidData())
                        { 
                            // f[^M܂A؂̌ʁAsȃf[^łB
                            // ̂ƂAMobt@f[^͎菜Ă邽߁A
                            // (݂Ȃ) Č㑱̃pPbgĂB
                        }
                        else if(r == nn::ir::ResultBufferInsufficient())
                        { 
                            // obt@TCYsĂ܂B
                            // ̂ƂAf[^̌؏słȂ߁A
                            // f[^sǂfł܂B

                            // ̃f[^M邽߂ɂ́AGetNextReceiveDataSize() ֐
                            // Mf[^̃TCYmFAKvȃTCỸobt@pӂĂB

                            // ̃fł́Az肷f[^M邽߂ɕKvȃobt@͗pӂĂ邽߁A
                            // Mꂽf[^͕sȃf[^Ǝv܂B

                            // Mobt@ɂ̓f[^cĂ܂B
                            // svȂ̂ŁÃf[^͔jāAČ㑱̃pPbg܂B
                            nn::ir::Communicator::DropNextReceiveData(&usedSize);
                        }
                    }

                }while(usedSize > 0);

                //f[^MĂÃf[^\
                ::std::memcpy(reinterpret_cast<void*>(&m_recvData),recvBuffer,receiveSize);

                SetStatus(gfx,"Receive succeeded.");
                requireRecv = false;
        }


        // M
        if (( nn::ir::Communicator::GetConnectionStatus() == nn::ir::CONNECTION_STATUS_CONNECTED)
          && ( true == requireSend ))
        {

                //MŎgpf[^`
                u8 sendData[32] NN_ATTRIBUTE_ALIGN(4);

                s32 usedSize = -1;
                size_t receiveSize = 0;

                //4byteACgKv
                bit8  sendBuffer[64] NN_ATTRIBUTE_ALIGN(4);
                ::memset(sendBuffer,0,sizeof(sendBuffer));

                //Mf[^cʂmFAcĂȂΑM
                nn::ir::Communicator::GetSendSizeFreeAndUsed(NULL,NULL,NULL,&usedSize);
                if(usedSize == 0)
                {
                    //Mf[^̍쐬
                    for (int i=0; i < 32; i++)
                    {
                        sendData[i] = 0x30 + i;
                    }
                    ::memcpy(sendBuffer,reinterpret_cast<void*>(&sendData),sizeof(sendData));


                    s_SendEvent.ClearSignal();

#if 0
                    r = nn::ir::Communicator::Send(sendBuffer,sizeof(sendData),bufferSize,false);
#else
                    r = nn::ir::Send(sendData,sizeof(sendData));
#endif
                    if(r.IsFailure())
                    {
                        if(r == nn::ir::ResultNotConnected())
                        {
                            // 肩̐ؒfvɂڑؒfꂽ\܂
                            SetStatus(gfx,"ResultNotConnected");
                        }
                        else if(r == nn::ir::ResultCannotConfirmId())
                        {
                            SetStatus(gfx,"ResultCannotConfirmId");
                        }
                        else if(r == nn::ir::ResultPacketFull())
                        {
                            SetStatus(gfx,"ResultPacketFull");
                        }
                        else if(r == nn::ir::ResultBufferInsufficient())
                        {
                            SetStatus(gfx,"ResultBufferInsufficient");
                        }
                        else if(r == nn::ir::ResultFatalError())
                        {
                            SetStatus(gfx,"ResultFatalError");
                        }
                        else
                        {
                            SetStatus(gfx,"Other Error");
                        }

                        goto ERROR;
                    }

                    SetStatus(gfx,"Send Succeeded.");
                    m_sendNum++;
                    requireSend = false;

                    // M͔񓯊ɍs܂BMmKvꍇɂ́A
                    // MCxg𗘗pĂB
                  }
        }

        // Mv
        if ( sys::Pad().IsButtonDown(sys::Pad::BUTTON_A))
        {
            requireSend = true;
        }

        // Mv
        if ( sys::Pad().IsButtonDown(sys::Pad::BUTTON_Y))
        {
            requireRecv = true;
        }

        UpdateRole();
        DRAW_LCD(gfx);
        m_frameLoop++;

    } while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_START));

    goto FIN;

ERROR:

 do {
        DRAW_LCD(gfx);
        UpdateRole();
        m_frameLoop++;

    }while (!sys::Pad().IsButtonDown(sys::Pad::BUTTON_START));


FIN:
    nn::ir::Communicator::Finalize();
    return true;

}


void IrComm::SetStatus(sys::GraphicsDrawing* gfx, const char * msg)
{
    //NA           123456789012345678901234567890123456789
    std::memcpy(m_status, "                                       ",sizeof(m_status));
    DRAW_LCD(gfx);

    //̃bZ[W
    std::memcpy(m_status, msg, std::strlen(msg));
    m_status[std::strlen(msg)] = '\0';

    return ;
}


void IrComm::ClearRecvData(sys::GraphicsDrawing* gfx)
{
    //NA             123456789012345678901234567890123456789
    std::memcpy(m_recvData, "                                       ",sizeof(m_recvData));
    DRAW_LCD(gfx);
    return ;
}



void IrComm::UpdateRole(void)
{
    std::memcpy(m_role, s_ConnectionRoleText[nn::ir::Communicator::GetConnectionRole()],
                 sizeof(s_ConnectionRoleText[nn::ir::Communicator::GetConnectionRole()]));
   return ;
}



bool Invoke_TestIR_Low( uji::seq::TestResult &result )
{
    result.m_Result = false;
    nn::Result r;

    DEBUG_WRITE("-- Invoke_TestIR --\n");

    //
    r = nn::ir::CTR::Low::Initialize();
    if( r.IsFailure())
    {
        std::sprintf( result.m_String, "Initialize Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    r = nn::ir::CTR::Low::SetAutoPowerControl( true );
    if( r.IsFailure())
    {
        std::sprintf( result.m_String, "Auto PowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    r = nn::ir::CTR::Low::SetBaudRate( nn::ir::CTR::BAUD_RATE_115200 );
    if( r.IsFailure())
    {
        std::sprintf( result.m_String, "SetBaudRate Error");
        result.m_Result = false;
        return result.m_Result;
    }

    DEBUG_WRITE("-- Initialize done. --\n");


    //--- MeXg ---
    
    u8 sendData[ 32 ];
    
    // CNgf[^
    for( int i = 0x00; i<= 0x1F; i++ )
    {
        sendData[i] = i + 0x20;
    }
    
    // PowerON
    r = nn::ir::CTR::Low::PowerOn();
    if( r.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOn Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    // MeXg
    nn::os::Event sendEvent( true );
    r = nn::ir::CTR::Low::GetFinishedSendingEvent( &sendEvent );
    if( r.IsFailure())
    {
        std::sprintf( result.m_String, "GetSendEvent Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    r = nn::ir::CTR::Low::Send( sendData, 32 );  //f[^M
    if( r.IsFailure())
    {
        std::sprintf( result.m_String, "Send Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    sendEvent.Wait();  // ł̑҂Ԃ́H
    
    nn::ir::CTR::Low::ErrorStatus errorStatus = nn::ir::CTR::Low::GetErrorStatus();
    if( errorStatus != STATUS_NO_ERROR )
    {
        std::sprintf( result.m_String, "Send Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(50));
    
    r = nn::ir::CTR::Low::PowerOff();
    if( r.IsFailure())
    {
        std::sprintf( result.m_String, "PowerOff Error");
        result.m_Result = false;
        return result.m_Result;
    }
    
    
    result.m_Result = true;
    return result.m_Result;
}

        
}//namespace import
}//namespace eva
}//namespace uji
