#include "Import.h"
#include "TcpComm.h"
#include "IrComm.h"
#include "TestImport.h"
#include "../mcu/TestMcu.h"
#include "../seq/TestListManager.h"
#include "../seq/TesterLog/ProductionLog.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

using namespace uji::seq::pl;
namespace uji{
namespace eva{

//------------------------------------------------
// f[^݂̕]j[
//------------------------------------------------
void OpenImportMenu()
{
    ClassMenu *m = new ClassMenu( "Import Evaluation Menu" );
    TcpComm *tc = new TcpComm;

    m->Add         ("Listener Mode",  uji::eva::import::EvaMenu_TcpCommListenerMode);
    m->Add<TcpComm>("Connect Test(ac only)",        tc, &TcpComm::MenuItem1, NULL);
    m->Add<TcpComm>("Connect Test(socket connect)", tc, &TcpComm::MenuItem2, NULL);

    m->Open();

    delete tc;
    delete m;
}


namespace import {

// _~[֐
bool Invoke_TestFunc( uji::seq::TestResult &result )
{
    result.m_Result = true;
    return result.m_Result;
}

//---------------------------------------------------------------------
// X^[gʕ`
//---------------------------------------------------------------------
bool Invoke_Startup( uji::seq::TestResult &result )
{
    result.m_Result = true;

    sys::GraphicsDrawing* gfx = sys::GraphicsDrawing::GetInstance();
    import::TestImport* ti = import::TestImport::GetInstance();

    ti->OpenStartMenu();

//  bRgAEg
//    delete ti;           //deleteƁAoϐ܂ŊJĂ܂߁A
                           //2Tڈȍ~܂Ƃɋ@\ȂB

    return result.m_Result;
}

//---------------------------------------------------------------------
// ݒu(p[ڑ)mF
//---------------------------------------------------------------------
bool Invoke_CheckInstallState( uji::seq::TestResult &result )
{
    result.m_Result = false;

    // config  ^CAEgl擾
    uji::seq::Config  *c = new uji::seq::Config;
    u32 timeoutSec = c->GetAlternative().InstallStateTimeout;
    delete c;

    u8 data;
    u8 value;
    data  = uji::eva::mcu::ReadMcu(0x0f);
    value = data & 0x08;

    // 100msƂɎIɌĂяoA20sxԂNGƔ肷
    for (int cnt=0; cnt < (timeoutSec * 10) ; cnt++)
    {
        if ( 0x08 == value )
        {
            result.m_Result = true;
            break;
        }
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));
        data  = uji::eva::mcu::ReadMcu(0x0f);
        value = data & 0x08;
    }
    return result.m_Result;
}

//---------------------------------------------------------------------
// TCPʐMvOĂяo
//---------------------------------------------------------------------
// ߂l͏true
bool Invoke_TcpComm          ( uji::seq::TestResult &result )
{
    result.m_Result = false;

    uji::eva::TcpComm  *tc = new uji::eva::TcpComm;
    result.m_Result = tc->ListenerMode();
    delete tc;

    return result.m_Result;
}
// Evaj[Ăяo
void EvaMenu_TcpCommListenerMode (void)
{
    uji::eva::TcpComm  *tc = new uji::eva::TcpComm;
    tc->ListenerMode();
    delete tc;
}


bool Invoke_IrComm( uji::seq::TestResult &result )
{
    result.m_Result = false;

    IrComm  *ic = new IrComm;
    result.m_Result = ic->ListenerMode();
    delete ic;

    return result.m_Result;
}

//--------------------------------------------------------------------
//
// O
//
//--------------------------------------------------------------------

// f[^݊JňO
bool Invoke_WriteStartLog( uji::seq::TestResult &result )
{
    result.m_Result = false;

    // Sequencẽ`FbNR[h擾
    uji::seq::TestListManager  *tlm = new uji::seq::TestListManager;
    int sequenceCheckCode;
    tlm->SetCurrentTestList(TESTLIST_ID_IMPORT);
    sequenceCheckCode = tlm->GetCheckCode();

    // Config̃`FbNR[h擾
    uji::seq::Config  *c = new uji::seq::Config;
    int configCheckCode;
    configCheckCode =  c->GetCheckCode();

    // ObZ[W̍쐬
    char message[80+1];
    std::memset(message, 0x00, sizeof(message));
    sprintf(message, "[%s] seq:%04d config:%04d", UJI_REGION, sequenceCheckCode, configCheckCode);

    // OpIuWFNg
    uji::seq::LogResult  lr;
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
    pl->Initialize();

    lr = pl->Add_1Line(c->Get().TestMode,"Import", "START",  VERSION_STRING, "","","",message);
    if (lr == uji::seq::LogResultCode::SUCCESS)
    {
        result.m_Result = true;
    }
    else
    {
        result.m_Result = false;
    }

    pl->Finalize();

    delete pl;
    delete c;
    delete tlm;

    return result.m_Result;

}

// p̌O
//   lЂ邽߁A璷łAPIĂсAꍇ̂SignOK̃O
bool Invoke_WriteSignLog( uji::seq::TestResult &result )
{
    result.m_Result = false;

    uji::seq::Config  *c = new uji::seq::Config;

    // vZX`FbN̏؃R[hĂсAł邱ƂmF
    if ( false == uji::eva::procchk::Invoke_ValidateSign(result))
    {
        result.m_Result = false;
        sprintf(result.m_String, "Validate Signature failed.");
        goto FIN;
    }

    // ObZ[W̍쐬
    char message[80+1];
    std::memset(message, 0x00, sizeof(message));

    // OpIuWFNg
    {
        uji::seq::LogResult  lr;
        uji::seq::ProductionLog * pl = new uji::seq::ProductionLog();
        pl->Initialize();

        lr = pl->Add_1Line(c->Get().TestMode,"Sign", "OK",  VERSION_STRING, "","","",message);
        if (lr == uji::seq::LogResultCode::SUCCESS)
        {
            result.m_Result = true;
        }
        else
        {
            result.m_Result = false;
        }
        pl->Finalize();
        delete pl;
    }

FIN:
    delete c;

    return result.m_Result;
}


//AgingÕ`FbN
    bool Invoke_CheckAgingLog( uji::seq::TestResult &result )
{
    uji::seq::ProductionLog * pl = new uji::seq::ProductionLog;
    pl->Initialize();
    
    // 핶񂪁Aproduct.logɑ݂Ă邩ǂ肷
    if ( pl->LogTable_LatestLogEntryIsOK("Aging", uji::seq::pl::LINE) == false)
    {
        sprintf(result.m_String, "==Process Missed!==\nAging");
        result.m_Result = false;
    } else {
        result.m_Result = true;
    }
    
    pl->Finalize();
    delete pl;
    
    return result.m_Result;
}

}//namespace import
}//namespace eva
}//namespace uji
