/*--------------------------------------------------------------------------*
 Project:
 File: gyro_UdsMaster.h


*--------------------------------------------------------------------------*/
#ifndef __GYRO_UDS_MASTER_H__
#define __GYRO_UDS_MASTER_H__

#include <nn/types.h>
#include <nn/hid.h>
#include <nw/ut.h>

#include "sys.h"
#include "gyro_UdsComm.h"
#include "gyro_Controller.h"
#include "../eva/wireless/UDS_Lib.h"
#include "../seq/Config.h"
#include "../seq/ConfigDefine.h"


namespace uji {
namespace eva {


/*
    Gyro UDS Master
    
    V[PTƂėlXȃeXggp܂BCX^X͂PƂ܂B
*/
class GyroUdsMaster
{
public:    
    static GyroUdsMaster* GetInstance()
    {
        if (m_pInstance == 0)
        {
            m_pInstance = new GyroUdsMaster;
        }
        return m_pInstance;
    }    
    
    bool Initialize() 
    {
        if (!m_IsInitialized)
        {
	        bit8 mac[6]={0,0,0,0,0,0};
            sys::GetMacAddress(mac);
            m_UniqueID = mac[5] + mac[4]*256;              
            
            m_Controller->Initialize();         // iSPIj֘Ȁ
            m_UdsLib.Initialize();              // UDSCȕ
            m_UdsLib.SetUniqueID(m_UniqueID);   // ʐMΏێʂׂ̈̃j[NIDݒ
            m_Platform = static_cast<sys::PlatformType>(seq::Config().Get().GyroSeqPlatform);

            m_IsInitialized = true;
            return true;
        }
        return true;
    }
    bool Finalize()
    {
        if (m_IsInitialized)
        {
            m_Controller->Finalize();            
            m_UdsLib.Finalize();
            m_IsInitialized = false;
            return true;
        }
        return true;
    }
    
    bool UdsSendPacket(eva::GPacket* send_packet, size_t send_size);
    bool UdsSendPacket(u16 command, u8* data, size_t data_length);
    
    bool UdsReceivePacket(eva::GPacket* recv_packet, s64 time_out);
    
    void OpenBmp(const wchar_t *fileName);
    void ShowBmp();
    void CloseBmp();
        
    void EvaCommunication();
    GyroController* GetController() { return m_Controller; }

    u32 GetUniqueID() { return m_UniqueID; }
    sys::PlatformType GetPlatform() { return m_Platform; }

    eva::UDS_Lib m_UdsLib;
    
private:    
    GyroUdsMaster() 
     : m_LogCount(0), m_IsInitialized(false), m_BmpBottom(0), m_TextureIdBottom(0), 
       m_UniqueID(UDS_DEFAULT_UNIQUE_ID)
    {
        if (m_pInstance != NULL)
        {
            NW_FATAL_ERROR("GyroUdsMaster instance already exists.");
        }
        m_pInstance = this;
        
        m_Controller = new GyroController;
    }    
    
    // VOgIuWFNgւ̃|C^
    static GyroUdsMaster* m_pInstance;
    
    GyroController* m_Controller;
    sys::WindowManager m_WndManager;
    int m_LogCount;
    bool m_IsInitialized;
    sys::BmpTexture *m_BmpBottom;
    GLuint m_TextureIdBottom;
       
    u32 m_UniqueID;
    sys::PlatformType m_Platform;
           
    void UpdateDisplay();
    void LogPrintf(sys::InputTextWindow *wnd, sys::ATTR_TEXT_COLOR color, const char* format, ...);
};



} // namespace
}

#endif
