/*--------------------------------------------------------------------------*
 Project:
 File: gyro_UdsMaster.cpp


*--------------------------------------------------------------------------*/
#include "gyro_UdsMaster.h"
#include "gyro_MasterFunction.h"    
#include "../seq/TestIdDefine.h"
#include "../seq/TestResult.h"    

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

namespace uji {
namespace eva {


GyroUdsMaster* GyroUdsMaster::m_pInstance = 0;        


/*
  Desc: UDSʐMeXg
  
  Args: Ȃ
  
  Rnts: Ȃ
*/
void GyroUdsMaster::EvaCommunication()
{
    static int loop_count = 0;    
	static const int FONT_SIZE = 12;
	eva::GPacket* send_packet = new eva::GPacket;
	eva::GPacket* recv_packet = new eva::GPacket;
    bool bExecuteUdsCommunication = false;
    
    const int MASTER_WND_WIDTH  = 300/(FONT_SIZE/2);
    const int MASTER_WND_HEIGHT = 216/FONT_SIZE;
   
    bool isContinuous = false;
   
	sys::InputTextWindow* masterWnd =
        new sys::InputTextWindow(
            MASTER_WND_WIDTH, MASTER_WND_HEIGHT, FONT_SIZE, m_WndManager
        );
    
	masterWnd->SetTitle("MASTER for Gyroscope Test");
	m_WndManager.CreateWindow(masterWnd, NN_GX_DISPLAY0, 0, 0);
    // ANeBuw
    masterWnd->SetActiveFlag(false);

    Initialize();

    nn::os::Timer timer;
    timer.Initialize(false);
    timer.StartPeriodic(0, nn::fnd::TimeSpan::FromMilliSeconds(500));

    m_LogCount = 0;
	masterWnd->Printf("\f");
    
    // lbg[N\zAMXbh𗧂Ă
    bool retInit = m_UdsLib.InitUDSConnectionMaster();
    LogPrintf(masterWnd, sys::ATTR_COLOR_WHITE, "Program Ver.%s\n", VERSION_STRING);            
    LogPrintf(masterWnd, sys::ATTR_COLOR_GREEN, "Network Created (%s)\n", (retInit == true) ? "SUCCESS" : "FAILED");
    LogPrintf(masterWnd, sys::ATTR_COLOR_YELLOW, "UniqueID: %04X\n", m_UniqueID);
    // MacAddress̕\
    {   
        bit8 MA[6];
        uji::sys::GetMacAddress(MA);
        LogPrintf(
            masterWnd,
            sys::ATTR_COLOR_WHITE,
            "MAC_ADDRESS(%s) %02X-%02X-%02X-%02X-%02X-%02X\n",
            MA[0], MA[1], MA[2], MA[3], MA[4], MA[5]
        );
    }

	do
	{        
		// pbhXV
        sys::Pad().UpdatePad();
         
        /*
            pPbg̍쐬               
            A: ATTEST
            X: GYRO ATTEST
            Y: o[W`FbN
        */
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_START))
        {
            isContinuous ^= 1;
        }
        
        if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_A))
        {     
            send_packet->m_Command = (G_ATTEST << 8 | TID_ATTEST);
            send_packet->m_DataLength = 0;
            bExecuteUdsCommunication = true;
        }        
        else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_X) || isContinuous)
        {
            seq::TestResult result;
            LogPrintf(masterWnd, sys::ATTR_COLOR_WHITE, "EXEC GYRO ATTEST\n");
            eva::gyroM::CallATTEST(result);
            LogPrintf(masterWnd, sys::ATTR_COLOR_WHITE, "%s\n", result.m_String);
            if (!result.m_Result)            
            {
                LogPrintf(masterWnd, sys::ATTR_COLOR_RED, "!! TEST FAILED !!\n");
                if (isContinuous) isContinuous ^= 1;
            }
            LogPrintf(masterWnd, sys::ATTR_COLOR_MAGENTA, "END(COUNT=%d)\n", ++loop_count);                        
        }
        else if (sys::Pad().IsButtonDown(sys::Pad::BUTTON_Y))
        {     
            seq::TestResult result;
            LogPrintf(masterWnd, sys::ATTR_COLOR_WHITE, "EXEC CEHCK PROGRAM Ver.\n");
            eva::gyroM::CallGetProgramVersion(result);
            LogPrintf(masterWnd, sys::ATTR_COLOR_WHITE, "%s\n", result.m_String);
            if (!result.m_Result)            
            {
                LogPrintf(masterWnd, sys::ATTR_COLOR_RED, "!! TEST FAILED !!\n");            
            }
            LogPrintf(masterWnd, sys::ATTR_COLOR_MAGENTA, "END(COUNT=%d)\n", ++loop_count);         
        }            
                             
        // MeXg
        if (bExecuteUdsCommunication)
        { 
            /*
                pPbgNCAgi팟jɑM
            */
            size_t send_size = GPacket::GetHeaderSize() + send_packet->m_DataLength;             
            LogPrintf(masterWnd, sys::ATTR_COLOR_WHITE, "Send Packet(cmd=%X psize=%d)\n", send_packet->m_Command, send_size);                 
            m_UdsLib.SendTo(static_cast<void*>(send_packet), send_size);
            
            while (m_UdsLib.GetLastSend() != UDS_Lib::SEND_SUCCESS)
            {
                // timer.Wait();
                nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(50));                                  
                if (m_UdsLib.GetLastSend() == UDS_Lib::SEND_FAILURE)
                {
                    // MsBgC܂B
                    LogPrintf(masterWnd, sys::ATTR_COLOR_RED, "Failure -> Retry\n");
                    m_UdsLib.RetrySendTo(static_cast<void*>(send_packet), send_size);
                }
                else
                {                 
                    LogPrintf(masterWnd, sys::ATTR_COLOR_WHITE, "NOW OPERATING..\n");
                }
                UpdateDisplay();                
            }
            LogPrintf(masterWnd, sys::ATTR_COLOR_CYAN, "Send Packet Success\n"); 
            
            /*
                NCAgi팟j̎M҂
            */
            LogPrintf(masterWnd, sys::ATTR_COLOR_WHITE, "Waiting for Reply Packet\n"); 
            while (!m_UdsLib.Receive(static_cast<void*>(recv_packet), sizeof(GPacket)))
            {
                timer.Wait();
                NN_LOG(" NOW WAITING for REPLY..\n");
                UpdateDisplay();
            }
            LogPrintf(masterWnd, sys::ATTR_COLOR_CYAN, "Received Packet Success\n");
            LogPrintf(masterWnd, 
                sys::ATTR_COLOR_WHITE, 
                "Cmd=%X Result=%d dLength=%d\n", 
                recv_packet->m_Command, 
                recv_packet->m_Result, 
                recv_packet->m_DataLength);
            bExecuteUdsCommunication = false;
            LogPrintf(masterWnd, sys::ATTR_COLOR_MAGENTA, "END(COUNT=%d)\n", ++loop_count);            
        }
        UpdateDisplay();        
    }
	while (!sys::Pad().IsButtonPress(sys::Pad::BUTTON_B));    
    
    // lbg[NI
    m_UdsLib.DisconnectNetwork();
    Finalize();
    
	m_WndManager.DestroyWindow(masterWnd);

    timer.Stop();
    timer.Finalize();

    delete send_packet;
    delete recv_packet;
}

/*
  Desc: ʍXV
    
  Args: Ȃ
    
  Rtns: Ȃ
*/
void GyroUdsMaster::UpdateDisplay()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    /* ------------------------------------------------------------------------
            ʕ`
    ------------------------------------------------------------------------ */
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);  
    gfx->m_DrawFramework->Clear();
    m_WndManager.DrawDisplay0();
    gfx->m_DrawFramework->SwapBuffers();

    /* ------------------------------------------------------------------------
            ʕ`
    ------------------------------------------------------------------------ */
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    m_WndManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();
        
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/*
  Desc: OJEgtPrintf
*/
void GyroUdsMaster::LogPrintf(sys::InputTextWindow *wnd, sys::ATTR_TEXT_COLOR color, const char* format, ...)
{    
    sys::ATTR_TEXT_COLOR prev_color = wnd->GetTextColor();
    
    wnd->SetTextColor(sys::ATTR_COLOR_WHITE);
    wnd->Printf("%03d> ", m_LogCount++);

    wnd->SetTextColor(color);
    va_list vlist;
    va_start(vlist, format);
    wnd->VPrintf(format, vlist);    
    va_end(vlist); 
    
    wnd->SetTextColor(prev_color);
}

/*
  Desc: pPbgM  
*/
bool GyroUdsMaster::UdsSendPacket(eva::GPacket* send_packet, size_t send_size)
{
    const int RETRY_COUNT_MAX = 30;
    int fail_count = 0;
    
    m_UdsLib.SendTo(static_cast<void*>(send_packet), send_size);
    while (m_UdsLib.GetLastSend() != UDS_Lib::SEND_SUCCESS)
    {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(50));
        
        if (m_UdsLib.GetLastSend() == UDS_Lib::SEND_FAILURE)
        {
            if (++fail_count > RETRY_COUNT_MAX)
            {
                return false;
            }
            m_UdsLib.RetrySendTo(static_cast<void*>(send_packet), send_size);
        }
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));
    }
    
    return true;
}

/*
  Desc: pPbgMiR}hEf[^wŁj
*/
bool GyroUdsMaster::UdsSendPacket(u16 command, u8* data, size_t data_length)
{
	eva::GPacket* send_packet = new eva::GPacket;
        
    // pPbg쐬
    send_packet->m_Command = command;
    send_packet->m_DataLength = data_length;
    if (data != 0 && data_length != 0)
    {    
        std::memcpy(send_packet->m_Data, data, data_length); 
    }    
    size_t send_size = GPacket::GetHeaderSize() + send_packet->m_DataLength;
    
    bool bResult = UdsSendPacket(send_packet, send_size);
    
    delete send_packet;
    
    return bResult;   
}
    
/*
  Desc: pPbgM
*/
bool GyroUdsMaster::UdsReceivePacket(eva::GPacket* recv_packet, s64 time_out)
{
    nn::os::Tick current;
    nn::os::Tick start = nn::os::Tick::GetSystemCurrent();
        
    while (!m_UdsLib.Receive(static_cast<void*>(recv_packet), sizeof(GPacket)))
    {
        // ^CAEg
        current = nn::os::Tick::GetSystemCurrent();
        if ((current - start).ToTimeSpan().GetMilliSeconds() > time_out)
        {
            return false;
        }
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(50));
    }
    
    return true;
}

/*
  Desc: BMPt@C[h܂
*/
void GyroUdsMaster::OpenBmp(const wchar_t *fileName)
{
    sys::GraphicsDrawing *gfx = sys::GraphicsDrawing::GetInstance();
    
	m_BmpBottom = new sys::BmpTexture();
	m_BmpBottom->Open(fileName);
    
	if (m_TextureIdBottom != 0) 
    {   
        gfx->m_DrawFramework->DeleteTexture(m_TextureIdBottom );
    }
	gfx->m_DrawFramework->GenerateTexture(
        GL_TEXTURE_2D, 
	    m_BmpBottom->INTERNAL_FORMAT,
		m_BmpBottom->GetTextureWidth(),
		m_BmpBottom->GetTextureHeight(),
		m_BmpBottom->FORMAT,
		m_BmpBottom->TYPE,
		m_BmpBottom->GetTextureDataPointer(),
		m_TextureIdBottom);    
}

/*
  Desc: ʂ\
        ʂ̂ݍXV܂B
*/
void GyroUdsMaster::ShowBmp()
{
    sys::GraphicsDrawing *gfx = sys::GraphicsDrawing::GetInstance();
    
    gfx->m_DrawFramework->FillTexturedRectangle(
        m_TextureIdBottom,
		0.0f, 0.0f, 320.0f, 240.0f, 
		m_BmpBottom->GetBmpWidth(), m_BmpBottom->GetBmpHeight(),
		m_BmpBottom->GetTextureWidth(), m_BmpBottom->GetTextureHeight() );    
}

/*
  Desc: BMPt@C̏I
*/
void GyroUdsMaster::CloseBmp()
{
	if (m_TextureIdBottom != 0)
    {
        sys::GraphicsDrawing::GetInstance()->m_DrawFramework->DeleteTexture(m_TextureIdBottom);
	}
	m_BmpBottom->Close();
	delete m_BmpBottom;    
}


} // namespace
}
