/*--------------------------------------------------------------------------*
 Project:
 File: gyro_UdsComm.h


*--------------------------------------------------------------------------*/
#ifndef __GYRO_UDS_COMM_H__
#define __GYRO_UDS_COMM_H__

#include <nn/types.h>
#include <nw/ut.h>

#include "sys.h"

namespace uji {
namespace eva {


const u32 UDS_DEFAULT_UNIQUE_ID       = 1234;                           // ʐM莯ʗpftHgID

/*
    e^CAEg
*/
const s64 G_TIMEOUT_TEST_COMMON       = 15000;                          // ʂ̃^CAEg
const s64 G_TIMEOUT_TURNTABLE_STABLE  = 22000;                          // ^[e[uw葬xň肷܂ł̎
const s64 G_TIMEOUT_TURNTABLE_STOP    = 10000;                          // ^[e[u~܂ł̎
const s64 G_TIMEOUT_CALIBRATION_C     = 15000;                          // NCAg̃Lũ^CAEg
const s64 G_TIMEOUT_CALIBRATION_M     = G_TIMEOUT_CALIBRATION_C + 8000; // }X^[̃Lũ^CAEg
const s64 G_ACCURATE_CARIBRATION_TIME = 8000;                           // 萳mȃLusׂɔ鎞

/*
    ʐMG[Ɋ֐}CNR[h
    E100̈ʂʐMG[ɊĂBł̃G[́A0`99gp邱ƁB
    ETODO: CheckCal_SensitivityACheckCal_ZeroRateOutput͍Či99zĂȂB0x4F=79j
*/
const u32 ERROR_MICRO_SEND_PACKET     = 600;    // pPbgMs
const u32 ERROR_MICRO_RECV_PACKET     = 700;    // pPbgMs
const u32 ERROR_MICRO_INVALID_COMMAND = 800;    // NCAg̎MɐAR}hӐ}̂ƈقȂ
const u32 ERROR_MICRO_UDS_COMMON      = 900;    // ʐMG[ʁi10/11/17 _łWriteSDLogŃG[ł̂ݎgpj

/*
    Lu[Vp}CNR[h
    ʐMG[100̈ʂgp邽߁A0`99̒lƂ܂
*/
const u32 ERROR_MICRO_CALIB_NONE                = 0x0;
const u32 ERROR_MICRO_CALIB_RANGE               = 0x1;
const u32 ERROR_MICRO_CALIB_CROSSAXIS           = 0x2;
const u32 ERROR_MICRO_CALIB_STABLE              = 0x4;
const u32 ERROR_MICRO_CALIB_VALID_DATA_SHORT    = 0x8;
const u32 ERROR_MICRO_CALIB_FATAL               = 0x10;
const u32 ERROR_MICRO_CALIB_ALL_ZERO            = 99;

/*
    e]̔
*/
const s16 CONFIG_T78RPM_MIN     = 6728 - 460;
const s16 CONFIG_T78RPM_MAX     = 6728 + 460;
const s16 CONFIG_T0RPM_MARGIN   = 628;


/*
    pPbg̒`
*/
struct GPacket  // R}h́Ai[\
{    
public:    
    // wb_
    u16 m_Command;
    NN_PADDING2;    
    u32 m_Result;  
    u32 m_Micro;          
    s16 m_DataLength;
    NN_PADDING2;
    
    // f[^
    u8  m_Data[896];
    
    static size_t GetHeaderSize() { return (sizeof(u16) + sizeof(u32) + sizeof(u32) + sizeof(s16) + 4); }
};

/*
    
*/
class GyroUdsCommon
{
private:
    GyroUdsCommon(){}
    virtual ~GyroUdsCommon(){}
    
public:
    // pPbg̉
    // TODO:
};


} // namespace
}

#endif
