/*--------------------------------------------------------------------------*
 Project:
 File: gyro_UdsClient.h


*--------------------------------------------------------------------------*/
#ifndef __GYRO_UDS_CLIENT_H__
#define __GYRO_UDS_CLIENT_H__

#include <nn.h>

#include "sys.h"
#include "gyro_UdsComm.h"
#include "gyro_ExtReader.h"
#include "gyro_Types.h"
#include "../seq/Config.h"
#include "../seq/ConfigDefine.h"
#include "../eva/wireless/UDS_Lib.h"

namespace uji {
namespace eva {


/*
    Gyro UDS Client
*/
class GyroUdsClient
{
public:
    GyroUdsClient() : m_LogCount(0) {}
    virtual ~GyroUdsClient(){}

    void DoReception();
    void Initialize();
    void Finalize();

    static GPacket* GetRecvPacket() { return &m_RecvPacket; }
    static GPacket* GetSendPacket() { return &m_SendPacket; }
    static GyroExtReader* GetExtReader() { return &m_ExtReader; }
    static gyro::GyroTestStatus* GetTestStatus() { return &m_TestStatus; }
    static void InitializeTestStatus();
    static void DisconnectNetwork();

    static void DebugPrintf(sys::ATTR_TEXT_COLOR color, const char* format, ...);
    static void UpdateDisplay();

    u32 GetUniqueID() { return seq::Config().GetAlternative().GyroC_UniqueID; }

private:
    void Execute(sys::InputTextWindow *win, u16 command);
    void LogPrintf(sys::InputTextWindow *wnd, sys::ATTR_TEXT_COLOR color, const char* format, ...);

    static uji::eva::UDS_Lib m_UDS_Lib;

    static GPacket m_RecvPacket;
    static GPacket m_SendPacket;
    static GyroExtReader m_ExtReader;
    static gyro::GyroTestStatus m_TestStatus;

    nn::hid::GyroscopeLowReader m_ExtDevReader;
    nn::hid::AccelerometerCalibrator m_AccCalibrator;
    nn::hid::GyroscopeLowCalibrator m_ExtDevCalibrator;

    // EChE}l[W
    static sys::WindowManager m_WndManager;
    // EChE
    static sys::TextWindow* m_DebugWnd;

    int m_LogCount;

    static const s32 LOOP_BUFFER_SIZE = 30*100;  // 30bԃTvO\
};


} // namespace
}

#endif
