/*--------------------------------------------------------------------------*
 Project:
 File: gyro_UdsClient.cpp


*--------------------------------------------------------------------------*/
#include "gyro_UdsClient.h"
#include "../seq/TestList.h"
#include "../eva/wireless/UDS_Lib.h"

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  = __DATE__ " " __TIME__ ;


// XgQ
// TODO:
// !!!!! Gyro Clientp̂쐬ۂ͂QƂ !!!!!
// extern uji::seq::TestList CheckerList[];
extern uji::seq::TestList GyroTestList[];

namespace uji {
namespace eva {

// ÓIoϐBVOgɂEE
GPacket GyroUdsClient::m_RecvPacket;
GPacket GyroUdsClient::m_SendPacket;
GyroExtReader GyroUdsClient::m_ExtReader;   // Oobt@͌m
gyro::GyroTestStatus GyroUdsClient::m_TestStatus;
sys::WindowManager GyroUdsClient::m_WndManager;
sys::TextWindow* GyroUdsClient::m_DebugWnd;
eva::UDS_Lib GyroUdsClient::m_UDS_Lib;


/*
  Desc: R}hɑΉeXgs

  Args: wnd     - bZ[W\pEChEւ̃|C^
        command - R}h

  Rnts: Ȃ
*/
void GyroUdsClient::Execute(sys::InputTextWindow *wnd, u16 command)
{
    using namespace uji::seq;

    TestList *list = GyroTestList;
    bool isMatched = false;
    bool judge;
    TestId tid;
    TestResult *result = new TestResult;

    // CXgNVID֕ϊ
    tid.m_Major = command >>8;
    tid.m_Minor = command & 0xff;
    LogPrintf(wnd, sys::ATTR_COLOR_WHITE, "INST=0x%04X[%02d-%03d]\n", command, tid.m_Major, tid.m_Minor);

    while (list->m_Name != NULL && isMatched == false)
    {
        if (list->m_Id.m_Major == tid.m_Major && list->m_Id.m_Minor == tid.m_Minor && list->m_Function != NULL)
        {
            LogPrintf(wnd, sys::ATTR_COLOR_YELLOW, "TEST[%s]\n", list->m_Name);
            UpdateDisplay();
            // s
            judge = (list->m_Function)(*result);
            LogPrintf(wnd, sys::ATTR_COLOR_WHITE, "%s\n", judge ? "PASS":"FAIL");
            LogPrintf(wnd, sys::ATTR_COLOR_WHITE, "%s,LEN=%d\n", result->m_String, strlen(result->m_String) + 1);

            GetSendPacket()->m_Result = static_cast<u32>(judge);
            GetSendPacket()->m_Micro = result->m_Micro;
            isMatched = true;
        }

        list++;
    }

    if (!isMatched)
    {
        // }b`ȂƂԐMpPbgɊi[
        // TODO:
        LogPrintf(wnd, sys::ATTR_COLOR_MAGENTA, "Not Matched!!\n" );
    }

    delete result;
}


/*
  Desc: WCNCAgi팟j҂

  Args: Ȃ

  Rtns: Ȃ
*/
void GyroUdsClient::DoReception()
{
    static int loop_count = 0;

    const int FONT_SIZE = 12;
    const int CLIENT_WND_WIDTH  = 264/(FONT_SIZE/2);
    const int CLIENT_WND_HEIGHT = 216/FONT_SIZE;
    const int DEBUG_WND_WIDTH  = 300/(FONT_SIZE/2);
    const int DEBUG_WND_HEIGHT = 216/FONT_SIZE;

    // 󋵏o͗pEChE̐
    sys::InputTextWindow* clientWnd =
        new sys::InputTextWindow(
            CLIENT_WND_WIDTH, CLIENT_WND_HEIGHT, FONT_SIZE, m_WndManager
        );

    clientWnd->SetTitle( "CLIENT for Gyroscope Test" );
    m_WndManager.CreateWindow(clientWnd, NN_GX_DISPLAY0, 0, 0);

    // fobOEChE
    m_DebugWnd = new sys::TextWindow(DEBUG_WND_WIDTH, DEBUG_WND_HEIGHT, FONT_SIZE);
    m_DebugWnd->SetTitle("CLIENT Debug");
    m_WndManager.CreateWindow(m_DebugWnd, NN_GX_DISPLAY1, 0, 0);
    // ANeBuw
    m_DebugWnd->SetActiveFlag(false);

    // N
    m_LogCount = 0;
    clientWnd->Printf("\f");
    LogPrintf(clientWnd, sys::ATTR_COLOR_WHITE, "Program Ver.%s\n", VERSION_STRING);
    LogPrintf(clientWnd, sys::ATTR_COLOR_YELLOW, "UniqueID: %04X\n", GetUniqueID());
    LogPrintf(clientWnd, sys::ATTR_COLOR_WHITE, "Platform: %s\n",
        ( (uji::sys::PLATFORM_SPR == uji::sys::GetPlatformType()) || (uji::sys::PLATFORM_FTR == uji::sys::GetPlatformType()) ) ? "SPR" : "CTR");
    LogPrintf(clientWnd, sys::ATTR_COLOR_GREEN, "Now Initializing UDS. Please Wait.\n");
    UpdateDisplay();

    // UDSCu
    m_UDS_Lib.Initialize();

    // ʐMΏێʂׂ̈̃j[NIDݒ
    m_UDS_Lib.SetUniqueID(GetUniqueID());

    // NCAg
    Initialize();

    // Mobt@̃NA
    std::memset(GetRecvPacket(), 0x00, sizeof(GPacket));

    nn::os::Timer timer;
    timer.Initialize(false);
    timer.StartPeriodic(0, nn::fnd::TimeSpan::FromMilliSeconds(500));

    LogPrintf(clientWnd, sys::ATTR_COLOR_GREEN, "Try Connect to Network\n");
    UpdateDisplay();

    // lbg[N܂ŌAڑ瑗MXbh𗧂Ă
    // TODO: ̉ʍXVǂ邩H
    //       ^CAEgς
    if (!m_UDS_Lib.InitUDSConnectionClient(nn::fnd::TimeSpan::FromSeconds(10)))
    {
        goto GYRO_UDS_CLIENT_FINALIZE;
    }
    LogPrintf(clientWnd, sys::ATTR_COLOR_CYAN, "Succeeded in Network Connection\n");

    // MasteriV[PTjɐڑƂ`
    // MastercłΕsv
    // TODO

    // SDK0.12-PEE΍
    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(500));

    do
    {
        //pbhXV
        sys::Pad().UpdatePad();

        // ؒfĂꍇ͍Đڑ
        if (m_UDS_Lib.IsDisconnected())
        {
            LogPrintf(clientWnd, sys::ATTR_COLOR_MAGENTA, "Client was Disconnected\n");
            UpdateDisplay();

            if (!m_UDS_Lib.InitUDSConnectionClient(nn::fnd::TimeSpan::FromSeconds(10)))
            {
                continue;
            }
            LogPrintf(clientWnd, sys::ATTR_COLOR_CYAN, "Reconnect Success\n");
        }

        // V[PTpPbgM
        if (m_UDS_Lib.Receive(static_cast<void*>(GetRecvPacket()), sizeof(GPacket)))
        {
            LogPrintf(clientWnd, sys::ATTR_COLOR_CYAN, "Receive Packet Success\n");
            LogPrintf(clientWnd, sys::ATTR_COLOR_WHITE, "Cmd=%X dLength=%d\n", GetRecvPacket()->m_Command, GetRecvPacket()->m_DataLength);

            // ԐMiMjppPbgNA
            // pPbǵANCAgseXgŕKv΍XVA
            // eXgsɕԐMpPbgƂĎgp܂B
            std::memset(GetSendPacket(), 0x00, sizeof(GPacket));
            GetSendPacket()->m_Command = GetRecvPacket()->m_Command;
            GetSendPacket()->m_DataLength = 0;

            // eXgs
            Execute(clientWnd, GetRecvPacket()->m_Command);

            /*
                eXgʂi[pPbgԐM
            */
            size_t send_size = GPacket::GetHeaderSize() + GetSendPacket()->m_DataLength;
            m_UDS_Lib.SendTo(static_cast<void*>(GetSendPacket()), send_size);
            LogPrintf(clientWnd, sys::ATTR_COLOR_WHITE, "Send Packet(cmd=%X psize=%d)\n", GetSendPacket()->m_Command, send_size);

            // ܂ŃgC
            // TODO: gC̉񐔂𐧌AG[
            while (m_UDS_Lib.GetLastSend() != UDS_Lib::SEND_SUCCESS)
            {
                // timer.Wait();
                nn::os::Thread::Sleep( nn::fnd::TimeSpan::FromMilliSeconds(50));
                if (m_UDS_Lib.GetLastSend() == UDS_Lib::SEND_FAILURE)
                {
                    LogPrintf(clientWnd, sys::ATTR_COLOR_RED, "Failure! Retry\n");
                    m_UDS_Lib.RetrySendTo(static_cast<void*>(GetSendPacket()), send_size);
                }
                else
                {
                    LogPrintf(clientWnd, sys::ATTR_COLOR_WHITE, "NOW OPERATING..\n");
                }
                UpdateDisplay();
            }
            LogPrintf(clientWnd, sys::ATTR_COLOR_CYAN, "Send Packet Success\n");
            LogPrintf(clientWnd, sys::ATTR_COLOR_MAGENTA, "END(COUNT=%d)\n", ++loop_count);
        }
        UpdateDisplay();
    }
    // ő҂󂯏Ԃ甲ȂlɂƕG
    while (!(sys::Pad().IsButtonPress(sys::Pad::BUTTON_START) &&
             sys::Pad().IsButtonPress(sys::Pad::BUTTON_B)));

    // lbg[NI
    m_UDS_Lib.DisconnectNetwork();
    m_UDS_Lib.Finalize();

GYRO_UDS_CLIENT_FINALIZE:

    m_WndManager.DestroyWindow(clientWnd);
    m_WndManager.DestroyWindow(m_DebugWnd);

    timer.Stop();
    timer.Finalize();

    // NCgI
    Finalize();

    delete clientWnd;
    delete m_DebugWnd;

    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(200));
}

/*
  Desc: 
*/
void GyroUdsClient::Initialize()
{
    // eXgf[^̃NA
    InitializeTestStatus();

    // ExtReader
    GetExtReader()->Initialize();
    // Oobt@̊m
    GetExtReader()->ReallocateRingBuffer(LOOP_BUFFER_SIZE);
    // TvOJn
    GetExtReader()->SamplingStart(
        m_ExtDevCalibrator,
        m_ExtDevReader,
        m_AccCalibrator);
}

/*
  Desc: I
*/
void GyroUdsClient::Finalize()
{
    GetExtReader()->SamplingStop();
    GetExtReader()->Finalize();
}

/*
  Desc: lbg[Nؒf
*/
void GyroUdsClient::DisconnectNetwork()
{
    m_UDS_Lib.DisconnectNetwork();
    m_UDS_Lib.Finalize();
}

/*
  Desc: f[^̏
*/
void GyroUdsClient::InitializeTestStatus()
{
    gyro::GyroTestStatus* ts = GetTestStatus();


#ifdef FTR_ACC_GYRO
    uji::seq::Config c;
    ts->m_TestMode = c.Get().TestMode;
#else
    // FLOWERpłȂꍇ(V[PTR}hꍇ)͉Ls
    // V[PT̃R}hƂă[hĂ邱ƂmFׂɁA
    // ȌĺuDEBUGvɂĂ
    ts->m_TestMode = seq::pl::DEBUG;
#endif

    ts->m_ExtDevCalibParam.x.rpm0 = 0;
    ts->m_ExtDevCalibParam.y.rpm0 = 0;
    ts->m_ExtDevCalibParam.z.rpm0 = 0;
    ts->m_ExtDevCalibParam.x.rpmPositive = 0;
    ts->m_ExtDevCalibParam.y.rpmPositive = 0;
    ts->m_ExtDevCalibParam.z.rpmPositive = 0;
    ts->m_ExtDevCalibParam.x.rpmNegative = 0;
    ts->m_ExtDevCalibParam.y.rpmNegative = 0;
    ts->m_ExtDevCalibParam.z.rpmNegative = 0;

    for (int axis = 0; axis < gyro::ROTATION_AXIS_RAW_NUM; axis++)
    {
        for (int speed = 0; speed < gyro::ROTATION_SPEED_NUM; speed++)
        {
            ts->m_GyroStatusMax[axis][speed].x = -37268/2;
            ts->m_GyroStatusMax[axis][speed].y = -37268/2;
            ts->m_GyroStatusMax[axis][speed].z = -37268/2;

            ts->m_GyroStatusMin[axis][speed].x = 37267/2;
            ts->m_GyroStatusMin[axis][speed].y = 37267/2;
            ts->m_GyroStatusMin[axis][speed].z = 37267/2;

            ts->m_StableTime[axis][speed] = 0;
        }
    }

    for (int axis = 0; axis < gyro::ROTATION_AXIS_RAW_NUM; axis++)
    {
        ts->m_RateCalSensDifference[axis].rpmPositive = 0.0f;
        ts->m_RateCalSensDifference[axis].rpmNegative = 0.0f;
        ts->m_LineSens[axis] = 0.0f;
        ts->m_ZeroRateOutputDiff[axis] = 0;
    }
}

/*
    Desc: ʍXV

    Args: Ȃ

    Rtns: Ȃ
*/
void GyroUdsClient::UpdateDisplay()
{
    uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();

    /* ------------------------------------------------------------------------
            ʕ`
    ------------------------------------------------------------------------ */
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->m_DrawFramework->Clear();
    m_WndManager.DrawDisplay0();
    gfx->m_DrawFramework->SwapBuffers();

    /* ------------------------------------------------------------------------
            ʕ`
    ------------------------------------------------------------------------ */
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->m_DrawFramework->Clear();
    m_WndManager.DrawDisplay1();
    gfx->m_DrawFramework->SwapBuffers();

    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY_BOTH);
}

/*
    Desc: OJEgtPrintf
*/
void GyroUdsClient::LogPrintf(sys::InputTextWindow *wnd, sys::ATTR_TEXT_COLOR color, const char* format, ...)
{
    sys::ATTR_TEXT_COLOR prev_color = wnd->GetTextColor();

    wnd->SetTextColor(sys::ATTR_COLOR_WHITE);
    wnd->Printf("%03d> ", m_LogCount++);

    wnd->SetTextColor(color);
    va_list vlist;
    va_start(vlist, format);
    wnd->VPrintf(format, vlist);
    va_end(vlist);

    wnd->SetTextColor(prev_color);
}

void GyroUdsClient::DebugPrintf(sys::ATTR_TEXT_COLOR color, const char* format, ...)
{
    static int logCount=0;
    sys::ATTR_TEXT_COLOR prev_color = m_DebugWnd->GetTextColor();

    m_DebugWnd->SetTextColor(sys::ATTR_COLOR_WHITE);
    m_DebugWnd->Printf("%03d> ", logCount++);

    m_DebugWnd->SetTextColor(color);
    va_list vlist;
    va_start(vlist, format);
    m_DebugWnd->VPrintf(format, vlist);
    va_end(vlist);

    m_DebugWnd->SetTextColor(prev_color);
}


} // namespace
}
