/*--------------------------------------------------------------------------*
 Project:
 File: gyro_Types.h

*--------------------------------------------------------------------------*/

#ifndef __UJI_GYRO_TYPES_H__
#define __UJI_GYRO_TYPES_H__


#include <nn.h>
#include <nn/hid/CTR/hid_GyroscopeLowCalibrator.h>
#include <nn/cfg/CTR/cfg_ApiInit.h>    

namespace uji {
namespace eva {
namespace gyro {


/*
/؃vOł̎

      /| Z
       |
       |------------+
       | |PPPP| |
       | |        | |
       + -+------+--+--->X
      //      /c/
     /{/______/. /
    /PPPPPP~
   /
 |/ Y
WC:_ƂɁA"v"

<菇>  <l>  <Cal>
RotRight    +Z    z.Positive
RotLeft     -Z    z.Negative
RotRight    -Y    y.Negative
RotLeft     +Y    y.Positive
RotRight    +X    x.Positive
RotLeft     -X    x.Negative


AvJ҂ɂƂĂ̎
                   /| +Y
                    |
                    |  _ +Z
       +------------+  / 
       | |PPPP| | /	
       | |        | |/
+X <---+-+--------+-+
      //      /c/
     /{/______/. /
     PPPPPP~
WC:_ƂɁA"v"
܂AX+ = Pitch+ ,Y+ = Yaw+ , Z+ = ROll+ 
*/

/*  
    
    p̎ݒ
*/
typedef enum AxisType
{
    AXIS_RAW_X =0,
    AXIS_RAW_Y,
    AXIS_RAW_Z,
    AXIS_RAW_NUM
}AxisType;

/*
    ]
    p̎ݒ
*/
typedef enum RotationAxis
{
    ROTATION_AXIS_RAW_X =AXIS_RAW_X,
    ROTATION_AXIS_RAW_Y,
    ROTATION_AXIS_RAW_Z,
    ROTATION_AXIS_RAW_NUM
} RotationAxis;
    
/*
    ]x
*/
typedef enum RotationSpeed
{
    ROTATION_SPEED_0 =0,
    ROTATION_SPEED_78_POSITIVE,
    ROTATION_SPEED_78_NEGATIVE,
    ROTATION_SPEED_NUM    
} RotationSpeed;

/*
    Lu[V̊xY
*/
typedef struct RateCalSensDifference
{
    double rpmPositive;
    double rpmNegative;
} RateCalSensDifference;


/*
    
*/
typedef struct TestTime
{
    s32 year;
    s32 month;
    s32 day;
    s32 hour;
    s32 minute;
    NN_PADDING4;
} TestTime;



/*
    f[^(312byte)
    TODO:NX̌
*/
struct GyroTestStatus 
{
    // ɎZoLupf[^
    nn::hid::GyroscopeLowCalibrateParam m_ExtDevCalibParam;                                 // 18byte
    NN_PADDING2;
    NN_PADDING4;
                            
    // eÎ~MAX 
    nn::hid::GyroscopeLowStatus m_GyroStatusMax[ROTATION_AXIS_RAW_NUM][ROTATION_SPEED_NUM]; // 6byte * 9 
    NN_PADDING2;

    // eÎ~MIN
    nn::hid::GyroscopeLowStatus m_GyroStatusMin[ROTATION_AXIS_RAW_NUM][ROTATION_SPEED_NUM]; // 6byte * 9 
    NN_PADDING2;
    
    // f[^̈܂łɗvԁiUnstablej    
    int m_StableTime[ROTATION_AXIS_RAW_NUM][ROTATION_SPEED_NUM];                            // 4byte * 9
    NN_PADDING4;
    
    // xY[%] o׌ł̂ݎZo 
    RateCalSensDifference m_RateCalSensDifference[ROTATION_AXIS_RAW_NUM];                   // 16byte * 3
    
    // ClZox
    double m_LineSens[ROTATION_AXIS_RAW_NUM];                                               // 8byte * 3
    
    // o/ƍH̃[_̐Βl
    s16 m_ZeroRateOutputDiff[AXIS_RAW_NUM];                                                 // 2byte * 3
    NN_PADDING2;    
    
    // [h
    u32 m_TestMode;
    NN_PADDING4;
    
    // MACAhX
    bit8 mac[6];
    NN_PADDING2;
        
    // VANo.
    char serialNo[nn::cfg::CTR::detail::CFG_SECURE_INFO_SERIAL_NO_LEN +1];    
    
    // ԁiWCATTEST{Ɏ擾j
    TestTime m_Rtc;    
};
    

} // namespace
}
}

#endif
