/*--------------------------------------------------------------------------*
 Project:
 File: gyro_ShockTester.h

*--------------------------------------------------------------------------*/
#ifndef __SHOCK_TESTER_H__
#define __SHOCK_TESTER_H__

#include <nn/types.h>
#include <nn/hid.h>
#include <nn/hid/CTR/hid_GyroscopeLowReader.h>
#include <nw/ut.h>

#include "gyro_ExtReader.h"
#include "gyro_GraphDrawing.h"
#include "gyro_Types.h"
#include "sys.h"
#include "../seq/TesterLog/ProductionLog.h"


extern const u8 SHOCKTEST_BEGIN[];
extern const u8 SHOCKTEST_END[];
extern const u8 PASS_BEGIN[];
extern const u8 PASS_END[];
extern const u8 FAIL_BEGIN[];
extern const u8 FAIL_END[];

extern const u8 ANNOTATION_PCM16_BEGIN[];
extern const u8 ANNOTATION_PCM16_END[];
extern const u8 OK_PCM16_BEGIN[];
extern const u8 OK_PCM16_END[];
extern const u8 NG_PCM16_BEGIN[];
extern const u8 NG_PCM16_END[];


namespace uji {
namespace eva {


// t@CǗ
typedef struct  {
    wchar_t*    wcTextureFile;
    const u8*   objBegin;
    const u8*   objEnd;
} FILE_INFO;


/*
    Desc: }CNTvO
*/
class MicDemo
{
public:
    virtual void Initialize();
    virtual void Finalize(void);

    virtual void Start(void);
    virtual void End(void);

    void GetMicData(s16* pDest, size_t size);

private:
    static const int MIC_BUFFER_SIZE   = nn::mic::BUFFER_ALIGNMENT_SIZE;
    static const u8  MIC_GAIN          = 43;

    size_t m_SamplingLength;
    u8 m_MicGain;
    NN_PADDING3;

    static char m_MicBuffer[MIC_BUFFER_SIZE];
};


/*
    Desc: VbN
*/
class ShockTester
{
public:
    ShockTester()
     : m_GyroRawLastAddedIndex(0), m_ScreenWidth(120), m_ScreenHeight(220), m_TestSequence(0), m_TextureNo(TEXTURE_NONE)
    {
        m_ExtReader = new GyroExtReader(GyroExtReader::LOGGING_BUFFER_SIZE);
        m_MicLoopBuffer = new LoopBuffer<s16>(4096);

        m_GyroRawLine[gyro::AXIS_RAW_X] = new LineElement("X", m_ScreenWidth, 0.0f, 110.0f, nw::ut::FloatColor(1.0f, 0.0f, 0.0f, 1.0f));
        m_GyroRawLine[gyro::AXIS_RAW_Y] = new LineElement("Y", m_ScreenWidth, 0.0f, 110.0f, nw::ut::FloatColor(0.0f, 1.0f, 0.0f, 1.0f));
        m_GyroRawLine[gyro::AXIS_RAW_Z] = new LineElement("Z", m_ScreenWidth, 0.0f, 110.0f, nw::ut::FloatColor(0.0f, 0.0f, 1.0f, 1.0f));
        m_AccRawLine[gyro::AXIS_RAW_X]  = new LineElement("X", m_ScreenWidth, 0.0f, 110.0f, nw::ut::FloatColor(1.0f, 0.0f, 0.0f, 1.0f));
        m_AccRawLine[gyro::AXIS_RAW_Y]  = new LineElement("Y", m_ScreenWidth, 0.0f, 110.0f, nw::ut::FloatColor(0.0f, 1.0f, 0.0f, 1.0f));
        m_AccRawLine[gyro::AXIS_RAW_Z]  = new LineElement("Z", m_ScreenWidth, 0.0f, 110.0f, nw::ut::FloatColor(0.0f, 0.0f, 1.0f, 1.0f));
        m_MicLine                       = new LineElement(" ", m_ScreenWidth, 0.0f, 110.0f, nw::ut::FloatColor(1.0f, 0.0f, 1.0f, 1.0f));
    }

    virtual ~ShockTester()
    {
        for (int i=0; i<gyro::AXIS_RAW_NUM; i++)
        {
            delete m_GyroRawLine[i];
            delete m_AccRawLine[i];
        }
        delete m_MicLine;

        delete m_ExtReader;
        if (m_MicLoopBuffer != 0) { delete m_MicLoopBuffer; m_MicLoopBuffer = 0; }
    }

    static void sRun()
    {
        ShockTester e;
        e.Run();
    }

private:
    void Run();
    bool TestGyroStiction(int sampling_num, u8* ng_code);
    bool TestAccelerometerStiction(int sampling_num, u8* ng_code);
    bool TestMicStiction(int sampling_num);
    void UpdateScreen(sys::GraphicsDrawing* gfx);
    void UpdateGraph();
    seq::LogResult WriteProductionLog(bool result, int minor, u32 micro, char* string);

    GyroExtReader* m_ExtReader;
    // ExtReader[hf[^̂ǂ܂łOt̃obt@ɔfCfbNX
    s64 m_GyroRawLastAddedIndex;
    // }CNŐVf[^
    s16 m_MicLatestData;
    // Ot
    GyroGraphDrawing* m_GyroRawGraphDrawing;
    GyroGraphDrawing* m_AccRawGraphDrawing;
    GyroGraphDrawing* m_MicGraphDrawing;
    LineElement* m_GyroRawLine[gyro::AXIS_RAW_NUM];
    LineElement* m_AccRawLine[gyro::AXIS_RAW_NUM];
    LineElement* m_MicLine;
    s32 m_ScreenWidth;
    s32 m_ScreenHeight;

    /*
        eXgV[PX
    */
    int m_TestSequence;
    nn::os::Tick::Tick  m_PassLedStartTick;
    bool m_bPassLedToggle;
    int m_StictionTestCount;

    bool m_ResultAccl;
    bool m_ResultGyro;
    bool m_ResultMic;
    bool m_TestResult;
    u8 m_NgcodeAccl;
    u8 m_NgcodeGyro;

    seq::LogResult m_LogResult;

    // eXgV[PXԍ
    enum TEST_SEQUENCE
    {
        TESTSEQ_STICTION,
        TESTSEQ_SHOCK,
        TESTSEQ_RESULT
    };

    /*
        p摜
    */
    sys::JpegDrawer* jpegDrawer;
    int m_TextureNo;

    // 摜ԍ
    enum TEST_TEXTURE_NO
    {
        TEXTURE_SHOCK_TARGET,
        TEXTURE_PASS,
        TEXTURE_FAIL,

        TEXTURE_NONE = 99
    };
    // 摜ԍɑΉt@C̎擾
    FILE_INFO GetTexture(int fileNo)
    {
        FILE_INFO texture[] = {
            {L"rom:/jpeg/ShockTest.jpg",    SHOCKTEST_BEGIN,    SHOCKTEST_END},
            {L"rom:/jpeg/Pass.jpg",         PASS_BEGIN,         PASS_END},
            {L"rom:/jpeg/Fail.jpg",         FAIL_BEGIN,         FAIL_END}
        };

        return texture[fileNo];
    }

    // }CN
    MicDemo micDemo;
    // }CNf[^ێp̃Oobt@
    LoopBuffer<s16>* m_MicLoopBuffer;
};




} // namespace
}

#endif
