/*--------------------------------------------------------------------------*
 Project:
 File: gyro_MasterFunction.h


*--------------------------------------------------------------------------*/
#ifndef __GYRO_MASTER_FUNCTION_H__
#define __GYRO_MASTER_FUNCTION_H__

#include <nn/types.h>
#include <nw/ut.h>

#include "sys.h"
#include "../seq/TestResult.h"    


namespace uji {
namespace eva {
namespace gyroM {


extern bool CreateNetwork(seq::TestResult &result);
extern bool PrepareForTest(seq::TestResult &result);
extern bool SetTTRotationDirPositive(seq::TestResult &result);
extern bool SetTTRotationDirNegative(seq::TestResult &result);
extern bool SetTTRotationSpeed78rpm(seq::TestResult &result);
extern bool WaitTTRotationSpeed78rpm(seq::TestResult &result);
extern bool RotateTurntableForZAxisTest(seq::TestResult &result);
extern bool RotateTurntableForYAxisTest(seq::TestResult &result);
extern bool RotateTurntableForXAxisTest(seq::TestResult &result);
extern bool StopTurnTable(seq::TestResult &result);
extern bool CallATTEST(seq::TestResult &result);
extern bool CallGetProgramVersion(seq::TestResult &result);
extern bool CallCalibrate_TTRotMotionless(seq::TestResult &result);
extern bool CallCalibrateZ_TTRotR78rpm(seq::TestResult &result);
extern bool CallCalibrateZ_TTRotL78rpm(seq::TestResult &result);
extern bool CallCalibrateY_TTRotR78rpm(seq::TestResult &result);
extern bool CallCalibrateY_TTRotL78rpm(seq::TestResult &result);
extern bool CallCalibrateX_TTRotR78rpm(seq::TestResult &result);
extern bool CallCalibrateX_TTRotL78rpm(seq::TestResult &result);
extern bool CallInitialize(seq::TestResult &result);
extern bool CallWriteSDLog(seq::TestResult &result);
extern bool CallWriteSDLogByMaster(seq::TestResult &result);
extern bool CallSetCal(seq::TestResult &result);
extern bool CallCheckCal_Sensitivity(seq::TestResult &result);
extern bool CallCheckCal_ZeroRateOutput(seq::TestResult &result);
extern bool CallWriteProductionLogOK(seq::TestResult &result);

} // namespace
}
}

#endif
