/*--------------------------------------------------------------------------*
 Project:
 File: gyro_MasterFunction.cpp


t[
Ẽt@[EFAo[W`FbN
EMasterlbg[N\z

ClientݒuAdAX^[g{^Ă
  X^[g{^҂

Ep[^̏
EATTESTi[hEݎClientɑMj
EClientɃvOo[Wv
EClientݒumFeXgixɂmFj
EClientɃ[_w

E^[e[u]E78prmw
^[e[u]wi{^wʁj
  ]X^[g{^{^҂
E78]mF
EClientɑwˎ擾iMasterNXɑf[^ێj
E^[e[ut]E78prmw
E78t]mF
EClientɑwˎ擾iMasterNXɑf[^ێj
E^[e[u~

E^[e[u]E78prmw
ݒuύXE^[e[u]wiݒuƃ{^wʁj
  ]X^[g{^{^҂
EClientݒumFeXgixɂmFj
E78]mF
EClientɑwˎ擾iMasterNXɑf[^ێj
E^[e[ut]E78prmw
E78t]mF
EClientɑwˎ擾iMasterNXɑf[^ێj
E^[e[u~

E^[e[u]E78prmw
ݒuύXE^[e[u]wiݒuƃ{^wʁj
  ]X^[g{^{^҂
EClientݒumFeXgixɂmFj
E78]mF
EClientɑwˎ擾iMasterNXɑf[^ێj
E^[e[ut]E78prmw
E78t]mF
EClientɑwˎ擾iMasterNXɑf[^ێj
E^[e[u~

ELul
ESDɑf[^ۑ
EȌ

OK
*--------------------------------------------------------------------------*/
#include "gyro_MasterFunction.h"
#include "gyro_UdsMaster.h"
#include "gyro_ClientTestFunction.h"
#include "../seq/TestIdDefine.h"
#include "../seq/TestResult.h"
#include "../seq/TesterLog/ProductionLog.h"
#include "../sys/sys_SoundPlayer.h"
#include "../mcu/McuInitializer.h"    
#include <nn/fs/CTR/MPCore/fs_ApiForHwCheck.h>

#ifdef EVA_COMPOSITE
extern       char VERSION_STRING[];
#else
static const char VERSION_STRING[]= UJI_APPVER;
#endif
static const char VERSION_DATE[]  =	__DATE__ " " __TIME__ ;

namespace uji {
namespace eva {
namespace gyroM {


// ֐̐錾
namespace internal {

bool WriteSDLog(int id_major, int id_minor, u32 micro, bool test_result);

} // namespace internal

//============================================================================
//      MISC
//============================================================================

/*
    Desc: Gyro ATTESTs
          eXg[hARTC̎NCAgɑM܂B
*/
bool CallATTEST(seq::TestResult &result)
{
    u16 command;
    u32 testMode;
    gyro::TestTime time;

    GyroUdsMaster* master = GyroUdsMaster::GetInstance();

    // pPbgM
    {
        eva::GPacket* send_packet = new eva::GPacket;
        
        send_packet->m_Command = (G_GYRO << 8 | TID_GYRO_C_ATTEST);
        command = send_packet->m_Command;
#ifdef GYRO_ATTEST_SIMPLECOMM
        u16 pack_data[3] = {0x1234, 0x5678, 0xabcd};
        std::memcpy(&send_packet->m_Data[0], reinterpret_cast<u8*>(&pack_data[0]), sizeof(u16));
        std::memcpy(&send_packet->m_Data[2], reinterpret_cast<u8*>(&pack_data[1]), sizeof(u16));
        std::memcpy(&send_packet->m_Data[4], reinterpret_cast<u8*>(&pack_data[2]), sizeof(u16));
        send_packet->m_DataLength = sizeof(pack_data);
#else // GYRO_ATTEST_SIMPLECOMM
#if 0    
        // ݂̎擾
        nn::fnd::DateTime now = nn::fnd::DateTime::GetNow();
        time.year   = now.GetYear();
        time.month  = now.GetMonth();
        time.day    = now.GetDay();
        time.hour   = now.GetHour();
        time.minute = now.GetMinute();
#else
        nn::mcu::CTR::RtcData rtc;
        eva::mcu::McuInitializer().HwCheckInit();
        nn::mcu::CTR::HwCheck mcu(eva::mcu::McuInitializer().GetHSession());
        mcu.GetRtcAll(&rtc);
        time.year   = rtc.m_Year+2000;
        time.month  = rtc.m_Month;
        time.day    = rtc.m_Day;
        time.hour   = rtc.m_Hour;
        time.minute = rtc.m_Minute;    
        eva::mcu::McuInitializer().HwCheckEnd();        
#endif            
        // eXg[h擾
        testMode = seq::Config().Get().TestMode;
        // Mf[^쐬
        std::memcpy(&send_packet->m_Data[0],                        reinterpret_cast<u8*>(&time),     sizeof(gyro::TestTime));
        std::memcpy(&send_packet->m_Data[0]+sizeof(gyro::TestTime), reinterpret_cast<u8*>(&testMode), sizeof(testMode));
        send_packet->m_DataLength = sizeof(gyro::TestTime) + sizeof(testMode);
#endif // GYRO_ATTEST_SIMPLECOMM
        if (!master->UdsSendPacket(send_packet, GPacket().GetHeaderSize() + send_packet->m_DataLength))
        {
            delete send_packet;
            std::sprintf(result.m_String, "FAIL: Send Packet");
            result.m_Micro = ERROR_MICRO_SEND_PACKET;
            return result.m_Result = false;
        }
        delete send_packet;
    }

    // pPbgM
    {
        eva::GPacket* recv_packet = new eva::GPacket;
        if (!master->UdsReceivePacket(recv_packet, G_TIMEOUT_TEST_COMMON))
        {
            std::sprintf(result.m_String, "FAIL: Receive Packet");
            result.m_Micro = ERROR_MICRO_RECV_PACKET;
            result.m_Result = false;
        }
        else if (recv_packet->m_Command != command)
        {
            std::sprintf(result.m_String, "FAIL: Invalid Command");
            result.m_Micro = ERROR_MICRO_INVALID_COMMAND;
            result.m_Result = false;
        }
        else
        {
#ifdef GYRO_ATTEST_SIMPLECOMM
            std::sprintf(
                result.m_String,
                "RecvPacket\nCResult=%X\nCom=0x%X\ndLength=%d\n"
                "data[0]=%X\ndata[2]=%X\ndata[4]=%X",
                recv_packet->m_Result,
                recv_packet->m_Command,
                recv_packet->m_DataLength,
                *reinterpret_cast<u16*>(&recv_packet->m_Data[0]),
                *reinterpret_cast<u16*>(&recv_packet->m_Data[2]),
                *reinterpret_cast<u16*>(&recv_packet->m_Data[4]));
#else
            gyro::TestTime* pNow = reinterpret_cast<gyro::TestTime*>(recv_packet->m_Data);
            u32* pTestMode = reinterpret_cast<u32*>(recv_packet->m_Data + sizeof(gyro::TestTime));
            
            if (testMode != *pTestMode)                                                         result.m_Micro |= 0x1;            
            if (time.year != pNow->year || time.month != pNow->month || time.day != pNow->day)  result.m_Micro |= 0x2;
            if (time.hour != pNow->hour || time.minute != pNow->minute)                         result.m_Micro |= 0x4;
            result.m_Result = (result.m_Micro == 0) ? true : false;

            std::sprintf(
                result.m_String,
                "Recv Packet(ret=%s cmd=0x%X len=%d)\n"
                "MResult(%s) Micro(%X)\n"
                "Mode(%Xh)\n""%04d/%02d/%02d  %02d:%02d",
                (recv_packet->m_Result == true) ? "PASS" : "FAIL",
                recv_packet->m_Command,
                recv_packet->m_DataLength,
                (result.m_Result == true) ? "PASS" : "FAIL", result.m_Micro,
                *pTestMode, pNow->year, pNow->month, pNow->day, pNow->hour, pNow->minute);
#endif // GYRO_ATTEST_SIMPLECOMM
        }
        delete recv_packet;
    }

    return result.m_Result;
}

/*
    Desc: NCAgvOo[W`FbN
*/
bool CallGetProgramVersion(seq::TestResult &result)
{
    u16 command;

    // }X^[ƃNCAg̃o[Wł邱ƂmF
    u8 Config_VersionMajor = VERSION_STRING[0]-'0';
    u8 Config_VersionMinor = VERSION_STRING[2]-'0';

    GyroUdsMaster* master = GyroUdsMaster::GetInstance();

    // pPbgM
    if (!master->UdsSendPacket(command = (G_GYRO << 8 | TID_GYRO_C_PROGRAM_VERSION), 0, 0))
    {
        std::sprintf(result.m_String, "FAIL: Send Packet");
        result.m_Micro = ERROR_MICRO_SEND_PACKET;
        return result.m_Result = false;
    }

    // pPbgM
    {
        eva::GPacket* recv_packet = new eva::GPacket;

        if (!master->UdsReceivePacket(recv_packet, G_TIMEOUT_TEST_COMMON))
        {
            std::sprintf(result.m_String, "FAIL: Receive Packet");
            result.m_Micro = ERROR_MICRO_RECV_PACKET;
            result.m_Result = false;
        }
        else if (recv_packet->m_Command != command)
        {
            std::sprintf(result.m_String, "FAIL: Invalid Command");
            result.m_Micro = ERROR_MICRO_INVALID_COMMAND;
            result.m_Result = false;
        }
        else
        {
            // o[W`FbN
            result.m_Result = (recv_packet->m_Data[0] == Config_VersionMajor &&
                               recv_packet->m_Data[1] == Config_VersionMinor) ? true : false;

            // Me𕶎Ɋi[
            std::sprintf(
                result.m_String,
                "Recv Packet(ret=%s cmd=0x%X len=%d)\n"
                "Ver.%X.%X",
                (recv_packet->m_Result == true) ? "PASS" : "FAIL",
                recv_packet->m_Command,
                recv_packet->m_DataLength,
                recv_packet->m_Data[0],
                recv_packet->m_Data[1]
            );
        }

        delete recv_packet;
    }

    return result.m_Result;
}

/*
    Desc: Elbg[N̍\z
*/
bool CreateNetwork(seq::TestResult &result)
{
    // ڂ"DisconnectNetwork"{ꍇ͗v!
    static bool bExecute=false;

    if (GyroUdsMaster::GetInstance()->Initialize() && !bExecute)
    {
        bExecute = true;
        // lbg[N\zɐۂ́AMXbhN
        return result.m_Result = GyroUdsMaster::GetInstance()->m_UdsLib.InitUDSConnectionMaster();
    }
    return result.m_Result = true;
}

/*
    Desc: 
          ɐݒuƓdONwASTART{^҂܂B
*/
bool PrepareForTest(seq::TestResult &result)
{
    sys::GraphicsDrawing *gfx = sys::GraphicsDrawing::GetInstance();
    GyroUdsMaster* master = GyroUdsMaster::GetInstance();

    while (master->GetController()->GetStatus().STA_BF == true)
    {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }

    // wʕ\
    const wchar_t* fileName = (master->GetPlatform() == sys::PLATFORM_SPR)
        ? L"rom:/bmp/gyro/gyro_SPFL_Prepare.bmp"
        : L"rom:/bmp/gyro/gyro_Prepare.bmp";    
    master->OpenBmp(fileName);
    sys::SoundPlayer().UjiSoundPlayer("rom:/SoundPlayer/annotation.wav", 300);

    // [h擾
    u32 testMode = seq::Config().Get().TestMode;

    // j[NID/SDo
    bool bDetected = nn::fs::IsSdmcInserted();
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY0);
    gfx->SetScreenSize(gfx->DISPLAY0_WIDTH, gfx->DISPLAY0_HEIGHT);
    gfx->BeginDrawingString();
    gfx->SetFixedWidthFont(16);
    gfx->m_TextWriter.SetTextColor(nw::ut::Color8::YELLOW);
    gfx->m_TextWriter.SetCursor(8, 202, 0);
    (void)gfx->m_TextWriter.Printf("[TestMode] %s", testMode == seq::pl::LINE   ? "LINE"    :
                                                    testMode == seq::pl::QC     ? "QC"      :
                                                    testMode == seq::pl::ACCEPT ? "ACCEPT"  :
                                                    testMode == seq::pl::REPAIR ? "SOCKET"  : "?");
    gfx->m_TextWriter.SetCursor(8, 220, 0);
    (void)gfx->m_TextWriter.Printf("[UniqueID] %04X", master->GetUniqueID());
    gfx->SetFixedWidthFont(14);
    gfx->m_TextWriter.SetTextColor(bDetected ? nw::ut::Color8::CYAN : nw::ut::Color8::MAGENTA);
    gfx->m_TextWriter.SetCursor(260, 220, 0);
    (void)gfx->m_TextWriter.Printf("SD-CARD: %s", bDetected ? "Detected" : "None");
    gfx->EndDrawingString();    
    gfx->m_DrawFramework->SwapBuffers();
    // wʂ̕\
    gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
    gfx->SetScreenSize(sys::GraphicsDrawing::DISPLAY1_WIDTH, sys::GraphicsDrawing::DISPLAY1_HEIGHT);
    master->ShowBmp();
    gfx->m_DrawFramework->SwapBuffers();
    gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY1);

    // X^[g{^Ď
    while (master->GetController()->GetStatus().STA_BF != true)
    {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
    }

    // vX^[g
    GyroController::TCError err = master->GetController()->SetMeasureStartPermissionFlag(true);
    if (err != GyroController::TCTRL_ERROR_NONE)
    {
        std::sprintf(result.m_String, "TCTRL_ERROR(%d)", err);
        result.m_Result = false;
    }
    else
    {
        result.m_Result = true;
    }
    master->CloseBmp();

    return result.m_Result;
}

/*
    Desc: NCAgڑ҂
*/
// TODO:


//============================================================================
//      ^[e[u
//============================================================================

namespace internal {

/*
    Desc: ^[e[ủ]ݒ肵܂
*/
bool SetTurnTableRotationDirection(seq::TestResult &result, GyroT_DirectionFlag dir)
{
    GyroController::TCError err;

    err = GyroUdsMaster::GetInstance()->GetController()->SetTurnTableDirection(dir);
    if (err != GyroController::TCTRL_ERROR_NONE)
    {
        std::sprintf(result.m_String, "TCTRL_SET_DIR_ERROR(%d)", err);
        return result.m_Result = false;
    }

    return result.m_Result = true;
}

/*
    Desc: ^[e[ủ]xݒ肵܂
*/
bool SetTurnTableRotationSpeed(seq::TestResult &result, GyroT_RPM speed)
{
    GyroController::TCError err;

    err = GyroUdsMaster::GetInstance()->GetController()->SetTurnTableRPM(speed);
    if (err != GyroController::TCTRL_ERROR_NONE)
    {
        std::sprintf(result.m_String, "TCTRL_SET_SPEED_ERROR(%d)", err);
        return result.m_Result = false;
    }

    return result.m_Result = true;
}

} // namespace internal

/*
    Desc: ^[e[u]𐳉]ɐݒ肵܂
*/
bool SetTTRotationDirPositive(seq::TestResult &result) {
    return internal::SetTurnTableRotationDirection(result, TT_DIR_RIGHT);
}

/*
    Desc: ^[e[u]t]ɐݒ肵܂
*/
bool SetTTRotationDirNegative(seq::TestResult &result) {
    return internal::SetTurnTableRotationDirection(result, TT_DIR_LEFT);
}

/*
    Desc: ^[e[ủ]x78prmɐݒ肵܂
*/
bool SetTTRotationSpeed78rpm(seq::TestResult &result) {
    return internal::SetTurnTableRotationSpeed(result, TT_RPM_78);
}


namespace internal {

/*
    Desc: ^[e[uw葬xŉ]Ă邱ƂmF܂
          2]ȏAŎw]xꂽƔ

    Args: result -
          speed  - ڕW]x
          margin - ڕW]xɑ΂锻}[W

    Rtns: truei肵j / falseivIG[A^CAEgj
*/
bool WaitRotationSpeed(seq::TestResult &result, f32 speed, f32 margin)
{
    f32 real_speed = 0.0f;
    f32 fail_speed = 0.0f;
    int stable_count = 0;
    int missread_count = 0;
    int unstable_count = 0;
    const int JUDGE_STABLE_COUNT = 10;
    GyroUdsMaster* master = GyroUdsMaster::GetInstance();

    typedef enum CHECK_SEQUENCE{CHECK_DIRECTION=0, CHECK_SPEED}CHECK_SEQUENCE;
    CHECK_SEQUENCE seq = CHECK_DIRECTION;
    GyroController::TCError err;

    s64 elapsed_time = 0;
    nn::os::Tick start = nn::os::Tick::GetSystemCurrent();

    // w]Ɉ肷܂ő҂
    do
    {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(100));

        switch (seq)
        {
        // ]̃`FbN
        case CHECK_DIRECTION:
            switch (err = master->GetController()->CheckTurnTableRealRotDirection())
            {
            // w]Ǝ]v
            case GyroController::TCTRL_ERROR_NONE:
                sys::WaitMilliSeconds(2000);    // ]xWX^̍XV҂
                seq = CHECK_SPEED;              // x`FbN
                break;
            // w]Ǝ]قȂ
            case GyroController::TCTRL_ERROR_ROT_DIR_F:
            case GyroController::TCTRL_ERROR_ROT_F_STOP:
                break;
            // G[
            default:
                // TODO: {ȂeXgV[PXŎ~߂
                GyroUdsMaster::GetInstance()->GetController()->SetTurnEnable(false);
                std::sprintf(result.m_String, "TCTRL_ERROR_DIRECTION(%d)", err);
                return result.m_Result = false;
            }
            break;

        // ]x̃`FbN
        case CHECK_SPEED:
            // ]x̎擾
            real_speed = master->GetController()->GetRotationSpeed();
            if (speed-margin < real_speed && real_speed < speed+margin)
            {
                if (++stable_count == JUDGE_STABLE_COUNT)
                {
                    std::sprintf(result.m_String, "Elapsed Time: %lld(ms) [US:%d]", elapsed_time, unstable_count);
                    return result.m_Result = true;
                }
                missread_count = 0;
            }
            else
            {
                fail_speed = real_speed;

                // WX^[h̎ԍɂ~XJEgh4(1+3)Ŕ
                if ((++missread_count >= 4) && stable_count)
                {
                    unstable_count++;
                    stable_count = 0;
                    missread_count = 0;
                    // ̍XV^C~O܂ő҂iԂ78rpmt߂ł邱Ƃzj
                    nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(800-400+100));
                }
            }
            break;

        default:
            break;
        }
        elapsed_time = (nn::os::Tick::GetSystemCurrent() - start).ToTimeSpan().GetMilliSeconds();
    }
    while (elapsed_time <= G_TIMEOUT_TURNTABLE_STABLE);

    // TODO: {ȂeXgV[PXŎ~߂
    GyroUdsMaster::GetInstance()->GetController()->SetTurnEnable(false);
    std::sprintf(
        result.m_String,
        "TIME_OUT: %lld(ms) SEQ_NO: %d\n" "SPEED: %.2lf < %.2lf(rpm) < %.2lf\n" "COUNT: %d",
        elapsed_time, seq, speed-margin, fail_speed, speed+margin, stable_count
    );
    return result.m_Result = false;
}

} // namespace internal

/*
    Desc: ^[e[u78RPMň肷܂ő҂܂
*/
bool WaitTTRotationSpeed78rpm(seq::TestResult &result) {
    return internal::WaitRotationSpeed(result, 78.0f, 0.31f);
}


namespace internal {

/*
    Desc: ʒu̕ύXwƁA^[e[u]woA
          ɉ]A]{^i2ӏĵ҂܂B

    Args: result
          fileName    - wʂƂĕ\BMPt@C

    Rtns: true / false 퐧G[
*/
bool RotateTurntable(seq::TestResult &result, const wchar_t *fileName)
{
    sys::GraphicsDrawing *gfx = sys::GraphicsDrawing::GetInstance();
    GyroUdsMaster* master = GyroUdsMaster::GetInstance();
    sys::SoundPlayer sp;

    master->OpenBmp(fileName);
    sp.UjiSoundPlayer("rom:/SoundPlayer/annotation.wav", 300);

    // ]
    GyroController::TCError err = master->GetController()->SetTurnEnable(true);
    if (err == GyroController::TCTRL_ERROR_NONE)
    {
        // wʂ̕\
        gfx->m_DrawFramework->SetRenderTarget(NN_GX_DISPLAY1);
        gfx->SetScreenSize(sys::GraphicsDrawing::DISPLAY1_WIDTH, sys::GraphicsDrawing::DISPLAY1_HEIGHT);
        master->ShowBmp();
        gfx->m_DrawFramework->SwapBuffers();
        gfx->m_DrawFramework->WaitVsync(NN_GX_DISPLAY1);

        // ]X^[g{^Ď
        while (master->GetController()->GetStatus().ROT_BF != true)
        {
            nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(16));
        }

        result.m_Result = true;
    }
    else
    {
        std::sprintf(result.m_String, "TCTRL_ERROR(%d)", err);
        result.m_Result = false;
    }

    master->CloseBmp();

    return result.m_Result;
}

} // namespace internal

/*
    Desc: ^[e[u]wiZ]eXgj
*/
bool RotateTurntableForZAxisTest(seq::TestResult &result) {
    GyroUdsMaster* master = GyroUdsMaster::GetInstance();
    
    const wchar_t* fileName = (master->GetPlatform() == sys::PLATFORM_SPR)
        ? L"rom:/bmp/gyro/gyro_SPFL_ZAxisTest.bmp"
        : L"rom:/bmp/gyro/gyro_ZAxisTest.bmp";        
    return internal::RotateTurntable(result, fileName);
}

/*
    Desc: ^[e[u]wiY]eXgj
*/
bool RotateTurntableForYAxisTest(seq::TestResult &result) {
    GyroUdsMaster* master = GyroUdsMaster::GetInstance();
    
    const wchar_t* fileName = (master->GetPlatform() == sys::PLATFORM_SPR)
        ? L"rom:/bmp/gyro/gyro_SPFL_YAxisTest.bmp"
        : L"rom:/bmp/gyro/gyro_YAxisTest.bmp";        
    return internal::RotateTurntable(result, fileName);    
}

/*
    Desc: ^[e[u]wiX]eXgj
*/
bool RotateTurntableForXAxisTest(seq::TestResult &result) {
    GyroUdsMaster* master = GyroUdsMaster::GetInstance();
    
    const wchar_t* fileName = (master->GetPlatform() == sys::PLATFORM_SPR)
        ? L"rom:/bmp/gyro/gyro_SPFL_XAxisTest.bmp"
        : L"rom:/bmp/gyro/gyro_XAxisTest.bmp";        
    return internal::RotateTurntable(result, fileName);    
}

/*
    Desc: ^[e[u~܂
*/
bool StopTurnTable(seq::TestResult &result)
{
    nn::os::Tick start = nn::os::Tick::GetSystemCurrent();
    GyroUdsMaster* master = GyroUdsMaster::GetInstance();

    // ɉ]~w
    GyroController::TCError err = master->GetController()->SetTurnEnable(false);
    if (err != GyroController::TCTRL_ERROR_NONE)
    {
        std::sprintf(result.m_String, "TCTRL_ERROR(%d)", err);
        return result.m_Result = false;
    }

    // ~҂
    while (master->GetController()->GetStatus().ROT_F == true)
    {
        nn::os::Thread::Sleep(nn::fnd::TimeSpan::FromMilliSeconds(10));

        // ^CAEg
        s64 elapsed_time = (nn::os::Tick::GetSystemCurrent() - start).ToTimeSpan().GetMilliSeconds();
        if (elapsed_time > G_TIMEOUT_TURNTABLE_STOP)
        {
            std::sprintf(result.m_String, "TIME_OUT(%lld)", elapsed_time);
            return result.m_Result = false;
        }
    }

    return result.m_Result = true;
}


//============================================================================
//      Lu[V
//============================================================================

namespace internal {

/*
    Desc: Lu[VĂяo֐̃RA
*/
bool CallCalibrateCore(seq::TestResult &result, G_GYRO_TYPE test_id)
{
    u16 command;
    GyroUdsMaster* master = GyroUdsMaster::GetInstance();

    // pPbgM
    if (master->UdsSendPacket(command = (G_GYRO << 8 | test_id), 0, 0))
    {
        eva::GPacket* recv_packet = new eva::GPacket;

        // pPbgM
        if (!master->UdsReceivePacket(recv_packet, G_TIMEOUT_CALIBRATION_M))
        {
            std::sprintf(result.m_String, "FAIL: Receive Packet");
            result.m_Micro = ERROR_MICRO_RECV_PACKET;
            result.m_Result = false;
        }
        else if (recv_packet->m_Command != command)
        {
            std::sprintf(result.m_String, "FAIL: Invalid Command");
            result.m_Micro = ERROR_MICRO_INVALID_COMMAND;
            result.m_Result = false;
        }
        else
        {
            // Me𕶎Ɋi[
            std::sprintf(
                result.m_String,
                "Recv Packet(ret=%s cmd=0x%X len=%d)\n",
                (recv_packet->m_Result == true) ? "PASS" : "FAIL",
                recv_packet->m_Command,
                recv_packet->m_DataLength
            );

            result.m_Result = recv_packet->m_Result;
            result.m_Micro = recv_packet->m_Micro;
        }

        delete recv_packet;
    }
    else
    {
        std::sprintf(result.m_String, "FAIL: Send Packet");
        result.m_Micro = ERROR_MICRO_SEND_PACKET;
        result.m_Result = false;
    }

    if (!result.m_Result)
    {
        // TODO: {ȂeXgV[PXŎ~߂
        GyroUdsMaster::GetInstance()->GetController()->SetTurnEnable(false);
    }

    return result.m_Result;
}

/*
    Desc: SDZ[u{Lu[V
*/
bool CallCalibrateCoreWithSaveData(seq::TestResult &result, G_GYRO_TYPE test_id)
{
    if (!internal::CallCalibrateCore(result, test_id)   &&
        result.m_Micro != ERROR_MICRO_SEND_PACKET       &&
        result.m_Micro != ERROR_MICRO_RECV_PACKET       &&
        result.m_Micro != ERROR_MICRO_INVALID_COMMAND)
    {
        // NGiʐMG[͏jSD֑f[^ۑ
        if (!internal::WriteSDLog(G_GYRO_MASTER, test_id, result.m_Micro, false))
        {
            std::sprintf(result.m_String, "FAIL: Write SD Log(UDS Common)");
            result.m_Micro += ERROR_MICRO_UDS_COMMON;
        }
    }

    return result.m_Result;
}

} // namespace internal


/*
    Desc: ^[e[u0rpm]̃Lu[V
*/
bool CallCalibrate_TTRotMotionless(seq::TestResult &result) {
    return internal::CallCalibrateCoreWithSaveData(result, TID_GYRO_C_CALIB_MOTIONLESS);
}

/*
    Desc: ZݒuE^[e[uE78rpm]̃Lu[V
*/
bool CallCalibrateZ_TTRotR78rpm(seq::TestResult &result) {
    return internal::CallCalibrateCoreWithSaveData(result, TID_GYRO_C_CALIB_Z_R78);
}

/*
    Desc: ZݒuE^[e[u78rpm]̃Lu[V
*/
bool CallCalibrateZ_TTRotL78rpm(seq::TestResult &result) {
    return internal::CallCalibrateCoreWithSaveData(result, TID_GYRO_C_CALIB_Z_L78);
}

/*
    Desc: YݒuE^[e[uE78rpm]̃Lu[V
*/
bool CallCalibrateY_TTRotR78rpm(seq::TestResult &result) {
    return internal::CallCalibrateCoreWithSaveData(result, TID_GYRO_C_CALIB_Y_R78);
}

/*
    Desc: YݒuE^[e[u78rpm]̃Lu[V
*/
bool CallCalibrateY_TTRotL78rpm(seq::TestResult &result) {
    return internal::CallCalibrateCoreWithSaveData(result, TID_GYRO_C_CALIB_Y_L78);
}

/*
    Desc: XݒuE^[e[uE78rpm]̃Lu[V
*/
bool CallCalibrateX_TTRotR78rpm(seq::TestResult &result) {
    return internal::CallCalibrateCoreWithSaveData(result, TID_GYRO_C_CALIB_X_R78);
}

/*
    Desc: XݒuE^[e[u78rpm]̃Lu[V
*/
bool CallCalibrateX_TTRotL78rpm(seq::TestResult &result) {
    return internal::CallCalibrateCoreWithSaveData(result, TID_GYRO_C_CALIB_X_L78);
}


//============================================================================
//      ZteXg
//============================================================================

namespace internal {

/*
    Desc: ZteXgĂяõRA
*/
bool CallSelfTestCore(seq::TestResult &result, int Minor, int msecTimeOut)
{
    u16 command;
    GyroUdsMaster* master = GyroUdsMaster::GetInstance();

    // pPbgM
    if (!master->UdsSendPacket(command = (G_GYRO << 8 | Minor), 0, 0))
    {
        std::sprintf(result.m_String, "FAIL: Send Packet");
        result.m_Micro = ERROR_MICRO_SEND_PACKET;
        return result.m_Result = false;
    }

    // pPbgM
    {
        eva::GPacket* recv_packet = new eva::GPacket;

        if (!master->UdsReceivePacket(recv_packet, msecTimeOut))
        {
            std::sprintf(result.m_String, "FAIL: Receive Packet");
            result.m_Micro = ERROR_MICRO_RECV_PACKET;
            result.m_Result = false;
        }
        else if (recv_packet->m_Command != command)
        {
            std::sprintf(result.m_String, "FAIL: Invalid Command");
            result.m_Micro = ERROR_MICRO_INVALID_COMMAND;
            result.m_Result = false;
        }
        else
        {
            // Me𕶎Ɋi[
            std::sprintf(
                result.m_String,
                "Recv Packet(ret=%s cmd=0x%X len=%d)\n",
                (recv_packet->m_Result == true) ? "PASS" : "FAIL",
                recv_packet->m_Command,
                recv_packet->m_DataLength
            );

            result.m_Result = recv_packet->m_Result;
            result.m_Micro = recv_packet->m_Micro;
        }

        delete recv_packet;
    }

    return result.m_Result;
}

} // namespace internal

/*
    Desc: 
*/
bool CallInitialize(seq::TestResult &result) {
    return internal::CallSelfTestCore(result, TID_GYRO_C_INITIALIZE, G_TIMEOUT_TEST_COMMON);
}

/*
    Desc: Cal̕ۑ
*/
bool CallSetCal(seq::TestResult &result)
{
    if (seq::Config().Get().TestMode == seq::pl::LINE)
    {
        return internal::CallSelfTestCore(result, TID_GYRO_C_SET_CAL, G_TIMEOUT_TEST_COMMON);
    }
    // CȊO͉܂
    else
    {
        std::sprintf(result.m_String, "Not Line Mode, Do Nothing");
        return result.m_Result = true;
    }
}

/*
    Desc: oׁEɂCall̔ixj
*/
bool CallCheckCal_Sensitivity(seq::TestResult &result)
{
    u32 testMode = seq::Config().Get().TestMode;

    // C̏ꍇ͉܂
    if (testMode == seq::pl::LINE)
    {
        std::sprintf(result.m_String, "Line Mode, Do Nothing");
        return result.m_Result = true;
    }
    // o/
    else if (testMode == seq::pl::QC || testMode == seq::pl::ACCEPT)
    {
        if (!internal::CallSelfTestCore(result, TID_GYRO_C_CHECK_CAL_SENS, G_TIMEOUT_TEST_COMMON) &&
            result.m_Micro != ERROR_MICRO_SEND_PACKET   &&
            result.m_Micro != ERROR_MICRO_RECV_PACKET   &&
            result.m_Micro != ERROR_MICRO_INVALID_COMMAND)
        {
            // NGiʐMG[͏jSD֑f[^ۑ
            if (!internal::WriteSDLog(G_GYRO_MASTER, TID_GYRO_M_CHECK_CAL_SENS, result.m_Micro, false))
            {
                std::sprintf(result.m_String, "FAIL: Write SD Log(UDS Common)");
                result.m_Micro += ERROR_MICRO_UDS_COMMON;
            }
        }
        return result.m_Result;
    }
    // ݒ~X/ݒt@Cj
    else
    {
        std::sprintf(result.m_String, "Invalid Test Mode");
        result.m_Micro = 0xffff;
        return result.m_Result = false;
    }
}

/*
    Desc: oׁEɂCall̔i[_j
*/
bool CallCheckCal_ZeroRateOutput(seq::TestResult &result)
{
    u32 testMode = seq::Config().Get().TestMode;

    // C̏ꍇ͉܂
    if (testMode == seq::pl::LINE)
    {
        std::sprintf(result.m_String, "Line Mode, Do Nothing");
        return result.m_Result = true;
    }
    // o/
    else if (testMode == seq::pl::QC || testMode == seq::pl::ACCEPT)
    {
        if (!internal::CallSelfTestCore(result, TID_GYRO_C_CHECK_CAL_ZERO, G_TIMEOUT_TEST_COMMON) &&
            result.m_Micro != ERROR_MICRO_SEND_PACKET   &&
            result.m_Micro != ERROR_MICRO_RECV_PACKET   &&
            result.m_Micro != ERROR_MICRO_INVALID_COMMAND)
        {
            // NGiʐMG[͏jSD֑f[^ۑ
            if (!internal::WriteSDLog(G_GYRO_MASTER, TID_GYRO_M_CHECK_CAL_ZERO, result.m_Micro, false))
            {
                std::sprintf(result.m_String, "FAIL: Write SD Log(UDS Common)");
                result.m_Micro += ERROR_MICRO_UDS_COMMON;
            }
        }
        return result.m_Result;
    }
    // ݒ~X/ݒt@Cj
    else
    {
        std::sprintf(result.m_String, "Invalid Test Mode");
        result.m_Micro = 0xffff;
        return result.m_Result = false;
    }
}

/*
    Desc: OKȌ
*/
bool CallWriteProductionLogOK(seq::TestResult &result) {
    return internal::CallSelfTestCore(result, TID_GYRO_C_PRODUCTION_LOG_OK, G_TIMEOUT_TEST_COMMON);
}

//============================================================================
//      eXgf[^̕ۑ
//============================================================================

namespace internal {

/*
    Desc: NCAgeXgf[^擾
*/
bool CallSendTestData(gyro::GyroTestStatus* ts)
{
    bool result;
    u16 command;
    GyroUdsMaster* master = GyroUdsMaster::GetInstance();

    // pPbgM
    if (!master->UdsSendPacket(command = (G_GYRO << 8 | TID_GYRO_C_SEND_TEST_DATA), 0, 0))
    {
        return false;
    }

    // pPbgM
    {
        eva::GPacket* recv_packet = new eva::GPacket;

        if (!master->UdsReceivePacket(recv_packet, G_TIMEOUT_TEST_COMMON) ||
            recv_packet->m_Command != command)
        {
            delete recv_packet;
            return false;
        }

        std::memcpy(reinterpret_cast<u8*>(ts), recv_packet->m_Data, sizeof(gyro::GyroTestStatus));

        result = recv_packet->m_Result;
        delete recv_packet;
    }

    return result;
}

/*
    Desc: }X^[ɑ}ςSDJ[hɃf[^ۑ
*/
bool WriteSDLog(int id_major, int id_minor, u32 micro, bool test_result)
{
    GyroLogger gyroLogger;
    bool bResultUds = true;

    // SDJ[ho
    if (gyroLogger.IsSdmcInserted())
    {
        nn::Result nnResult = nn::fs::MountSdmc();
        if (nnResult.IsSuccess())
        {
            // fBNgȂꍇ͐
            gyroLogger.CreateDirectory();

            // t@CI[v
            gyroLogger.OpenFile(
                L"Calibration.csv", static_cast<u32>(1024*10), GyroLogger::SDLOG_WRITE_TYPE_CONTINUANCE);

            // x݂܂
            if (gyroC::LoggerWriteLabel(&gyroLogger))
            {
                // SDɕۑ
                gyroLogger.Flush();
            }
            // eXgɑEZof[^̏
            gyro::GyroTestStatus ts;
            if (internal::CallSendTestData(&ts))
            {
                gyroC::LoggerWriteTestData(&gyroLogger, &ts, id_major, id_minor, micro, test_result);
                gyroLogger.Flush();
            }
            else
            {
                bResultUds = false;
            }

            // I
            gyroLogger.CloseFile();

            // SD J[h A}Eg
            NN_UTIL_PANIC_IF_FAILED(nn::fs::Unmount("sdmc:"));
        }
    }

    return bResultUds;
}

} // namespace internal

/*
    Desc: NCAgɑ}ςSDJ[hɃf[^ۑ
*/
bool CallWriteSDLog(seq::TestResult &result) {
    return internal::CallSelfTestCore(result, TID_GYRO_C_WRITE_SDLOG, G_TIMEOUT_TEST_COMMON);
}

/*
    Desc: }X^[ɑ}ςSDJ[hɃf[^ۑ
*/
bool CallWriteSDLogByMaster(seq::TestResult &result) {
    result.m_Result = internal::WriteSDLog(G_GYRO_MASTER, TID_GYRO_M_WRITE_SDLOG, 0, true);
    if (!result.m_Result)
    {
        std::sprintf(result.m_String, "FAIL: UDS Common");
        result.m_Micro = ERROR_MICRO_UDS_COMMON;
    }

    return result.m_Result;
}


} // namespace
}
}
