/*--------------------------------------------------------------------------*
 Project:
 File: gyro_Logger.cpp


*--------------------------------------------------------------------------*/
#include "gyro_Logger.h"

namespace uji {
namespace eva {


/* 
    Desc: Printf
*/
bool GyroLogger::Printf(const char *format, ...)
{
    va_list vlist;
    va_start(vlist, format);
    bool ret = VPrintf(format, vlist);
    va_end(vlist);
    
    return ret;    
}

/*
    Desc: VPrintf
*/
bool GyroLogger::VPrintf(const char* format, std::va_list vlist)
{
    const unsigned long STRING_BUF_SIZE = 1024;
    static char sStrBuf[STRING_BUF_SIZE];

    (void)std::vsnprintf(sStrBuf, STRING_BUF_SIZE, format, vlist);
    return PutString(sStrBuf);    
}

/*
    Desc: PutString
*/
bool GyroLogger::PutString(const char *str)
{
    const char* s = str;
    int n=0;
    
    while (*s++)
    {
        n++;
    }

    return this->Write(str, (u32)n);
}

/*
    Desc: Write
*/
bool GyroLogger::Write(const void* buf, u32 size)
{
    int n=0;
    
    if (((m_CurrentBufPtr + size) - m_Buffer) >= m_BufferSize - 1)
    {
#ifdef DEBUG_LOGGER_NN_LOG                    
        NN_LOG("buf_size(%d) diff(%d) wsize(%d)\n", m_BufferSize, m_CurrentBufPtr-m_Buffer, size);
#endif        
        return false;
    }

    while (n < size)
    {                
        *m_CurrentBufPtr++ = ((char*)buf)[n++];
    }
    
    return true;
}

/*
    Desc: Flush
*/
void GyroLogger::Flush()
{    
    s32 ret = m_FileStream.Write(m_Buffer, std::strlen(m_Buffer));
#ifdef DEBUG_LOGGER_NN_LOG            
    NN_LOG("Flush: LEN= %d\n", ret);
#endif    
    // obt@̐擪
    m_CurrentBufPtr = m_Buffer;
    
    // obt@NA
    std::memset(m_Buffer, '\0', m_BufferSize);
}


} // namespace
}
