/*--------------------------------------------------------------------------*
 Project:
 File: gyro_GraphDrawing.h


*--------------------------------------------------------------------------*/
#ifndef __GYRO_GRAPH_DRAWING_H__
#define __GYRO_GRAPH_DRAWING_H__

#include <nn/types.h>
#include <nn/hid.h>
#include <nw/ut.h>
#include "gyro_LoopBuffer.h"
#include "sys.h"


namespace uji {
namespace eva {


/*
    Cvf
*/
class LineElement
{
public:
    /*
        Desc: RXgN^
        
        Args: label         - x̕
              buffer_size   - CYWi[obt@TCY        
              x, y          - \ʒu
              color         - ̐F
    */
    LineElement(char* label, s32 buffer_size, f32 x, f32 y, nw::ut::FloatColor color)
     : m_Label(label), m_Color(color), m_X(x), m_Y(y), m_Width(2.0f), m_Visible(true)
    {
        m_LoopBuffer = new LoopBuffer<s16>(buffer_size);        
    }
    // fXgN^
    virtual ~LineElement()
    {
        if (m_LoopBuffer != 0) { delete m_LoopBuffer; m_LoopBuffer = 0; }        
    }
    
    // x̐ݒE擾
    void SetLabel(char* label)  { m_Label = label; }
    char* GetLabel()      const { return m_Label; }
    
    // J[̐ݒE擾
    void SetColor(nw::ut::FloatColor color) { m_Color = color; }
    nw::ut::FloatColor GetColor()     const { return m_Color; }
    
    // \Jnʒu̐ݒE擾
    void SetPosition(f32 x, f32 y)      { m_X = x; m_Y = y; }
    void GetPosition(f32& x, f32& y)    { x = m_X; y = m_Y; }
    
    // C̐ݒE擾
    void SetWidth(f32 line_width) { m_Width = line_width; }
    f32 GetWidth()          const { return m_Width; }
    
    // \L̐ݒE擾
    void SetVisible(bool isVisible) { m_Visible = isVisible; }
    bool GetVisible()         const { return m_Visible; }
    
    // mۂ[vobt@̎擾
    LoopBuffer<s16>* GetLoopBuffer() const { return m_LoopBuffer; }
     
private:
    char* m_Label;
    nw::ut::FloatColor m_Color;
    f32 m_X, m_Y;
    f32 m_Width;
    bool m_Visible;
    
    LoopBuffer<s16>* m_LoopBuffer;
};


/*
    Ot`@\񋟂NX
*/
class GyroGraphDrawing
{
public:
    /*
        Desc: ftHgRXgN^
    */
    GyroGraphDrawing() 
     : m_AddedLineNum(0), m_Coefficient(1.0f), m_X(0.0f), m_Y(0.0f), m_Width(0.0f), m_Height(0.0f), 
       m_BackCol(nw::ut::FloatColor(0.0f, 0.0f, 0.0f, 1.0f))
    {
        this->SetTitle("GRAPH");
    }    
    /*
        Desc: RXgN^
        Args: coefficient - XP[p̌W
    */
    GyroGraphDrawing(char* title, f32 coefficient, f32 x, f32 y, f32 width, f32 height, nw::ut::FloatColor color) 
     : m_AddedLineNum(0), m_Coefficient(coefficient), 
       m_X(x), m_Y(y), m_Width(width), m_Height(height), m_BackCol(color)
    {
        this->SetTitle(title);
    }
    virtual ~GyroGraphDrawing()
    {
        uji::sys::GraphicsDrawing *gfx = uji::sys::GraphicsDrawing::GetInstance();
        gfx->ReInitRenderSystem();
    }
        
    bool AddLine(LineElement* graph_line);
    void Draw(sys::GraphicsDrawing* gfx);
    
    // XP[pW̐ݒ
    void SetCoefficient(f32 coefficient)    { m_Coefficient = coefficient; }
    f32 GetCoefficient()              const { return m_Coefficient; }
    
    // wiJ[̐ݒE擾
    void SetBackColor(nw::ut::FloatColor color) { m_BackCol = color; }
    nw::ut::FloatColor GetBackColor()     const { return m_BackCol; }

    // ^Cg̐ݒE擾
    void SetTitle(const char* title) {
        std::memset(m_Title, 0, sizeof(m_Title));
    
        const char* sp = title;
        char* dp = m_Title;
        char* dpe = m_Title + 32-1;
        while (dp < dpe) 
        {
            if ( sp == '\0' ) break;
            *dp++ = *sp++;
        }
        *dp = '\0';
    };
    const char* GetTitle() const { return m_Title; }
    
private:
    static const s32 DISP0_GRAPH_BUFFER_SIZE = 400;
    static const s32 DISP1_GRAPH_BUFFER_SIZE = 320;
    static const s32 MAX_LINE_NUM = 6;

    char m_Title[32]; 

    // TODO: vectorƂɕύX
    LineElement* m_Lines[MAX_LINE_NUM];    
    int m_AddedLineNum;
    
    f32 m_Coefficient;      // XP[p̌W        
    f32 m_DispCenterPosY;   // ʏ̒Sʒu    

    f32 m_X, m_Y;
    f32 m_Width, m_Height;
    nw::ut::FloatColor m_BackCol;
};



} // namespace
}

#endif
