/*--------------------------------------------------------------------------*
 Project:
 File: gyro_GraphDrawing.cpp
 

*--------------------------------------------------------------------------*/
#include "gyro_GraphDrawing.h"
#include "gyro_ExtReader.h"

namespace uji {
namespace eva {


/*
  Desc: グラフを描画

  Args: gfx - uji::sys::GraphicsDrawing
  
  Rtns: なし
*/

// UJIの描画用APIを使用する場合に定義。RenderSystemのAPIの方が速いです・・。
//#define USE_EVA_DRAWING_API
void GyroGraphDrawing::Draw(sys::GraphicsDrawing* gfx)
{
#ifdef USE_EVA_DRAWING_API    
    gfx->BeginDrawingShape();    
#endif
    
    /*
        フレームの描画
    */
    // 外枠    
	gfx->m_DrawFramework->SetColor(0.0f, 0.0f, 0.0f, 1.0f);
    gfx->m_DrawFramework->FillRectangle(m_X-1.0f, m_Y-1.0f, m_Width+2.0f, m_Height+2.0f);        
	// 背景
	gfx->m_DrawFramework->SetColor(m_BackCol.r, m_BackCol.g, m_BackCol.b, m_BackCol.a);
    gfx->m_DrawFramework->FillRectangle(m_X, m_Y, m_Width, m_Height);
    // タイトル
	gfx->m_DrawFramework->SetColor(0.9f, 0.9f, 0.9f, 1.0f);
    gfx->m_DrawFramework->FillRectangle(m_X, m_Y, m_Width, 8.0f);
    gfx->m_DrawFramework->SetFontSize(8.0f);                             
    gfx->m_DrawFramework->SetColor(0.0f, 0.0f, 0.0f);              
    gfx->m_DrawFramework->DrawText(m_X, m_Y, "%s", m_Title);
    
    /* 
        登録順にグラフ描画
    */
    for (int lineNo = 0; lineNo < m_AddedLineNum; lineNo++)
    {
        LineElement* pLine = m_Lines[lineNo];
        
        if (!pLine->GetVisible())
        {
            continue;   
        }
        // 描画準備
#ifdef USE_EVA_DRAWING_API
        gfx->SetColor(pLine->GetColor());
        gfx->SetLineWidth(pLine->GetWidth());
#else
        gfx->m_DrawFramework->SetLineWidth(pLine->GetWidth());    
	    gfx->m_DrawFramework->SetColor(
            pLine->GetColor().r,
            pLine->GetColor().g, 
            pLine->GetColor().b, 
            pLine->GetColor().a
        );
#endif            
        // 最古のデータを取得
        s32 oldestIndex = pLine->GetLoopBuffer()->OldestDataIndex();
        // バッファ中で有効なデータ数を取得
        s32 validDataNum = pLine->GetLoopBuffer()->GetValidDataNum();
        s32 bufferLength = pLine->GetLoopBuffer()->GetBufferLength();
                
        // グラフフレーム内における表示位置        
        f32 line_pos_x, line_pos_y;
        pLine->GetPosition(line_pos_x, line_pos_y);
        
        // 表示スケール調整用係数（±反転も実施）
        f32 coefficient = -GetCoefficient();
                    
        for (int i = 0; i < validDataNum - 1; i++)
        {
            f32 tmp_y0 = static_cast<f32>(pLine->GetLoopBuffer()->GetData(oldestIndex+i));
            f32 tmp_y1 = static_cast<f32>(pLine->GetLoopBuffer()->GetData(oldestIndex+i+1));            
#ifdef USE_EVA_DRAWING_API                        
            gfx->DrawLine(
                nn::math::VEC2(
                    m_X + line_pos_x + static_cast<f32>(bufferLength - validDataNum + i), 
                    m_Y + line_pos_y + coefficient*tmp_y0), 
                nn::math::VEC2(
                    m_X + line_pos_x + static_cast<f32>(bufferLength - validDataNum + i+1), 
                    m_Y + line_pos_y + coefficient*tmp_y1)
            );
#else
            gfx->m_DrawFramework->DrawLine( 
                m_X + line_pos_x + static_cast<f32>(bufferLength - validDataNum + i), 
                m_Y + line_pos_y + coefficient*tmp_y0, 
                m_X + line_pos_x + static_cast<f32>(bufferLength - validDataNum + i+1), 
                m_Y + line_pos_y + coefficient*tmp_y1 
            );

            // 最新データをポイント表示
            if (i == validDataNum - 2)
            {
                gfx->m_DrawFramework->SetPointSize(4.0f);
                gfx->m_DrawFramework->DrawPoint(
                    m_X + line_pos_x + static_cast<f32>(bufferLength - validDataNum + i+1), 
                    m_Y + line_pos_y + coefficient*tmp_y1);                
            }
#endif        
        }
    }
}

/*
  Desc: 新規ライングラフの追加
    
  Args: graph_line -  登録するグラフへのポインタ
    
  Rtns: true（成功） / false（失敗）
*/
bool GyroGraphDrawing::AddLine(LineElement* graph_line)
{
    if (m_AddedLineNum >= MAX_LINE_NUM)
    {
        return false;   
    }
    
    m_Lines[m_AddedLineNum] = graph_line;
    ++m_AddedLineNum;
    
    return true;
}



} // namespace
}
