/*--------------------------------------------------------------------------*
 Project:
 File: gyro_ExtReader.h


*--------------------------------------------------------------------------*/
#ifndef __GYRO_EXT_READER_H__
#define __GYRO_EXT_READER_H__

#include <nn/types.h>
#include <nn/hid.h>
#include <nn/hid/CTR/hid_GyroscopeLowReader.h>
#include <nn/hid/CTR/hid_GyroscopeLowCalibrator.h>
#include <nn/hid/CTR/hid_AccelerometerCalibrator.h>    

#include <nw/ut.h>

#include "gyro_LoopBuffer.h"
#include "sys.h"
    
namespace uji {
namespace eva {


/*
    HIDf[^擾\
*/
template <typename R, typename S> struct ReaderImpl
{
    R* reader;                    // foCX[_
    S latestStatus;               // ŐVf[^
    s32 latestReadLen;            // ŌɎ擾TvOf[^
    LoopBuffer<S>* loopBuffer;    // f[^i[pOobt@
};

/*
    WCf[^CHIDf[^擾NX
*/
class GyroExtReader
{
public:
    /*
      Desc: ftHgRXgN^
        
      Args: Ȃ
    */
    GyroExtReader() : m_IsSamplingFlag(false), m_CancelEvent(false)
    {
        m_ExtDev.loopBuffer = new LoopBuffer<nn::hid::GyroscopeLowStatus>();
        m_ExtDevCalib.loopBuffer = new LoopBuffer<nn::hid::GyroscopeLowStatus>();                            
        m_AccCalib.loopBuffer= new LoopBuffer<nn::hid::AccelerometerStatus>();
    }    
    /*
      Desc: RXgN^
        
      Args: loopBufferLength -  [vobt@̃TCY
    */
    GyroExtReader(s32 loopBufferLength) 
     : m_IsSamplingFlag(false), m_CancelEvent(false)
    {
        m_ExtDev.loopBuffer = new LoopBuffer<nn::hid::GyroscopeLowStatus>(loopBufferLength);
        m_ExtDevCalib.loopBuffer = new LoopBuffer<nn::hid::GyroscopeLowStatus>(loopBufferLength);     
        m_AccCalib.loopBuffer = new LoopBuffer<nn::hid::AccelerometerStatus>(loopBufferLength);
    }
    /*
      Desc: fXgN^
    */
    virtual ~GyroExtReader()
    {
        if (m_ExtDev.loopBuffer != 0) { delete m_ExtDev.loopBuffer; m_ExtDev.loopBuffer = 0; }
        if (m_ExtDevCalib.loopBuffer != 0) { delete m_ExtDevCalib.loopBuffer; m_ExtDevCalib.loopBuffer = 0; } 
        if (m_AccCalib.loopBuffer != 0) { delete m_AccCalib.loopBuffer; m_AccCalib.loopBuffer = 0; }
    }
    
    /*
        TvOJnE~
    */
    s32 SamplingStart(
        nn::hid::GyroscopeLowCalibrator& extCalibReader,
        nn::hid::GyroscopeLowReader& extDevReader, 
        nn::hid::AccelerometerCalibrator& accCalibReader
    );
    void SamplingStop();
    
    // Oobt@̃TCYĊm Ɋi[ς݃f[^̕ۏ͖
    void ReallocateRingBuffer(s32 bufferLength);
    
    /* 
        EI
    */
    void Initialize();
    void Finalize();
    
    // TvOԂ̎擾
    bool IsSampling() const { return m_IsSamplingFlag; }
    
    /*
        efoCXpReader擾iQƖ߂j
    */
    ReaderImpl<nn::hid::GyroscopeLowReader, nn::hid::GyroscopeLowStatus>& GetExtdev() { return m_ExtDev; }
    ReaderImpl<nn::hid::AccelerometerCalibrator, nn::hid::AccelerometerStatus>& GetAccCalib() { return m_AccCalib; }
    ReaderImpl<nn::hid::GyroscopeLowCalibrator, nn::hid::GyroscopeLowStatus>& GetExtdevCalib() { return m_ExtDevCalib; }

public:
    /*
        萔
    */
    static const s32 TMP_SAMPLING_BUFFER_SIZE = 8;
    static const s32 LOGGING_BUFFER_SIZE = 30*100;  // 30bԃTvO\
                
private:
    bool m_IsSamplingFlag;
    nn::os::Alarm m_Alarm;
    nn::os::Event m_CancelEvent;    
    nn::os::Thread m_ThreadRawSampling;

    ReaderImpl<nn::hid::GyroscopeLowReader, nn::hid::GyroscopeLowStatus> m_ExtDev;
    ReaderImpl<nn::hid::AccelerometerCalibrator, nn::hid::AccelerometerStatus> m_AccCalib;
    // ݂̓Luς݂̃f[^ł͂Ȃϊ̃f[^̈
    // SDK0.13[X͍ւ̕KvB
    // TODO:    
    ReaderImpl<nn::hid::GyroscopeLowCalibrator, nn::hid::GyroscopeLowStatus> m_ExtDevCalib;

    nn::os::LightEvent m_EventSamplingThreadBreak;

    void ThreadGyroSamplingRawData();
    static void s_ThreadGyroSamplingRawData(void* param);
    void SamplingAlarmHandler(bool cancelled);
    static void s_SamplingAlarmHandler(void* param, bool cancelled);
    
    static const s32 ALARM_READ_INTERVAL_MSEC = 5;        // TvOf[^̎擾    
};


} // namespace
}

#endif
